/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.scaffolding.view;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.scaffolding.GrailsTemplateGenerator;
import org.codehaus.groovy.grails.scaffolding.view.ScaffoldedGroovyPageView;
import org.codehaus.groovy.grails.web.pages.FastStringWriter;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.view.GrailsViewResolver;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.web.servlet.View;

public class ScaffoldingViewResolver
extends GrailsViewResolver {
    GrailsTemplateGenerator templateGenerator;
    Map<String, List<String>> scaffoldedActionMap = Collections.emptyMap();
    Map<String, GrailsDomainClass> scaffoldedDomains = Collections.emptyMap();
    static final Map<String, View> scaffoldedViews = new ConcurrentHashMap();
    protected static final Log log = LogFactory.getLog(ScaffoldingViewResolver.class);

    public static void clearViewCache() {
        scaffoldedViews.clear();
    }

    protected View createFallbackView(String viewName) throws Exception {
        GrailsDomainClass domainClass;
        View v;
        GrailsWebRequest webRequest = GrailsWebRequest.lookup();
        String[] viewNameParts = this.splitViewName(viewName);
        if (viewNameParts.length == 1) {
            viewName = WebUtils.addViewPrefix((String)viewName, (String)webRequest.getControllerName());
            viewNameParts = this.splitViewName(viewName);
        }
        if ((v = (View)scaffoldedViews.get(viewName)) == null && (domainClass = (GrailsDomainClass)this.scaffoldedDomains.get(viewNameParts[0])) != null) {
            String viewCode = null;
            try {
                viewCode = this.generateViewSource(viewNameParts[1], domainClass);
            }
            catch (Exception e) {
                log.error((Object)("Error generating scaffolded view [" + viewName + "]: " + e.getMessage()), (Throwable)e);
            }
            if (org.springframework.util.StringUtils.hasLength((String)viewCode)) {
                v = this.createScaffoldedView(viewName, viewCode);
                scaffoldedViews.put(viewName, v);
            }
        }
        if (v != null) {
            return v;
        }
        return super.createFallbackView(viewName);
    }

    protected String[] splitViewName(String viewName) {
        return StringUtils.split((String)viewName, (char)'/');
    }

    protected View createScaffoldedView(String viewName, String viewCode) throws Exception {
        ScaffoldedGroovyPageView view = new ScaffoldedGroovyPageView(viewName, viewCode);
        view.setApplicationContext(this.getApplicationContext());
        view.setServletContext(this.getServletContext());
        view.setTemplateEngine(this.templateEngine);
        view.afterPropertiesSet();
        return view;
    }

    protected String generateViewSource(String viewName, GrailsDomainClass domainClass) throws IOException {
        FastStringWriter sw = new FastStringWriter();
        this.templateGenerator.generateView(domainClass, viewName, (Writer)sw);
        return sw.toString();
    }

    public void setTemplateGenerator(GrailsTemplateGenerator templateGenerator) {
        this.templateGenerator = templateGenerator;
    }

    public void setScaffoldedActionMap(Map scaffoldedActionMap) {
        this.scaffoldedActionMap = scaffoldedActionMap;
    }

    public void setScaffoldedDomains(Map scaffoldedDomains) {
        this.scaffoldedDomains = scaffoldedDomains;
    }
}

