/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.scaffolding;

import grails.build.logging.GrailsConsole;
import groovy.text.SimpleTemplateEngine;
import groovy.text.Template;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.plugins.GrailsPluginInfo;
import org.codehaus.groovy.grails.plugins.GrailsPluginManager;
import org.codehaus.groovy.grails.plugins.GrailsPluginUtils;
import org.codehaus.groovy.grails.plugins.PluginManagerAware;
import org.codehaus.groovy.grails.scaffolding.DomainClassPropertyComparator;
import org.codehaus.groovy.grails.scaffolding.GrailsTemplateGenerator;
import org.codehaus.groovy.grails.scaffolding.SimpleDomainClassPropertyComparator;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractGrailsTemplateGenerator
implements GrailsTemplateGenerator,
ResourceLoaderAware,
PluginManagerAware {
    protected static final Log log = LogFactory.getLog(AbstractGrailsTemplateGenerator.class);
    protected String basedir = ".";
    protected boolean overwrite = false;
    protected SimpleTemplateEngine engine = new SimpleTemplateEngine();
    protected ResourceLoader resourceLoader;
    protected Template renderEditorTemplate;
    protected String domainSuffix = "";
    protected GrailsPluginManager pluginManager;
    protected GrailsApplication grailsApplication;

    protected AbstractGrailsTemplateGenerator(ClassLoader classLoader) {
        this.engine = new SimpleTemplateEngine(classLoader);
    }

    public void generateViews(GrailsDomainClass domainClass, String destDir) throws IOException {
        Assert.hasText((String)destDir, (String)"Argument [destdir] not specified");
        File viewsDir = new File(destDir, "grails-app/views/" + domainClass.getPropertyName());
        if (!viewsDir.exists()) {
            viewsDir.mkdirs();
        }
        for (String name : this.getTemplateNames()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Generating [" + name + "] view for domain class [" + domainClass.getFullName() + "]"));
            }
            this.generateView(domainClass, name, viewsDir.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateController(GrailsDomainClass domainClass, String destDir) throws IOException {
        block7: {
            File destFile;
            Assert.hasText((String)destDir, (String)"Argument [destdir] not specified");
            if (domainClass == null) {
                return;
            }
            String fullName = domainClass.getFullName();
            String pkg = "";
            int pos = fullName.lastIndexOf(46);
            if (pos != -1) {
                pkg = fullName.substring(0, pos + 1);
            }
            if (!this.canWrite(destFile = new File(destDir, "grails-app/controllers/" + pkg.replace('.', '/') + domainClass.getShortName() + "Controller.groovy"))) break block7;
            destFile.getParentFile().mkdirs();
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(destFile));
                this.generateController(domainClass, (Writer)writer);
                try {
                    writer.flush();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                IOGroovyMethods.closeQuietly(writer);
                throw throwable;
            }
            IOGroovyMethods.closeQuietly((Closeable)writer);
            log.info((Object)("Controller generated at [" + destFile + "]"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateAsyncController(GrailsDomainClass domainClass, String destDir) throws IOException {
        block7: {
            File destFile;
            Assert.hasText((String)destDir, (String)"Argument [destdir] not specified");
            if (domainClass == null) {
                return;
            }
            String fullName = domainClass.getFullName();
            String pkg = "";
            int pos = fullName.lastIndexOf(46);
            if (pos != -1) {
                pkg = fullName.substring(0, pos + 1);
            }
            if (!this.canWrite(destFile = new File(destDir, "grails-app/controllers/" + pkg.replace('.', '/') + domainClass.getShortName() + "Controller.groovy"))) break block7;
            destFile.getParentFile().mkdirs();
            BufferedWriter writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(destFile));
                this.generateAsyncController(domainClass, (Writer)writer);
                try {
                    writer.flush();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                IOGroovyMethods.closeQuietly(writer);
                throw throwable;
            }
            IOGroovyMethods.closeQuietly((Closeable)writer);
            log.info((Object)("Controller generated at [" + destFile + "]"));
        }
    }

    public void generateView(GrailsDomainClass domainClass, String viewName, Writer out) throws IOException {
        String templateText = this.getTemplateText(viewName + ".gsp");
        if (!StringUtils.hasLength((String)templateText)) {
            return;
        }
        GrailsDomainClassProperty multiPart = null;
        for (GrailsDomainClassProperty property : domainClass.getProperties()) {
            if (property.getType() != Byte[].class && property.getType() != byte[].class) continue;
            multiPart = property;
            break;
        }
        String packageName = StringUtils.hasLength((String)domainClass.getPackageName()) ? "<%@ page import=\"" + domainClass.getFullName() + "\" %>" : "";
        Map binding = this.createBinding(domainClass);
        binding.put("packageName", packageName);
        binding.put("multiPart", multiPart);
        binding.put("propertyName", this.getPropertyName(domainClass));
        this.generate(templateText, binding, out);
    }

    protected abstract Object getRenderEditor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateView(GrailsDomainClass domainClass, String viewName, String destDir) throws IOException {
        File destFile = new File(destDir, viewName + ".gsp");
        if (!this.canWrite(destFile)) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(destFile));
            this.generateView(domainClass, viewName, (Writer)writer);
            try {
                writer.flush();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            IOGroovyMethods.closeQuietly(writer);
            throw throwable;
        }
        IOGroovyMethods.closeQuietly((Closeable)writer);
    }

    public void generateController(GrailsDomainClass domainClass, Writer out) throws IOException {
        String templateText = this.getTemplateText("Controller.groovy");
        Map binding = this.createBinding(domainClass);
        binding.put("packageName", domainClass.getPackageName());
        binding.put("propertyName", this.getPropertyName(domainClass));
        this.generate(templateText, binding, out);
    }

    public void generateAsyncController(GrailsDomainClass domainClass, Writer out) throws IOException {
        String templateText = this.getTemplateText("AsyncController.groovy");
        Map binding = this.createBinding(domainClass);
        binding.put("packageName", domainClass.getPackageName());
        binding.put("propertyName", this.getPropertyName(domainClass));
        this.generate(templateText, binding, out);
    }

    public void generateAsyncTest(GrailsDomainClass domainClass, String destDir) throws IOException {
        this.generateTest(domainClass, destDir, "AsyncSpec.groovy");
    }

    public void generateTest(GrailsDomainClass domainClass, String destDir) throws IOException {
        this.generateTest(domainClass, destDir, "Spec.groovy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateTest(GrailsDomainClass domainClass, String destDir, String templateName) throws IOException {
        File destFile = new File(destDir, domainClass.getPackageName().replace('.', '/') + '/' + domainClass.getShortName() + "ControllerSpec.groovy");
        if (!this.canWrite(destFile)) {
            return;
        }
        String templateText = this.getTemplateText(templateName);
        Map binding = this.createBinding(domainClass);
        binding.put("packageName", domainClass.getPackageName());
        binding.put("propertyName", domainClass.getLogicalPropertyName());
        binding.put("modelName", this.getPropertyName(domainClass));
        destFile.getParentFile().mkdirs();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(destFile));
            this.generate(templateText, binding, (Writer)writer);
            try {
                writer.flush();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            IOGroovyMethods.closeQuietly(writer);
            throw throwable;
        }
        IOGroovyMethods.closeQuietly((Closeable)writer);
    }

    protected Map<String, Object> createBinding(GrailsDomainClass domainClass) {
        boolean hasHibernate = this.pluginManager.hasGrailsPlugin("hibernate") || this.pluginManager.hasGrailsPlugin("hibernate4");
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("pluginManager", this.pluginManager);
        binding.put("domainClass", domainClass);
        binding.put("className", domainClass.getShortName());
        binding.put("renderEditor", this.getRenderEditor());
        binding.put("comparator", hasHibernate ? DomainClassPropertyComparator.class : SimpleDomainClassPropertyComparator.class);
        return binding;
    }

    protected void generate(String templateText, Map<String, Object> binding, Writer out) {
        try {
            this.engine.createTemplate(templateText).make(binding).writeTo(out);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getPropertyName(GrailsDomainClass domainClass) {
        return domainClass.getPropertyName() + this.domainSuffix;
    }

    protected String getTemplateText(String template) throws IOException {
        InputStream inputStream = null;
        if (this.resourceLoader != null && this.grailsApplication.isWarDeployed()) {
            inputStream = this.resourceLoader.getResource("/WEB-INF/templates/scaffolding/" + template).getInputStream();
        } else {
            AbstractResource templateFile = this.getTemplateResource(template);
            if (templateFile.exists()) {
                inputStream = templateFile.getInputStream();
            }
        }
        return inputStream == null ? null : IOGroovyMethods.getText((InputStream)inputStream);
    }

    protected AbstractResource getTemplateResource(String template) throws IOException {
        String name = "src/templates/scaffolding/" + template;
        FileSystemResource templateFile = new FileSystemResource(new File(this.basedir, name).getAbsoluteFile());
        if (!templateFile.exists()) {
            templateFile = new FileSystemResource(new File(this.getPluginDir(), name).getAbsoluteFile());
        }
        return templateFile;
    }

    protected File getPluginDir() throws IOException {
        GrailsPluginInfo info = GrailsPluginUtils.getPluginBuildSettings().getPluginInfoForName("scaffolding");
        return info.getDescriptor().getFile().getParentFile();
    }

    protected boolean canWrite(File testFile) {
        if (this.overwrite || !testFile.exists()) {
            return true;
        }
        try {
            String relative = this.makeRelativeIfPossible(testFile.getAbsolutePath(), this.basedir);
            String response = GrailsConsole.getInstance().userInput("File " + relative + " already exists. Overwrite?", new String[]{"y", "n", "a"});
            this.overwrite = this.overwrite || "a".equals(response);
            return this.overwrite || "y".equals(response);
        }
        catch (Exception e) {
            return true;
        }
    }

    protected String makeRelativeIfPossible(String fileName, String base) throws IOException {
        if (StringUtils.hasLength((String)base)) {
            fileName = StringGroovyMethods.minus((String)fileName, (Object)new File(base).getCanonicalPath());
        }
        return fileName;
    }

    protected Set<String> getTemplateNames() throws IOException {
        if (this.resourceLoader != null && this.grailsApplication.isWarDeployed()) {
            try {
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
                return this.extractNames(resolver.getResources("/WEB-INF/templates/scaffolding/*.gsp"));
            }
            catch (Exception e) {
                return Collections.emptySet();
            }
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        HashSet<String> resources2 = new HashSet<String>();
        String templatesDirPath = this.basedir + "/src/templates/scaffolding";
        FileSystemResource templatesDir = new FileSystemResource(templatesDirPath);
        if (templatesDir.exists()) {
            try {
                resources2.addAll(this.extractNames(resolver.getResources("file:" + templatesDirPath + "/*.gsp")));
            }
            catch (Exception e) {
                log.error((Object)("Error while loading views from " + this.basedir), (Throwable)e);
            }
        }
        File pluginDir = this.getPluginDir();
        try {
            resources2.addAll(this.extractNames(resolver.getResources("file:" + pluginDir + "/src/templates/scaffolding/*.gsp")));
        }
        catch (Exception e) {
            log.error((Object)("Error locating templates from " + pluginDir + ": " + e.getMessage()), (Throwable)e);
        }
        return resources2;
    }

    protected Set<String> extractNames(Resource[] resources2) {
        HashSet<String> names = new HashSet<String>();
        for (Resource resource : resources2) {
            String name = resource.getFilename();
            names.add(name.substring(0, name.length() - 4));
        }
        return names;
    }

    public void setGrailsApplication(GrailsApplication ga) {
        this.grailsApplication = ga;
        Object suffix = ga.getFlatConfig().get("grails.scaffolding.templates.domainSuffix");
        if (suffix instanceof CharSequence) {
            this.domainSuffix = suffix.toString();
        }
    }

    public void setResourceLoader(ResourceLoader rl) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Scaffolding template generator set to use resource loader [" + rl + "]"));
        }
        this.resourceLoader = rl;
    }

    public void setPluginManager(GrailsPluginManager gpm) {
        this.pluginManager = gpm;
    }

    public void setOverwrite(boolean shouldOverwrite) {
        this.overwrite = shouldOverwrite;
    }
}

