/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.web.filter;

import grails.plugin.cache.GrailsAnnotationCacheOperationSource;
import grails.plugin.cache.SerializableByteArrayOutputStream;
import grails.plugin.cache.SerializableOutputStream;
import grails.plugin.cache.Timer;
import grails.plugin.cache.web.ContentCacheParameters;
import grails.plugin.cache.web.GenericResponseWrapper;
import grails.plugin.cache.web.Header;
import grails.plugin.cache.web.PageInfo;
import grails.plugin.cache.web.SerializableCookie;
import grails.plugin.cache.web.filter.AbstractFilter;
import grails.plugin.cache.web.filter.CacheOperationContext;
import grails.plugin.cache.web.filter.ExpressionEvaluator;
import grails.plugin.cache.web.filter.PageFragmentCachingFilter;
import grails.plugin.cache.web.filter.WebKeyGenerator;
import grails.util.GrailsNameUtils;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import org.codehaus.groovy.grails.plugins.web.api.RequestMimeTypesApi;
import org.codehaus.groovy.grails.web.servlet.WrappedResponseHolder;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsParameterMap;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class PageFragmentCachingFilter
extends AbstractFilter {
    public static final String X_CACHED = "X-Grails-Cached";
    protected static final String CACHEABLE = "cacheable";
    protected static final String UPDATE = "cacheupdate";
    protected static final String EVICT = "cacheevict";
    protected ParameterNameDiscoverer paramNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    protected static final Map<Class<?>, String> TYPE_TO_CONVERSION_METHOD_NAME = grails.util.CollectionUtils.newMap((Object[])new Object[]{Boolean.class, "boolean", Byte.class, "byte", Character.class, "char", Double.class, "double", Float.class, "float", Integer.class, "int", Long.class, "long", Short.class, "short"});
    protected static List<Class<?>> PRIMITIVE_CLASSES = grails.util.CollectionUtils.newList((Object[])new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE});
    protected static final Map<String, Method> PARAMS_METHODS = new HashMap();
    protected GrailsAnnotationCacheOperationSource cacheOperationSource;
    protected final ThreadLocal<Stack<ContentCacheParameters>> contextHolder = new /* Unavailable Anonymous Inner Class!! */;
    protected ExpressionEvaluator expressionEvaluator;
    protected WebKeyGenerator keyGenerator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws Exception {
        this.initContext();
        try {
            Method method;
            Object controller = this.lookupController(this.getContext().getControllerClass());
            if (controller == null) {
                this.log.debug("Not a controller request {}:{} {}", new Object[]{request.getMethod(), request.getRequestURI(), this.getContext()});
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            Class<?> controllerClass = AopProxyUtils.ultimateTargetClass((Object)controller);
            if (controllerClass == null) {
                controllerClass = controller.getClass();
            }
            if ((method = this.getContext().getMethod()) == null) {
                this.log.debug("No cacheable method found for {}:{} {}", new Object[]{request.getMethod(), request.getRequestURI(), this.getContext()});
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            Collection cacheOperations = this.cacheOperationSource.getCacheOperations(method, controllerClass, true);
            if (CollectionUtils.isEmpty((Collection)cacheOperations)) {
                this.log.debug("No cacheable annotation found for {}:{} {}", new Object[]{request.getMethod(), request.getRequestURI(), this.getContext()});
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            Map operationsByType = this.createOperationContext(cacheOperations, method, controllerClass, request);
            if (this.inspectBeforeCacheEvicts((Collection)operationsByType.get(EVICT))) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            CacheStatus status = this.inspectCacheables((Collection)operationsByType.get(CACHEABLE));
            Map updates = this.inspectCacheUpdates((Collection)operationsByType.get(UPDATE));
            if (status != null) {
                if (status.updateRequired) {
                    updates.putAll(status.updates);
                } else {
                    this.logRequestDetails(request, this.getContext(), "Caching enabled for request");
                    PageInfo pageInfo = this.buildCachedPageInfo(request, response, status);
                    this.writeResponse(request, response, pageInfo);
                    return;
                }
            }
            this.logRequestDetails(request, this.getContext(), "Caching enabled for request");
            PageInfo pageInfo = this.buildNewPageInfo(request, response, chain, status, operationsByType);
            this.writeResponse(request, response, pageInfo);
            this.inspectAfterCacheEvicts((Collection)operationsByType.get(EVICT));
            if (!updates.isEmpty()) {
                ArrayList<Cache> caches = new ArrayList<Cache>();
                for (Map.Entry entry : updates.entrySet()) {
                    for (Cache cache : ((CacheOperationContext)entry.getKey()).getCaches()) {
                        caches.add(cache);
                    }
                }
                this.update(caches, pageInfo, status, this.calculateKey(request));
            }
        }
        finally {
            this.destroyContext();
        }
    }

    protected PageInfo buildNewPageInfo(HttpServletRequest request, HttpServletResponse response, FilterChain chain, CacheStatus cacheStatus, Map<String, Collection<CacheOperationContext>> operationsByType) throws Exception {
        PageInfo pageInfo;
        Timer timer = new Timer(this.getCachedUri(request));
        timer.start();
        String key = this.calculateKey(request);
        try {
            pageInfo = this.buildPage(request, response, chain);
            if (pageInfo.isOk()) {
                Object noCache = pageInfo.getCacheDirectives().get("no-cache");
                if (noCache instanceof Boolean && ((Boolean)noCache).booleanValue()) {
                    this.log.debug("Response ok but Cache-Control: no-cache is present, not caching");
                    this.releaseCacheLocks(operationsByType, key);
                } else {
                    ArrayList<Cache> caches = new ArrayList<Cache>();
                    for (CacheOperationContext operationContext : operationsByType.get(UPDATE)) {
                        for (Cache cache : operationContext.getCaches()) {
                            caches.add(cache);
                        }
                    }
                    this.update(caches, pageInfo, cacheStatus, key);
                }
            } else {
                for (CacheOperationContext operationContext : operationsByType.get(UPDATE)) {
                    for (Cache cache : operationContext.getCaches()) {
                        this.log.debug("Response not ok ({}). Putting null into cache {} with key {}", new Object[]{pageInfo.getStatusCode(), cache.getName(), key});
                    }
                }
                this.releaseCacheLocks(operationsByType, key);
            }
        }
        catch (LockTimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            this.releaseCacheLocks(operationsByType, key);
            throw e;
        }
        timer.stop(false);
        response.addHeader(X_CACHED, String.valueOf(false));
        return pageInfo;
    }

    protected PageInfo buildCachedPageInfo(HttpServletRequest request, HttpServletResponse response, CacheStatus cacheStatus) throws Exception {
        Timer timer = new Timer(this.getCachedUri(request));
        timer.start();
        String key = this.calculateKey(request);
        Cache.ValueWrapper element = cacheStatus.valueWrapper;
        this.log.debug("Serving cached content for {}", (Object)key);
        PageInfo pageInfo = (PageInfo)element.get();
        for (Map.Entry entry : pageInfo.getRequestAttributes().entrySet()) {
            request.setAttribute((String)entry.getKey(), entry.getValue());
        }
        if (StringUtils.hasLength((String)this.getContext().getControllerName())) {
            Object controller = this.lookupController(this.getContext().getControllerClass());
            request.setAttribute("org.codehaus.groovy.grails.CONTROLLER", controller);
        }
        timer.stop(true);
        response.addHeader(X_CACHED, String.valueOf(true));
        return pageInfo;
    }

    protected abstract int getTimeToLive(Cache.ValueWrapper var1);

    protected abstract void put(Cache var1, String var2, PageInfo var3, Integer var4);

    protected void releaseCacheLocks(Map<String, Collection<CacheOperationContext>> operationsByType, String key) {
        for (CacheOperationContext operationContext : operationsByType.get(EVICT)) {
            for (Cache cache : operationContext.getCaches()) {
                this.put(cache, key, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PageInfo buildPage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        SerializableByteArrayOutputStream out = new SerializableByteArrayOutputStream();
        GenericResponseWrapper wrapper = new GenericResponseWrapper(response, (SerializableOutputStream)out);
        HashMap<String, Serializable> cacheableRequestAttributes = new HashMap<String, Serializable>();
        HttpServletResponse originalResponse = null;
        boolean isInclude = WebUtils.isIncludeRequest((ServletRequest)request);
        if (isInclude) {
            originalResponse = WrappedResponseHolder.getWrappedResponse();
            WrappedResponseHolder.setWrappedResponse((HttpServletResponse)wrapper);
        }
        try {
            List attributesBefore = this.toList(request.getAttributeNames());
            chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
            List attributesAfter = this.toList(request.getAttributeNames());
            attributesAfter.removeAll(attributesBefore);
            for (String attrName : attributesAfter) {
                Object value = request.getAttribute(attrName);
                if (!(value instanceof Serializable)) continue;
                cacheableRequestAttributes.put(attrName, (Serializable)value);
            }
        }
        finally {
            if (isInclude) {
                WrappedResponseHolder.setWrappedResponse((HttpServletResponse)originalResponse);
            }
        }
        wrapper.flush();
        long timeToLiveSeconds = Integer.MAX_VALUE;
        String contentType = wrapper.getContentType();
        if (!StringUtils.hasLength((String)contentType)) {
            contentType = response.getContentType();
        }
        return new PageInfo(wrapper.getStatus(), contentType, out.toByteArray(), false, timeToLiveSeconds, wrapper.getAllHeaders(), wrapper.getCookies(), cacheableRequestAttributes);
    }

    protected List<String> toList(Enumeration<String> e) {
        ArrayList<String> list = new ArrayList<String>();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        return list;
    }

    protected String calculateKey(HttpServletRequest request) {
        return this.keyGenerator.generate(request);
    }

    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, PageInfo pageInfo) throws IOException {
        if (!WebUtils.isIncludeRequest((ServletRequest)request)) {
            int statusCode = this.determineResponseStatus(request, pageInfo);
            response.setStatus(statusCode);
            this.setContentType(response, pageInfo);
            this.setCookies(pageInfo, response);
            this.setHeaders(pageInfo, response);
        }
        this.writeResponse(response, pageInfo);
    }

    protected int determineResponseStatus(HttpServletRequest request, PageInfo pageInfo) {
        int statusCode = pageInfo.getStatusCode();
        if (!pageInfo.isModified(request)) {
            this.log.debug("Content not modified since {} sending 304", (Object)request.getHeader("If-Modified-Since"));
            statusCode = 304;
        } else if (pageInfo.isMatch(request)) {
            this.log.debug("Content matches entity tag {} sending 304", (Object)request.getHeader("If-None-Match"));
            statusCode = 304;
        }
        return statusCode;
    }

    protected void setContentType(HttpServletResponse response, PageInfo pageInfo) {
        String contentType = pageInfo.getContentType();
        if (contentType != null && contentType.length() > 0) {
            response.setContentType(contentType);
        }
    }

    protected void setCookies(PageInfo pageInfo, HttpServletResponse response) {
        List cookies = pageInfo.getSerializableCookies();
        for (SerializableCookie cookie : cookies) {
            response.addCookie(cookie.toCookie());
        }
    }

    protected void setHeaders(PageInfo pageInfo, HttpServletResponse response) {
        List headers = pageInfo.getHeaders();
        TreeSet<String> setHeaders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        block5: for (Header header : headers) {
            String name = header.getName();
            switch (2.$SwitchMap$grails$plugin$cache$web$Header$Type[header.getType().ordinal()]) {
                case 1: {
                    if (setHeaders.contains(name)) {
                        response.addHeader(name, (String)((Object)header.getValue()));
                        continue block5;
                    }
                    setHeaders.add(name);
                    response.setHeader(name, (String)((Object)header.getValue()));
                    continue block5;
                }
                case 2: {
                    if (setHeaders.contains(name)) {
                        response.addDateHeader(name, ((Long)header.getValue()).longValue());
                        continue block5;
                    }
                    setHeaders.add(name);
                    response.setDateHeader(name, ((Long)header.getValue()).longValue());
                    continue block5;
                }
                case 3: {
                    if (setHeaders.contains(name)) {
                        response.addIntHeader(name, ((Integer)header.getValue()).intValue());
                        continue block5;
                    }
                    setHeaders.add(name);
                    response.setIntHeader(name, ((Integer)header.getValue()).intValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("No mapping for Header: " + header);
        }
    }

    protected void initContext() {
        GrailsWebRequest requestAttributes = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
        ((Stack)this.contextHolder.get()).push(new ContentCacheParameters(requestAttributes));
    }

    protected ContentCacheParameters getContext() {
        return (ContentCacheParameters)((Stack)this.contextHolder.get()).peek();
    }

    protected void destroyContext() {
        ((Stack)this.contextHolder.get()).pop();
        if (((Stack)this.contextHolder.get()).empty()) {
            this.contextHolder.remove();
        }
    }

    protected String getCachedUri(HttpServletRequest request) {
        if (WebUtils.isIncludeRequest((ServletRequest)request)) {
            return (String)request.getAttribute("javax.servlet.include.request_uri");
        }
        return request.getRequestURI();
    }

    protected void logRequestDetails(HttpServletRequest request, ContentCacheParameters cacheParameters, String message) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        this.log.debug("{}...", (Object)message);
        this.log.debug("    method = {}", (Object)request.getMethod());
        this.log.debug("    requestURI = {}", (Object)request.getRequestURI());
        this.log.debug("    forwardURI = {}", (Object)WebUtils.getForwardURI((HttpServletRequest)request));
        if (WebUtils.isIncludeRequest((ServletRequest)request)) {
            this.log.debug("    includeURI = {}", request.getAttribute("javax.servlet.include.request_uri"));
        }
        this.log.debug("    controller = {}", (Object)cacheParameters.getControllerName());
        this.log.debug("    action = {}", (Object)cacheParameters.getActionName());
        RequestMimeTypesApi requestMimeTypesApi = (RequestMimeTypesApi)this.getBean("requestMimeTypesApi");
        this.log.debug("    format = {}", (Object)requestMimeTypesApi.getFormat(request));
        this.log.debug("    params = {}", (Object)cacheParameters.getParams());
    }

    protected Map<String, Collection<CacheOperationContext>> createOperationContext(Collection<CacheOperation> cacheOperations, Method method, Class<?> targetClass, HttpServletRequest request) {
        LinkedHashMap<String, Collection<CacheOperationContext>> map = new LinkedHashMap<String, Collection<CacheOperationContext>>(3);
        ArrayList<CacheOperationContext> cacheables = new ArrayList<CacheOperationContext>();
        ArrayList<CacheOperationContext> evicts = new ArrayList<CacheOperationContext>();
        ArrayList<CacheOperationContext> updates = new ArrayList<CacheOperationContext>();
        Object[] args = this.findArgs(request, method);
        for (CacheOperation cacheOperation : cacheOperations) {
            CacheOperationContext opContext = new CacheOperationContext(cacheOperation, method, args, targetClass, this.getCaches(cacheOperation), this.expressionEvaluator, this.keyGenerator, request);
            if (cacheOperation instanceof CacheableOperation) {
                cacheables.add(opContext);
            }
            if (cacheOperation instanceof CacheEvictOperation) {
                evicts.add(opContext);
            }
            if (!(cacheOperation instanceof CachePutOperation)) continue;
            updates.add(opContext);
        }
        map.put(CACHEABLE, cacheables);
        map.put(EVICT, evicts);
        map.put(UPDATE, updates);
        return map;
    }

    protected Object[] findArgs(HttpServletRequest request, Method method) {
        String[] names = this.paramNameDiscoverer.getParameterNames(method);
        if (names == null) {
            this.log.warn("Unable to lookup parameter names for method " + method);
            return null;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Class<?>[] types = method.getParameterTypes();
        int count = types.length;
        for (int i = 0; i < count; ++i) {
            args.add(this.findArg(request, types[i], names[i]));
        }
        return args.toArray();
    }

    protected Object findArg(HttpServletRequest request, Class<?> type, String name) {
        if (String.class.equals(type)) {
            return request.getParameter(name);
        }
        if (PRIMITIVE_CLASSES.contains(type) || TYPE_TO_CONVERSION_METHOD_NAME.containsKey(type)) {
            String conversionMethodName = TYPE_TO_CONVERSION_METHOD_NAME.containsKey(type) ? (String)TYPE_TO_CONVERSION_METHOD_NAME.get(type) : type.getName();
            GrailsWebRequest grailsRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes();
            GrailsParameterMap params = grailsRequest.getParams();
            return this.getParamValue(params, conversionMethodName, name);
        }
        this.log.warn("Unsupported parameter type " + type + " for parameter " + name);
        return null;
    }

    protected Object getParamValue(GrailsParameterMap params, String conversionMethodName, String paramName) {
        Method method = (Method)PARAMS_METHODS.get(conversionMethodName);
        if (method == null) {
            this.log.warn("No method found for " + conversionMethodName + " in GrailsParameterMap");
            return null;
        }
        return ReflectionUtils.invokeMethod((Method)method, (Object)params, (Object[])new Object[]{paramName});
    }

    protected Collection<Cache> getCaches(CacheOperation operation) {
        Set cacheNames = operation.getCacheNames();
        ArrayList<Cache> caches = new ArrayList<Cache>(cacheNames.size());
        for (String name : cacheNames) {
            Cache cache = this.getCacheManager().getCache(name);
            if (cache == null) {
                throw new IllegalArgumentException("Cannot find cache named [" + name + "] for " + operation);
            }
            caches.add(cache);
        }
        return caches;
    }

    protected boolean inspectBeforeCacheEvicts(Collection<CacheOperationContext> evictions) {
        return this.inspectCacheEvicts(evictions, true);
    }

    protected boolean inspectAfterCacheEvicts(Collection<CacheOperationContext> evictions) {
        return this.inspectCacheEvicts(evictions, false);
    }

    protected boolean inspectCacheEvicts(Collection<CacheOperationContext> evictions, boolean beforeInvocation) {
        if (evictions.isEmpty()) {
            return false;
        }
        boolean trace = this.log.isTraceEnabled();
        boolean atLeastOne = false;
        for (CacheOperationContext operationContext : evictions) {
            CacheEvictOperation evict = (CacheEvictOperation)operationContext.operation;
            if (beforeInvocation != evict.isBeforeInvocation()) continue;
            if (operationContext.isConditionPassing()) {
                atLeastOne = true;
                Object key = null;
                for (Cache cache : operationContext.getCaches()) {
                    if (evict.isCacheWide()) {
                        cache.clear();
                        this.logRequestDetails(operationContext.request, this.getContext(), "Flushing request");
                        continue;
                    }
                    if (key == null) {
                        key = operationContext.generateKey();
                    }
                    if (trace) {
                        this.log.trace("Invalidating cache key {} for operation {} on method {}", new Object[]{key, evict, operationContext.method});
                    }
                    cache.evict(key);
                }
                continue;
            }
            this.logRequestDetails(operationContext.request, this.getContext(), "Not flushing request");
        }
        return atLeastOne;
    }

    protected CacheStatus inspectCacheables(Collection<CacheOperationContext> cacheables) {
        if (cacheables.isEmpty()) {
            return null;
        }
        LinkedHashMap<CacheOperationContext, Object> cUpdates = new LinkedHashMap<CacheOperationContext, Object>(cacheables.size());
        boolean trace = this.log.isTraceEnabled();
        boolean updateRequired = false;
        boolean atLeastOne = false;
        Cache.ValueWrapper valueWrapper = null;
        for (CacheOperationContext context : cacheables) {
            if (context.isConditionPassing()) {
                atLeastOne = true;
                Object key = context.generateKey();
                if (trace) {
                    this.log.trace("Computed cache key {} for operation {}", new Object[]{key, context.operation});
                }
                if (key == null) {
                    throw new IllegalArgumentException("Null key returned for cache operation (maybe you are using named params on classes without debug info?) " + context.operation);
                }
                cUpdates.put(context, key);
                boolean localCacheHit = false;
                if (!updateRequired) {
                    for (Cache cache : context.getCaches()) {
                        Cache.ValueWrapper wrapper = cache.get(key);
                        if (wrapper == null) continue;
                        valueWrapper = wrapper;
                        localCacheHit = true;
                        break;
                    }
                }
                if (localCacheHit) continue;
                updateRequired = true;
                continue;
            }
            if (!trace) continue;
            this.log.trace("Cache condition failed on method {} for operation {}", new Object[]{context.method, context.operation});
        }
        if (atLeastOne) {
            return new CacheStatus(cUpdates, updateRequired, valueWrapper);
        }
        return null;
    }

    protected Map<CacheOperationContext, Object> inspectCacheUpdates(Collection<CacheOperationContext> updates) {
        LinkedHashMap<CacheOperationContext, Object> cUpdates = new LinkedHashMap<CacheOperationContext, Object>(updates.size());
        if (updates.isEmpty()) {
            return cUpdates;
        }
        boolean trace = this.log.isTraceEnabled();
        for (CacheOperationContext context : updates) {
            if (context.isConditionPassing()) {
                Object key = context.generateKey();
                if (trace) {
                    this.log.trace("Computed cache key {} for operation {}", new Object[]{key, context.operation});
                }
                if (key == null) {
                    throw new IllegalArgumentException("Null key returned for cache operation (maybe you are using named params on classes without debug info?) " + context.operation);
                }
                cUpdates.put(context, key);
                continue;
            }
            if (!trace) continue;
            this.log.trace("Cache condition failed on method {} for operation {}", new Object[]{context.method, context.operation});
        }
        return cUpdates;
    }

    protected void writeResponse(HttpServletResponse response, PageInfo pageInfo) throws IOException {
        byte[] cachedPage = pageInfo.getUngzippedBody();
        String page = new String(cachedPage, response.getCharacterEncoding());
        String implementationVendor = response.getClass().getPackage().getImplementationVendor();
        if (implementationVendor != null && implementationVendor.equals("\"Evermind\"")) {
            response.getOutputStream().print(page);
        } else {
            response.getWriter().write(page);
        }
    }

    protected void update(Collection<Cache> caches, PageInfo pageInfo, CacheStatus cacheStatus, String key) {
        Cache.ValueWrapper element = cacheStatus == null ? null : cacheStatus.valueWrapper;
        Object maxAge = pageInfo.getCacheDirectives().get("max-age");
        int timeToLive = maxAge instanceof Integer ? (Integer)maxAge : (int)pageInfo.getTimeToLiveSeconds();
        for (Cache cache : caches) {
            this.log.debug("Response ok. Adding to cache {} with key {} and ttl {}", new Object[]{cache.getName(), key, this.getTimeToLive(element)});
            this.put(cache, key, pageInfo, Integer.valueOf(timeToLive));
        }
    }

    protected Object lookupController(Class<?> controllerClass) {
        if (controllerClass == null) {
            return null;
        }
        return this.getBean(controllerClass.getName());
    }

    public void setCacheOperationSource(GrailsAnnotationCacheOperationSource source) {
        this.cacheOperationSource = source;
    }

    public void setExpressionEvaluator(ExpressionEvaluator evaluator) {
        this.expressionEvaluator = evaluator;
    }

    public void setKeyGenerator(WebKeyGenerator generator) {
        this.keyGenerator = generator;
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.cacheOperationSource, (String)"cacheOperationSource is required");
        Assert.notNull((Object)this.expressionEvaluator, (String)"expressionEvaluator is required");
        Assert.notNull((Object)this.keyGenerator, (String)"keyGenerator is required");
    }

    static {
        for (String typeName : TYPE_TO_CONVERSION_METHOD_NAME.values()) {
            String methodName = GrailsNameUtils.getGetterName((String)typeName);
            Method method = ClassUtils.getMethod(GrailsParameterMap.class, (String)methodName, (Class[])new Class[]{String.class});
            PARAMS_METHODS.put(typeName, method);
        }
    }
}

