/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.web.filter;

import grails.plugin.cache.web.filter.ExpressionEvaluator;
import grails.plugin.cache.web.filter.WebKeyGenerator;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cache.Cache;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.StringUtils;

public class CacheOperationContext {
    protected final Collection<Cache> caches;
    protected final ExpressionEvaluator evaluator;
    protected final WebKeyGenerator keyGenerator;
    protected final CacheOperation operation;
    protected final Method method;
    protected final EvaluationContext evalContext;
    protected final HttpServletRequest request;

    public CacheOperationContext(CacheOperation operation, Method method, Object[] args, Class<?> targetClass, Collection<Cache> caches, ExpressionEvaluator evaluator, WebKeyGenerator keyGenerator, HttpServletRequest request) {
        this.operation = operation;
        this.caches = caches;
        this.method = method;
        this.evaluator = evaluator;
        this.keyGenerator = keyGenerator;
        this.request = request;
        this.evalContext = evaluator.createEvaluationContext(caches, method, args, targetClass);
    }

    protected boolean isConditionPassing() {
        if (StringUtils.hasText((String)this.operation.getCondition())) {
            return this.evaluator.condition(this.operation.getCondition(), this.method, this.evalContext);
        }
        return true;
    }

    protected Object generateKey() {
        if (StringUtils.hasText((String)this.operation.getKey())) {
            return this.evaluator.key(this.operation.getKey(), this.method, this.evalContext);
        }
        return this.keyGenerator.generate(this.request);
    }

    protected Collection<Cache> getCaches() {
        return this.caches;
    }
}

