/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.web;

import grails.plugin.cache.web.AlreadyGzippedException;
import grails.plugin.cache.web.Header;
import grails.plugin.cache.web.HttpDateFormatter;
import grails.plugin.cache.web.SerializableCookie;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.cglib.proxy.Callback;
import org.codehaus.groovy.grails.plugins.web.api.ControllersApi;
import org.codehaus.groovy.grails.web.servlet.GrailsFlashScope;
import org.slf4j.LoggerFactory;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.TargetSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.FlashMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class PageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Pattern PATTERN_CACHE_DIRECTIVE = Pattern.compile("([\\w-]+)(?:=(.+))?");
    protected static final int FOUR_KB = 4196;
    protected static final int GZIP_MAGIC_NUMBER_BYTE_1 = 31;
    protected static final int GZIP_MAGIC_NUMBER_BYTE_2 = -117;
    protected static final long ONE_YEAR_IN_SECONDS = 31536000L;
    protected final HttpDateFormatter httpDateFormatter = new HttpDateFormatter();
    protected final List<Header<? extends Serializable>> responseHeaders = new ArrayList();
    protected final List<SerializableCookie> serializableCookies = new ArrayList();
    protected Map<String, Serializable> requestAttributes;
    protected String contentType;
    protected byte[] gzippedBody;
    protected byte[] ungzippedBody;
    protected int statusCode;
    protected boolean storeGzipped;
    protected Date created;
    protected long timeToLiveSeconds;

    public PageInfo(int statusCode, String contentType, byte[] body, boolean storeGzipped, long timeToLiveSeconds, Collection<Header<? extends Serializable>> headers, Collection<Cookie> cookies, Map<String, Serializable> requestAttributes) throws AlreadyGzippedException {
        if (headers != null) {
            this.responseHeaders.addAll(headers);
        }
        this.setTimeToLiveWithCheckForNeverExpires(timeToLiveSeconds);
        this.created = new Date();
        this.contentType = contentType;
        this.storeGzipped = storeGzipped;
        this.statusCode = statusCode;
        this.setCacheableRequestAttributes(requestAttributes);
        try {
            if (storeGzipped) {
                this.ungzippedBody = null;
                this.gzippedBody = this.isBodyParameterGzipped() ? body : this.gzip(body);
            } else {
                Assert.isTrue((!this.isBodyParameterGzipped() ? 1 : 0) != 0, (String)"Non gzip content has been gzipped.");
                this.ungzippedBody = body;
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(this.getClass()).error("Error ungzipping gzipped body", (Throwable)e);
        }
    }

    protected void setTimeToLiveWithCheckForNeverExpires(long ttlSeconds) {
        this.timeToLiveSeconds = ttlSeconds == 0L || ttlSeconds > 31536000L ? 31536000L : ttlSeconds;
    }

    protected byte[] gzip(byte[] ungzipped) throws IOException, AlreadyGzippedException {
        if (PageInfo.isGzipped((byte[])ungzipped)) {
            throw new AlreadyGzippedException("The byte[] is already gzipped. It should not be gzipped again.");
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bytes);
        gzipOutputStream.write(ungzipped);
        gzipOutputStream.close();
        return bytes.toByteArray();
    }

    protected boolean isBodyParameterGzipped() {
        for (Header header : this.responseHeaders) {
            if (!"gzip".equals(header.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGzipped(byte[] candidate) {
        if (candidate == null || candidate.length < 2) {
            return false;
        }
        return candidate[0] == 31 && candidate[1] == -117;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getGzippedBody() {
        return this.storeGzipped ? this.gzippedBody : null;
    }

    public List<Header<? extends Serializable>> getHeaders() {
        return this.responseHeaders;
    }

    public List<SerializableCookie> getSerializableCookies() {
        return this.serializableCookies;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public byte[] getUngzippedBody() throws IOException {
        return this.storeGzipped ? this.ungzip(this.gzippedBody) : this.ungzippedBody;
    }

    protected byte[] ungzip(byte[] gzipped) throws IOException {
        GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(gzipped));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(gzipped.length);
        byte[] buffer = new byte[4196];
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = inputStream.read(buffer, 0, 4196);
            if (bytesRead == -1) continue;
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        byte[] ungzipped = byteArrayOutputStream.toByteArray();
        inputStream.close();
        byteArrayOutputStream.close();
        return ungzipped;
    }

    public boolean hasGzippedBody() {
        return this.gzippedBody != null;
    }

    public boolean hasUngzippedBody() {
        return this.ungzippedBody != null;
    }

    public boolean isOk() {
        return this.statusCode == 200;
    }

    public Date getCreated() {
        return this.created;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public Map<String, Serializable> getRequestAttributes() {
        return Collections.unmodifiableMap(this.requestAttributes);
    }

    public String getHeader(String headerName) {
        for (Header header : this.responseHeaders) {
            if (!header.getName().equals(headerName)) continue;
            return (String)((Object)header.getValue());
        }
        return null;
    }

    public long getDateHeader(String headerName) {
        String header = this.getHeader(headerName);
        if (!StringUtils.hasLength((String)header)) {
            return -1L;
        }
        try {
            return Long.valueOf(header);
        }
        catch (NumberFormatException e) {
            return this.httpDateFormatter.parseDateFromHttpDate(header).getTime();
        }
    }

    public boolean isModified(HttpServletRequest request) {
        long ifModifiedSince = request.getDateHeader("If-Modified-Since");
        long lastModified = this.getDateHeader("Last-Modified");
        if (ifModifiedSince == -1L || lastModified == -1L) {
            return true;
        }
        return lastModified > ifModifiedSince;
    }

    public boolean isMatch(HttpServletRequest request) {
        String ifNoneMatch = request.getHeader("If-None-Match");
        String etag = this.getHeader("ETag");
        if (!StringUtils.hasLength((String)ifNoneMatch) || !StringUtils.hasLength((String)etag)) {
            return false;
        }
        return ifNoneMatch == etag;
    }

    public Map<String, Object> getCacheDirectives() {
        String cacheControl = this.getHeader("Cache-Control");
        HashMap<String, Object> directives = new HashMap<String, Object>();
        if (StringUtils.hasLength((String)cacheControl)) {
            for (String directive : cacheControl.split(",\\s*")) {
                Matcher matcher = PATTERN_CACHE_DIRECTIVE.matcher(directive);
                if (!matcher.find()) continue;
                String name = matcher.group(1);
                String value = matcher.group(2);
                if (StringUtils.hasLength((String)value)) {
                    try {
                        directives.put(name, Integer.valueOf(value));
                    }
                    catch (NumberFormatException e) {
                        directives.put(name, value);
                    }
                    continue;
                }
                directives.put(name, true);
            }
        }
        return directives;
    }

    protected void setCacheableRequestAttributes(Map<String, Serializable> attributes) {
        this.requestAttributes = new HashMap();
        for (Map.Entry<String, Serializable> entry : attributes.entrySet()) {
            Serializable value = entry.getValue();
            if (value instanceof GrailsFlashScope || value instanceof FlashMap || value instanceof HttpServletResponse || value instanceof ControllersApi || value instanceof PointcutAdvisor || value instanceof PointcutAdvisor[] || value instanceof Callback || value instanceof Callback[] || value instanceof TargetSource) continue;
            this.requestAttributes.put(entry.getKey(), value);
        }
    }
}

