/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.web;

import grails.plugin.cache.SerializableOutputStream;
import grails.plugin.cache.web.GenericResponseWrapper;
import grails.plugin.cache.web.Header;
import grails.plugin.cache.web.filter.FilterServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.LoggerFactory;

public class GenericResponseWrapper
extends HttpServletResponseWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int statusCode = 200;
    protected int contentLength;
    protected String contentType;
    protected final Map<String, List<Serializable>> headersMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    protected final List<Cookie> cookies = new ArrayList();
    protected ServletOutputStream out;
    protected transient PrintWriter writer;
    protected boolean disableFlushBuffer = true;

    public GenericResponseWrapper(HttpServletResponse response, SerializableOutputStream outputStream) {
        super(response);
        this.out = new FilterServletOutputStream(outputStream);
    }

    public ServletOutputStream getOutputStream() {
        return this.out;
    }

    public void setStatus(int code) {
        this.statusCode = code;
        super.setStatus(code);
    }

    public void sendError(int code, String string) throws IOException {
        this.statusCode = code;
        super.sendError(code, string);
    }

    public void sendError(int code) throws IOException {
        this.statusCode = code;
        super.sendError(code);
    }

    public void sendRedirect(String string) throws IOException {
        this.statusCode = 302;
        super.sendRedirect(string);
    }

    public void setStatus(int code, String msg) {
        this.statusCode = code;
        LoggerFactory.getLogger(this.getClass()).warn("Discarding message because this method is deprecated.");
        super.setStatus(code);
    }

    public int getStatus() {
        return this.statusCode;
    }

    public void setContentLength(int length) {
        this.contentLength = length;
        super.setContentLength(length);
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String type) {
        this.contentType = type;
        super.setContentType(type);
    }

    public String getContentType() {
        return this.contentType;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.out, this.getCharacterEncoding()), true);
        }
        return this.writer;
    }

    public void addHeader(String name, String value) {
        LinkedList<String> values = (LinkedList<String>)this.headersMap.get(name);
        if (values == null) {
            values = new LinkedList<String>();
            this.headersMap.put(name, values);
        }
        values.add(value);
        super.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        LinkedList<String> values = new LinkedList<String>();
        values.add(value);
        this.headersMap.put(name, values);
        super.setHeader(name, value);
    }

    public void addDateHeader(String name, long date) {
        LinkedList<Long> values = (LinkedList<Long>)this.headersMap.get(name);
        if (values == null) {
            values = new LinkedList<Long>();
            this.headersMap.put(name, values);
        }
        values.add(date);
        super.addDateHeader(name, date);
    }

    public void setDateHeader(String name, long date) {
        LinkedList<Long> values = new LinkedList<Long>();
        values.add(date);
        this.headersMap.put(name, values);
        super.setDateHeader(name, date);
    }

    public void addIntHeader(String name, int value) {
        LinkedList<Integer> values = (LinkedList<Integer>)this.headersMap.get(name);
        if (values == null) {
            values = new LinkedList<Integer>();
            this.headersMap.put(name, values);
        }
        values.add(value);
        super.addIntHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        LinkedList<Integer> values = new LinkedList<Integer>();
        values.add(value);
        this.headersMap.put(name, values);
        super.setIntHeader(name, value);
    }

    public Collection<Header<? extends Serializable>> getAllHeaders() {
        LinkedList<Header<? extends Serializable>> headers = new LinkedList<Header<? extends Serializable>>();
        for (Map.Entry headerEntry : this.headersMap.entrySet()) {
            String name = (String)headerEntry.getKey();
            block6: for (Serializable value : (List)headerEntry.getValue()) {
                Header.Type type = Header.Type.determineType(value.getClass());
                switch (1.$SwitchMap$grails$plugin$cache$web$Header$Type[type.ordinal()]) {
                    case 1: {
                        headers.add((Header<? extends Serializable>)new Header(name, (Serializable)((Object)((String)((Object)value)))));
                        continue block6;
                    }
                    case 2: {
                        headers.add((Header<? extends Serializable>)new Header(name, (Serializable)((Long)value)));
                        continue block6;
                    }
                    case 3: {
                        headers.add((Header<? extends Serializable>)new Header(name, (Serializable)((Integer)value)));
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("No mapping for Header.Type: " + type);
            }
        }
        return headers;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
        super.addCookie(cookie);
    }

    public Collection<Cookie> getCookies() {
        return this.cookies;
    }

    public void flushBuffer() throws IOException {
        this.flush();
        if (!this.disableFlushBuffer) {
            super.flushBuffer();
        }
    }

    public void reset() {
        super.reset();
        this.cookies.clear();
        this.headersMap.clear();
        this.statusCode = 200;
        this.contentType = null;
        this.contentLength = 0;
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.out.flush();
    }

    public boolean isDisableFlushBuffer() {
        return this.disableFlushBuffer;
    }

    public void setDisableFlushBuffer(boolean disable) {
        this.disableFlushBuffer = disable;
    }
}

