/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.ehcache;

import grails.plugin.cache.GrailsCacheManager;
import grails.plugin.cache.ehcache.GrailsEhcacheCache;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.util.Assert;

public class GrailsEhcacheCacheManager
implements GrailsCacheManager,
InitializingBean {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected CacheManager cacheManager;
    protected final ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap();
    protected Set<String> cacheNames = new LinkedHashSet();

    public Cache getCache(String name) {
        Cache cache = (Cache)this.cacheMap.get(name);
        if (cache == null) {
            Ehcache ehcache = this.cacheManager.getEhcache(name);
            if (ehcache == null) {
                this.cacheManager.addCache(name);
                ehcache = this.cacheManager.getEhcache(name);
            }
            cache = new GrailsEhcacheCache(ehcache);
            this.addCache(cache);
        }
        return cache;
    }

    public boolean cacheExists(String name) {
        return this.getCacheNames().contains(name);
    }

    public boolean destroyCache(String name) {
        this.cacheManager.removeCache(name);
        this.cacheMap.remove(name);
        this.cacheNames.remove(name);
        return true;
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableSet(this.cacheNames);
    }

    protected Collection<Cache> loadCaches() {
        Assert.notNull((Object)this.cacheManager, (String)"A backing EhCache CacheManager is required");
        Status status = this.cacheManager.getStatus();
        Assert.isTrue((boolean)Status.STATUS_ALIVE.equals(status), (String)("An 'alive' EhCache CacheManager is required - current cache is " + status));
        String[] names = this.cacheManager.getCacheNames();
        LinkedHashSet<Cache> caches = new LinkedHashSet<Cache>(names.length);
        for (String name : names) {
            caches.add((Cache)new GrailsEhcacheCache(this.cacheManager.getEhcache(name)));
        }
        return caches;
    }

    protected void addCache(Cache cache) {
        this.cacheMap.put(cache.getName(), cache);
        this.cacheNames.add(cache.getName());
    }

    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.cacheManager, (String)"A backing EhCache CacheManager is required");
        if (Status.STATUS_ALIVE != this.cacheManager.getStatus()) {
            return;
        }
        Collection caches = this.loadCaches();
        for (Cache cache : caches) {
            this.addCache(cache);
        }
        this.log.debug("Cache names: {}", (Object)this.getCacheNames());
    }
}

