/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.ehcache;

import grails.plugin.cache.ehcache.GrailsEhCacheManagerFactoryBean;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class GrailsEhCacheManagerFactoryBean
implements FactoryBean<CacheManager>,
InitializingBean,
DisposableBean {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Resource configLocation;
    protected String cacheManagerName;
    protected ReloadableCacheManager cacheManager;

    public CacheManager getObject() {
        return this.cacheManager;
    }

    public Class<? extends ReloadableCacheManager> getObjectType() {
        return this.cacheManager == null ? ReloadableCacheManager.class : this.cacheManager.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws IOException, CacheException {
        InputStream inputStream;
        this.logger.info("Initializing EHCache CacheManager");
        if (this.configLocation == null) {
            String dummyXml = "<ehcache updateCheck='false'><defaultCache maxElementsInMemory='1' eternal='false' overflowToDisk='false' timeToLiveSeconds='1234' /></ehcache>";
            inputStream = new ByteArrayInputStream(dummyXml.getBytes());
        } else {
            inputStream = this.configLocation.getInputStream();
        }
        try {
            this.cacheManager = new ReloadableCacheManager(inputStream);
        }
        finally {
            inputStream.close();
        }
        if (this.cacheManagerName != null) {
            this.cacheManager.setName(this.cacheManagerName);
        }
    }

    public void destroy() {
        this.logger.info("Shutting down EHCache CacheManager");
        this.cacheManager.shutdown();
    }

    public void setConfigLocation(Resource location) {
        this.configLocation = location;
    }

    public void setCacheManagerName(String name) {
        this.cacheManagerName = name;
    }
}

