/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache.compiler;

import grails.plugin.cache.CacheEvict;
import grails.plugin.cache.CachePut;
import grails.plugin.cache.Cacheable;
import grails.util.CollectionUtils;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class CacheTransformation
implements ASTTransformation {
    protected static final Map<ClassNode, ClassNode> GRAILS_ANNOTATION_CLASS_NODE_TO_SPRING_ANNOTATION_CLASS_NODE = CollectionUtils.newMap((Object[])new Object[]{new ClassNode(Cacheable.class), new ClassNode(org.springframework.cache.annotation.Cacheable.class), new ClassNode(CachePut.class), new ClassNode(org.springframework.cache.annotation.CachePut.class), new ClassNode(CacheEvict.class), new ClassNode(org.springframework.cache.annotation.CacheEvict.class)});

    public void visit(ASTNode[] astNodes, SourceUnit sourceUnit) {
        ASTNode firstNode = astNodes[0];
        ASTNode secondNode = astNodes[1];
        if (!(firstNode instanceof AnnotationNode) || !(secondNode instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: " + firstNode.getClass().getName() + " / " + secondNode.getClass().getName());
        }
        AnnotationNode grailsCacheAnnotationNode = (AnnotationNode)firstNode;
        AnnotatedNode annotatedNode = (AnnotatedNode)secondNode;
        AnnotationNode springCacheAnnotationNode = this.getCorrespondingSpringAnnotation(grailsCacheAnnotationNode);
        annotatedNode.addAnnotation(springCacheAnnotationNode);
    }

    protected AnnotationNode getCorrespondingSpringAnnotation(AnnotationNode grailsCacheAnnotationNode) {
        Map grailsAnnotationMembers = grailsCacheAnnotationNode.getMembers();
        ClassNode springCacheAnnotationClassNode = (ClassNode)GRAILS_ANNOTATION_CLASS_NODE_TO_SPRING_ANNOTATION_CLASS_NODE.get(grailsCacheAnnotationNode.getClassNode());
        AnnotationNode springCacheAnnotationNode = new AnnotationNode(springCacheAnnotationClassNode);
        for (Map.Entry entry : grailsAnnotationMembers.entrySet()) {
            springCacheAnnotationNode.addMember((String)entry.getKey(), (Expression)entry.getValue());
        }
        return springCacheAnnotationNode;
    }
}

