/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.cache;

import grails.plugin.cache.GrailsAnnotationCacheOperationSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.cache.annotation.AnnotationCacheOperationSource;

public class CacheBeanPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
        this.log.info("postProcessBeanDefinitionRegistry start");
        AbstractBeanDefinition beanDef = this.findBeanDefinition(registry);
        if (beanDef == null) {
            this.log.error("Unable to find the AnnotationCacheOperationSource bean definition");
            return;
        }
        beanDef.setBeanClass(GrailsAnnotationCacheOperationSource.class);
        MutablePropertyValues props = beanDef.getPropertyValues();
        if (props == null) {
            props = new MutablePropertyValues();
            beanDef.setPropertyValues(props);
        }
        props.addPropertyValue("grailsApplication", (Object)new RuntimeBeanReference("grailsApplication", true));
        this.log.debug("updated {}", (Object)beanDef);
    }

    protected AbstractBeanDefinition findBeanDefinition(BeanDefinitionRegistry registry) {
        AbstractBeanDefinition beanDef = null;
        String beanName = null;
        if (registry.containsBeanDefinition("org.springframework.cache.annotation.AnnotationCacheOperationSource#0")) {
            beanDef = (AbstractBeanDefinition)registry.getBeanDefinition("org.springframework.cache.annotation.AnnotationCacheOperationSource#0");
            beanName = "org.springframework.cache.annotation.AnnotationCacheOperationSource#0";
        } else {
            String className = AnnotationCacheOperationSource.class.getName();
            for (String name : registry.getBeanDefinitionNames()) {
                if (!className.equals(registry.getBeanDefinition(name).getBeanClassName())) continue;
                beanDef = (AbstractBeanDefinition)registry.getBeanDefinition(name);
                beanName = name;
                break;
            }
        }
        if (beanDef != null && !"cacheOperationSource".equals(beanName)) {
            registry.registerAlias(beanName, "cacheOperationSource");
        }
        return beanDef;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        this.log.info("postProcessBeanFactory");
    }
}

