/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.web;

import au.org.emii.portal.config.ConfigurationLoaderStage1Impl;
import au.org.emii.portal.javascript.OpenLayersJavascript;
import au.org.emii.portal.session.PortalSession;
import au.org.emii.portal.util.PortalSessionCloner;
import au.org.emii.portal.util.PortalSessionUtilities;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.util.DesktopInit;
import org.zkoss.zk.ui.util.SessionInit;

public class SessionInitImpl
implements SessionInit,
DesktopInit {
    public static final String PORTAL_SESSION_ATTRIBUTE = "portalSession";
    private static final Logger LOGGER = Logger.getLogger(SessionInitImpl.class);
    private static final String ERROR_PAGE = "/WEB-INF/jsp/Error.jsp";
    private static final int MAX_TIME_RELOADING_SECONDS = 30;

    private PortalSession getMasterPortalSession(Session session) {
        return (PortalSession)this.getServletContext(session).getAttribute("masterPortalSession");
    }

    private ServletContext getServletContext(Session session) {
        return ((HttpSession)session.getNativeSession()).getServletContext();
    }

    private ApplicationContext getApplicationContext(Session session) {
        return WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext(session));
    }

    private ConfigurationLoaderStage1Impl getConfigurationLoaderStage1(Session session) {
        return (ConfigurationLoaderStage1Impl)this.getApplicationContext(session).getBean(ConfigurationLoaderStage1Impl.class);
    }

    private PortalSessionUtilities getPortalSessionUtilities(Session session) {
        return (PortalSessionUtilities)this.getApplicationContext(session).getBean(PortalSessionUtilities.class);
    }

    private PortalSessionCloner getPortalSessionCloner(Session session) {
        return (PortalSessionCloner)this.getApplicationContext(session).getBean(PortalSessionCloner.class);
    }

    private void waitForPortalReload(ConfigurationLoaderStage1Impl stage1, Session session) {
        for (int seconds = 30; this.getMasterPortalSession(session) == null && seconds > 0; --seconds) {
            try {
                Thread.sleep(1000L);
                LOGGER.debug((Object)("waited " + (30 - seconds) + " for portal to come up..."));
                continue;
            }
            catch (InterruptedException ex) {
                LOGGER.debug((Object)"config reload-wait cancelled");
            }
        }
    }

    public void init(Session session, Object request) throws Exception {
        LOGGER.debug((Object)"* SESSION INIT:");
        ConfigurationLoaderStage1Impl stage1 = this.getConfigurationLoaderStage1(session);
        this.waitForPortalReload(stage1, session);
        if (stage1.isError()) {
            this.redirectAndInvalidateSession(session, ERROR_PAGE);
        } else {
            PortalSession masterPortalSession = this.getMasterPortalSession(session);
            if (masterPortalSession == null) {
                LOGGER.error((Object)"masterPortalSession is null - redirecting user to error page");
                this.redirectAndInvalidateSession(session, ERROR_PAGE);
            } else {
                PortalSessionCloner cloner = this.getPortalSessionCloner(session);
                PortalSession portalSession = cloner.clone(masterPortalSession);
                session.setAttribute(PORTAL_SESSION_ATTRIBUTE, (Object)portalSession);
                LOGGER.debug((Object)"* SESSION INIT OK");
            }
        }
    }

    private void redirectAndInvalidateSession(Session session, String page) {
        try {
            HttpSession nativeSession;
            Executions.getCurrent().forward(page);
            if (session != null && (nativeSession = (HttpSession)session.getNativeSession()) != null) {
                nativeSession.invalidate();
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Error redirecting", (Throwable)ex);
        }
    }

    public void init(Desktop desktop, Object request) throws Exception {
        LOGGER.debug((Object)"* INIT Desktop");
        Session session = desktop.getSession();
        if (session == null) {
            LOGGER.debug((Object)"user has a null session - no idea why (system coming up/going down - concurrency ?) will redirect to error page");
            this.redirectAndInvalidateSession(desktop.getSession(), ERROR_PAGE);
        } else {
            PortalSession portalSession = (PortalSession)session.getAttribute(PORTAL_SESSION_ATTRIBUTE);
            if (portalSession == null) {
                this.init(session, null);
                portalSession = (PortalSession)session.getAttribute(PORTAL_SESSION_ATTRIBUTE);
            }
            PortalSessionUtilities portalSessionUtilities = this.getPortalSessionUtilities(session);
            OpenLayersJavascript openLayersJavascript = (OpenLayersJavascript)this.getApplicationContext(session).getBean(OpenLayersJavascript.class);
            String script = openLayersJavascript.initialiseMap(portalSessionUtilities.getCurrentBoundingBox(portalSession)) + openLayersJavascript.getIFrameReferences() + openLayersJavascript.setBaseLayer(portalSession.getBaseLayer()) + openLayersJavascript.activateMapLayers(portalSession.getActiveLayers());
            script = openLayersJavascript.minify(script);
            portalSession.setOnIframeMapFullyLoaded(script);
            LOGGER.debug((Object)("onIframeMapFullyLoaded set to: " + script));
        }
        LOGGER.debug((Object)"...session init complete");
    }
}

