/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.web;

import au.org.emii.portal.config.ConfigurationLoaderStage1;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import org.apache.log4j.Logger;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.zkoss.util.resource.LabelLocator;
import org.zkoss.util.resource.Labels;
import zk.extra.BiocacheLabelLocator;

public class ApplicationInit
extends ContextLoaderListener {
    public static final String CONFIGURATION_LOADER_ATTRIBUTE = "configurationLoader";
    public static final String CONFIGURATION_LOADER_THREAD_ATTRIBUTE = "configurationLoaderThread";
    public static final String PORTAL_MASTER_SESSION_ATTRIBUTE = "masterPortalSession";
    private static final Logger LOGGER = Logger.getLogger(ApplicationInit.class);

    public void contextInitialized(ServletContextEvent sce) {
        LOGGER.debug((Object)"================[WEB PORTAL APPLICATION INIT]================");
        super.contextInitialized(sce);
        ServletContext servletContext = sce.getServletContext();
        WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        ConfigurationLoaderStage1 configurationLoader = (ConfigurationLoaderStage1)context.getBean(ConfigurationLoaderStage1.class);
        configurationLoader.setServletContext(servletContext);
        servletContext.setAttribute(CONFIGURATION_LOADER_ATTRIBUTE, (Object)configurationLoader);
        Thread configurationLoaderThread = new Thread((Runnable)configurationLoader);
        configurationLoaderThread.setName("ConfigurationLoader-instance-" + configurationLoaderThread.toString());
        servletContext.setAttribute(CONFIGURATION_LOADER_THREAD_ATTRIBUTE, (Object)configurationLoaderThread);
        configurationLoaderThread.start();
        LOGGER.debug((Object)"REGISTERING Biocache Labeller...");
        Labels.register((LabelLocator)new BiocacheLabelLocator());
        LOGGER.debug((Object)"* APPLICATION INIT: complete");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        LOGGER.debug((Object)"APPLICATION shutdown requested");
        ServletContext servletContext = sce.getServletContext();
        ConfigurationLoaderStage1 configurationLoader = (ConfigurationLoaderStage1)servletContext.getAttribute(CONFIGURATION_LOADER_ATTRIBUTE);
        Thread configurationLoaderThread = (Thread)servletContext.getAttribute(CONFIGURATION_LOADER_THREAD_ATTRIBUTE);
        if (configurationLoader != null) {
            configurationLoader.stop();
        }
        if (configurationLoaderThread != null) {
            configurationLoaderThread.interrupt();
        }
        servletContext.removeAttribute(CONFIGURATION_LOADER_ATTRIBUTE);
        servletContext.removeAttribute(CONFIGURATION_LOADER_THREAD_ATTRIBUTE);
        super.contextDestroyed(sce);
    }
}

