/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.validator.EmailValidator;
import org.apache.commons.validator.UrlValidator;

public final class Validate {
    private Validate() {
    }

    public static boolean empty(String string) {
        return string == null || string.matches("\\s*");
    }

    public static String escapeHtmlAndTrim(String string) {
        return StringEscapeUtils.escapeHtml((String)string).trim();
    }

    public static boolean invalidHttpUri(String uri) {
        UrlValidator urlValidator = new UrlValidator(new String[]{"http", "https"});
        return !urlValidator.isValid(uri.trim());
    }

    public static String prefixUri(String uri) {
        String fullUri = !uri.matches("^[Hh][Tt][Tt][Pp][Ss]?://.*") ? "http://" + uri : uri;
        return fullUri;
    }

    public static DateFormat getIsoDateFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    }

    public static SimpleDateFormat getShortIsoDateFormatter() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static boolean email(String email) {
        return EmailValidator.getInstance().isValid(email);
    }
}

