/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.util;

import au.org.ala.spatial.util.Util;
import au.org.emii.portal.lang.LanguagePack;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.MapLayerMetadata;
import au.org.emii.portal.util.LayerUtilities;
import au.org.emii.portal.util.RemoteMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;

public class RemoteMapImpl
implements RemoteMap {
    private static final Logger LOGGER = Logger.getLogger(RemoteMapImpl.class);
    protected LanguagePack languagePack = null;
    protected LayerUtilities layerUtilities = null;

    public MapLayer createWKTLayer(String wkt, String label) {
        MapLayer wktLayer = new MapLayer();
        wktLayer.setPolygonLayer(true);
        LOGGER.debug((Object)("adding WKT feature layer " + label));
        wktLayer.setName(label);
        wktLayer.setLayer(label);
        wktLayer.setId(label);
        wktLayer.setEnvColour("red");
        int colour = Util.nextColour();
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        wktLayer.setRedVal(r);
        wktLayer.setGreenVal(g);
        wktLayer.setBlueVal(b);
        wktLayer.setType(11);
        wktLayer.setWKT(wkt);
        if (wktLayer.getMapLayerMetadata() == null) {
            wktLayer.setMapLayerMetadata(new MapLayerMetadata());
        }
        wkt = wkt.replace(" (", "(").replace(", ", ",");
        List bb = Util.getBoundingBox((String)wkt);
        wktLayer.getMapLayerMetadata().setBbox(bb);
        return wktLayer;
    }

    public MapLayer createAndTestWMSLayer(String label, String uri, float opacity) {
        MapLayer mapLayer = new MapLayer();
        mapLayer.setName(label);
        mapLayer.setUri(uri);
        mapLayer.setLayer(this.layerUtilities.getLayer(uri));
        mapLayer.setOpacity(opacity);
        mapLayer.setImageFormat(this.layerUtilities.getImageFormat(uri));
        List bbox = this.layerUtilities.getBBox(uri);
        if (bbox != null) {
            mapLayer.getMapLayerMetadata().setBbox(bbox);
        }
        mapLayer.setId(uri + label.replaceAll("\\s+", ""));
        mapLayer.setDescription(label);
        String version = this.layerUtilities.getVersionValue(uri);
        mapLayer.setType(this.layerUtilities.internalVersion(version));
        return mapLayer;
    }

    public LanguagePack getLanguagePack() {
        return this.languagePack;
    }

    @Required
    public void setLanguagePack(LanguagePack languagePack) {
        this.languagePack = languagePack;
    }

    public LayerUtilities getLayerUtilities() {
        return this.layerUtilities;
    }

    @Required
    public void setLayerUtilities(LayerUtilities layerUtilities) {
        this.layerUtilities = layerUtilities;
    }

    public MapLayer createLocalLayer(int type, String label) {
        MapLayer layer = new MapLayer();
        layer.setName(label);
        layer.setLayer(label);
        layer.setId(label);
        layer.setEnvColour("red");
        int colour = Util.nextColour();
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        layer.setBlueVal(b);
        layer.setGreenVal(g);
        layer.setRedVal(r);
        layer.setType(type);
        layer.setSubType(type);
        return layer;
    }
}

