/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.util;

import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.SpatialUtil;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.util.LayerUtilities;
import au.org.emii.portal.util.LayerUtilitiesImpl;
import au.org.emii.portal.util.PrintMapComposer;
import au.org.emii.portal.util.Validate;
import au.org.emii.portal.value.BoundingBox;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class PrintMapComposer {
    private static final int MAX_WIDTH_LOW_RES = 2080;
    private static final int MAX_HEIGHT_LOW_RES = 2080;
    private static final int MAX_WIDTH_HIGH_RES = 7016;
    private static final int MAX_HEIGHT_HIGH_RES = 4960;
    private static final int DPI_HIGH_RES = 600;
    private static final int DPI_LOW_RES = 200;
    private static final Logger LOGGER = Logger.getLogger(PrintMapComposer.class);
    private static final Map<String, Object[]> IMAGE_CACHE = new ConcurrentHashMap();
    private static Long imageCacheSize = 0L;
    private static Long maxImageCacheSize = 100000000L;
    private String baseMap;
    private double[] extents;
    private int[] windowSize;
    private String comment;
    private String outputType;
    private double aspectRatio;
    private int width;
    private int height;
    private int dpi;
    private double scale;
    private List<MapLayer> mapLayers;
    private LayerUtilities layerUtilities = new LayerUtilitiesImpl();

    public PrintMapComposer(String baseMap, List<MapLayer> mapLayers, BoundingBox bb, double[] extents, int[] windowSize, String comment, String outputType, int resolution) {
        int h;
        this.mapLayers = new ArrayList<MapLayer>(mapLayers);
        this.baseMap = baseMap;
        this.extents = extents == null ? null : (double[])extents.clone();
        int[] nArray = this.windowSize = windowSize == null ? null : (int[])windowSize.clone();
        if (bb.getMaxLongitude() < bb.getMinLongitude() || bb.getMaxLongitude() > 180.0f) {
            bb.setMaxLongitude(180.0f);
        }
        if (bb.getMinLongitude() < -180.0f) {
            bb.setMinLongitude(-180.0f);
        }
        this.aspectRatio = (double)this.windowSize[0] / (double)this.windowSize[1];
        if (this.aspectRatio > 10.0 || this.aspectRatio < 0.1) {
            LOGGER.error((Object)("bad aspect ratio, windowSize = " + this.windowSize[0] + ", " + this.windowSize[1] + ", extents = " + this.extents[0] + " " + this.extents[1] + " " + this.extents[2] + " " + this.extents[3]));
            this.windowSize[0] = SpatialUtil.convertLngToPixel((double)bb.getMaxLongitude()) - SpatialUtil.convertLngToPixel((double)bb.getMinLongitude());
            this.windowSize[1] = SpatialUtil.convertLatToPixel((double)bb.getMaxLatitude()) - SpatialUtil.convertLatToPixel((double)bb.getMinLatitude());
            this.aspectRatio = (double)this.windowSize[0] / (double)this.windowSize[1];
        }
        this.comment = comment;
        this.outputType = outputType;
        int w = resolution == 1 && "outline".equalsIgnoreCase(baseMap) ? 7016 : 2080;
        int n = h = resolution == 1 && "outline".equalsIgnoreCase(baseMap) ? 4960 : 2080;
        if (this.aspectRatio > (double)w / (double)h) {
            this.width = w;
            this.height = (int)((double)w / this.aspectRatio);
        } else {
            this.height = h;
            this.width = (int)((double)h * this.aspectRatio);
        }
        this.scale = (double)this.width / (double)this.windowSize[0];
        this.dpi = resolution == 1 && "outline".equalsIgnoreCase(baseMap) ? 600 : 200;
    }

    public PrintMapComposer(double[] bbox, String baseMap, MapLayer[] mapLayers, double aspectRatio, String comment, String type, int resolution) {
        int h;
        this.mapLayers = Arrays.asList(mapLayers);
        this.baseMap = baseMap;
        this.aspectRatio = aspectRatio;
        this.extents = new double[]{SpatialUtil.convertLngToMeters((double)bbox[0]), SpatialUtil.convertLatToMeters((double)bbox[1]), SpatialUtil.convertLngToMeters((double)bbox[2]), SpatialUtil.convertLatToMeters((double)bbox[3])};
        this.windowSize = new int[2];
        this.windowSize[0] = SpatialUtil.convertLngToPixel((double)bbox[2]) - SpatialUtil.convertLngToPixel((double)bbox[0]);
        this.windowSize[1] = SpatialUtil.convertLatToPixel((double)bbox[1]) - SpatialUtil.convertLatToPixel((double)bbox[3]);
        this.comment = comment;
        this.outputType = type;
        int w = resolution == 1 && "outline".equalsIgnoreCase(baseMap) ? 7016 : 2080;
        int n = h = resolution == 1 && "outline".equalsIgnoreCase(baseMap) ? 4960 : 2080;
        if (aspectRatio < (double)this.windowSize[0] / (double)this.windowSize[1]) {
            this.width = w;
            this.height = (int)((double)w / aspectRatio);
            double mid = (double)this.windowSize[1] / 2.0 + (double)SpatialUtil.convertLatToPixel((double)bbox[3]);
            this.windowSize[1] = (int)((double)this.windowSize[0] / aspectRatio);
            double half = (double)this.windowSize[1] / 2.0;
            this.extents[1] = SpatialUtil.convertLatToMeters((double)SpatialUtil.convertPixelToLat((int)((int)(mid + half))));
            this.extents[3] = SpatialUtil.convertLatToMeters((double)SpatialUtil.convertPixelToLat((int)((int)(mid - half))));
        } else {
            this.height = h;
            this.width = (int)((double)h * aspectRatio);
            double mid = (double)this.windowSize[0] / 2.0 + (double)SpatialUtil.convertLngToPixel((double)bbox[0]);
            this.windowSize[0] = (int)((double)this.windowSize[1] * aspectRatio);
            double half = (double)this.windowSize[0] / 2.0;
            this.extents[0] = SpatialUtil.convertLngToMeters((double)SpatialUtil.convertPixelToLng((int)((int)(mid - half))));
            this.extents[2] = SpatialUtil.convertLngToMeters((double)SpatialUtil.convertPixelToLng((int)((int)(mid + half))));
        }
        this.scale = 1.0;
        this.dpi = resolution == 1 && "outline".equalsIgnoreCase(baseMap) ? 600 : 200;
    }

    private List drawTiles(Graphics2D g, boolean drawTiles) {
        ArrayList urls = new ArrayList();
        if ("normal".equalsIgnoreCase(this.baseMap)) {
            urls.addAll(this.drawGoogle(g, "roadmap", drawTiles));
        } else if ("hybrid".equalsIgnoreCase(this.baseMap)) {
            urls.addAll(this.drawGoogle(g, "hybrid", drawTiles));
        } else if ("minimal".equalsIgnoreCase(this.baseMap)) {
            urls.addAll(this.drawOSM(g, drawTiles));
        } else {
            String uri = CommonData.getGeoServer() + "/wms/reflect?LAYERS=ALA%3Aworld&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&STYLES=&FORMAT=image%2Fjpeg&SRS=EPSG%3A3857&DPI=" + this.dpi;
            urls.addAll(this.drawUri(g, uri, 1.0f, false, drawTiles));
        }
        for (int i = this.mapLayers.size() - 1; i >= 0; --i) {
            if ("Map options".equalsIgnoreCase(((MapLayer)this.mapLayers.get(i)).getName()) || !((MapLayer)this.mapLayers.get(i)).isDisplayed()) continue;
            for (int j = ((MapLayer)this.mapLayers.get(i)).getChildCount() - 1; j >= 0; --j) {
                if (!((MapLayer)this.mapLayers.get(i)).getChild(j).isDisplayed()) continue;
                urls.addAll(this.drawLayer(g, ((MapLayer)this.mapLayers.get(i)).getChild(j), drawTiles));
            }
            urls.addAll(this.drawLayer(g, (MapLayer)this.mapLayers.get(i), drawTiles));
        }
        return urls;
    }

    public void fetchTiles(Graphics2D g) {
        List list = this.drawTiles(g, false);
        ArrayList<FileCacheUrl> fileCacheUrls = new ArrayList<FileCacheUrl>();
        for (Object o : list) {
            fileCacheUrls.add(new FileCacheUrl(this, (String)o));
        }
        int NUMBER_OF_GET_IMAGE_THREADS = 4;
        ExecutorService executorService = Executors.newFixedThreadPool(NUMBER_OF_GET_IMAGE_THREADS);
        try {
            executorService.invokeAll(fileCacheUrls);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"getting image urls interrupted", (Throwable)e);
        }
    }

    private String getCacheFilename(String url) {
        String hash = url.hashCode() + "";
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] b = md.digest(url.getBytes());
            hash = "";
            for (byte i : b) {
                hash = hash + i;
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)"failed to use MD5 as filename");
        }
        return "/data/webportal/cache/" + hash;
    }

    public byte[] get() {
        BufferedImage map = new BufferedImage(this.width, this.height, 2);
        Graphics2D g = (Graphics2D)map.getGraphics();
        g.setPaint(Color.white);
        g.fillRect(0, 0, this.width, this.height);
        this.fetchTiles(g);
        this.drawTiles(g, true);
        int fontSize = 30;
        String[] lines = this.comment.split("\n");
        int commentHeight = this.comment.length() > 0 ? (int)((double)(fontSize * lines.length) * 1.5) : 0;
        BufferedImage mapFlat = new BufferedImage(this.width, this.height + commentHeight, 1);
        Graphics2D gFlat = (Graphics2D)mapFlat.getGraphics();
        gFlat.setPaint(Color.white);
        gFlat.fillRect(0, 0, this.width, this.height + commentHeight);
        gFlat.drawImage(map, 0, 0, this.width, this.height, Color.white, null);
        if (commentHeight > 0) {
            gFlat.setColor(Color.black);
            gFlat.setFont(new Font("Arial", 0, fontSize));
            int h = this.height + fontSize;
            for (int i = 0; i < lines.length; ++i) {
                gFlat.drawString(lines[i], 20, (int)((double)h + (double)i * 1.5 * (double)fontSize));
            }
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if ("png".equalsIgnoreCase(this.outputType)) {
                ImageIO.write((RenderedImage)mapFlat, "png", bos);
            } else if ("jpg".equalsIgnoreCase(this.outputType)) {
                ImageIO.write((RenderedImage)mapFlat, "jpg", bos);
            } else if ("pdf".equalsIgnoreCase(this.outputType)) {
                ImageIO.write((RenderedImage)mapFlat, "jpg", bos);
                bos.flush();
                return this.makePdf(bos.toByteArray());
            }
            bos.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)"failed output image", (Throwable)e);
        }
        return bos.toByteArray();
    }

    private byte[] makePdf(byte[] bytes) throws IOException {
        File tmpJpg = File.createTempFile("makePdfFromJpg", ".jpg");
        FileUtils.writeByteArrayToFile((File)tmpJpg, (byte[])bytes);
        File tmpHtml = File.createTempFile("makePdfFromJpg", ".html");
        File tmpPdf = File.createTempFile("makePdfFromJpg", ".pdf");
        int fontSize = 30;
        String[] lines = this.comment.split("\n");
        int commentHeight = this.comment.length() > 0 ? (int)((double)(fontSize * lines.length) * 1.5) : 0;
        FileUtils.writeStringToFile((File)tmpHtml, (String)("<html><body><img style='height:" + (this.height + commentHeight) + ";width:" + this.width + ";' " + "src='" + tmpJpg.getPath() + "' />"));
        String[] cmd = new String[]{CommonData.getSettings().getProperty("wkhtmltopdf.path"), "-B", "10", "-L", "10", "-T", "10", "-R", "10", "--page-width", "" + (this.width / 4 + 40), "--page-height", "" + ((this.height + commentHeight) / 4 + 40), tmpHtml.getPath(), tmpPdf.getPath()};
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.environment().putAll(System.getenv());
        builder.redirectErrorStream(true);
        Process proc = null;
        try {
            proc = builder.start();
            proc.waitFor();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error running wkhtmltopdf", (Throwable)e);
        }
        byte[] pdf = FileUtils.readFileToByteArray((File)tmpPdf);
        FileUtils.deleteQuietly((File)tmpJpg);
        FileUtils.deleteQuietly((File)tmpHtml);
        FileUtils.deleteQuietly((File)tmpPdf);
        return pdf;
    }

    private List drawOSM(Graphics2D g, boolean drawTiles) {
        int srcWidth;
        int res;
        ArrayList<String> imageUrls = new ArrayList<String>();
        double[] resolutions = new double[]{156543.03390625, 78271.516953125, 39135.7584765625, 19567.87923828125, 9783.939619140625, 4891.9698095703125, 2445.9849047851562, 1222.9924523925781, 611.4962261962891, 305.74811309814453, 152.87405654907226, 76.43702827453613, 38.218514137268066, 19.109257068634033, 9.554628534317017, 4.777314267158508, 2.388657133579254, 1.194328566789627, 0.5971642833948135};
        double[] origin = new double[]{-2.003750834E7, -2.003750834E7};
        double actualRes = (this.extents[2] - this.extents[0]) / (double)this.width;
        for (res = 0; res < resolutions.length && resolutions[res] > actualRes; ++res) {
        }
        if (res > 0) {
            --res;
        }
        int tileWidth = 256;
        int tileHeight = 256;
        int tiles = (int)Math.pow(2.0, res);
        int sx = (int)Math.floor((this.extents[0] - origin[0]) / resolutions[res] / (double)tileWidth);
        int sy = tiles - (int)Math.ceil((this.extents[3] - origin[1]) / resolutions[res] / (double)tileHeight);
        int mx = (int)Math.ceil((this.extents[2] - origin[0]) / resolutions[res] / (double)tileWidth);
        int my = tiles - (int)Math.floor((this.extents[1] - origin[1]) / resolutions[res] / (double)tileHeight);
        if (sx < 0) {
            sx = 0;
        }
        if (my < 0) {
            my = 0;
        }
        if (sy >= tiles) {
            sy = tiles - 1;
        }
        int destWidth = this.width;
        int srcHeight = srcWidth = (int)((double)destWidth / (this.extents[2] - this.extents[0]) * ((double)tileWidth * resolutions[res]));
        int xOffset = (int)(((double)sx - (this.extents[0] - origin[0]) / resolutions[res] / (double)tileWidth) * (double)srcWidth);
        int yOffset = (int)(((double)sy - (-1.0 * origin[1] - this.extents[3]) / resolutions[res] / (double)tileHeight) * (double)srcHeight);
        RescaleOp op = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
        String uri = "http://tile.openstreetmap.org/";
        for (int iy = my; iy >= sy; --iy) {
            for (int ix = sx; ix <= mx; ++ix) {
                BufferedImage img;
                String bbox = res + "/" + ix % tiles + "/" + iy + ".png";
                LOGGER.trace((Object)("print uri: " + uri + bbox));
                imageUrls.add(uri + bbox);
                if (!drawTiles || (img = this.getImage(uri + bbox, true)) == null) continue;
                int nx = (ix - sx) * srcWidth + xOffset;
                int ny = (iy - sy) * srcHeight + yOffset;
                BufferedImage tmp = new BufferedImage(srcWidth, srcHeight, 2);
                tmp.getGraphics().drawImage(img, 0, 0, srcWidth, srcHeight, 0, 0, tileWidth, tileHeight, null);
                g.drawImage(tmp, op, nx, ny);
            }
        }
        return imageUrls;
    }

    private List drawGoogle(Graphics2D g, String maptype, boolean drawTiles) {
        BufferedImage img;
        int res;
        ArrayList<String> imageUrls = new ArrayList<String>();
        double[] resolutions = new double[]{156543.03390625, 78271.516953125, 39135.7584765625, 19567.87923828125, 9783.939619140625, 4891.9698095703125, 2445.9849047851562, 1222.9924523925781, 611.4962261962891, 305.74811309814453, 152.87405654907226, 76.43702827453613, 38.218514137268066, 19.109257068634033, 9.554628534317017, 4.777314267158508, 2.388657133579254, 1.194328566789627, 0.5971642833948135};
        int imgSize = 640;
        int gScale = 2;
        double actualWidth = this.extents[2] - this.extents[0];
        double actualHeight = this.extents[3] - this.extents[1];
        for (res = 0; res < resolutions.length - 1 && resolutions[res + 1] * (double)imgSize > actualWidth && resolutions[res + 1] * (double)imgSize > actualHeight; ++res) {
        }
        int centerX = (int)((this.extents[2] - this.extents[0]) / 2.0 + this.extents[0]);
        int centerY = (int)((this.extents[3] - this.extents[1]) / 2.0 + this.extents[1]);
        double latitude = SpatialUtil.convertMetersToLat((double)centerY);
        double longitude = SpatialUtil.convertMetersToLng((double)centerX);
        int imgWidth = (int)((this.extents[2] - this.extents[0]) / resolutions[res]);
        int imgHeight = (int)((this.extents[3] - this.extents[1]) / resolutions[res]);
        String uri = "http://maps.googleapis.com/maps/api/staticmap?";
        String parameters = "center=" + latitude + "," + longitude + "&zoom=" + res + "&scale=" + gScale + "&size=" + imgWidth + "x" + imgHeight + "&maptype=" + maptype;
        RescaleOp op = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, 1.0f}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
        LOGGER.debug((Object)("print uri: " + uri + parameters));
        imageUrls.add(uri + parameters);
        if (drawTiles && (img = this.getImage(uri + parameters, true)) != null) {
            BufferedImage tmp = new BufferedImage(this.width, this.height, 2);
            tmp.getGraphics().drawImage(img, 0, 0, this.width, this.height, 0, 0, imgWidth * gScale, imgHeight * gScale, null);
            g.drawImage(tmp, op, 0, 0);
        }
        return imageUrls;
    }

    private List drawLayer(Graphics2D g, MapLayer layer, boolean drawTiles) {
        ArrayList imageUrls = new ArrayList();
        int oldSize = layer.getSizeVal();
        layer.setSizeVal((int)((double)oldSize * this.scale));
        String oldEnvParams = layer.getEnvParams();
        if (oldEnvParams != null) {
            layer.setEnvParams(oldEnvParams.replace(";size:" + oldSize + ";", ";size:" + layer.getSizeVal() + ";"));
        }
        String dynamicStyle = "";
        if (layer.isPolygonLayer()) {
            String colour = Integer.toHexString(0xFF0000 & layer.getRedVal() << 16 | 0xFF00 & layer.getGreenVal() << 8 | 0xFF & layer.getBlueVal());
            while (colour.length() < 6) {
                colour = "0" + colour;
            }
            String filter = layer.getUri().contains("ALA:envelope") ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"><NamedLayer><Name>" + this.layerUtilities.getLayer(layer.getUri()) + "</Name>" + "<UserStyle><FeatureTypeStyle><Rule><RasterSymbolizer><Geometry></Geometry>" + "<ColorMap>" + "<ColorMapEntry color=\"#ffffff\" opacity=\"0\" quantity=\"0\"/>" + "<ColorMapEntry color=\"#" + colour + "\" opacity=\"1\" quantity=\"1\" />" + "</ColorMap></RasterSymbolizer></Rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>" : (layer.getColourMode() != null && "hatching".equals(layer.getColourMode()) ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor version=\"1.0.0\" xmlns=\"http://www.opengis.net/sld\"><NamedLayer><Name>" + this.layerUtilities.getLayer(layer.getUri()) + "</Name>" + "<UserStyle><FeatureTypeStyle><Rule><Title>Polygon</Title><PolygonSymbolizer>" + "<Stroke>" + "<CssParameter name=\"stroke\">#" + colour + "</CssParameter>" + "<CssParameter name=\"stroke-width\">4</CssParameter>" + "</Stroke>" + "<Fill>" + "<GraphicFill><Graphic><Mark><WellKnownName>shape://times</WellKnownName><Stroke>" + "<CssParameter name=\"stroke\">#" + colour + "</CssParameter>" + "<CssParameter name=\"stroke-width\">1</CssParameter>" + "</Stroke></Mark></Graphic></GraphicFill>" + "</Fill>" + "</PolygonSymbolizer></Rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>" : "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor version=\"1.0.0\" xmlns=\"http://www.opengis.net/sld\"><NamedLayer><Name>" + this.layerUtilities.getLayer(layer.getUri()) + "</Name>" + "<UserStyle><FeatureTypeStyle><Rule><Title>Polygon</Title><PolygonSymbolizer><Fill>" + "<CssParameter name=\"fill\">#" + colour + "</CssParameter></Fill>" + "</PolygonSymbolizer></Rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>");
            try {
                dynamicStyle = filter.startsWith("&") ? filter : "&sld_body=" + URLEncoder.encode(filter, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.debug((Object)"invalid filter sld", (Throwable)e);
            }
        }
        if (layer.getColourMode() != null && layer.getColourMode().startsWith("&")) {
            dynamicStyle = layer.getColourMode();
        }
        String params = "&SRS=EPSG:3857&FORMAT=" + layer.getImageFormat() + "&LAYERS=" + layer.getLayer() + "&REQUEST=GetMap" + "&SERVICE=WMS" + "&VERSION=" + this.layerUtilities.getWmsVersion(layer) + dynamicStyle;
        if (!Validate.empty((String)layer.getCql())) {
            params = params + "&CQL_FILTER=" + layer.getCql();
        }
        if (!Validate.empty((String)layer.getEnvParams())) {
            try {
                params = params + "&ENV=" + URLEncoder.encode(URLEncoder.encode(layer.getEnvParams().replace("'", "\\'"), "UTF-8"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)("failed to encode env params : " + layer.getEnvParams().replace("'", "\\'")), (Throwable)e);
            }
        }
        String uri = layer.getUri().replace("gwc/service/", "") + params + "&FORMAT=" + layer.getImageFormat() + "&LAYERS=" + layer.getLayer() + "&SRS=EPSG:3857" + "&DPI=" + this.dpi;
        imageUrls.addAll(this.drawUri(g, uri, layer.getOpacity(), layer.getColourMode() != null && layer.getColourMode().equalsIgnoreCase("grid"), drawTiles));
        layer.setEnvParams(oldEnvParams);
        layer.setSizeVal(oldSize);
        return imageUrls;
    }

    private List drawUri(Graphics2D g, String uri, float opacity, boolean imageOnly256, boolean drawTiles) {
        ArrayList<String> imageUrls = new ArrayList<String>();
        double minX = this.extents[0];
        double maxX = this.extents[2];
        double minY = this.extents[1];
        double maxY = this.extents[3];
        int pageWidth = this.width;
        int pageHeight = this.height;
        int tileWidth = 1024;
        int tileHeight = 1024;
        if (imageOnly256) {
            tileWidth = 256;
            tileHeight = 256;
        }
        double stepX = (maxX - minX) / (double)pageWidth * (double)tileWidth;
        double stepY = (maxY - minY) / (double)pageHeight * (double)tileHeight;
        RescaleOp op = new RescaleOp(new float[]{1.0f, 1.0f, 1.0f, opacity}, new float[]{0.0f, 0.0f, 0.0f, 0.0f}, null);
        int iy = 0;
        double y = maxY;
        while (y > minY) {
            int ix = 0;
            double x = minX;
            while (x < maxX) {
                BufferedImage img;
                String bbox = "&BBOX=" + x + "," + (y - stepY) + "," + (x + stepX) + "," + y + "&WIDTH=" + tileWidth + "&HEIGHT=" + tileHeight + "&TRANSPARENT=true";
                LOGGER.debug((Object)("print uri: " + uri + bbox));
                imageUrls.add(uri + bbox);
                if (drawTiles && (img = this.getImage(uri + bbox, true)) != null) {
                    int nx = ix * tileWidth;
                    int ny = iy * tileHeight;
                    BufferedImage tmp = new BufferedImage(tileWidth, tileHeight, 2);
                    tmp.getGraphics().drawImage(img, 0, 0, null);
                    g.drawImage(tmp, op, nx, ny);
                }
                x += stepX;
                ++ix;
            }
            y -= stepY;
            ++iy;
        }
        return imageUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(String path, boolean useCache) {
        String pth = path.replace("&styles=&", "&");
        if (useCache) {
            Map map = IMAGE_CACHE;
            synchronized (map) {
                String filename = this.getCacheFilename(path);
                File file = new File(filename);
                if (file.exists()) {
                    try {
                        return ImageIO.read(file);
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)("failed to read cache image: " + filename), (Throwable)e);
                    }
                }
            }
        }
        try {
            BufferedImage img = ImageIO.read(new URL(pth));
            return img;
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to get image at: " + pth));
            return null;
        }
    }

    static /* synthetic */ String access$000(PrintMapComposer x0, String x1) {
        return x0.getCacheFilename(x1);
    }

    static /* synthetic */ Logger access$100() {
        return LOGGER;
    }
}

