/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.util;

import au.org.emii.portal.lang.LanguagePack;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.session.PortalSession;
import au.org.emii.portal.settings.Settings;
import au.org.emii.portal.value.BoundingBox;
import org.springframework.beans.factory.annotation.Required;

public class PortalSessionUtilities {
    private static final String LAYER_TAB = "LAYER";
    private static final String LINK_TAB = "LINK";
    private static final String SEARCH_TAB = "SEARCH";
    private static final String AREA_TAB = "AREA";
    private static final String MAP_TAB = "MAP";
    private static final String START_TAB = "START";
    private static final String LAYER_FACILITY_TAB = "FACILITY";
    private static final String LAYER_REGION_TAB = "REGION";
    private static final String LAYER_REALTIME_TAB = "REALTIME";
    private static final String LAYER_USER_TAB = "USER";
    private LanguagePack languagePack = null;
    private Settings settings = null;

    public MapLayer getUserDefinedById(PortalSession portalSession, String id) {
        for (MapLayer map : portalSession.getUserDefinedLayers()) {
            if (map == null || map.getId() == null || !map.getId().equals(id)) continue;
            return map;
        }
        return null;
    }

    public BoundingBox getCurrentBoundingBox(PortalSession portalSession) {
        return portalSession.getDefaultBoundingBox();
    }

    public LanguagePack getLanguagePack() {
        return this.languagePack;
    }

    @Required
    public void setLanguagePack(LanguagePack languagePack) {
        this.languagePack = languagePack;
    }

    public int convertTab(String str) {
        int tab = str.equals(LAYER_TAB) ? 0 : (str.equals(LINK_TAB) ? 3 : (str.equals(SEARCH_TAB) ? 1 : (str.equals(AREA_TAB) ? 4 : (str.equals(MAP_TAB) ? 5 : (str.equals(START_TAB) ? 3 : -1)))));
        return tab;
    }

    public int convertLayerView(String str) {
        int tab = str.equals(LAYER_FACILITY_TAB) ? 0 : (str.equals(LAYER_REALTIME_TAB) ? 3 : (str.equals(LAYER_REGION_TAB) ? 1 : (str.equals(LAYER_USER_TAB) ? 2 : -1)));
        return tab;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }
}

