/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.util;

import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.settings.Settings;
import au.org.emii.portal.util.LayerUtilities;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;

public class LayerUtilitiesImpl
implements LayerUtilities {
    public static final int KML = 4;
    public static final int GEOJSON = 5;
    public static final int WKT = 11;
    public static final int IMAGELAYER = 9;
    public static final int MAP = 12;
    public static final int ALOC = 14;
    public static final int MAXENT = 15;
    public static final int GDM = 16;
    public static final int SCATTERPLOT = 17;
    public static final int TABULATION = 18;
    public static final int CONTEXTUAL = 19;
    public static final int GRID = 20;
    public static final int SPECIES = 21;
    public static final int ENVIRONMENTAL_ENVELOPE = 22;
    public static final int SPECIES_UPLOAD = 23;
    public static final int ODENSITY = 24;
    public static final int SRICHNESS = 25;
    public static final int POINT = 25;
    public static final int UNSUPPORTED = -1;
    public static final int WMS_1_0_0 = 0;
    public static final int WMS_1_1_0 = 1;
    public static final int WMS_1_1_1 = 2;
    public static final int WMS_1_3_0 = 3;
    private static final Logger LOGGER = Logger.getLogger(LayerUtilitiesImpl.class);
    private static final String IMAGE_FORMAT_REGEXP = "[Ff][Oo][Rr][Mm][Aa][Tt]";
    private static final String LAYERS_REGEXP = "[Ll][Aa][Yy][Ee][Rr][Ss]";
    private static final String LAYER_REGEXP = "[Ll][Aa][Yy][Ee][Rr]";
    private static final String VERSION_REGEXP = "[Vv][Ee][Rr][Ss][Ii][Oo][Nn]";
    private List<String> versions = new ArrayList();
    private Settings settings = null;
    private List<Double> worldBBox = null;

    public LayerUtilitiesImpl() {
        this.versions.add(0, "1.0.0");
        this.versions.add(1, "1.1.0");
        this.versions.add(2, "1.1.1");
        this.versions.add(3, "1.3.0");
        this.versions.add(4, "KML");
        this.versions.add(5, "GEOJSON");
        this.worldBBox = new ArrayList(4);
        this.worldBBox.add(-179.999);
        this.worldBBox.add(-89.999);
        this.worldBBox.add(179.999);
        this.worldBBox.add(89.999);
    }

    public boolean supportsWms(int type) {
        return type == 0 || type == 1 || type == 2 || type == 3;
    }

    public int internalVersion(String requestedType) {
        int version = -1;
        if (requestedType != null) {
            String realVersion = requestedType.replaceAll("[Ww][Mm][Ss]-([Ll][Aa][Yy][Ee][Rr]-)?", "");
            version = this.versions.indexOf(realVersion);
        }
        return version;
    }

    public String externalVersion(int version) {
        String externalVersion = null;
        if (version != -1) {
            externalVersion = (String)this.versions.get(version);
        }
        return externalVersion;
    }

    public String getVersionValue(String uri) {
        return this.getParameterValue(VERSION_REGEXP, uri);
    }

    public String getImageFormat(String uri) {
        return this.getParameterValue(IMAGE_FORMAT_REGEXP, uri);
    }

    public String queryConjunction(String uri) {
        String conjunction = "";
        char last = uri.charAt(uri.length() - 1);
        if (last != '?' && last != '&') {
            conjunction = uri.contains("?") ? conjunction + "&" : conjunction + "?";
        }
        return conjunction;
    }

    public String stripParameter(String parameter, String uri) {
        return uri.replaceAll(parameter + "=([^&]?)*&?", "");
    }

    public String stripUriVersion(String uri) {
        return this.stripParameter(VERSION_REGEXP, uri);
    }

    public String stripUriService(String uri) {
        return this.stripParameter("[Ss][Ee][Rr][Vv][Ii][Cc][Ee]", uri);
    }

    public String stripUriRequest(String uri) {
        return this.stripParameter("[Rr][Ee][Qq][Uu][Ee][Ss][Tt]", uri);
    }

    public String getLayer(String uri) {
        String layer = this.getParameterValue(LAYER_REGEXP, uri);
        if (layer == null) {
            layer = this.getParameterValue(LAYERS_REGEXP, uri);
        }
        return layer;
    }

    public String getLayers(String uri) {
        String layers = this.getParameterValue(LAYERS_REGEXP, uri);
        if (layers == null) {
            layers = this.getParameterValue(LAYER_REGEXP, uri);
        }
        return layers;
    }

    public String getParameterValue(String parameter, String uri) {
        String value = null;
        String fullRegexp = ".*?" + parameter + "=([^&]*)&?.*";
        Pattern pattern = Pattern.compile(fullRegexp);
        Matcher matcher = pattern.matcher(uri);
        while (matcher.find()) {
            value = matcher.group(1);
        }
        if (value != null) {
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)"missing URL encoder! ", (Throwable)e);
            }
        }
        return value;
    }

    public String getWmsVersion(MapLayer mapLayer) {
        String version = this.supportsWms(mapLayer.getType()) ? this.externalVersion(mapLayer.getType()) : null;
        return version;
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Required
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public List<Double> getBBox(String uri) {
        return this.getBBoxWCSWFS(uri);
    }

    private List<Double> getBBoxWCSWFS(String uri) {
        try {
            ArrayList<Double> bbox = new ArrayList<Double>();
            int q = uri.indexOf(63);
            String server = q > 0 ? uri.substring(0, uri.substring(0, q).lastIndexOf(47) + 1) : uri.substring(0, uri.lastIndexOf(47) + 1);
            String name = this.getLayer(uri);
            server = server.replace("gwc/service/", "");
            LayerUtilitiesImpl wmsUtilities = new LayerUtilitiesImpl();
            String mangled = this.stripUriRequest(server + "wcs");
            mangled = this.stripUriService(mangled);
            mangled = this.stripUriVersion(mangled);
            mangled = mangled + this.queryConjunction(server + "wcs");
            mangled = mangled + "SERVICE=WCS&REQUEST=GetCapabilities&VERSION=" + wmsUtilities.externalVersion(2);
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(mangled);
            get.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            int startPos = slist.indexOf("<ows:Title>" + name.replace("ALA:", "") + "</ows:Title>");
            if (startPos == -1) {
                startPos = slist.indexOf("<wcs:Identifier>" + name.replace("ALA:", "") + "</wcs:Identifier>");
                startPos = slist.lastIndexOf("<ows:Title>", startPos);
            }
            if (startPos == -1) {
                client = new HttpClient();
                get = new GetMethod(mangled.replace("WCS", "WFS").replace("wcs", "wfs"));
                get.addRequestHeader("Accept", "text/plain");
                client.executeMethod((HttpMethod)get);
                slist = get.getResponseBodyAsString();
                startPos = slist.indexOf("<Name>" + name + "</Name>");
            }
            if (startPos == -1) {
                LOGGER.debug((Object)("BoundingBox not found for layer: " + name));
                return this.worldBBox;
            }
            String lc = "ows:LowerCorner>";
            String uc = "ows:UpperCorner>";
            int lowerCornerPosStart = slist.indexOf(lc, startPos) + lc.length();
            int lowerCornerPosEnd = slist.indexOf("</" + lc, lowerCornerPosStart);
            int upperCornerPosStart = slist.indexOf(uc, startPos) + uc.length();
            int upperCornerPosEnd = slist.indexOf("</" + uc, upperCornerPosStart);
            String[] lowerCorner = slist.substring(lowerCornerPosStart, lowerCornerPosEnd).split(" ");
            String[] upperCorner = slist.substring(upperCornerPosStart, upperCornerPosEnd).split(" ");
            bbox.add(Double.parseDouble(lowerCorner[0]));
            bbox.add(Double.parseDouble(lowerCorner[1]));
            bbox.add(Double.parseDouble(upperCorner[0]));
            bbox.add(Double.parseDouble(upperCorner[1]));
            return bbox;
        }
        catch (Exception e) {
            return this.worldBBox;
        }
    }
}

