/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.util;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.legend.Facet;
import au.org.ala.spatial.StringConstants;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.UserShapes;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.MapLayerMetadata;
import au.org.emii.portal.util.LayerUtilities;
import au.org.emii.portal.util.LayerUtilitiesImpl;
import au.org.emii.portal.util.PrintMapComposer;
import au.org.emii.portal.util.RemoteMap;
import au.org.emii.portal.util.RemoteMapImpl;
import au.org.emii.portal.wms.WMSStyle;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AreaReportPDF {
    private static final Logger LOGGER = Logger.getLogger(AreaReportPDF.class);
    private static final int PROGRESS_COUNT = 92;
    private String wkt;
    private MapLayer mlArea;
    private String areaPid;
    private String areaName;
    private Map<String, String> counts;
    private Map<String, String> csvs;
    private Map<String, String> speciesLinks;
    private BiocacheQuery query;
    private String[] checklists;
    private String[] distributions;
    List<JSONObject> documents;
    private Map<String, byte[]> imageMap;
    private RemoteMap remoteMap;
    private Map tabulation;
    private int fileNumber;
    private String filePath;
    private Map progress;

    public AreaReportPDF(String wkt, String areaName, List<Facet> facets, Map progress) {
        this.wkt = wkt;
        this.areaName = areaName;
        this.progress = progress;
        this.query = new BiocacheQuery(null, wkt, null, facets, false, new boolean[]{true, true, true});
        this.remoteMap = new RemoteMapImpl();
        ((RemoteMapImpl)this.remoteMap).setLayerUtilities((LayerUtilities)new LayerUtilitiesImpl());
        this.filePath = "/data/webportal/data/area_" + System.currentTimeMillis();
        try {
            FileUtils.forceMkdir((File)new File(this.filePath + "/"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to create directory for PDF: " + this.filePath), (Throwable)e);
        }
        this.setProgress("Getting information", 0.0);
        if (!this.isCancelled()) {
            this.init();
        }
        this.setProgress("Formatting", 0.0);
        if (!this.isCancelled()) {
            this.makeHTML();
        }
        this.setProgress("Producing PDF", 0.0);
        if (!this.isCancelled()) {
            this.savePDF();
        }
        this.setProgress("Finished", 1.0);
    }

    public static void main(String[] args) {
        Properties p = new Properties();
        try {
            p.load(new FileInputStream("/data/webportal/config/webportal-config.properties"));
            CommonData.init((Properties)p);
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to load properties", (Throwable)e);
        }
        String wkt = "POLYGON((149.26687622068 -35.258741390775,149.35579681395 -35.298540090399,149.33657073973 -35.320673151768,149.28404235838 -35.336638814392,149.24559020995 -35.322914136746,149.26687622068 -35.258741390775))";
        new AreaReportPDF(wkt, "My area", null, null);
    }

    private boolean isCancelled() {
        return this.progress != null && this.progress.containsKey("cancel");
    }

    private void setProgress(String label, double percent) {
        if (this.progress != null) {
            this.progress.put("label", label);
            if (percent == 0.0) {
                Double currentPercent = (Double)this.progress.get("percent");
                currentPercent = currentPercent == null ? Double.valueOf(0.0) : Double.valueOf(currentPercent * 100.0);
                this.progress.put("percent", Math.min((currentPercent + 1.0) / 100.0, 1.0));
            } else {
                this.progress.put("percent", percent);
            }
        }
    }

    public byte[] getPDF() {
        try {
            return FileUtils.readFileToByteArray((File)new File(this.filePath + "/output.pdf"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to get PDF from: " + this.filePath + "/output.pdf"), (Throwable)e);
            return null;
        }
    }

    private void savePDF() {
        try {
            String[] inputHtmls = new String[this.fileNumber - 2];
            for (int i = 2; i < this.fileNumber; ++i) {
                inputHtmls[i - 2] = this.filePath + "/report." + i + ".html";
            }
            this.makePDF(this.filePath + "/report.1.html", inputHtmls, this.filePath + "/output.pdf");
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to produce PDF", (Throwable)e);
        }
    }

    private void makeHTML() {
        this.fileNumber = 1;
        try {
            String[] layers;
            JSONParser jp = new JSONParser();
            JSONObject tabulations = (JSONObject)jp.parse(FileUtils.readFileToString((File)new File(this.filePath + "/tabulations.json"), (String)"UTF-8"));
            JSONObject csvs = (JSONObject)jp.parse(FileUtils.readFileToString((File)new File(this.filePath + "/csvs.json")));
            JSONObject counts = (JSONObject)jp.parse(FileUtils.readFileToString((File)new File(this.filePath + "/counts.json"), (String)"UTF-8"));
            String filename = this.filePath + "/report.html";
            FileWriter fw = this.startHtmlOut(this.fileNumber, filename);
            fw.write("<img  id='imgHeader' src='" + CommonData.getWebportalServer() + "/area-report/header.jpg' width='100%' />");
            fw.write("<table id='dashboard' >");
            fw.write("<tr>");
            fw.write("<td>");
            fw.write("Area: " + String.format("%s", counts.get((Object)"Area (sq km)")) + " sq km");
            fw.write("</td>");
            fw.write("<td>");
            fw.write("Species: " + String.format("%s", counts.get((Object)"Species")));
            fw.write("</td>");
            fw.write("<td>");
            fw.write("Occurrences: " + String.format("%s", counts.get((Object)"Occurrences")));
            fw.write("</td>");
            fw.write("</tr>");
            fw.write("<tr>");
            fw.write("<td>");
            fw.write("Endemic species: " + String.format("%s", counts.get((Object)"Endemic Species")));
            fw.write("</td>");
            fw.write("<td>");
            fw.write("All threatened species: " + counts.get((Object)"Threatened_Species"));
            fw.write("</td>");
            fw.write("<td>");
            fw.write("Migratory species: " + counts.get((Object)"Migratory_Species"));
            fw.write("</td>");
            fw.write("</tr>");
            fw.write("<tr>");
            fw.write("<td>");
            fw.write("All invasive species: " + counts.get((Object)"Invasive_Species"));
            fw.write("</td>");
            fw.write("<td>");
            fw.write("Iconic species: " + counts.get((Object)"Iconic_Species"));
            fw.write("</td>");
            fw.write("<td>");
            fw.write("JournalMap Articles: " + counts.get((Object)"Journalmap"));
            fw.write("</td>");
            fw.write("</tr>");
            fw.write("<tr>");
            fw.write("<td>");
            fw.write("Animals: " + String.format("%s", counts.get((Object)"Animals")));
            fw.write("</td>");
            fw.write("<td>");
            fw.write("Plants: " + String.format("%s", counts.get((Object)"Plants")));
            fw.write("</td>");
            fw.write("<td>");
            fw.write("Birds: " + String.format("%s", counts.get((Object)"Birds")));
            fw.write("</td>");
            fw.write("</tr>");
            fw.write("</table>");
            fw.write("</body></html>");
            fw.close();
            ++this.fileNumber;
            fw = this.startHtmlOut(this.fileNumber, filename);
            int figureNumber = 1;
            int tableNumber = 1;
            this.mapPage(fw, this.areaName, figureNumber, tableNumber, "base_area.png", "Area: <b>" + String.format("%s", counts.get((Object)"Area (sq km)")) + " sq km</b>", null, null);
            fw.write("</body></html>");
            fw.close();
            for (String layer : layers = CommonData.getSettings().getProperty("detailed_area_report_layers").split("\n")) {
                if (layer.isEmpty()) continue;
                String[] split = layer.trim().split("\\|");
                String shortname = split[0];
                String displayname = split[1];
                String geoserver_url = split[2];
                String canSetColourMode = split[3];
                String description = split[4];
                ++this.fileNumber;
                fw = this.startHtmlOut(this.fileNumber, filename);
                this.mapPage(fw, displayname, ++figureNumber, tableNumber, shortname + ".png", description, (JSONObject)tabulations.get((Object)CommonData.getLayerFacetName((String)shortname)), geoserver_url.isEmpty() ? null : geoserver_url);
                fw.write("</body></html>");
                fw.close();
            }
            ++this.fileNumber;
            fw = this.startHtmlOut(this.fileNumber, filename);
            int count = Integer.parseInt(counts.get((Object)"Occurrences").toString());
            int countKosher = Integer.parseInt(counts.get((Object)"Occurrences (spatially valid only)").toString());
            String imageUrl = "occurrences.png";
            String notes = "Spatially valid records are considered those that do not have any type of flag questioning their location, for example a terrestrial species being recorded in the ocean. [Ref6]";
            this.speciesPage(true, fw, "My Area", "Occurrences", notes, ++tableNumber, count, countKosher, ++figureNumber, imageUrl, null);
            ++figureNumber;
            fw.write("</body></html>");
            fw.close();
            ++this.fileNumber;
            fw = this.startHtmlOut(this.fileNumber, filename);
            count = Integer.parseInt(counts.get((Object)"Species").toString());
            countKosher = Integer.parseInt(counts.get((Object)"Species (spatially valid only)").toString());
            imageUrl = null;
            notes = "Spatially valid records are considered those that do not have any type of flag questioning their location, for example a terrestrial species being recorded in the ocean. [Ref6]";
            this.speciesPage(true, fw, "My Area", "Species", notes, tableNumber, count, countKosher, figureNumber, imageUrl, csvs.get((Object)"Species").toString());
            ++tableNumber;
            fw.write("</body></html>");
            fw.close();
            ++this.fileNumber;
            fw = this.startHtmlOut(this.fileNumber, filename);
            count = Integer.parseInt(counts.get((Object)"Threatened_Species").toString());
            imageUrl = "Threatened_Species.png";
            notes = "";
            this.speciesPage(true, fw, "My Area", "All threatened species", notes, tableNumber, count, -1, figureNumber, imageUrl, csvs.get((Object)"Threatened_Species").toString());
            ++figureNumber;
            fw.write("</body></html>");
            fw.close();
            ++this.fileNumber;
            fw = this.startHtmlOut(this.fileNumber, filename);
            count = Integer.parseInt(counts.get((Object)"Invasive_Species").toString());
            imageUrl = "Invasive_Species.png";
            notes = "";
            this.speciesPage(true, fw, "My Area", "All invasive species", notes, tableNumber, count, -1, figureNumber, imageUrl, csvs.get((Object)"Invasive_Species").toString());
            ++figureNumber;
            fw.write("</body></html>");
            fw.close();
            ++this.fileNumber;
            fw = this.startHtmlOut(this.fileNumber, filename);
            count = Integer.parseInt(counts.get((Object)"Iconic_Species").toString());
            imageUrl = "Iconic_Species.png";
            notes = "";
            this.speciesPage(true, fw, "My Area", "Iconic species", notes, tableNumber, count, -1, figureNumber, imageUrl, csvs.get((Object)"Iconic_Species").toString());
            ++figureNumber;
            fw.write("</body></html>");
            fw.close();
            ++this.fileNumber;
            fw = this.startHtmlOut(this.fileNumber, filename);
            count = Integer.parseInt(counts.get((Object)"Migratory_Species").toString());
            imageUrl = "Migratory_Species.png";
            notes = "";
            this.speciesPage(true, fw, "My Area", "Migratory species", notes, tableNumber, count, -1, figureNumber, imageUrl, csvs.get((Object)"Migratory_Species").toString());
            ++figureNumber;
            fw.write("</body></html>");
            fw.close();
            ++this.fileNumber;
            fw = this.startHtmlOut(this.fileNumber, filename);
            for (int i = 0; i < StringConstants.SPECIES_GROUPS.length; ++i) {
                String s = StringConstants.SPECIES_GROUPS[i];
                count = Integer.parseInt(counts.get((Object)s).toString());
                countKosher = Integer.parseInt(counts.get((Object)(s + " (spatially valid only)")).toString());
                this.speciesPage(true, fw, "My Area", "lifeform - " + s, notes, tableNumber, count, countKosher, figureNumber, "lifeform - " + s + ".png", csvs.get((Object)s).toString());
                ++tableNumber;
                ++figureNumber;
                fw.write("</body></html>");
                fw.close();
                ++this.fileNumber;
                fw = this.startHtmlOut(this.fileNumber, filename);
            }
            count = Integer.parseInt(counts.get((Object)"Distribution Areas").toString());
            this.speciesPage(false, fw, "My Area", "Expert Distributions", notes, tableNumber, count, -1, figureNumber, null, csvs.get((Object)"distributions").toString());
            fw.write("</body></html>");
            fw.close();
            ++this.fileNumber;
            fw = this.startHtmlOut(this.fileNumber, filename);
            count = Integer.parseInt(counts.get((Object)"Checklist Areas").toString());
            this.speciesPage(false, fw, "My Area", "Checklist Areas", notes, tableNumber, count, -1, figureNumber, null, csvs.get((Object)"checklists").toString());
            fw.write("</body></html>");
            fw.close();
            ++this.fileNumber;
            fw = this.startHtmlOut(this.fileNumber, filename);
            count = Integer.parseInt(counts.get((Object)"Journalmap").toString());
            countKosher = Integer.parseInt(counts.get((Object)"Journalmap").toString());
            imageUrl = null;
            notes = "<a href='http://journalmap.org'>JournalMap</a>";
            this.speciesPage(false, fw, "My Area", "JournalMap Articles", notes, tableNumber, count, -1, figureNumber, null, csvs.get((Object)"Journalmap").toString());
            ++tableNumber;
            fw.write("</body></html>");
            fw.close();
            ++this.fileNumber;
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to produce report pdf", (Throwable)e);
        }
    }

    private void makePDF(String headerHtml, String[] inputHtmls, String outputPdf) {
        String[] cmdStart = new String[]{CommonData.getSettings().getProperty("wkhtmltopdf.path"), "-B", "10", "-L", "10", "-T", "10", "-R", "10", "--encoding", "UTF-8", "--footer-font-size", "9", "--footer-line", "--footer-left", "    www.ala.org.au", "--footer-right", "Page [page] of [toPage]     "};
        String[] cmd = new String[cmdStart.length + 4 + inputHtmls.length + 2];
        System.arraycopy(cmdStart, 0, cmd, 0, cmdStart.length);
        cmd[cmdStart.length] = headerHtml;
        cmd[cmdStart.length + 1] = "toc";
        cmd[cmdStart.length + 2] = "--xsl-style-sheet";
        cmd[cmdStart.length + 3] = this.filePath + "/toc.xsl";
        System.arraycopy(inputHtmls, 0, cmd, cmdStart.length + 4, inputHtmls.length);
        cmd[cmd.length - 2] = CommonData.getWebportalServer() + "/area-report/furtherLinks.html";
        cmd[cmd.length - 1] = outputPdf;
        ProcessBuilder builder = new ProcessBuilder(cmd);
        builder.environment().putAll(System.getenv());
        builder.redirectErrorStream(true);
        Process proc = null;
        try {
            proc = builder.start();
            proc.waitFor();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error running wkhtmltopdf", (Throwable)e);
        }
    }

    private FileWriter startHtmlOut(int fileNumber, String filename) throws Exception {
        FileWriter fw = new FileWriter(filename.replace(".", "." + fileNumber + "."));
        fw.write("<html>");
        fw.write("<head><link rel='stylesheet' type='text/css' href='" + CommonData.getWebportalServer() + "/area-report/areaReport.css'></link></head>");
        fw.write("<body>");
        return fw;
    }

    private void speciesPage(boolean isSpecies, FileWriter fw, String areaName, String title, String notes, int tableNumber, int count, int countKosher, int figureNumber, String imageUrl, String csv) throws Exception {
        String imageUrlActual = imageUrl;
        if (imageUrlActual != null) {
            imageUrlActual = this.filePath + "/" + imageUrlActual;
        }
        fw.write("<table id='species'>");
        fw.write("<tr>");
        fw.write("<td id='title'><h1>");
        fw.write(title);
        fw.write("</h1></td>");
        fw.write("</tr><tr>");
        fw.write("<td>");
        fw.write("<br />Number of " + title.toLowerCase() + ": <b>" + count + "</b>");
        fw.write("</td>");
        fw.write("</tr><tr>");
        fw.write("<td><br />");
        fw.write(notes);
        fw.write("</td>");
        fw.write("</tr><tr>");
        if (countKosher >= 0) {
            fw.write("<td>");
            fw.write("<br />Number of " + title.toLowerCase() + " (spatially valid only): <b>" + countKosher + "</b>");
            fw.write("</td>");
            fw.write("</tr><tr>");
        }
        if ((count > 0 || countKosher > 0) && imageUrlActual != null) {
            fw.write("<td>");
            fw.write("<br /><img src='" + imageUrlActual + "' />");
            fw.write("</td>");
            fw.write("</tr><tr>");
            fw.write("<td id='figure'>");
            fw.write("<b>Figure " + figureNumber + ":</b> Map of " + title + " in " + areaName);
            fw.write("</td>");
            fw.write("</tr><tr>");
        }
        if ((count > 0 || countKosher > 0) && csv != null) {
            String[] line;
            int[] columnOrder;
            CSVReader r = new CSVReader((Reader)new StringReader(csv));
            fw.write("<td id='tableNumber'><br /><b>Table " + tableNumber + ":</b> " + title);
            if (this.speciesLinks.get(title.replace("lifeform - ", "")) != null) {
                fw.write("<a href='" + (String)this.speciesLinks.get(title.replace("lifeform - ", "")) + "'>(Link to full list)</a>");
            }
            fw.write("</td></tr><tr><td>");
            fw.write("<table id='table'>");
            if (isSpecies) {
                columnOrder = new int[]{8, 1, 10, 11};
                fw.write("<tr><td>Family</td><td id='scientificName' >Scientific Name</td><td>Common Name</td><td>No. Occurrences</td>");
                for (int i = 0; i < CommonData.getSpeciesListAdditionalColumnsHeader().size(); ++i) {
                    columnOrder = Arrays.copyOf(columnOrder, columnOrder.length + 1);
                    columnOrder[columnOrder.length - 1] = 12 + i;
                    fw.write("<td>" + (String)CommonData.getSpeciesListAdditionalColumnsHeader().get(i) + "</td>");
                }
                fw.write("</tr>");
            } else if ("JournalMap Articles".equals(title)) {
                columnOrder = new int[]{0, 1, 2, 3, 4, 5};
                fw.write("<tr><td>Author/s</td><td>Year</td><td>Title</td><td>Publication</td><td>DOI</td><td>URL</td></tr>");
            } else {
                columnOrder = new int[]{4, 1, 3, 7, 8, 11, 12};
                fw.write("<tr><td>Family</td><td id='scientificName' >Scientific Name</td><td>Common Name</td><td>Min Depth</td><td>Max Depth</td><td>Area Name</td><td>Area sq km</td></tr>");
            }
            r.readNext();
            int row = 0;
            while ((line = r.readNext()) != null) {
                fw.write("<tr>");
                for (int i = 0; i < columnOrder.length && columnOrder[i] < line.length; ++i) {
                    fw.write("<td><div>" + line[columnOrder[i]] + "</div></td>");
                }
                fw.write("</tr>");
                ++row;
            }
            fw.write("</table>");
            fw.write("<td>");
        }
        fw.write("</tr>");
        fw.write("</table>");
    }

    private void mapPage(FileWriter fw, String areaName, int figureNumber, int tableNumber, String imageUrl, String notes, JSONObject tabulation, String legendUrl) throws Exception {
        String imageUrlActual = imageUrl;
        if (imageUrlActual != null) {
            imageUrlActual = this.filePath + "/" + imageUrlActual;
        }
        fw.write("<table id='mapPage'>");
        fw.write("<tr>");
        fw.write("<td id='title'><h1>");
        fw.write(areaName);
        fw.write("</h1></td>");
        fw.write("</tr><tr>");
        fw.write("<td><br />");
        fw.write(notes);
        fw.write("</td>");
        fw.write("</tr><tr>");
        fw.write("<td>");
        if (imageUrlActual.endsWith("base_area.png")) {
            fw.write("<br /><img src='" + this.filePath + "/base_area_zoomed_out.png' />");
        }
        fw.write("<br /><img " + (legendUrl != null ? "id='imgWithLegend' " : "") + " src='" + imageUrlActual + "' />");
        if (legendUrl != null) {
            fw.write("<img id='legend' src='" + legendUrl + "'/>");
        }
        fw.write("</td>");
        fw.write("</tr><tr>");
        fw.write("<td id='figure'>");
        fw.write("<b>Figure " + figureNumber + ":</b> Map of " + areaName);
        fw.write("</td>");
        fw.write("</tr><tr>");
        if (tabulation != null && tabulation.containsKey((Object)"tabulationList")) {
            JSONObject jo;
            double totalArea = 0.0;
            for (Object o : (JSONArray)tabulation.get((Object)"tabulationList")) {
                jo = (JSONObject)o;
                totalArea += Double.parseDouble(jo.get((Object)"area").toString()) / 1000000.0;
            }
            if (totalArea > 0.0) {
                fw.write("<td id='tableNumber'>");
                fw.write("<br /><b>Table " + tableNumber + ":</b> " + areaName);
                fw.write("</td></tr><tr><td>");
                fw.write("<br /><table id='table'><tr><td>Class/Region</td><td>Area (sq km)</td><td>% of total area</td></tr>");
                for (Object o : (JSONArray)tabulation.get((Object)"tabulationList")) {
                    jo = (JSONObject)o;
                    fw.write("<tr><td>");
                    fw.write(jo.get((Object)"name1").toString());
                    fw.write("</td><td>");
                    fw.write(String.format("%.2f", Double.parseDouble(jo.get((Object)"area").toString()) / 1000000.0));
                    fw.write("</td><td>");
                    fw.write(String.format("%.2f", Double.parseDouble(jo.get((Object)"area").toString()) / 1000000.0 / totalArea * 100.0));
                    fw.write("</td></tr>");
                }
                fw.write("</table>");
                fw.write("</td>");
            }
        }
        fw.write("</tr>");
        fw.write("</table>");
    }

    final void init() {
        this.counts = new ConcurrentHashMap();
        this.csvs = new ConcurrentHashMap();
        this.imageMap = new ConcurrentHashMap();
        this.tabulation = new ConcurrentHashMap();
        this.speciesLinks = new ConcurrentHashMap();
        this.mlArea = this.createWKTLayer(this.wkt, 255, 0, 0, 0.6f);
        ArrayList<Object> callables = new ArrayList<Object>();
        callables.addAll(this.initTabulation());
        callables.add(new /* Unavailable Anonymous Inner Class!! */);
        callables.add(new /* Unavailable Anonymous Inner Class!! */);
        callables.add(new /* Unavailable Anonymous Inner Class!! */);
        callables.add(new /* Unavailable Anonymous Inner Class!! */);
        callables.add(new /* Unavailable Anonymous Inner Class!! */);
        callables.add(new /* Unavailable Anonymous Inner Class!! */);
        callables.add(new /* Unavailable Anonymous Inner Class!! */);
        callables.add(new /* Unavailable Anonymous Inner Class!! */);
        callables.add(new /* Unavailable Anonymous Inner Class!! */);
        callables.add(new /* Unavailable Anonymous Inner Class!! */);
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        try {
            executorService.invokeAll(callables);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"failed to run all Init callables for detailed pdf", (Throwable)e);
        }
        this.setProgress("Getting information: saving", 0.0);
        if (this.isCancelled()) {
            return;
        }
        try {
            FileWriter fw = new FileWriter(this.filePath + File.separator + "counts.json");
            fw.write(JSONValue.toJSONString((Object)this.counts));
            fw.close();
            fw = new FileWriter(this.filePath + File.separator + "tabulations.json");
            fw.write(JSONValue.toJSONString((Object)this.tabulation));
            fw.close();
            fw = new FileWriter(this.filePath + File.separator + "csvs.json");
            fw.write(JSONValue.toJSONString((Object)this.csvs));
            fw.close();
            FileUtils.copyURLToFile((URL)new URL(CommonData.getWebportalServer() + "/area-report/toc.xsl"), (File)new File(this.filePath + "/toc.xsl"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to output area report information", (Throwable)e);
        }
    }

    private Callable getTabulationCallable(String fieldId) {
        String fid = fieldId;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private List initTabulation() {
        String[] layers;
        ArrayList<Callable> callables = new ArrayList<Callable>();
        for (String layer : layers = CommonData.getSettings().getProperty("detailed_area_report_layers").split("\n")) {
            if (layer.isEmpty()) continue;
            String[] split = layer.trim().split("\\|");
            String shortname = split[0];
            String displayname = split[1];
            String geoserver_url = split[2];
            String canSetColourMode = split[3];
            String description = split[4];
            String fid = CommonData.getLayerFacetName((String)shortname);
            callables.add(this.getTabulationCallable(fid));
        }
        return callables;
    }

    private void initDistributionsCsv(String type) {
        String[] list;
        this.setProgress("Getting information: " + type, 0.0);
        if (this.isCancelled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : list = Util.getDistributionsOrChecklists((String)type, (String)this.wkt, null, null)) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(line);
        }
        if ("checklists".equals(type)) {
            this.checklists = list;
            if (this.checklists.length <= 0) {
                this.counts.put("Checklist Areas", "0");
                this.counts.put("Checklist Species", "0");
            } else {
                String[] areaChecklistText = Util.getAreaChecklists((String[])this.checklists);
                this.counts.put("Checklist Areas", String.valueOf(areaChecklistText.length - 1));
                this.counts.put("Checklist Species", String.valueOf(this.checklists.length - 1));
            }
        } else {
            this.distributions = list;
            if (this.distributions.length <= 0) {
                this.counts.put("Distribution Areas", "0");
            } else {
                this.counts.put("Distribution Areas", String.valueOf(this.distributions.length - 1));
            }
        }
        this.csvs.put(type, sb.toString());
    }

    private void initJournalmapCsv() {
        this.setProgress("Getting information: Journalmap", 0.0);
        if (this.isCancelled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        List list = CommonData.filterJournalMapArticles((String)this.wkt);
        sb.append("\n");
        for (JSONObject jo : list) {
            JSONObject o;
            if (sb.length() > 0) {
                sb.append("\n");
            }
            if (jo.containsKey((Object)"authors")) {
                String author = "";
                JSONArray ja = (JSONArray)jo.get((Object)"authors");
                for (int i = 0; i < ja.size(); ++i) {
                    JSONObject o2;
                    if (i > 0) {
                        author = author + ", ";
                    }
                    if ((o2 = (JSONObject)ja.get(i)).containsKey((Object)"last_name")) {
                        author = author + o2.get((Object)"last_name") + ", ";
                    }
                    if (!o2.containsKey((Object)"first_name")) continue;
                    author = author + o2.get((Object)"first_name");
                }
                sb.append("\"").append(author.replace("\"", "\"\"")).append("\".");
            }
            sb.append(",");
            if (jo.containsKey((Object)"publish_year")) {
                sb.append("\"").append(jo.get((Object)"publish_year").toString().replace("\"", "\"\"")).append(".\"");
            }
            sb.append(",");
            if (jo.containsKey((Object)"title")) {
                sb.append("\"").append(jo.get((Object)"title").toString().replace("\"", "\"\"")).append(".\"");
            }
            sb.append(",");
            if (jo.containsKey((Object)"publication") && (o = (JSONObject)jo.get((Object)"publication")).containsKey((Object)"name")) {
                sb.append("\"").append(o.get((Object)"name").toString().replace("\"", "\"\"")).append(".\"");
            }
            sb.append(",");
            if (jo.containsKey((Object)"doi")) {
                sb.append("\"").append(jo.get((Object)"doi").toString().replace("\"", "\"\"")).append(".\"");
            }
            sb.append(",");
            if (!jo.containsKey((Object)"id")) continue;
            String journalmapUrl = CommonData.getSettings().getProperty("journalmap.url", null);
            String articleUrl = journalmapUrl + "articles/" + jo.get((Object)"id").toString();
            sb.append("<a href='" + articleUrl + "'>" + articleUrl + "</a>");
        }
        this.documents = list;
        if (this.documents.size() <= 0) {
            this.counts.put("Journalmap", "0");
        } else {
            this.counts.put("Journalmap", String.valueOf(this.documents.size()));
        }
        this.csvs.put("Journalmap", sb.toString());
    }

    private void initCsvSpecies() {
        this.setProgress("Getting information: species list", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.csvs.put("Species", this.query.speciesList());
        this.speciesLinks.put("Species", this.query.getWS() + "/occurrences/search?q=" + this.query.getQ());
        for (int i = 0; i < StringConstants.SPECIES_GROUPS.length; ++i) {
            String s = StringConstants.SPECIES_GROUPS[i];
            this.setProgress("Getting information: species list for lifeform " + s, 0.0);
            if (this.isCancelled()) {
                return;
            }
            BiocacheQuery q = this.query.newFacet(new Facet("species_group", s, true), false);
            this.csvs.put(s, q.speciesList());
            this.speciesLinks.put(s, q.getWS() + "/occurrences/search?q=" + q.getQ());
            this.counts.put(s, String.valueOf(q.getSpeciesCount()));
            this.counts.put(s + " (spatially valid only)", String.valueOf(q.getSpeciesCountKosher()));
        }
        this.setProgress("Getting information: threatened species list", 0.0);
        if (this.isCancelled()) {
            return;
        }
        BiocacheQuery q = this.query.newFacet(Facet.parseFacet((String)CommonData.speciesListThreatened), true);
        this.csvs.put("Threatened_Species", q.speciesList());
        this.speciesLinks.put("Threatened_Species", q.getWS() + "/occurrences/search?q=" + q.getQ());
        this.counts.put("Threatened_Species", String.valueOf(q.getSpeciesCount()));
        this.setProgress("Getting information: iconic species list", 0.0);
        if (this.isCancelled()) {
            return;
        }
        q = this.query.newFacet(new Facet("species_list_uid", "dr781", true), true);
        this.csvs.put("Iconic_Species", q.speciesList());
        this.speciesLinks.put("Iconic_Species", q.getWS() + "/occurrences/search?q=" + q.getQ());
        this.counts.put("Iconic_Species", String.valueOf(q.getSpeciesCount()));
        this.setProgress("Getting information: migratory species list", 0.0);
        if (this.isCancelled()) {
            return;
        }
        q = this.query.newFacet(new Facet("species_list_uid", "dr1005", true), true);
        this.csvs.put("Migratory_Species", q.speciesList());
        this.speciesLinks.put("Migratory_Species", q.getWS() + "/occurrences/search?q=" + q.getQ());
        this.counts.put("Migratory_Species", String.valueOf(q.getSpeciesCount()));
        this.setProgress("Getting information: invasive species list", 0.0);
        if (this.isCancelled()) {
            return;
        }
        q = this.query.newFacet(Facet.parseFacet((String)CommonData.speciesListInvasive), true);
        this.csvs.put("Invasive_Species", q.speciesList());
        this.speciesLinks.put("Invasive_Species", q.getWS() + "/occurrences/search?q=" + q.getQ());
        this.counts.put("Invasive_Species", String.valueOf(q.getSpeciesCount()));
    }

    private void initCountSpecies() {
        this.setProgress("Getting information: species count", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.counts.put("Species", String.valueOf(this.query.getSpeciesCount()));
        this.setProgress("Getting information: species count geospatial_kosher=true", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.counts.put("Species (spatially valid only)", String.valueOf(this.query.getSpeciesCountKosher()));
    }

    private void initCountOccurrences() {
        this.setProgress("Getting information: occurrences", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.counts.put("Occurrences", String.valueOf(this.query.getOccurrenceCount()));
        this.setProgress("Getting information: occurrences count geospatial_kosher=true", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.counts.put("Occurrences (spatially valid only)", String.valueOf(this.query.getOccurrenceCountKosher()));
        this.speciesLinks.put("Occurrences", this.query.getWS() + "/occurrences/search?q=" + this.query.getQ());
    }

    private void initCountEndemicSpecies() {
        this.setProgress("Getting information: endemic species count", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.counts.put("Endemic Species", String.valueOf(this.query.getEndemicSpeciesCount()));
    }

    private void initCountThreatenedSpecies() {
        this.setProgress("Getting information: threatened species", 0.0);
        if (this.isCancelled()) {
            return;
        }
        Facet f = new Facet("state_conservation", "Endangered", true);
        this.counts.put("Endangered Species", String.valueOf(this.query.newFacet(f, false).getSpeciesCount()));
    }

    private void initCountArea() {
        DecimalFormat df = new DecimalFormat("###,###.##");
        this.counts.put("Area (sq km)", df.format(Util.calculateArea((String)this.wkt) / 1000.0 / 1000.0));
    }

    private void initImages() {
        String[] layers;
        double aspectRatio = 1.6;
        String type = "png";
        int resolution = 0;
        String basemap = "Minimal";
        this.mlArea.setColourMode("hatching");
        List bbox = this.mlArea.getMapLayerMetadata().getBbox();
        double step = ((Double)bbox.get(2) - (Double)bbox.get(0)) * 0.3;
        double[] extents = new double[]{(Double)bbox.get(0) - step, (Double)bbox.get(1) - step, (Double)bbox.get(2) + step, (Double)bbox.get(3) + step};
        step = ((Double)bbox.get(2) - (Double)bbox.get(0)) * 0.05;
        double[] extentsSmall = new double[]{(Double)bbox.get(0) - step, (Double)bbox.get(1) - step, (Double)bbox.get(2) + step, (Double)bbox.get(3) + step};
        step = ((Double)bbox.get(2) - (Double)bbox.get(0)) * 10.0;
        double[] extentsLarge = new double[]{(Double)bbox.get(0) - step, (Double)bbox.get(1) - step, (Double)bbox.get(2) + step, (Double)bbox.get(3) + step};
        if (extentsLarge[2] > 180.0) {
            extentsLarge[2] = 180.0;
        }
        if (extentsLarge[0] < -180.0) {
            extentsLarge[0] = -180.0;
        }
        if (extentsLarge[1] < -85.0) {
            extentsLarge[1] = -85.0;
        }
        if (extentsLarge[3] > 85.0) {
            extentsLarge[3] = 85.0;
        }
        this.setProgress("Getting information: images for map of map", 0.0);
        if (this.isCancelled()) {
            return;
        }
        MapLayer mlSpecies = this.createSpeciesLayer((Query)this.query, 0, 0, 255, 0.6f, false, 9, false);
        ArrayList<MapLayer> lifeforms = new ArrayList<MapLayer>();
        for (int i = 0; i < StringConstants.SPECIES_GROUPS.length; ++i) {
            String s = StringConstants.SPECIES_GROUPS[i];
            this.setProgress("Getting information: images for map of lifeform " + s, 0.0);
            if (this.isCancelled()) {
                return;
            }
            lifeforms.add(this.createSpeciesLayer((Query)this.query.newFacet(new Facet("species_group", s, true), false), 0, 0, 255, 0.6f, false, 9, false));
        }
        this.setProgress("Getting information: images for map of threatened species", 0.0);
        if (this.isCancelled()) {
            return;
        }
        MapLayer threatenedSpecies = this.createSpeciesLayer((Query)this.query.newFacet(Facet.parseFacet((String)CommonData.speciesListThreatened), false), 0, 0, 255, 0.6f, false, 9, false);
        this.setProgress("Getting information: images for map of iconic species", 0.0);
        if (this.isCancelled()) {
            return;
        }
        MapLayer iconicSpecies = this.createSpeciesLayer((Query)this.query.newFacet(new Facet("species_list_uid", "dr781", true), false), 0, 0, 255, 0.6f, false, 9, false);
        this.setProgress("Getting information: images for map of migratory species", 0.0);
        if (this.isCancelled()) {
            return;
        }
        MapLayer migratorySpecies = this.createSpeciesLayer((Query)this.query.newFacet(new Facet("species_list_uid", "dr1005", true), false), 0, 0, 255, 0.6f, false, 9, false);
        this.setProgress("Getting information: images for map of invasive species", 0.0);
        if (this.isCancelled()) {
            return;
        }
        MapLayer invasiveSpecies = this.createSpeciesLayer((Query)this.query.newFacet(Facet.parseFacet((String)CommonData.speciesListInvasive), false), 0, 0, 255, 0.6f, false, 9, false);
        for (String layer : layers = CommonData.getSettings().getProperty("detailed_area_report_layers").split("\n")) {
            if (layer.isEmpty()) continue;
            String[] split = layer.trim().split("\\|");
            String shortname = split[0];
            String displayname = split[1];
            String geoserver_url = split[2];
            String canSetColourMode = split[3];
            String description = split[4];
            this.setProgress("Getting information: images for map of layer " + shortname, 0.0);
            if (this.isCancelled()) {
                return;
            }
            MapLayer ml = this.createLayer(shortname, 1.0f);
            if ("Y".equalsIgnoreCase(canSetColourMode)) {
                ml.setColourMode("&styles=" + shortname + "&format_options=dpi:600");
            }
            this.setProgress("Getting information: making map of " + shortname, 0.0);
            if (this.isCancelled()) {
                return;
            }
            this.imageMap.put(shortname, new PrintMapComposer(extents, basemap, new MapLayer[]{this.mlArea, ml}, aspectRatio, "", type, resolution).get());
        }
        this.setProgress("Getting information: making map of area", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.imageMap.put("base_area", new PrintMapComposer(extents, basemap, new MapLayer[]{this.mlArea}, aspectRatio, "", type, resolution).get());
        this.setProgress("Getting information: making map of area overview", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.imageMap.put("base_area_zoomed_out", new PrintMapComposer(extentsLarge, basemap, new MapLayer[]{this.mlArea}, aspectRatio, "", type, resolution).get());
        this.setProgress("Getting information: making occurrences", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.imageMap.put("occurrences", new PrintMapComposer(extentsSmall, basemap, new MapLayer[]{this.mlArea, mlSpecies}, aspectRatio, "", type, resolution).get());
        this.setProgress("Getting information: making threatened species", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.imageMap.put("Threatened_Species", new PrintMapComposer(extentsSmall, basemap, new MapLayer[]{this.mlArea, threatenedSpecies}, aspectRatio, "", type, resolution).get());
        this.setProgress("Getting information: making iconic species", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.imageMap.put("Iconic_Species", new PrintMapComposer(extentsSmall, basemap, new MapLayer[]{this.mlArea, iconicSpecies}, aspectRatio, "", type, resolution).get());
        this.setProgress("Getting information: making migratory species", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.imageMap.put("Migratory_Species", new PrintMapComposer(extentsSmall, basemap, new MapLayer[]{this.mlArea, migratorySpecies}, aspectRatio, "", type, resolution).get());
        this.setProgress("Getting information: making invasive species", 0.0);
        if (this.isCancelled()) {
            return;
        }
        this.imageMap.put("Invasive_Species", new PrintMapComposer(extentsSmall, basemap, new MapLayer[]{this.mlArea, invasiveSpecies}, aspectRatio, "", type, resolution).get());
        for (int i = 0; i < StringConstants.SPECIES_GROUPS.length; ++i) {
            this.setProgress("Getting information: making map of lifeform " + StringConstants.SPECIES_GROUPS[i], 0.0);
            if (this.isCancelled()) {
                return;
            }
            this.imageMap.put("lifeform - " + StringConstants.SPECIES_GROUPS[i], new PrintMapComposer(extentsSmall, basemap, new MapLayer[]{this.mlArea, (MapLayer)lifeforms.get(i)}, aspectRatio, "", type, resolution).get());
        }
        this.setProgress("Getting information: saving maps", 0.0);
        if (this.isCancelled()) {
            return;
        }
        for (String key : this.imageMap.keySet()) {
            try {
                BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.filePath + File.separator + key + ".png"));
                bos.write((byte[])this.imageMap.get(key));
                bos.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)("failed to write image to: " + this.filePath), (Throwable)e);
            }
        }
    }

    MapLayer createLayer(String layerName, float opacity) {
        String type = "";
        String treeName = "";
        String treePath = "";
        String legendurl = "";
        String metadata = "";
        JSONArray layerlist = CommonData.getLayerListJSONArray();
        for (int j = 0; j < layerlist.size(); ++j) {
            JSONObject jo = (JSONObject)layerlist.get(j);
            String name = jo.get((Object)"name").toString();
            if (!name.equals(layerName)) continue;
            String uid = jo.get((Object)"id").toString();
            type = jo.get((Object)"type").toString();
            treeName = StringUtils.capitalize((String)jo.get((Object)"displayname").toString());
            treePath = jo.get((Object)"displaypath").toString();
            legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=9&LAYER=" + layerName;
            metadata = CommonData.getLayersServer() + "/layers/view/more/" + uid;
            break;
        }
        return this.addWMSLayer(layerName, treeName, treePath, opacity, metadata, legendurl, "environmental".equalsIgnoreCase(type) ? 20 : 19, null, null, null);
    }

    MapLayer createWKTLayer(String wkt, int red, int green, int blue, float opacity) {
        String pid;
        this.areaPid = pid = UserShapes.upload((String)wkt, (String)"", (String)"", (String)"area_report", (String)CommonData.getSettings().getProperty("api_key"));
        if (pid != null) {
            MapLayer newml = this.addObjectByPid(pid, red, green, blue, opacity);
            newml.setDisplayed(true);
            return newml;
        }
        LOGGER.error((Object)"failed to upload wkt to layers-service");
        return null;
    }

    public MapLayer addObjectByPid(String pid, int red, int green, int blue, float opacity) {
        JSONParser jp = new JSONParser();
        JSONObject obj = null;
        try {
            obj = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/object/" + pid)));
        }
        catch (ParseException e) {
            LOGGER.error((Object)("failed to parse for object: " + pid));
        }
        MapLayer mapLayer = this.addWMSLayer("PID:" + pid, "", obj.get((Object)"wmsurl").toString(), opacity, null, null, 11, null, null, null);
        mapLayer.setPolygonLayer(true);
        String bbox = obj.get((Object)"bbox").toString();
        MapLayerMetadata md = mapLayer.getMapLayerMetadata();
        try {
            List dbb = Util.getBoundingBox((String)bbox);
            md.setBbox(dbb);
        }
        catch (Exception e) {
            LOGGER.debug((Object)("failed to parse: " + bbox), (Throwable)e);
        }
        mapLayer.setRedVal(red);
        mapLayer.setGreenVal(green);
        mapLayer.setBlueVal(blue);
        mapLayer.setOpacity(opacity);
        mapLayer.setDynamicStyle(true);
        return mapLayer;
    }

    MapLayer createSpeciesLayer(Query query, int red, int green, int blue, float opacity, boolean grid, int size, boolean uncertainty) {
        Color c = new Color(red, green, blue);
        String hexColour = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        String envString = "";
        envString = grid ? envString + "colormode:grid" : "color:" + hexColour;
        envString = envString + ";name:circle;size:" + size + ";opacity:1";
        if (uncertainty) {
            envString = envString + ";uncertainty:1";
        }
        String uri = query.getUrl();
        uri = uri + "service=WMS&version=1.1.0&request=GetMap&format=image/png";
        uri = uri + "&layers=ALA:occurrences";
        uri = uri + "&transparent=true";
        uri = uri + (query.getQc() == null ? "" : query.getQc());
        uri = uri + "&CQL_FILTER=";
        MapLayer ml = this.addWMSLayer("", "", uri + query.getQ(), opacity, null, null, 21, "", envString, query);
        ml.setDynamicStyle(true);
        ml.setEnvParams(envString);
        ml.setGeometryType(25);
        ml.setBlueVal(blue);
        ml.setGreenVal(green);
        ml.setRedVal(red);
        ml.setSizeVal(3);
        ml.setOpacity(opacity);
        ml.setClustered(false);
        ml.setSpeciesQuery(query);
        return ml;
    }

    public MapLayer addWMSLayer(String name, String displayName, String uri, float opacity, String metadata, String legendUri, int subType, String cqlfilter, String envParams, Query q) {
        MapLayer mapLayer = this.remoteMap.createAndTestWMSLayer(name, uri, opacity);
        mapLayer.setDisplayName(displayName);
        if (q != null) {
            mapLayer.setSpeciesQuery(q);
        }
        mapLayer.setSubType(subType);
        mapLayer.setCql(cqlfilter);
        mapLayer.setEnvParams(envParams);
        String uriActual = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=9&LAYER=" + mapLayer.getLayer();
        mapLayer.setDefaultStyleLegendUri(uriActual);
        if (metadata != null) {
            if (metadata.startsWith("http")) {
                mapLayer.getMapLayerMetadata().setMoreInfo(metadata + "\n" + displayName);
            } else {
                mapLayer.getMapLayerMetadata().setMoreInfo(metadata);
            }
        }
        if (legendUri != null) {
            WMSStyle style = new WMSStyle();
            style.setName("Default");
            style.setDescription("Default style");
            style.setTitle("Default");
            style.setLegendUri(legendUri);
            mapLayer.addStyle(style);
            mapLayer.setSelectedStyleIndex(1);
            LOGGER.debug((Object)("adding WMSStyle with legendUri: " + legendUri));
            mapLayer.setDefaultStyleLegendUriSet(true);
        }
        mapLayer.setDisplayed(true);
        return mapLayer;
    }

    static /* synthetic */ void access$000(AreaReportPDF x0) {
        x0.initImages();
    }

    static /* synthetic */ void access$100(AreaReportPDF x0) {
        x0.initCountArea();
    }

    static /* synthetic */ void access$200(AreaReportPDF x0) {
        x0.initCountSpecies();
    }

    static /* synthetic */ void access$300(AreaReportPDF x0) {
        x0.initCountOccurrences();
    }

    static /* synthetic */ void access$400(AreaReportPDF x0) {
        x0.initCsvSpecies();
    }

    static /* synthetic */ void access$500(AreaReportPDF x0) {
        x0.initCountThreatenedSpecies();
    }

    static /* synthetic */ void access$600(AreaReportPDF x0) {
        x0.initCountEndemicSpecies();
    }

    static /* synthetic */ void access$700(AreaReportPDF x0, String x1) {
        x0.initDistributionsCsv(x1);
    }

    static /* synthetic */ void access$800(AreaReportPDF x0) {
        x0.initJournalmapCsv();
    }

    static /* synthetic */ String access$900(AreaReportPDF x0) {
        return x0.areaPid;
    }

    static /* synthetic */ Map access$1000(AreaReportPDF x0) {
        return x0.tabulation;
    }

    static /* synthetic */ Logger access$1100() {
        return LOGGER;
    }
}

