/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.servlet;

import au.org.emii.portal.net.HttpConnection;
import au.org.emii.portal.settings.Settings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.web.HttpRequestHandler;

public class RemoteRequestServlet
implements HttpRequestHandler {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(RemoteRequestServlet.class);
    private byte[] requestBody;
    private List<String> allowedHosts = new ArrayList();
    private Date updatedOn = null;
    private Settings settings = null;
    private HttpConnection httpConnection = null;

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.requestBody = IOUtils.toString((Reader)request.getReader()).getBytes("UTF-8");
        String queryString = request.getQueryString();
        LOGGER.debug((Object)("requested: " + queryString));
        String targetUrl = request.getParameter("url");
        if (targetUrl == null) {
            LOGGER.debug((Object)"no url parameter supplied");
            this.outputError(response);
        } else {
            try {
                URL url = new URL(targetUrl);
                String hostname = url.getHost();
                this.initAllowedHosts();
                if (this.allowed(hostname)) {
                    String extra = this.rebuildParameters(request.getParameterMap());
                    if (targetUrl.contains("?") && extra.startsWith("?")) {
                        extra = "&" + extra.substring(1);
                    }
                    String target = targetUrl + extra;
                    LOGGER.debug((Object)("access granted to hostname : " + hostname));
                    this.fetchAndOutputUrl(target, response, request);
                } else {
                    this.outputError(response);
                    LOGGER.debug((Object)("access to " + targetUrl + " denied - host is not allowed"));
                }
            }
            catch (MalformedURLException e) {
                LOGGER.debug((Object)("Url is malformed: " + targetUrl));
                this.outputError(response);
            }
        }
    }

    private String rebuildParameters(Map params) {
        StringBuilder uri = new StringBuilder();
        String delim = "?";
        for (Map.Entry o : params.entrySet()) {
            Map.Entry entry = o;
            if ("url".equalsIgnoreCase((String)entry.getKey())) continue;
            String[] value = (String[])entry.getValue();
            try {
                uri.append(delim).append(entry.getKey()).append("=").append(URLEncoder.encode(value[0], "UTF-8"));
                delim = "&";
            }
            catch (UnsupportedEncodingException e) {}
        }
        return uri.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAndOutputUrl(String url, HttpServletResponse response, HttpServletRequest request) {
        InputStream is = null;
        try {
            LOGGER.debug((Object)("will request '" + url + "' from remote server"));
            URLConnection con = this.httpConnection.configureSlowURLConnection(url);
            if ("POST".equals(request.getMethod())) {
                HttpURLConnection hc = (HttpURLConnection)new URL(url).openConnection();
                if (request.getContentType() != null) {
                    hc.setRequestProperty("Content-Type", request.getContentType());
                }
                hc.setRequestMethod("POST");
                hc.setDoInput(true);
                hc.setDoOutput(true);
                if (this.requestBody != null && this.requestBody.length > 0) {
                    hc.getOutputStream().write(this.requestBody);
                }
                con = hc;
            }
            response.addHeader("Cache-Control", "max-age=" + this.settings.getCacheMaxAge() + "public must-revalidate");
            is = con.getInputStream();
            byte[] data = IOUtils.toByteArray((InputStream)is);
            response.setContentType(con.getContentType());
            response.getOutputStream().write(data);
        }
        catch (IOException e) {
            LOGGER.debug((Object)("IO error doing remote request: " + e.getMessage()));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error closing stream to " + url), (Throwable)e);
                }
            }
        }
    }

    private boolean allowed(String hostname) {
        return this.allowedHosts.contains(hostname);
    }

    private void loadList() {
        this.allowedHosts.clear();
        String[] allowedHostsRaw = this.settings.getProxyAllowedHosts().split("\\|");
        ArrayList<String> newAllowedHosts = new ArrayList<String>();
        for (String string : allowedHostsRaw) {
            String trimmed = string.trim();
            LOGGER.debug((Object)("allowed host + " + trimmed));
            newAllowedHosts.add(trimmed);
        }
        this.allowedHosts = newAllowedHosts;
        this.updatedOn = new Date();
    }

    private void initAllowedHosts() {
        if (this.updatedOn == null) {
            this.loadList();
        }
    }

    private void outputError(HttpServletResponse response) throws IOException {
        response.getWriter().write("NOT ALLOWED");
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Required
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Required
    public void setHttpConnection(HttpConnection httpConnection) {
        this.httpConnection = httpConnection;
    }
}

