/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.menu;

import au.org.ala.legend.Facet;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.menu.MapLayer;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.List;

public class SelectedArea
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MapLayer mapLayer;
    private String wkt;
    private String area;
    private String reducedWkt = null;

    public SelectedArea(MapLayer mapLayer, String wkt) {
        this.mapLayer = mapLayer;
        this.wkt = wkt;
    }

    public String getWkt() {
        if (this.mapLayer != null) {
            return this.mapLayer.getWKT();
        }
        return this.wkt;
    }

    public String getReducedWkt() {
        if (this.reducedWkt == null) {
            this.reducedWkt = Util.reduceWKT((String)this.getWkt()).getReducedWKT();
        }
        return this.reducedWkt;
    }

    public MapLayer getMapLayer() {
        return this.mapLayer;
    }

    public String getKm2Area() {
        if (this.area == null) {
            if (this.mapLayer != null && this.mapLayer.getAreaSqKm() != null && this.mapLayer.getAreaSqKm().length() > 0) {
                this.area = this.mapLayer.getAreaSqKm();
            } else {
                try {
                    double totalarea = Util.calculateArea((String)this.getWkt());
                    DecimalFormat df = new DecimalFormat("###,###.##");
                    this.area = df.format(totalarea / 1000.0 / 1000.0);
                }
                catch (Exception e) {
                    this.area = "";
                }
            }
        }
        return this.area;
    }

    public List<Facet> getFacets() {
        return this.mapLayer != null ? this.mapLayer.getFacets() : null;
    }
}

