/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.menu;

import au.org.ala.legend.Facet;
import au.org.ala.legend.LegendObject;
import au.org.ala.spatial.dto.ScatterplotDataDTO;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.menu.MapLayerMetadata;
import au.org.emii.portal.menu.SelectedArea;
import au.org.emii.portal.value.AbstractIdentifierImpl;
import au.org.emii.portal.wms.WMSStyle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONArray;

public class MapLayer
extends AbstractIdentifierImpl
implements Cloneable,
Serializable {
    public static final int STYLE_DEFAULT = 0;
    private int selectedStyleIndex = 0;
    private static final String DELIM = "::";
    private static final long serialVersionUID = 1L;
    private String uri = null;
    private String cql = null;
    private float opacity = 0.0f;
    private String imageFormat = null;
    private int type = -1;
    private boolean baseLayer = false;
    private boolean displayed = false;
    private boolean defaultStyleLegendUriSet = false;
    private int subType = -1;
    private String geoJSON = null;
    private String geometryWKT = null;
    private List<WMSStyle> styles = new ArrayList();
    private MapLayerMetadata mapLayerMetadata = null;
    private boolean currentlyAnimated = false;
    private String colourMode = "-1";
    private String highlight = null;
    private String displayName = null;
    private ScatterplotDataDTO scatterplotDataDTO;
    private List<MapLayer> children = new ArrayList();
    private String layer = null;
    private boolean polygonLayer = false;
    private boolean removeable = true;
    private String areaSqKm;
    private Query speciesQuery;
    private List<Facet> facets;
    private String cache;
    private String envelope;
    private String spcode;
    private String poi;
    private String highlightState;
    private Integer animationStep;
    private Double animationInterval;
    private Integer lastYear;
    private Integer firstYear;
    private Integer classificationSelection;
    private Integer classificationGroupCount;
    private LegendObject legendObject;
    private String pid;
    private long mapLayerId = 0L;
    private long parentmaplayerid = 0L;
    private long userMapId;
    private long maplayermetadataid;
    private boolean userDefinedLayer = false;
    private int geometryType;
    private boolean dynamicStyle = false;
    private int redVal;
    private int blueVal;
    private int greenVal;
    private int sizeVal;
    private boolean sizeUncertain;
    private boolean clustered;
    private String envColour;
    private String envName;
    private String envSize;
    private String envParams = null;
    private JSONArray classificationObjects;
    private String baseUri;
    private String wktUrl;

    public MapLayer() {
        WMSStyle style = new WMSStyle();
        style.setName("Default");
        style.setDescription("Default style");
        style.setTitle("Default");
        this.styles.add(style);
        this.setMapLayerMetadata(new MapLayerMetadata());
    }

    public boolean defaultStyleLegendUriSet() {
        return this.defaultStyleLegendUriSet;
    }

    public String getGeoJSON() {
        return this.geoJSON;
    }

    public void setGeoJSON(String geoJSON) {
        this.geoJSON = geoJSON;
    }

    public String getWktUrl() {
        return this.wktUrl;
    }

    public void setWktUrl(String wktUrl) {
        this.wktUrl = wktUrl;
    }

    public String getWKT() {
        String wkt = this.testWKT();
        if (wkt == null && this.getWktUrl() != null) {
            wkt = Util.readUrl((String)this.getWktUrl());
        }
        return wkt;
    }

    public void setWKT(String wkt) {
        this.geometryWKT = wkt;
    }

    public int getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(int geometryType) {
        this.geometryType = geometryType;
    }

    public int getBlueVal() {
        return this.blueVal;
    }

    public void setBlueVal(int blueVal) {
        this.blueVal = blueVal;
    }

    public int getGreenVal() {
        return this.greenVal;
    }

    public void setGreenVal(int greenVal) {
        this.greenVal = greenVal;
    }

    public int getRedVal() {
        return this.redVal;
    }

    public void setRedVal(int redVal) {
        this.redVal = redVal;
    }

    public int getSizeVal() {
        return this.sizeVal;
    }

    public void setSizeVal(int sizeVal) {
        this.sizeVal = sizeVal;
    }

    public boolean getSizeUncertain() {
        return this.sizeUncertain;
    }

    public void setSizeUncertain(boolean sizeUncertain) {
        this.sizeUncertain = sizeUncertain;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public String getEnvColour() {
        return this.envColour;
    }

    public void setEnvColour(String envColour) {
        this.envColour = envColour;
    }

    public String getEnvName() {
        return this.envName;
    }

    public void setEnvName(String envName) {
        this.envName = envName;
    }

    public String getEnvSize() {
        return this.envSize;
    }

    public void setEnvSize(String envSize) {
        this.envSize = envSize;
    }

    public boolean isDynamicStyle() {
        return this.dynamicStyle;
    }

    public void setDynamicStyle(boolean dynamicStyle) {
        this.dynamicStyle = dynamicStyle;
    }

    public String getEnvParams() {
        return this.envParams;
    }

    public void setEnvParams(String envParams) {
        this.envParams = envParams;
    }

    public boolean isUserDefinedLayer() {
        return this.userDefinedLayer;
    }

    public void setUserDefinedLayer(boolean userDefinedLayer) {
        this.userDefinedLayer = userDefinedLayer;
    }

    public long getMaplayermetadataid() {
        return this.maplayermetadataid;
    }

    public void setMaplayermetadataid(long maplayermetadataid) {
        this.maplayermetadataid = maplayermetadataid;
    }

    public long getParentmaplayerid() {
        return this.parentmaplayerid;
    }

    public void setParentmaplayerid(long parentmaplayerid) {
        this.parentmaplayerid = parentmaplayerid;
    }

    public long getUserMapId() {
        return this.userMapId;
    }

    public void setUserMapId(long userMapId) {
        this.userMapId = userMapId;
    }

    public long getMapLayerId() {
        return this.mapLayerId;
    }

    public void setMapLayerId(long mapLayerId) {
        this.mapLayerId = mapLayerId;
    }

    public WMSStyle getSelectedStyle() {
        WMSStyle style = this.selectedStyleIndex > 0 ? (WMSStyle)this.styles.get(this.selectedStyleIndex) : null;
        return style;
    }

    public String getSelectedSystemStyleName() {
        return ((WMSStyle)this.styles.get(this.selectedStyleIndex)).getName();
    }

    public String getSelectedStyleName() {
        if (this.selectedStyleIndex > 0) {
            return this.getSelectedSystemStyleName();
        }
        String styleName = "";
        return styleName;
    }

    public String getCurrentLegendUri() {
        String u = this.isDynamicStyle() ? ((WMSStyle)this.styles.get(this.selectedStyleIndex)).getLegendUri() : (this.hasStyle() ? ((WMSStyle)this.styles.get(this.selectedStyleIndex)).getLegendUri() : null);
        return u;
    }

    public int getSelectedStyleIndex() {
        return this.selectedStyleIndex;
    }

    public void setSelectedStyleIndex(int selectedStyleIndex) {
        this.selectedStyleIndex = selectedStyleIndex;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public String getUri() {
        if (this.cache != null) {
            return this.uri + "&CACHE=" + this.cache;
        }
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getCache() {
        return this.cache;
    }

    public void setCache(String cache) {
        this.cache = cache;
    }

    public String getCql() {
        return this.cql;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public String getUniqueId() {
        return this.getId() + DELIM + this.layer + DELIM + this.getName();
    }

    public String getLayer() {
        return this.layer;
    }

    public void setLayer(String layer) {
        this.layer = layer;
    }

    public List<MapLayer> getChildren() {
        return this.children;
    }

    public void setChildren(List<MapLayer> children) {
        this.children = children;
    }

    public MapLayer getChild(int i) {
        return (MapLayer)this.children.get(i);
    }

    public boolean isLeaf() {
        return !this.hasChildren();
    }

    public int getChildCount() {
        return this.children.size();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void addChild(MapLayer c) {
        this.children.add(c);
    }

    public void addStyle(WMSStyle style) {
        this.styles.add(style);
    }

    public void addStyles(List<WMSStyle> styles) {
        this.styles.addAll(styles);
    }

    public void setDefaultStyleLegendUri(String legendUri) {
        if (legendUri != null) {
            ((WMSStyle)this.styles.get(0)).setLegendUri(legendUri);
            this.defaultStyleLegendUriSet = true;
        }
    }

    public int getStyleCount() {
        return this.styles.size();
    }

    public boolean hasStyles() {
        return this.styles.size() > 1;
    }

    public boolean hasStyle() {
        return !this.styles.isEmpty();
    }

    public boolean isBaseLayer() {
        return this.baseLayer;
    }

    public void setBaseLayer(boolean baseLayer) {
        this.baseLayer = baseLayer;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    public List<WMSStyle> getStyles() {
        return this.styles;
    }

    public void setStyles(List<WMSStyle> styles) {
        this.styles = styles;
    }

    public boolean isDefaultStyleLegendUriSet() {
        return this.defaultStyleLegendUriSet;
    }

    public void setDefaultStyleLegendUriSet(boolean defaultStyleLegendUriSet) {
        this.defaultStyleLegendUriSet = defaultStyleLegendUriSet;
    }

    public boolean isRemoveable() {
        return this.removeable;
    }

    public void setRemoveable(boolean removeable) {
        this.removeable = removeable;
    }

    public Object clone() throws CloneNotSupportedException {
        MapLayer mapLayer = (MapLayer)super.clone();
        mapLayer.children = new ArrayList();
        mapLayer.styles = new ArrayList();
        if (this.mapLayerId > 0L) {
            mapLayer.mapLayerId = this.mapLayerId;
        }
        if (this.styles != null) {
            for (WMSStyle style : this.styles) {
                mapLayer.addStyle((WMSStyle)style.copy());
            }
        }
        if (this.children != null) {
            for (MapLayer child : this.children) {
                MapLayer clonedChild = (MapLayer)child.clone();
                mapLayer.addChild(clonedChild);
            }
        }
        if (this.mapLayerMetadata != null) {
            mapLayer.mapLayerMetadata = this.mapLayerMetadata;
        }
        return mapLayer;
    }

    public MapLayerMetadata getMapLayerMetadata() {
        return this.mapLayerMetadata;
    }

    public void setMapLayerMetadata(MapLayerMetadata mapLayerMetadata) {
        this.mapLayerMetadata = mapLayerMetadata;
    }

    public String getNameJS() {
        return StringEscapeUtils.escapeJavaScript((String)this.getName());
    }

    public String getUniqueIdJS() {
        return StringEscapeUtils.escapeJavaScript((String)this.getUniqueId());
    }

    public String getUriJS() {
        return StringEscapeUtils.escapeJavaScript((String)this.getUri());
    }

    public String getCqlJS() {
        return StringEscapeUtils.escapeJavaScript((String)this.getCql());
    }

    public String getLayerJS() {
        return StringEscapeUtils.escapeJavaScript((String)this.getLayer());
    }

    public String getSelectedStyleNameJS() {
        return StringEscapeUtils.escapeJavaScript((String)this.getSelectedStyleName());
    }

    public String getHighlight() {
        return this.highlight;
    }

    public void setHighlight(String pid) {
        this.highlight = pid;
    }

    public String getColourMode() {
        return this.colourMode;
    }

    public void setColourMode(String string) {
        this.colourMode = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public void setName(String name) {
        super.setName(name);
        this.setDisplayName(name);
    }

    public boolean isPolygonLayer() {
        return this.polygonLayer || this.subType == 22;
    }

    public void setPolygonLayer(boolean isPolygon) {
        this.polygonLayer = isPolygon;
    }

    public boolean isSpeciesLayer() {
        return this.speciesQuery != null;
    }

    public Query getSpeciesQuery() {
        return this.speciesQuery;
    }

    public void setSpeciesQuery(Query query) {
        this.speciesQuery = query;
    }

    public boolean isGridLayer() {
        return this.subType == 20;
    }

    public boolean isContextualLayer() {
        return this.subType == 19;
    }

    public int getSubType() {
        return this.subType;
    }

    public void setSubType(int type) {
        this.subType = type;
    }

    public String calculateAndStoreArea() {
        String area = new SelectedArea(this, null).getKm2Area();
        this.setAreaSqKm(area);
        return area;
    }

    public String getAreaSqKm() {
        return this.areaSqKm;
    }

    public void setAreaSqKm(String areaSqKm) {
        this.areaSqKm = areaSqKm;
    }

    public ScatterplotDataDTO getScatterplotDataDTO() {
        return this.scatterplotDataDTO;
    }

    public void setScatterplotDataDTO(ScatterplotDataDTO data) {
        this.scatterplotDataDTO = data;
    }

    public List<Facet> getFacets() {
        return this.facets;
    }

    public void setFacets(List<Facet> facets) {
        this.facets = facets;
    }

    public String getHighlightState() {
        return this.highlightState;
    }

    public void setHighlightState(String state) {
        this.highlightState = state;
    }

    public String getPointsOfInterestWS() {
        return this.poi;
    }

    public void setPointsOfInterestWS(String poi) {
        this.poi = poi;
    }

    public LegendObject getLegendObject() {
        return this.legendObject;
    }

    public void setLegendObject(LegendObject lo) {
        this.legendObject = lo;
    }

    public Integer getClassificationGroupCount() {
        return this.classificationGroupCount;
    }

    public void setClassificationGroupCount(Integer classificationGroupCount) {
        this.classificationGroupCount = classificationGroupCount;
    }

    public Integer getClassificationSelection() {
        return this.classificationSelection;
    }

    public void setClassificationSelection(Integer groupSelection) {
        this.classificationSelection = groupSelection;
    }

    public Integer getFirstYear() {
        return this.firstYear;
    }

    public void setFirstYear(Integer firstYear) {
        this.firstYear = firstYear;
    }

    public Integer getLastYear() {
        return this.lastYear;
    }

    public void setLastYear(Integer lastYear) {
        this.lastYear = lastYear;
    }

    public Integer getAnimationStep() {
        return this.animationStep;
    }

    public void setAnimationStep(Integer step) {
        this.animationStep = step;
    }

    public Double getAnimationInterval() {
        return this.animationInterval;
    }

    public void setAnimationInterval(Double interval) {
        this.animationInterval = interval;
    }

    public String getSPCode() {
        return this.spcode;
    }

    public void setSPCode(String spcode) {
        this.spcode = spcode;
    }

    public String getEnvelope() {
        return this.envelope;
    }

    public void setEnvelope(String envelope) {
        this.envelope = envelope;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public JSONArray getClassificationObjects() {
        return this.classificationObjects;
    }

    public void setClassificationObjects(JSONArray classificationObjects) {
        this.classificationObjects = classificationObjects;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String testWKT() {
        if (this.isPolygonLayer() && this.getType() != 11 && this.geometryWKT == null && this.geoJSON == null) {
            return null;
        }
        if (this.geometryWKT == null) {
            this.geometryWKT = Util.wktFromJSON((String)this.geoJSON);
        }
        return this.geometryWKT;
    }
}

