/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.javascript;

import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.emii.portal.javascript.OpenLayersJavascript;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.session.PortalSession;
import au.org.emii.portal.util.LayerUtilities;
import au.org.emii.portal.util.Validate;
import au.org.emii.portal.value.BoundingBox;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.util.Clients;

public class OpenLayersJavascriptImpl
implements OpenLayersJavascript {
    public static final String SAFE_TO_PROCEED_CLOSE = "} ";
    public static final String SAFE_TO_PROCEED_OPEN = "if (typeof safeToProceed !== 'undefined' && safeToProceed) { ";
    private static final Logger LOGGER = Logger.getLogger(OpenLayersJavascriptImpl.class);
    private LayerUtilities layerUtilities = null;
    private String additionalScript = "";

    public String getIFrameReferences() {
        return "var safeToProceed=true; if (mapLayers == null) {\tmapLayers = window.mapFrame.mapLayers; } if (map == null) {\tmap = window.mapFrame.map; } if (OpenLayers == null) {\tOpenLayers = window.mapFrame.OpenLayers; } if (baseLayers == null) {\tbaseLayers = window.mapFrame.baseLayers; } if (currentBaseLayer == null) {\tcurrentBaseLayer = window.mapFrame.currentBaseLayer; } if (currentBaseLayer == null) {\tcurrentBaseLayer = window.mapFrame.currentBaseLayer; } if (registerLayer == null) {\tregisterLayer = window.mapFrame.registerLayer; } if (\t(mapLayers == null) || \t\t(map == null) || \t\t(OpenLayers == null) || \t\t(baseLayers == null)) { \tsafeToProceed=false;\talert('map subsystem is not fully loaded yet - this operation will fail');} ";
    }

    private String wrapWithSafeToProceed(String script) {
        return SAFE_TO_PROCEED_OPEN + script + SAFE_TO_PROCEED_CLOSE;
    }

    public String minify(String fragment) {
        return fragment.replaceAll("\\s+", " ");
    }

    public String initialiseMap(BoundingBox boundingBox) {
        return "window.mapFrame.buildMapReal(" + Math.max(-180.0f, boundingBox.getMinLongitude()) + ", " + Math.max(-85.0f, boundingBox.getMinLatitude()) + ", " + Math.min(180.0f, boundingBox.getMaxLongitude()) + ", " + Math.min(85.0f, boundingBox.getMaxLatitude()) + "); ";
    }

    public String addPolygonDrawingTool() {
        return "window.mapFrame.addPolygonDrawingTool()";
    }

    public String addRadiusDrawingTool() {
        return "window.mapFrame.addRadiusDrawingTool()";
    }

    public String addFeatureSelectionTool() {
        return "window.mapFrame.addFeatureSelectionTool()";
    }

    public String addBoxDrawingTool() {
        return "window.mapFrame.addBoxDrawingTool()";
    }

    public void zoomGeoJsonExtentNow(MapLayer ml) {
        this.execute(this.zoomGeoJsonExtent(ml));
    }

    public String zoomGeoJsonExtent(MapLayer ml) {
        String script = ml.getMapLayerMetadata().getBboxString() != null ? "window.mapFrame.map.zoomToExtent(new OpenLayers.Bounds.fromString('" + ml.getMapLayerMetadata().getBboxString() + "').transform(new OpenLayers.Projection('EPSG:4326'),map.getProjectionObject()))" : "window.mapFrame.zoomBoundsGeoJSON('" + ml.getName().replaceAll("'", "\\'") + "')";
        return script;
    }

    public void zoomLayerExtent(MapLayer ml) {
        String script = "";
        if (ml.getMapLayerMetadata().getBboxString() != null) {
            script = "map.zoomToExtent(new OpenLayers.Bounds(" + ml.getMapLayerMetadata().getBboxString() + ")" + ".transform(" + "  new OpenLayers.Projection('EPSG:4326')," + "  map.getProjectionObject()));";
            this.execute(script);
        }
    }

    public void removeLayer(MapLayer ml) {
        String script = "window.mapFrame.removeItFromTheList('" + ml.getName() + "')";
        this.execute(script);
    }

    public String removeMapLayer(MapLayer layer) {
        return this.removeMapLayer(layer, true);
    }

    private String removeMapLayer(MapLayer layer, boolean recursive) {
        StringBuilder script = new StringBuilder();
        if (layer.isDisplayed()) {
            script.append("if (mapLayers['").append(layer.getUniqueIdJS()).append("'] != null) { ").append(" window.mapFrame.removeFromSelectControl('").append(layer.getNameJS()).append("'); ").append(" map.removeLayer(mapLayers['").append(layer.getUniqueIdJS()).append("']); ").append(" mapLayers['").append(layer.getUniqueIdJS()).append("'] = null; ").append(SAFE_TO_PROCEED_CLOSE);
            layer.setDisplayed(false);
        }
        if (recursive) {
            for (MapLayer child : layer.getChildren()) {
                script.append(this.removeMapLayer(child, true));
            }
        }
        return this.wrapWithSafeToProceed(script.toString());
    }

    public void removeMapLayerNow(MapLayer mapLayer) {
        this.execute(this.getIFrameReferences() + this.removeMapLayer(mapLayer) + this.getAdditionalScript());
    }

    public String updateMapLayerIndexes(List<MapLayer> activeLayers) {
        int order = 0;
        StringBuilder script = new StringBuilder();
        for (int i = activeLayers.size() - 1; i > -1; --i) {
            if (!activeLayers.get(i).isDisplayed()) continue;
            script.append("map.setLayerIndex(mapLayers['").append(activeLayers.get(i).getUniqueIdJS()).append("'], ").append(order).append("); ");
            ++order;
        }
        return this.wrapWithSafeToProceed(script.toString());
    }

    public void updateMapLayerIndexesNow(List<MapLayer> activeLayers) {
        this.execute(this.getIFrameReferences() + this.updateMapLayerIndexes(activeLayers));
    }

    public String zoomToBoundingBox(BoundingBox boundingBox) {
        String script = "var mapObj = window.frames.mapFrame.map;map.zoomToExtent( (new OpenLayers.Bounds(" + Math.max(-180.0f, boundingBox.getMinLongitude()) + ", " + Math.max(-85.0f, boundingBox.getMinLatitude()) + ", " + Math.min(180.0f, boundingBox.getMaxLongitude()) + ", " + Math.min(85.0f, boundingBox.getMaxLatitude()) + ")).transform(mapObj.displayProjection, mapObj.projection) " + "); ";
        return this.wrapWithSafeToProceed(script);
    }

    public void zoomToBoundingBoxNow(BoundingBox boundingBox, boolean closest) {
        this.execute(this.getIFrameReferences() + this.zoomToBoundingBox(boundingBox, closest));
    }

    public String zoomToBoundingBox(BoundingBox boundingBox, boolean closest) {
        String script = "var mapObj = window.frames.mapFrame.map;map.zoomToExtent( (new OpenLayers.Bounds(" + Math.max(-180.0f, boundingBox.getMinLongitude()) + ", " + Math.max(-85.0f, boundingBox.getMinLatitude()) + ", " + Math.min(180.0f, boundingBox.getMaxLongitude()) + ", " + Math.min(85.0f, boundingBox.getMaxLatitude()) + ")).transform(mapObj.displayProjection, mapObj.projection) " + ", " + closest + "); ";
        return this.wrapWithSafeToProceed(script);
    }

    public String activateMapLayer(MapLayer mapLayer) {
        return this.activateMapLayer(mapLayer, true, false);
    }

    public String activateMapLayer(MapLayer mapLayer, boolean recursive, boolean alternativeScript) {
        String associativeArray = mapLayer.isBaseLayer() ? "baseLayers" : "mapLayers";
        StringBuilder script = new StringBuilder("if (" + associativeArray + "['" + mapLayer.getUniqueIdJS() + "'] == null) { ");
        switch (mapLayer.getType()) {
            case 11: {
                script.append(this.defineWKTMapLayer(mapLayer));
                break;
            }
            default: {
                script.append(this.defineWMSMapLayer(mapLayer));
            }
        }
        script.append(SAFE_TO_PROCEED_CLOSE);
        script.append(" if(").append(associativeArray).append("['").append(mapLayer.getUniqueIdJS()).append("'] != undefined) map.addLayer(").append(associativeArray).append("['").append(mapLayer.getUniqueIdJS()).append("']); ");
        if (mapLayer.isBaseLayer()) {
            script.append("if (currentBaseLayer != null) { ").append(" map.removeLayer( ").append(associativeArray).append("[currentBaseLayer]); ").append(associativeArray).append("[currentBaseLayer] = null; ").append(SAFE_TO_PROCEED_CLOSE).append("currentBaseLayer='").append(mapLayer.getUniqueIdJS()).append("'; ").append("map.setBaseLayer(").append(associativeArray).append("[currentBaseLayer]); ");
        }
        mapLayer.setDisplayed(true);
        if (recursive) {
            for (MapLayer child : mapLayer.getChildren()) {
                if (child.getHighlightState() != null && !"show".equals(child.getHighlightState())) continue;
                script.append(this.activateMapLayer(child, true, alternativeScript));
            }
        }
        return this.wrapWithSafeToProceed(this.getAdditionalScript() + script.toString());
    }

    public String defineKMLMapLayer(MapLayer layer) {
        String script = " mapLayers['" + layer.getUniqueIdJS() + "'] = window.mapFrame.loadKmlFile('" + layer.getNameJS() + "','" + layer.getUriJS() + "');" + "registerLayer(mapLayers['" + layer.getUniqueIdJS() + "']);";
        return this.wrapWithSafeToProceed(script);
    }

    public void redrawFeatures(MapLayer selectedLayer) {
        String script = "window.mapFrame.redrawFeatures('" + selectedLayer.getName() + "','" + selectedLayer.getEnvColour() + "', " + selectedLayer.getOpacity() + "," + selectedLayer.getSizeVal() + "," + selectedLayer.getSizeUncertain() + ")";
        this.execute(script);
    }

    public void redrawWKTFeatures(MapLayer selectedLayer) {
        String script = "window.mapFrame.redrawWKTFeatures('" + selectedLayer.getWKT() + "', '" + selectedLayer.getName() + "','" + selectedLayer.getEnvColour() + "', " + selectedLayer.getOpacity() + ")";
        this.execute(script);
    }

    public String defineWKTMapLayer(MapLayer layer) {
        String script = "var vector_layer = window.mapFrame.addWKTFeatureToMap('" + layer.getWKT() + "','" + layer.getNameJS() + "','" + layer.getEnvColour() + "', " + layer.getOpacity() + ");" + "mapLayers['" + layer.getUniqueIdJS() + "'] = vector_layer;";
        if (layer.getPointsOfInterestWS() != null) {
            script = script + "mapLayers['" + layer.getUniqueIdJS() + "']" + ".pointsOfInterestWS = '" + layer.getPointsOfInterestWS() + "';";
        }
        script = script + "registerLayer(mapLayers['" + layer.getUniqueIdJS() + "']);";
        return this.wrapWithSafeToProceed(script);
    }

    private String wmsVersionDeclaration(MapLayer layer) {
        String version = this.layerUtilities.getWmsVersion(layer);
        String versionJS = "";
        if (version != null) {
            versionJS = "1.3.0".equals(version) ? "version: '1.3.0', crs: 'epsg:4326' " : "version: '" + version + "' ";
        }
        return versionJS;
    }

    public String defineWMSMapLayer(MapLayer layer) {
        String gutter = "0";
        String params = "";
        String associativeArray = layer.isBaseLayer() ? "baseLayers" : "mapLayers";
        if (!Validate.empty((String)layer.getCql())) {
            params = "CQL_FILTER: '" + layer.getCqlJS() + "' ";
            params = params + ", ";
        }
        if (!Validate.empty((String)layer.getEnvParams())) {
            try {
                params = params + "env: '" + URLEncoder.encode(layer.getEnvParams(), "UTF-8") + "', ";
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error((Object)("failed to encode env params : " + layer.getEnvParams().replace("'", "\\'")), (Throwable)e);
            }
        }
        String dynamicStyle = "";
        if (layer.isPolygonLayer()) {
            String filter;
            String colour = Integer.toHexString(0xFF0000 & layer.getRedVal() << 16 | 0xFF00 & layer.getGreenVal() << 8 | 0xFF & layer.getBlueVal());
            while (colour.length() < 6) {
                colour = "0" + colour;
            }
            if (layer.getUri().contains("ALA:envelope")) {
                filter = "";
                if (!layer.getUri().contains("sld_body")) {
                    filter = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"><NamedLayer><Name>" + this.layerUtilities.getLayer(layer.getUri()) + "</Name>" + "<UserStyle><FeatureTypeStyle><Rule><RasterSymbolizer><Geometry></Geometry>" + "<ColorMap>" + "<ColorMapEntry color=\"#ffffff\" opacity=\"0\" quantity=\"0\"/>" + "<ColorMapEntry color=\"#" + colour + "\" opacity=\"1\" quantity=\"1\" />" + "</ColorMap></RasterSymbolizer></Rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>";
                }
            } else if (layer.getUri() != null && layer.getUri().contains("ColorMapEntry")) {
                String uri = layer.getUri();
                String str = "ColorMapEntry+color%3D%220x";
                int p = uri.indexOf(str);
                while (p > 0 && p + str.length() + 6 < uri.length()) {
                    uri = uri.substring(0, p + str.length()) + colour + uri.substring(p + str.length() + 6);
                    p = uri.indexOf(str, p + 1);
                }
                layer.setUri(uri);
                filter = "";
            } else {
                filter = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor version=\"1.0.0\" xmlns=\"http://www.opengis.net/sld\"><NamedLayer><Name>" + this.layerUtilities.getLayer(layer.getUri()) + "</Name>" + "<UserStyle><FeatureTypeStyle><Rule><Title>Polygon</Title><PolygonSymbolizer><Fill>" + "<CssParameter name=\"fill\">#" + colour + "</CssParameter></Fill>" + "</PolygonSymbolizer></Rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>";
            }
            try {
                dynamicStyle = filter.length() == 0 ? "" : "&sld_body=" + URLEncoder.encode(filter, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.debug((Object)"invalid filter sld", (Throwable)e);
            }
        }
        String script = " " + associativeArray + "['" + layer.getUniqueIdJS() + "'] = new OpenLayers.Layer.WMS(" + "  '" + layer.getNameJS() + "', " + "  '" + layer.getUriJS().replace("wms?service=WMS&version=1.1.0&request=GetMap&", "wms\\/reflect?") + dynamicStyle + "', " + "  {" + ("Default".equals(layer.getSelectedStyleNameJS()) ? "" : "   styles: '" + layer.getSelectedStyleNameJS() + "', ") + "   layers: '" + layer.getLayerJS() + "', " + "   format: '" + layer.getImageFormat() + "', " + "         srs: 'epsg:3857', " + "   transparent: " + !layer.isBaseLayer() + ", " + "   " + params + this.wmsVersionDeclaration(layer) + "  }, " + "  { " + "   isBaseLayer: " + layer.isBaseLayer() + ", " + "   opacity: " + layer.getOpacity() + ", " + "   queryable: true, " + "   gutter: " + gutter + ", " + "   wrapDateLine: true" + "  }  " + " ); " + associativeArray + "['" + layer.getUniqueIdJS() + "']" + ".getFeatureInfoBuffer =" + CommonData.getSettings().getProperty("get_feature_info_buffer") + "; ";
        if (layer.getSpeciesQuery() != null) {
            Query q = layer.getSpeciesQuery();
            if (q instanceof BiocacheQuery) {
                BiocacheQuery bq = (BiocacheQuery)q;
                try {
                    script = script + associativeArray + "['" + layer.getUniqueIdJS() + "']" + ".ws ='" + StringEscapeUtils.escapeJavaScript((String)bq.getWS()) + "'; " + associativeArray + "['" + layer.getUniqueIdJS() + "']" + ".bs ='" + StringEscapeUtils.escapeJavaScript((String)bq.getBS()) + "'; ";
                }
                catch (Exception e) {
                    LOGGER.error((Object)("error escaping for JS: " + bq.getBS()), (Throwable)e);
                }
            }
            if (q.flagRecordCount() > 0) {
                script = script + "parent.addFlaggedRecords('" + layer.getNameJS() + "','" + StringEscapeUtils.escapeJavaScript((String)q.getFlaggedRecords()) + "'); ";
            }
        }
        if (!layer.isBaseLayer()) {
            script = script + " " + associativeArray + "['" + layer.getUniqueIdJS() + "']" + ".featureInfoResponseType=" + layer.getType() + "; ";
        }
        script = script + "registerLayer(" + associativeArray + "['" + layer.getUniqueIdJS() + "']);";
        return this.wrapWithSafeToProceed(script);
    }

    public void activateMapLayerNow(MapLayer layer) {
        this.execute(this.getIFrameReferences() + this.getAdditionalScript() + this.activateMapLayer(layer));
    }

    public String activateMapLayers(List<MapLayer> layers) {
        StringBuilder script = new StringBuilder();
        if (layers != null) {
            for (int i = layers.size() - 1; i >= 0; --i) {
                MapLayer layer = layers.get(i);
                if (!layer.isDisplayed()) continue;
                script.append(this.activateMapLayer(layer, true, true));
            }
        }
        if (script.toString().length() > 0) {
            return this.wrapWithSafeToProceed(script.toString());
        }
        return "";
    }

    public void activateMapLayersNow(List<MapLayer> layers) {
        this.execute(this.getIFrameReferences() + this.activateMapLayers(layers));
    }

    public String setMapLayerOpacity(MapLayer mapLayer, float percentage) {
        String script = "mapLayers['" + mapLayer.getUniqueIdJS() + "'].setOpacity(" + percentage + "); mapLayers['" + mapLayer.getUniqueIdJS() + "'].redraw(); ";
        return this.wrapWithSafeToProceed(script);
    }

    public void setMapLayerOpacityNow(MapLayer mapLayer, float percentage) {
        this.execute(this.getIFrameReferences() + this.setMapLayerOpacity(mapLayer, percentage));
    }

    public String reloadMapLayer(MapLayer mapLayer) {
        return this.removeMapLayer(mapLayer) + this.activateMapLayer(mapLayer);
    }

    public void reloadMapLayerNow(MapLayer mapLayer) {
        this.execute(this.getIFrameReferences() + this.reloadMapLayer(mapLayer));
    }

    public void execute(String script) {
        if (this.mapLoaded()) {
            String minScript = this.minify(script);
            LOGGER.debug((Object)("exec javascript: " + minScript));
            Clients.evalJavaScript((String)minScript);
        } else {
            LOGGER.debug((Object)"refused to execute javascript - map not loaded");
        }
    }

    public boolean mapLoaded() {
        PortalSession portalSession = (PortalSession)Sessions.getCurrent().getAttribute("portalSession");
        return portalSession != null && portalSession.isMapLoaded();
    }

    public String popupWindow(String uri, String title) {
        return "window.open(\"" + uri + "\",\"" + title + "\");";
    }

    public void popupWindowNow(String uri, String title) {
        this.execute(this.popupWindow(uri, title));
    }

    public LayerUtilities getLayerUtilities() {
        return this.layerUtilities;
    }

    @Required
    public void setLayerUtilities(LayerUtilities layerUtilities) {
        this.layerUtilities = layerUtilities;
    }

    public String getAdditionalScript() {
        String aS = this.additionalScript;
        this.additionalScript = "";
        return aS;
    }

    public void setAdditionalScript(String additionalScript) {
        if (this.additionalScript == null) {
            this.additionalScript = "";
        }
        if (additionalScript != null) {
            this.additionalScript = this.additionalScript + additionalScript;
        }
    }

    public void useAdditionalScript() {
        if (this.additionalScript != null && this.additionalScript.length() > 0) {
            this.execute(this.getAdditionalScript());
        }
    }

    public String setBaseLayer(String baseLayer) {
        return "changeBaseLayer('" + baseLayer + "');";
    }
}

