/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.factory;

import au.org.emii.portal.factory.PortalDocumentFactory;
import au.org.emii.portal.settings.Settings;
import au.org.emii.portal.util.PortalProperties;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class PortalDocumentFactoryFileImpl
implements PortalDocumentFactory,
InitializingBean {
    private static final Logger LOGGER = Logger.getLogger(PortalDocumentFactoryFileImpl.class);
    private Settings settings = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties createPortalDocumentInstance() {
        PortalProperties portalDocument = new PortalProperties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.getConfigFilename());
            portalDocument.load(is);
        }
        catch (FileNotFoundException e) {
            portalDocument = null;
            LOGGER.error((Object)("Could not load portal configuration file from: " + this.getConfigFilename()));
        }
        catch (IOException e) {
            portalDocument = null;
            LOGGER.error((Object)"IOException reading configuration - should never happen, you may have big problems! - check this stack trace", (Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error closing " + this.getConfigFilename()), (Throwable)e);
            }
        }
        return portalDocument;
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Required
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public String getConfigFilename() {
        return "/data/webportal/config/webportal-config.properties";
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.settings);
    }
}

