/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.event;

import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.javascript.OpenLayersJavascript;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.session.PortalSession;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Listitem;

public class VisibilityToggleEventListener
implements EventListener {
    private static final Logger LOGGER = Logger.getLogger(VisibilityToggleEventListener.class);
    private OpenLayersJavascript openLayersJavascript = null;

    public void onEvent(Event event) throws Exception {
        LOGGER.debug((Object)"VisibilityToggleEventListener.onEvent() fired ");
        Checkbox checkbox = (Checkbox)event.getTarget();
        try {
            MapComposer mapComposer = (MapComposer)event.getPage().getFellow("mapPortalPage");
            if (mapComposer.safeToPerformMapAction()) {
                Listitem listitem = (Listitem)checkbox.getParent().getParent();
                MapLayer layer = (MapLayer)listitem.getValue();
                boolean checked = checkbox.isChecked();
                if (checked) {
                    PortalSession portalSession = (PortalSession)Executions.getCurrent().getDesktop().getSession().getAttribute("portalSession");
                    this.openLayersJavascript.execute(this.openLayersJavascript.getIFrameReferences() + this.openLayersJavascript.activateMapLayer(layer, false, true) + this.openLayersJavascript.updateMapLayerIndexes(portalSession.getActiveLayers()));
                    checkbox.setTooltiptext("Hide");
                    mapComposer.refreshContextualMenu();
                } else {
                    this.openLayersJavascript.removeMapLayerNow(layer);
                    checkbox.setTooltiptext("Show");
                    mapComposer.refreshContextualMenu();
                }
            } else {
                checkbox.setChecked(!checkbox.isChecked());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OpenLayersJavascript getOpenLayersJavascript() {
        return this.openLayersJavascript;
    }

    @Required
    public void setOpenLayersJavascript(OpenLayersJavascript openLayersJavascript) {
        this.openLayersJavascript = openLayersJavascript;
    }
}

