/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.event;

import au.org.ala.spatial.dto.ScatterplotDataDTO;
import au.org.ala.spatial.util.Query;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.event.PortalEvent;
import au.org.emii.portal.menu.MapLayer;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Listitem;

public class ActiveLayersInfoEventListener
extends PortalEvent
implements EventListener {
    private static final Logger LOGGER = Logger.getLogger(PortalEvent.class);

    public void onEvent(Event event) throws Exception {
        MapComposer mapComposer = this.getMapComposer(event);
        if (mapComposer != null && mapComposer.safeToPerformMapAction()) {
            Component target = event.getTarget();
            Listitem listItem = (Listitem)target.getParent().getParent();
            MapLayer activeLayer = (MapLayer)listItem.getValue();
            if (activeLayer != null) {
                if (activeLayer.getSpeciesQuery() != null) {
                    Query q = activeLayer.getSpeciesQuery();
                    Events.echoEvent((String)"openHTML", (Component)mapComposer, (String)q.getMetadataHtml());
                } else if (activeLayer.getMapLayerMetadata().getMoreInfo() != null && activeLayer.getMapLayerMetadata().getMoreInfo().startsWith("http://")) {
                    String infourl = activeLayer.getMapLayerMetadata().getMoreInfo().replace("__", ".");
                    if (activeLayer.getSubType() == 17) {
                        ScatterplotDataDTO data = activeLayer.getScatterplotDataDTO();
                        infourl = infourl + "?dparam=X-Layer:" + data.getLayer1Name();
                        infourl = infourl + "&dparam=Y-Layer:" + data.getLayer2Name();
                    }
                    LOGGER.debug((Object)("opening the following url " + infourl));
                    Events.echoEvent((String)"openUrl", (Component)mapComposer, (String)activeLayer.getMapLayerMetadata().getMoreInfo().replace("__", "."));
                } else if (activeLayer.getMapLayerMetadata().getMoreInfo() != null && activeLayer.getMapLayerMetadata().getMoreInfo().length() > 0) {
                    LOGGER.debug((Object)("performing a MapComposer.showMessage for following content " + activeLayer.getMapLayerMetadata().getMoreInfo()));
                    String metadata = activeLayer.getMapLayerMetadata().getMoreInfo();
                    Events.echoEvent((String)"openHTML", (Component)mapComposer, (String)metadata);
                } else if (activeLayer.getType() == 12) {
                    String metaurl = "http://www.google.com/intl/en_au/help/terms_maps.html";
                    if ("outline".equalsIgnoreCase(mapComposer.getPortalSession().getBaseLayer())) {
                        metaurl = "openstreetmap_metadata.html";
                    } else if ("minimal".equalsIgnoreCase(mapComposer.getPortalSession().getBaseLayer())) {
                        metaurl = "http://www.naturalearthdata.com/about/terms-of-use";
                    }
                    LOGGER.debug((Object)("opening base map metadata for: " + mapComposer.getPortalSession().getBaseLayer() + ", url:" + metaurl));
                    Events.echoEvent((String)"openUrl", (Component)mapComposer, (String)metaurl);
                } else {
                    LOGGER.debug((Object)"no metadata is available for current layer");
                    mapComposer.showMessage("Metadata currently unavailable");
                }
            }
        } else {
            LOGGER.debug((Object)"MapController reports unsafe to perform action");
        }
    }
}

