/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.databinding;

import au.org.emii.portal.event.ActiveLayerDNDEventListener;
import au.org.emii.portal.event.ActiveLayersAdjustEventListener;
import au.org.emii.portal.event.ActiveLayersInfoEventListener;
import au.org.emii.portal.event.ActiveLayersLegendEventListener;
import au.org.emii.portal.event.ActiveLayersRemoveAll;
import au.org.emii.portal.event.ActiveLayersRemoveEventListener;
import au.org.emii.portal.event.ActiveLayersZoomExtentEventListener;
import au.org.emii.portal.event.VisibilityAllToggleEventListener;
import au.org.emii.portal.event.VisibilityToggleEventListener;
import au.org.emii.portal.lang.LanguagePack;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.util.LayerUtilities;
import org.springframework.beans.factory.annotation.Required;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;

public class ActiveLayerRenderer
implements ListitemRenderer {
    private LanguagePack languagePack = null;
    private LayerUtilities layerUtilities = null;
    private VisibilityToggleEventListener visibilityToggleEventListener = null;

    public void render(Listitem item, Object data, int itemIdx) throws Exception {
        MapLayer layer = (MapLayer)data;
        Listcell listcell = new Listcell();
        Checkbox checkbox = new Checkbox();
        checkbox.setChecked(layer.isDisplayed());
        checkbox.setParent((Component)listcell);
        checkbox.setTooltiptext("Hide");
        if (layer.getType() == 12) {
            checkbox.setChecked(true);
        }
        checkbox.addEventListener("onCheck", (EventListener)this.visibilityToggleEventListener);
        if (!layer.isRemoveable()) {
            checkbox.setStyle("float:left; visibility:hidden; ");
            checkbox.setDisabled(true);
        }
        Label label = new Label(layer.getDisplayName());
        listcell.setParent((Component)item);
        item.addEventListener("onDrop", (EventListener)new ActiveLayerDNDEventListener());
        item.setDraggable("true");
        item.setDroppable("true");
        item.setValue((Object)layer);
        label.setTooltiptext(layer.getDescription());
        if (layer.isRemoveable()) {
            checkbox.setStyle("float:left;");
        }
        if (layer.isRemoveable()) {
            Html remove = new Html(this.languagePack.getLang("layer_remove_icon_html"));
            remove.addEventListener("onClick", (EventListener)new ActiveLayersRemoveEventListener());
            remove.setParent((Component)listcell);
            remove.setStyle("float:right;");
            remove.setTooltiptext("remove layer");
        }
        Html info = new Html(this.languagePack.getLang("layer_info_icon_html"));
        info.setParent((Component)listcell);
        info.setStyle("float:right;");
        info.setTooltiptext("metadata");
        info.addEventListener("onClick", (EventListener)new ActiveLayersInfoEventListener());
        if (layer.getType() != 12) {
            Html zoomextent = new Html(this.languagePack.getLang("layer_zoomextent_icon_html"));
            zoomextent.setParent((Component)listcell);
            zoomextent.setStyle("float:right");
            zoomextent.setTooltiptext("zoom to extent");
            zoomextent.addEventListener("onClick", (EventListener)new ActiveLayersZoomExtentEventListener());
        }
        Image legend = layer.isGridLayer() || layer.getSubType() == 16 || layer.getSubType() == 15 || layer.getSubType() == 14 ? new Image(this.languagePack.getLang("icon_grid")) : (layer.isSpeciesLayer() ? new Image(this.languagePack.getLang("icon_species")) : (layer.isPolygonLayer() ? new Image(this.languagePack.getLang("icon_polygon")) : (layer.isContextualLayer() ? new Image(this.languagePack.getLang("icon_contextual")) : new Image(this.languagePack.getLang("layer_legend_icon")))));
        legend.setStyle("float:left;");
        legend.setParent((Component)listcell);
        legend.setTooltiptext("View/edit the legend");
        legend.addEventListener("onClick", (EventListener)new ActiveLayersLegendEventListener());
        label.setParent((Component)listcell);
        if (layer.getType() == 12) {
            Div div = new Div();
            div.setClass("btn-group");
            div.setParent((Component)listcell);
            div.setStyle("float:right;margin-right:30px");
            Button b = new Button("Delete all");
            b.setClass("btn-mini");
            b.setParent((Component)div);
            b.setVisible(false);
            b.addEventListener("onClick", (EventListener)new ActiveLayersRemoveAll());
            b = new Button("Show all");
            b.setClass("btn-mini");
            b.setParent((Component)div);
            b.setVisible(false);
            b.addEventListener("onClick", (EventListener)new VisibilityAllToggleEventListener(true));
            b = new Button("Hide all");
            b.setClass("btn-mini");
            b.setParent((Component)div);
            b.setVisible(false);
            b.addEventListener("onClick", (EventListener)new VisibilityAllToggleEventListener(false));
            new ActiveLayersAdjustEventListener().equals(new ForwardEvent("", (Component)legend, null));
        }
    }

    public LanguagePack getLanguagePack() {
        return this.languagePack;
    }

    @Required
    public void setLanguagePack(LanguagePack languagePack) {
        this.languagePack = languagePack;
    }

    public LayerUtilities getLayerUtilities() {
        return this.layerUtilities;
    }

    @Required
    public void setLayerUtilities(LayerUtilities layerUtilities) {
        this.layerUtilities = layerUtilities;
    }

    public VisibilityToggleEventListener getVisibilityToggleEventListener() {
        return this.visibilityToggleEventListener;
    }

    @Required
    public void setVisibilityToggleEventListener(VisibilityToggleEventListener visibilityToggleEventListener) {
        this.visibilityToggleEventListener = visibilityToggleEventListener;
    }
}

