/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.config;

import au.org.ala.spatial.util.CommonData;
import au.org.emii.portal.config.ConfigurationLoaderStage2;
import au.org.emii.portal.session.PortalSession;
import au.org.emii.portal.settings.Settings;
import au.org.emii.portal.util.PortalSessionUtilities;
import au.org.emii.portal.value.BoundingBox;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;

public class ConfigurationLoaderStage2Impl
implements ConfigurationLoaderStage2 {
    private static final Logger LOGGER = Logger.getLogger(ConfigurationLoaderStage2Impl.class);
    private Properties portalDocument = null;
    private PortalSession workingPortalSession = null;
    private Settings settings = null;
    private Properties settingsSupplementary = null;
    private PortalSessionUtilities portalSessionUtilities = null;
    private boolean error = false;
    private boolean reloading = false;

    public PortalSession load() {
        PortalSession masterPortalSession;
        this.reloading = true;
        this.error = false;
        this.workingPortalSession = new PortalSession();
        this.settings();
        this.settingsSupplementary();
        this.finaliseSession();
        if (this.error) {
            LOGGER.error((Object)"error constructing master portal session in stage 2 loader - error flag got set, returning null PortalSession instance and disabling portal");
            masterPortalSession = null;
        } else {
            masterPortalSession = this.workingPortalSession;
        }
        CommonData.init((Properties)this.settingsSupplementary);
        this.cleanup();
        this.reloading = false;
        return masterPortalSession;
    }

    private void finaliseSession() {
        this.workingPortalSession.setDefaultBoundingbox(this.settings.getDefaultBoundingBox());
    }

    public void cleanup() {
        this.portalDocument = null;
        this.workingPortalSession = null;
    }

    public void setProperties(Properties portalDocument) {
        this.portalDocument = portalDocument;
    }

    private void settings() {
        LOGGER.debug((Object)"settings...");
        LOGGER.debug((Object)"Settings from config file:");
        this.settings.setConfigRereadInitialInterval(Integer.parseInt(this.portalDocument.getProperty("configRereadInitialInterval")));
        this.settings.setConfigRereadInterval(Integer.parseInt(this.portalDocument.getProperty("configRereadInterval")));
        this.settings.setNetConnectSlowTimeout(Integer.parseInt(this.portalDocument.getProperty("netConnectSlowTimeout")));
        this.settings.setNetConnectTimeout(Integer.parseInt(this.portalDocument.getProperty("netConnectTimeout")));
        this.settings.setNetReadSlowTimeout(Integer.parseInt(this.portalDocument.getProperty("netReadSlowTimeout")));
        this.settings.setNetReadTimeout(Integer.parseInt(this.portalDocument.getProperty("netReadTimeout")));
        this.settings.setProxyAllowedHosts(this.portalDocument.getProperty("proxyAllowedHosts"));
        this.settings.setDefaultBoundingBox(this.defaultBoundingBox());
    }

    private BoundingBox defaultBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        try {
            bbox.setMinLatitude(Float.parseFloat(this.portalDocument.getProperty("defaultBoundingBox.minLatitude")));
            bbox.setMaxLatitude(Float.parseFloat(this.portalDocument.getProperty("defaultBoundingBox.maxLatitude")));
            bbox.setMinLongitude(Float.parseFloat(this.portalDocument.getProperty("defaultBoundingBox.minLongitude")));
            bbox.setMaxLongitude(Float.parseFloat(this.portalDocument.getProperty("defaultBoundingBox.maxLongitude")));
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to parse defaultBoundBox values", (Throwable)e);
        }
        return bbox;
    }

    private void settingsSupplementary() {
        this.settingsSupplementary = this.portalDocument;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isError() {
        return this.error;
    }

    public PortalSessionUtilities getPortalSessionUtilities() {
        return this.portalSessionUtilities;
    }

    @Required
    public void setPortalSessionUtilities(PortalSessionUtilities portalSessionUtilities) {
        this.portalSessionUtilities = portalSessionUtilities;
    }

    public void setReloading(boolean reloading) {
        this.reloading = reloading;
    }
}

