/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.config;

import au.org.emii.portal.config.ConfigurationLoaderStage1;
import au.org.emii.portal.config.ConfigurationLoaderStage2;
import au.org.emii.portal.factory.PortalDocumentFactory;
import au.org.emii.portal.session.PortalSession;
import au.org.emii.portal.settings.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Required;

public class ConfigurationLoaderStage1Impl
implements ConfigurationLoaderStage1 {
    public static final int BROKEN_CONFIG_RELOAD = 300000;
    private static int rereadInterval = 300000;
    public static final List<Thread> LOADERS = new ArrayList();
    private static final Logger LOGGER = Logger.getLogger(ConfigurationLoaderStage1Impl.class);
    private ConfigurationLoaderStage2 stage2 = null;
    private PortalDocumentFactory portalDocumentFactory = null;
    private Settings settings = null;
    private boolean running = false;
    private ServletContext servletContext = null;
    private boolean error = false;
    private boolean reloading;

    @Required
    public void setStage2(ConfigurationLoaderStage2 stage2) {
        this.stage2 = stage2;
    }

    private void load() {
        this.error = false;
        this.reloading = true;
        Properties portalDocument = this.portalDocumentFactory.createPortalDocumentInstance();
        if (portalDocument == null) {
            LOGGER.debug((Object)"Configuration file missing or invalid - cannot load portal.  See previous message for cause");
        } else {
            this.stage2.setProperties(portalDocument);
            PortalSession masterPortalSession = this.stage2.load();
            if (this.stage2.isError()) {
                this.error = true;
            }
            this.servletContext.setAttribute("masterPortalSession", (Object)masterPortalSession);
            LOGGER.debug((Object)"finished building master portalSession");
        }
        this.reloading = false;
    }

    public void run() {
        this.running = true;
        boolean firstRun = true;
        while (this.running) {
            try {
                this.load();
                if (firstRun) {
                    LOADERS.add(Thread.currentThread());
                    rereadInterval = this.settings.getConfigRereadInitialInterval();
                    firstRun = false;
                } else {
                    rereadInterval = this.settings.getConfigRereadInterval();
                }
                if (rereadInterval == 0) {
                    LOGGER.warn((Object)"invalid value (0) for configReloadInitial or configReload in config file (or config file not loaded)");
                    rereadInterval = 300000;
                }
                LOGGER.debug((Object)("menu (re)load attempt finished, goinging to sleep for " + rereadInterval + "ms"));
                Thread.sleep(rereadInterval);
            }
            catch (InterruptedException e) {
                LOGGER.debug((Object)"Configuration Loader was interrupted during its sleep, probably not important");
            }
        }
    }

    public void stop() {
        LOGGER.debug((Object)"requesting stop for configuration loader thread");
        this.running = false;
        this.servletContext = null;
    }

    public Settings getSettings() {
        return this.settings;
    }

    @Required
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public boolean isError() {
        return this.error;
    }

    public void setPortalDocumentFactory(PortalDocumentFactory portalDocumentFactory) {
        this.portalDocumentFactory = portalDocumentFactory;
    }

    public boolean isReloading() {
        return this.reloading;
    }
}

