/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.composer.legend;

import au.org.ala.legend.QueryField;
import au.org.ala.spatial.util.LegendMaker;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.UserDataQuery;
import au.org.emii.portal.composer.GenericAutowireAutoforwardComposer;
import au.org.emii.portal.menu.MapLayer;
import java.awt.Color;
import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Div;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.Slider;

public class ScatterplotLayerLegendComposer
extends GenericAutowireAutoforwardComposer {
    private static final Logger LOGGER = Logger.getLogger(ScatterplotLayerLegendComposer.class);
    private Slider opacitySlider;
    private Label opacityLabel;
    private Slider redSlider;
    private Slider greenSlider;
    private Slider blueSlider;
    private Slider sizeSlider;
    private Slider plotSizeSlider;
    private Label redLabel;
    private Label greenLabel;
    private Label blueLabel;
    private Label sizeLabel;
    private Label plotSizeLabel;
    private Div sizeChooser;
    private Image legendImg;
    private Div legendHtml;
    private Div divUserColours;
    private Combobox cbColour;
    private Comboitem ciColourUser;
    private EventListener listener;
    private Query query;
    private MapLayer mapLayer;

    public void afterCompose() {
        super.afterCompose();
        this.cbColour.setSelectedIndex(0);
    }

    public void onScroll$opacitySlider(Event e) {
        float opacity = (float)this.opacitySlider.getCurpos() / 100.0f;
        int percentage = (int)(opacity * 100.0f);
        this.opacitySlider.setCurpos(percentage);
        this.opacityLabel.setValue(percentage + "%");
    }

    public void updateLegendImage() {
        LegendMaker lm = new LegendMaker();
        int red = this.redSlider.getCurpos();
        int blue = this.blueSlider.getCurpos();
        int green = this.greenSlider.getCurpos();
        Color c = new Color(red, green, blue);
        this.legendImg.setContent((RenderedImage)lm.singleCircleImage(c, 120, 120, 50.0));
        this.sizeChooser.setVisible(true);
        if (this.cbColour.getSelectedItem() != this.ciColourUser) {
            this.legendHtml.setVisible(true);
            this.legendImg.setVisible(false);
            this.showPointsColourModeLegend();
        } else {
            this.legendImg.setVisible(true);
            this.legendHtml.setVisible(false);
        }
    }

    public void onScroll$sizeSlider() {
        int size = this.sizeSlider.getCurpos();
        this.sizeLabel.setValue(String.valueOf(size));
    }

    public void onScroll$plotSizeSlider() {
        int size = this.plotSizeSlider.getCurpos();
        this.plotSizeLabel.setValue(String.valueOf(size));
    }

    public void onScroll$blueSlider() {
        int blue = this.blueSlider.getCurpos();
        this.blueLabel.setValue(String.valueOf(blue));
        this.updateLegendImage();
    }

    public void onScroll$redSlider() {
        int red = this.redSlider.getCurpos();
        this.redLabel.setValue(String.valueOf(red));
        this.updateLegendImage();
    }

    public void onScroll$greenSlider() {
        int green = this.greenSlider.getCurpos();
        this.greenLabel.setValue(String.valueOf(green));
        this.updateLegendImage();
    }

    public void selectColour(Object obj) {
        String backgroundColor;
        Div div = (Div)obj;
        String style = div.getStyle();
        int a = style.indexOf(backgroundColor = "background-color");
        if (a >= 0) {
            String colour = style.substring(a + backgroundColor.length() + 2, a + backgroundColor.length() + 8);
            int r = Integer.parseInt(colour.substring(0, 2), 16);
            int g = Integer.parseInt(colour.substring(2, 4), 16);
            int b = Integer.parseInt(colour.substring(4, 6), 16);
            this.redSlider.setCurpos(r);
            this.greenSlider.setCurpos(g);
            this.blueSlider.setCurpos(b);
            this.redLabel.setValue(String.valueOf(r));
            this.greenLabel.setValue(String.valueOf(g));
            this.blueLabel.setValue(String.valueOf(b));
            this.updateLegendImage();
        }
    }

    public void onChange$cbColour(Event event) {
        this.updateUserColourDiv();
        this.updateLegendImage();
    }

    void updateUserColourDiv() {
        if (this.cbColour.getSelectedItem() == this.ciColourUser) {
            this.divUserColours.setVisible(true);
        } else {
            this.divUserColours.setVisible(false);
        }
    }

    void updateComboBoxesColour(MapLayer currentSelection) {
        if (currentSelection.isClustered()) {
            this.cbColour.setSelectedItem(this.ciColourUser);
            this.cbColour.setDisabled(true);
        } else {
            this.cbColour.setDisabled(false);
            for (int i = 0; i < this.cbColour.getItemCount(); ++i) {
                if (!this.cbColour.getItemAtIndex(i).getValue().equals(currentSelection.getColourMode())) continue;
                this.cbColour.setSelectedIndex(i);
            }
            this.updateUserColourDiv();
        }
    }

    void showPointsColourModeLegend() {
        while (!this.legendHtml.getChildren().isEmpty()) {
            this.legendHtml.removeChild(this.legendHtml.getFirstChild());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("query", this.query);
        map.put("layer", this.mapLayer);
        map.put("readonly", "true");
        map.put("colourmode", this.cbColour.getSelectedItem().getValue());
        if (!"grid".equals(this.mapLayer.getColourMode()) && this.query.getLegend((String)this.cbColour.getSelectedItem().getValue()).getCategoryNameOrder() != null) {
            map.put("checkmarks", "true");
        }
        map.put("disableselection", "true");
        try {
            Executions.createComponents((String)"/WEB-INF/zul/legend/LayerLegendClassification.zul", (Component)this.legendHtml, map);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error creating LayerLegendClassification.zul", (Throwable)e);
        }
    }

    public void init(Query query, MapLayer mapLayer, int red, int green, int blue, int size, int opacity, String colourMode, EventListener listener) {
        this.query = query;
        this.mapLayer = mapLayer;
        this.opacitySlider.setCurpos(opacity);
        this.onScroll$opacitySlider(null);
        this.redSlider.setCurpos(red);
        this.onScroll$redSlider();
        this.greenSlider.setCurpos(green);
        this.onScroll$greenSlider();
        this.blueSlider.setCurpos(blue);
        this.onScroll$blueSlider();
        this.sizeSlider.setCurpos(mapLayer.getSizeVal());
        this.onScroll$sizeSlider();
        this.plotSizeSlider.setCurpos(size);
        this.onScroll$plotSizeSlider();
        this.setupCBColour(query);
        for (Comboitem item : this.cbColour.getItems()) {
            if (item.getValue() == null || !item.getValue().equals(colourMode)) continue;
            this.cbColour.setSelectedItem(item);
            break;
        }
        this.listener = listener;
        this.updateUserColourDiv();
        this.updateLegendImage();
    }

    public int getRed() {
        return this.redSlider.getCurpos();
    }

    public int getGreen() {
        return this.greenSlider.getCurpos();
    }

    public int getBlue() {
        return this.blueSlider.getCurpos();
    }

    public int getSize() {
        return this.sizeSlider.getCurpos();
    }

    public int getPlotSize() {
        return this.plotSizeSlider.getCurpos();
    }

    public int getOpacity() {
        return this.opacitySlider.getCurpos();
    }

    public String getColourMode() {
        return (String)this.cbColour.getSelectedItem().getValue();
    }

    public void onClick$btnApply(Event event) {
        if (this.listener != null) {
            try {
                this.listener.onEvent(null);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error updating legend in scatterplot window", (Throwable)e);
            }
        }
    }

    public void onClick$btnClose(Event event) {
        this.detach();
    }

    public void onClick$btnCancel(Event event) {
        this.detach();
    }

    private void setupCBColour(Query q) {
        for (int i = this.cbColour.getItemCount() - 1; i >= 0; --i) {
            if (this.cbColour.getItemAtIndex(i) == this.ciColourUser) continue;
            this.cbColour.removeItemAt(i);
        }
        if (q != null) {
            List fields = this.query.getFacetFieldList();
            Collections.sort(fields, new QueryField.QueryFieldComparator());
            String lastGroup = null;
            for (QueryField field : fields) {
                if (field.getFieldType() != QueryField.FieldType.STRING || !(q instanceof UserDataQuery) && ("occurrence_year".equalsIgnoreCase(field.getName()) || "coordinate_uncertainty".equalsIgnoreCase(field.getName()) || "month".equalsIgnoreCase(field.getName()))) continue;
                String newGroup = field.getGroup().getName();
                if (!newGroup.equals(lastGroup)) {
                    Comboitem sep = new Comboitem("seperator");
                    sep.setLabel(StringUtils.center((String)newGroup, (int)19));
                    sep.setParent((Component)this.cbColour);
                    sep.setDisabled(true);
                    lastGroup = newGroup;
                }
                Comboitem ci = new Comboitem(field.getDisplayName());
                ci.setValue((Object)field.getName());
                ci.setParent((Component)this.cbColour);
            }
        }
    }
}

