/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.composer.legend;

import au.org.ala.legend.Facet;
import au.org.ala.spatial.dto.ScatterplotDataDTO;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.composer.legend.LayerLegendScatterplotController;
import au.org.emii.portal.composer.legend.ScatterplotLayerLegendComposer;
import au.org.emii.portal.menu.HasMapLayer;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.SelectedArea;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.simple.JSONArray;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Label;
import org.zkoss.zul.Textbox;

public class LayerLegendScatterplotController
extends UtilityComposer
implements HasMapLayer {
    private static final Logger LOGGER = Logger.getLogger(LayerLegendScatterplotController.class);
    private Textbox tbxChartSelection;
    private Label tbxSelectionCount;
    private Label tbxRange;
    private Label tbxDomain;
    private Label tbxMissingCount;
    private ScatterplotDataDTO data;
    private Div scatterplotButtons;
    private Div scatterplotDownloads;
    private MapLayer mapLayer = null;
    private Checkbox chkSelectMissingRecords;
    private Button addNewLayers;
    private Combobox cbHighlightArea;
    private ScatterplotLayerLegendComposer layerWindow = null;

    public void afterCompose() {
        super.afterCompose();
        this.addEventListener("onSize", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void doEmbedded() {
        super.doEmbedded();
        this.redraw();
    }

    public void doOverlapped() {
        super.doOverlapped();
        this.redraw();
    }

    public ScatterplotDataDTO getScatterplotData() {
        if (this.data == null) {
            this.data = this.mapLayer == null ? new ScatterplotDataDTO() : this.mapLayer.getScatterplotDataDTO();
        }
        return this.data;
    }

    public void onChange$tbxChartSelection(Event event) {
        try {
            LOGGER.debug(event.getData());
            String[] coordsStr = ((String)event.getData()).replace("px", "").split(",");
            double[] coordsDbl = new double[coordsStr.length];
            for (int i = 0; i < coordsStr.length; ++i) {
                coordsDbl[i] = Double.parseDouble(coordsStr[i]);
            }
            String params = "?minx=" + coordsDbl[0] + "&miny=" + coordsDbl[1] + "&maxx=" + coordsDbl[2] + "&maxy=" + coordsDbl[3];
            this.data.setImagePath(CommonData.getSatServer() + "/ws/scatterplot/" + this.data.getId() + params);
            ObjectMapper om = new ObjectMapper();
            JSONArray ja = (JSONArray)om.readValue(new URL(this.data.getImagePath()), JSONArray.class);
            this.data.setPrevSelection(new double[4]);
            this.data.getPrevSelection()[0] = Double.parseDouble(ja.get(0).toString());
            this.data.getPrevSelection()[1] = Double.parseDouble(ja.get(1).toString());
            this.data.getPrevSelection()[2] = Double.parseDouble(ja.get(2).toString());
            this.data.getPrevSelection()[3] = Double.parseDouble(ja.get(3).toString());
            Facet f = this.getFacetIn();
            if (f != null) {
                this.mapLayer.setHighlight(f.toString());
            } else {
                this.mapLayer.setHighlight(null);
            }
            this.getMapComposer().applyChange(this.mapLayer);
            this.tbxChartSelection.setText("");
            this.tbxDomain.setValue(String.format("%s: %g - %g", this.data.getLayer1Name(), this.data.getPrevSelection()[1], this.data.getPrevSelection()[3]));
            this.tbxRange.setValue(String.format("%s: %g - %g", this.data.getLayer2Name(), this.data.getPrevSelection()[0], this.data.getPrevSelection()[2]));
            this.data.setImagePath(CommonData.getSatServer() + "/ws/scatterplot/" + this.data.getId() + ".png" + params);
            this.registerScatterPlotSelection();
            this.redraw();
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to build scatterplot legend", (Throwable)e);
            this.clearSelection();
            this.getMapComposer().applyChange(this.mapLayer);
        }
    }

    void redraw() {
        this.getScatterplotData();
        this.updateCbHighlightArea();
        int width = Integer.parseInt(this.getWidth().replace("px", "")) - 20;
        int height = Integer.parseInt(this.getHeight().replace("px", "")) - Integer.parseInt(this.tbxChartSelection.getHeight().replace("px", ""));
        if (height > width) {
            height = width;
        } else {
            width = height;
        }
        if (this.data.getImagePath() == null || !this.data.getImagePath().contains(".png")) {
            this.data.setImagePath(CommonData.getSatServer() + "/ws/scatterplot/" + this.data.getId() + ".png?" + System.currentTimeMillis());
        }
        String script = "if (typeof updateScatterplot !== 'undefined') updateScatterplot(" + width + "," + height + ",'url(" + this.data.getImagePath() + ")')";
        Clients.evalJavaScript((String)script);
        this.scatterplotDownloads.setVisible(true);
        this.updateCount(String.valueOf(this.data.getSelectionCount()));
        if (this.data.getMissingDataChecked().booleanValue() != this.chkSelectMissingRecords.isChecked()) {
            this.chkSelectMissingRecords.setChecked(this.data.getMissingDataChecked().booleanValue());
        }
        if (this.data.getMissingCount() > 0) {
            this.tbxMissingCount.setValue("(" + this.data.getMissingCount() + ")");
            this.chkSelectMissingRecords.setVisible(true);
        } else {
            this.tbxMissingCount.setValue("");
            this.chkSelectMissingRecords.setVisible(false);
        }
    }

    private void registerScatterPlotSelection() {
        try {
            if (this.data.getLayer1() != null && this.data.getLayer1().length() > 0 && this.data.getLayer2() != null && this.data.getLayer2().length() > 0) {
                Facet f = this.getFacetIn();
                int count = 0;
                if (f != null) {
                    Query q = this.data.getQuery().newFacet(f, false);
                    count = q.getOccurrenceCount();
                }
                this.updateCount(String.valueOf(count));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error updating scatterplot selection", (Throwable)e);
            this.clearSelection();
            this.getMapComposer().applyChange(this.mapLayer);
        }
    }

    void updateCount(String txt) {
        if (txt != null && !txt.isEmpty()) {
            this.data.setSelectionCount(Integer.parseInt(txt));
            this.tbxSelectionCount.setValue("Records selected: " + txt);
            if (this.data.getSelectionCount() > 0) {
                this.addNewLayers.setVisible(true);
            } else {
                this.addNewLayers.setVisible(false);
            }
            this.scatterplotButtons.setVisible(true);
        }
    }

    void clearSelection() {
        this.tbxSelectionCount.setValue("");
        this.addNewLayers.setVisible(false);
        this.tbxRange.setValue("");
        this.tbxDomain.setValue("");
        this.data.setPrevSelection(null);
        this.chkSelectMissingRecords.setChecked(false);
        this.getScatterplotData().setEnabled(false);
        this.scatterplotDownloads.setVisible(false);
        this.data.setPrevSelection(null);
        this.scatterplotButtons.setVisible(false);
    }

    public void onClick$addSelectedRecords(Event event) {
        Facet f = this.getFacetIn();
        if (f != null) {
            this.addUserLayer(this.data.getQuery().newFacet(this.getFacetIn(), true), "IN " + this.data.getSpeciesName(), null, 0);
        }
    }

    public void onClick$addUnSelectedRecords(Event event) {
        this.addUserLayer(this.data.getQuery().newFacet(this.getFacetOut(), true), "OUT " + this.data.getSpeciesName(), null, 0);
    }

    void addUserLayer(Query query, String layername, String description, int numRecords) {
        String cLayername = StringUtils.capitalize((String)layername);
        this.getMapComposer().mapSpecies(query, cLayername, "species", -1, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
    }

    public void onClick$addNewLayers(Event event) {
        this.onClick$addUnSelectedRecords(null);
        this.onClick$addSelectedRecords(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick$scatterplotImageDownload(Event event) {
        this.getScatterplotData();
        try {
            byte[] b = null;
            InputStream in = new URL(this.data.getImagePath()).openStream();
            try {
                b = IOUtils.toByteArray((InputStream)in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            Filedownload.save((byte[])b, (String)"image/png", (String)"scatterplot.png");
        }
        catch (Exception e) {
            LOGGER.error((Object)("error saving scatterplot image: " + this.data.getImagePath()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClick$scatterplotDataDownload(Event event) {
        this.getScatterplotData();
        try {
            String csv = null;
            InputStream in = new URL(CommonData.getSatServer() + "/ws/scatterplot/csv/" + this.data.getId()).openStream();
            try {
                csv = IOUtils.toString((InputStream)in);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
            Filedownload.save((String)csv, (String)"text/plain", (String)"scatterplot.csv");
        }
        catch (Exception e) {
            LOGGER.error((Object)("error downloading scatterplot csv for id: " + this.data.getId()), (Throwable)e);
        }
    }

    public void onCheck$chkSelectMissingRecords(Event event) {
        try {
            this.registerScatterPlotSelection();
            ScatterplotDataDTO d = this.getScatterplotData();
            d.setEnabled(true);
            Facet f = this.getFacetIn();
            if (f == null) {
                this.mapLayer.setHighlight(null);
            } else {
                this.mapLayer.setHighlight(f.toString());
            }
            this.getMapComposer().applyChange(this.mapLayer);
            this.tbxChartSelection.setText("");
            this.data.setImagePath(null);
            this.data.setMissingDataChecked(this.chkSelectMissingRecords.isChecked());
            this.redraw();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error toggling missing records checkbox", (Throwable)e);
            this.clearSelection();
            this.getMapComposer().applyChange(this.mapLayer);
        }
    }

    public void updateFromLegend() {
        this.updateFromLegend(this.layerWindow.getRed(), this.layerWindow.getGreen(), this.layerWindow.getBlue(), this.layerWindow.getOpacity(), this.layerWindow.getPlotSize(), this.layerWindow.getColourMode());
        if (this.mapLayer != null) {
            this.mapLayer.setColourMode(this.layerWindow.getColourMode());
            this.mapLayer.setRedVal(this.layerWindow.getRed());
            this.mapLayer.setGreenVal(this.layerWindow.getGreen());
            this.mapLayer.setBlueVal(this.layerWindow.getBlue());
            this.mapLayer.setOpacity((float)this.layerWindow.getOpacity() / 100.0f);
            this.mapLayer.setSizeVal(this.layerWindow.getSize());
            this.getMapComposer().applyChange(this.mapLayer);
        }
    }

    public void updateFromLegend(int red, int green, int blue, int opacity, int size, String colourMode) {
        this.data.setRed(red);
        this.data.setGreen(green);
        this.data.setBlue(blue);
        this.data.setOpacity(opacity);
        this.data.setSize(size);
        this.data.setColourMode(colourMode);
        try {
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(CommonData.getSatServer() + "/ws/scatterplot/style/" + this.data.getId());
            post.addParameter("colourMode", String.valueOf(this.data.getColourMode()));
            post.addParameter("red", String.valueOf(this.data.getRed()));
            post.addParameter("green", String.valueOf(this.data.getGreen()));
            post.addParameter("blue", String.valueOf(this.data.getBlue()));
            post.addParameter("opacity", String.valueOf(this.data.getOpacity()));
            post.addParameter("size", String.valueOf(this.data.getSize()));
            post.addRequestHeader("Accept", "application/json");
            client.executeMethod((HttpMethod)post);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error getting a new scatterplot id", (Throwable)e);
        }
        this.data.setImagePath(null);
        this.redraw();
    }

    private Facet getFacetIn() {
        String fq = null;
        String e1 = CommonData.getLayerFacetName((String)this.data.getLayer1());
        String e2 = CommonData.getLayerFacetName((String)this.data.getLayer2());
        if (this.chkSelectMissingRecords.isChecked() && this.data.getPrevSelection() == null) {
            fq = "-(" + e1 + ":[* TO *] AND " + e2 + ":[* TO *])";
        } else if (this.data.getPrevSelection() != null) {
            double x1 = this.data.getPrevSelection()[0];
            double x2 = this.data.getPrevSelection()[2];
            double y1 = this.data.getPrevSelection()[1];
            double y2 = this.data.getPrevSelection()[3];
            Facet f1 = new Facet(e1, y1, y2, true);
            Facet f2 = new Facet(e2, x1, x2, true);
            fq = this.chkSelectMissingRecords.isChecked() ? "-(-(" + f1.toString() + " AND " + f2.toString() + ") AND " + e1 + ":[* TO *] AND " + e2 + ":[* TO *])" : f1.toString() + " AND " + f2.toString();
        }
        return Facet.parseFacet(fq);
    }

    private Facet getFacetOut() {
        String fq = "*:*";
        String e1 = CommonData.getLayerFacetName((String)this.data.getLayer1());
        String e2 = CommonData.getLayerFacetName((String)this.data.getLayer2());
        if (this.chkSelectMissingRecords.isChecked() && this.data.getPrevSelection() == null) {
            fq = e1 + ":[* TO *] AND " + e2 + ":[* TO *]";
        } else if (this.data.getPrevSelection() != null) {
            double x1 = this.data.getPrevSelection()[0];
            double x2 = this.data.getPrevSelection()[1];
            double y1 = this.data.getPrevSelection()[2];
            double y2 = this.data.getPrevSelection()[3];
            Facet f1 = new Facet(e1, y1, y2, true);
            Facet f2 = new Facet(e2, x1, x2, true);
            fq = this.chkSelectMissingRecords.isChecked() ? "-(" + f1.toString() + " AND " + f2.toString() + ") AND " + e1 + ":[* TO *] AND " + e2 + ":[* TO *]" : "-(" + f1.toString() + " AND " + f2.toString() + ")";
        }
        return Facet.parseFacet((String)fq);
    }

    private void updateCbHighlightArea() {
        Comboitem ci;
        for (int i = this.cbHighlightArea.getItemCount() - 1; i >= 0; --i) {
            this.cbHighlightArea.removeItemAt(i);
        }
        boolean selectionSuccessful = false;
        for (MapLayer ml : this.getMapComposer().getPolygonLayers()) {
            ci = new Comboitem(ml.getDisplayName());
            ci.setValue((Object)ml);
            ci.setParent((Component)this.cbHighlightArea);
            if (this.data == null || this.data.getHighlightSa() == null || !this.data.getHighlightSa().getMapLayer().getName().equals(ml.getName())) continue;
            this.cbHighlightArea.setSelectedItem(ci);
            selectionSuccessful = true;
        }
        if (!selectionSuccessful && this.data != null && this.data.getHighlightSa() != null) {
            MapLayer ml = this.data.getHighlightSa().getMapLayer();
            if (ml != null) {
                Comboitem ci2 = new Comboitem(ml.getDisplayName() + " (DELETED LAYER)");
                ci2.setValue((Object)ml);
                ci2.setParent((Component)this.cbHighlightArea);
                this.cbHighlightArea.setSelectedItem(ci2);
            } else {
                String name = "Previous area";
                if (this.data.getHighlightSa().getWkt() != null) {
                    if (this.data.getHighlightSa().getWkt().equals(CommonData.getSettings().getProperty("default.wkt"))) {
                        name = CommonData.getSettings().getProperty("default.name");
                    } else if (this.data.getHighlightSa().getWkt().equals("POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))")) {
                        name = "World";
                    }
                }
                ci = new Comboitem(name);
                ci.setValue((Object)this.data.getHighlightSa().getWkt());
                ci.setParent((Component)this.cbHighlightArea);
                this.cbHighlightArea.setSelectedItem(ci);
            }
        }
    }

    public void onSelect$cbHighlightArea(Event event) {
        if (this.cbHighlightArea.getSelectedItem() != null) {
            SelectedArea sa;
            if (this.cbHighlightArea.getSelectedItem().getValue() instanceof MapLayer) {
                MapLayer ml;
                sa = new SelectedArea(ml, (ml = (MapLayer)this.cbHighlightArea.getSelectedItem().getValue()).getFacets() == null ? ml.getWKT() : null);
                this.data.setHighlightSa(sa);
            } else {
                String wkt = (String)this.cbHighlightArea.getSelectedItem().getValue();
                sa = new SelectedArea(null, wkt);
                this.data.setHighlightSa(sa);
            }
        } else {
            this.data.setHighlightSa(null);
        }
        try {
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(CommonData.getSatServer() + "/ws/scatterplot/style/" + this.data.getId());
            if (this.data.getHighlightSa() != null) {
                post.addParameter("highlightWkt", this.data.getHighlightSa().getWkt());
            } else {
                post.addParameter("highlightWkt", "");
            }
            post.addRequestHeader("Accept", "application/json");
            client.executeMethod((HttpMethod)post);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error getting a new scatterplot id", (Throwable)e);
        }
        this.data.setImagePath(null);
        this.redraw();
    }

    public void onClick$bClearHighlightArea(Event event) {
        this.cbHighlightArea.setSelectedIndex(-1);
        this.onSelect$cbHighlightArea(null);
    }

    public void setMapLayer(MapLayer mapLayer) {
        this.mapLayer = mapLayer;
    }

    public void onClick$btnEditAppearance1(Event event) {
        if (this.layerWindow != null) {
            boolean closing = this.layerWindow.getParent() != null;
            this.layerWindow.detach();
            this.layerWindow = null;
            if (closing) {
                return;
            }
        }
        this.getScatterplotData();
        if (this.data.getQuery() != null) {
            this.layerWindow = (ScatterplotLayerLegendComposer)Executions.createComponents((String)"WEB-INF/zul/legend/ScatterplotLayerLegend.zul", (Component)this.getRoot(), null);
            2 el = new /* Unavailable Anonymous Inner Class!! */;
            this.layerWindow.init(this.data.getQuery(), this.mapLayer, this.data.getRed(), this.data.getGreen(), this.data.getBlue(), this.data.getSize(), this.data.getOpacity(), this.data.getColourMode(), (EventListener)el);
            try {
                this.layerWindow.doOverlapped();
                this.layerWindow.setPosition("right");
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed ot open scatteplot layer legend", (Throwable)e);
            }
        }
    }
}

