/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.composer.legend;

import au.org.ala.legend.Facet;
import au.org.ala.legend.LegendObject;
import au.org.ala.legend.QueryField;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LegendMaker;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.UserDataQuery;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.GenericAutowireAutoforwardComposer;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.composer.legend.Popup;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.MapLayerMetadata;
import java.awt.Color;
import java.awt.image.RenderedImage;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Div;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Image;
import org.zkoss.zul.Intbox;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.SimpleListModel;
import org.zkoss.zul.Slider;
import org.zkoss.zul.Textbox;

public class LayerLegendGeneralComposer
extends GenericAutowireAutoforwardComposer {
    private static final Logger LOGGER = Logger.getLogger(LayerLegendGeneralComposer.class);
    private static final String SUB_LAYERNAME = "*layername*";
    private static final String SUB_COLOUR = "0xff0000";
    private static final String SUB_MIN_MINUS_ONE = "*min_minus_one*";
    private static final String SUB_MIN = "*min*";
    private static final String SUB_MAX_PLUS_ONE = "*max_plus_one*";
    private static final String POLYGON_SLD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"><NamedLayer><Name>ALA:*layername*</Name><UserStyle><FeatureTypeStyle><Rule><RasterSymbolizer><Geometry></Geometry><ColorMap><ColorMapEntry color=\"0xff0000\" opacity=\"0\" quantity=\"*min_minus_one*\"/><ColorMapEntry color=\"0xff0000\" opacity=\"1\" quantity=\"*min*\"/><ColorMapEntry color=\"0xff0000\" opacity=\"0\" quantity=\"*max_plus_one*\"/></ColorMap></RasterSymbolizer></Rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>";
    private Combobox cbColour;
    private Radiogroup pointtype;
    private Radio rPoint;
    private Radio rCluster;
    private Radio rGrid;
    private Textbox txtLayerName;
    private Slider opacitySlider;
    private Label opacityLabel;
    private Slider redSlider;
    private Slider greenSlider;
    private Slider blueSlider;
    private Slider sizeSlider;
    private Checkbox chkUncertaintySize;
    private Label lblFupload;
    private Label redLabel;
    private Label greenLabel;
    private Label blueLabel;
    private Label sizeLabel;
    private Listbox activeLayersList;
    private Div layerControls;
    private Div clusterpoints;
    private Div uncertainty;
    private Hbox uncertaintyLegend;
    private Div colourChooser;
    private Div sizeChooser;
    private Image legendImg;
    private Image legendImgUri;
    private Div legendHtml;
    private Label legendLabel;
    private Div divUserColours;
    private Hbox dAnimationStep;
    private Comboitem ciColourUser;
    private Label layerName;
    private Query query;
    private MapLayer mapLayer;
    private boolean inInit = false;
    private String sLayerName;
    private Button btnLayerName;
    private Label lInGroupCount;
    private Button btnCreateGroupLayers;
    private Div dGroupBox;
    private Combobox cbClassificationGroup;
    private Listbox lbClassificationGroup;
    private Hbox hboxClassificationGroup;
    private Div divClassificationPicker;
    private Div divAnimation;
    private Combobox cbAnimationDenomination;
    private Button btnAnimationStart;
    private Button btnAnimationStop;
    private Intbox intAnimationStep;
    private Intbox intAnimationYearStart;
    private Intbox intAnimationYearEnd;
    private Doublebox dblAnimationSeconds;
    private Div legendImgUriDiv;
    private Button clearSelection;
    private Button createInGroup;
    private Label lblSelectedCount;
    private Set selectedList = new HashSet();

    public void afterCompose() {
        super.afterCompose();
        MapLayer llc2MapLayer = null;
        Map m = Executions.getCurrent().getArg();
        if (m != null) {
            for (Map.Entry o : m.entrySet()) {
                if (!(o.getKey() instanceof String) || !"map_layer".equals(o.getKey())) continue;
                llc2MapLayer = (MapLayer)o.getValue();
            }
        }
        this.cbColour.setSelectedIndex(0);
        this.getMapComposer().setFacetsOpenListener((EventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getMapComposer().setLayerLegendNameRefresh((EventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.init(llc2MapLayer, llc2MapLayer.getSpeciesQuery(), llc2MapLayer.getRedVal(), llc2MapLayer.getGreenVal(), llc2MapLayer.getBlueVal(), llc2MapLayer.getSizeVal(), (int)(llc2MapLayer.getOpacity() * 100.0f), llc2MapLayer.getColourMode(), "grid".equals(llc2MapLayer.getColourMode()) ? 0 : (llc2MapLayer.isClustered() ? 1 : 2), llc2MapLayer.getSizeUncertain());
        this.getFellow("btnSearch").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getFellow("btnClear").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onScroll$opacitySlider(Event e) {
        float opacity = (float)this.opacitySlider.getCurpos() / 100.0f;
        int percentage = (int)(opacity * 100.0f);
        this.opacitySlider.setCurpos(percentage);
        this.opacityLabel.setValue(percentage + "%");
        this.refreshLayer();
    }

    public void updateLegendImage() {
        LegendMaker lm = new LegendMaker();
        int red = this.redSlider.getCurpos();
        int blue = this.blueSlider.getCurpos();
        int green = this.greenSlider.getCurpos();
        Color c = new Color(red, green, blue);
        this.legendImg.setContent((RenderedImage)lm.singleCircleImage(c, 60, 60, 50.0));
        if (this.cbColour.getSelectedItem() != this.ciColourUser) {
            this.legendHtml.setVisible(true);
            this.legendImg.setVisible(false);
            this.showPointsColourModeLegend();
        } else {
            this.legendImg.setVisible(true);
            this.legendHtml.setVisible(false);
        }
    }

    public void onScroll$sizeSlider() {
        int size = this.sizeSlider.getCurpos();
        this.sizeLabel.setValue(String.valueOf(size));
        this.refreshLayer();
    }

    public void onScroll$blueSlider() {
        int blue = this.blueSlider.getCurpos();
        this.blueLabel.setValue(String.valueOf(blue));
        this.updateLegendImage();
        this.refreshLayer();
    }

    public void onScroll$redSlider() {
        int red = this.redSlider.getCurpos();
        this.redLabel.setValue(String.valueOf(red));
        this.updateLegendImage();
        this.refreshLayer();
    }

    public void onScroll$greenSlider() {
        int green = this.greenSlider.getCurpos();
        this.greenLabel.setValue(String.valueOf(green));
        this.updateLegendImage();
        this.refreshLayer();
    }

    public void selectColour(Object obj) {
        String backgroundColor;
        Div div = (Div)obj;
        String style = div.getStyle();
        int a = style.indexOf(backgroundColor = "background-color");
        if (a >= 0) {
            String colour = style.substring(a + backgroundColor.length() + 2, a + backgroundColor.length() + 8);
            int r = Integer.parseInt(colour.substring(0, 2), 16);
            int g = Integer.parseInt(colour.substring(2, 4), 16);
            int b = Integer.parseInt(colour.substring(4, 6), 16);
            this.redSlider.setCurpos(r);
            this.greenSlider.setCurpos(g);
            this.blueSlider.setCurpos(b);
            this.redLabel.setValue(String.valueOf(r));
            this.greenLabel.setValue(String.valueOf(g));
            this.blueLabel.setValue(String.valueOf(b));
            this.updateLegendImage();
            this.refreshLayer();
        }
    }

    public void onChange$cbColour(Event event) {
        this.mapLayer.setHighlight(null);
        this.updateUserColourDiv();
        this.updateLegendImage();
        this.refreshLayer();
    }

    void updateUserColourDiv() {
        if (this.cbColour.getSelectedItem() == this.ciColourUser) {
            this.divUserColours.setVisible(true);
        } else {
            this.divUserColours.setVisible(false);
        }
    }

    void updateComboBoxesColour(MapLayer currentSelection) {
        if (currentSelection.isClustered()) {
            this.cbColour.setSelectedItem(this.ciColourUser);
            this.cbColour.setDisabled(true);
        } else {
            this.cbColour.setDisabled(false);
            for (int i = 0; i < this.cbColour.getItemCount(); ++i) {
                if (this.cbColour.getItemAtIndex(i).getValue() == null || !this.cbColour.getItemAtIndex(i).getValue().equals(currentSelection.getColourMode())) continue;
                this.cbColour.setSelectedIndex(i);
            }
            this.updateUserColourDiv();
        }
    }

    void showPointsColourModeLegend() {
        while (!this.legendHtml.getChildren().isEmpty()) {
            this.legendHtml.removeChild(this.legendHtml.getFirstChild());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("query", this.query);
        map.put("layer", this.mapLayer);
        map.put("readonly", "true");
        String colourmode = (String)this.cbColour.getSelectedItem().getValue();
        if (!"grid".equals(this.mapLayer.getColourMode()) && this.query.getLegend(colourmode) != null && this.query.getLegend(colourmode).getCategoryNameOrder() != null) {
            map.put("checkmarks", "true");
        }
        try {
            LegendObject lo = this.query.getLegend(colourmode);
            if (lo != null) {
                this.mapLayer.setLegendObject(lo);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("querying layer legend for: " + this.query.getFullQ(false)), (Throwable)e);
        }
        map.put("colourmode", colourmode);
        try {
            Executions.createComponents((String)"/WEB-INF/zul/legend/LayerLegendClassification.zul", (Component)this.legendHtml, map);
        }
        catch (Exception e) {
            LOGGER.error((Object)("attempting to open classification legend: " + this.legendHtml), (Throwable)e);
        }
    }

    public void init(MapLayer ml, Query query, int red, int green, int blue, int size, int opacity, String colourMode, int type, boolean uncertainty) {
        this.mapLayer = ml;
        this.inInit = true;
        this.txtLayerName.setValue(ml.getDisplayName());
        this.sLayerName = ml.getDisplayName();
        this.query = query;
        this.opacitySlider.setCurpos(opacity);
        this.onScroll$opacitySlider(null);
        this.redSlider.setCurpos(red);
        this.onScroll$redSlider();
        this.greenSlider.setCurpos(green);
        this.onScroll$greenSlider();
        this.blueSlider.setCurpos(blue);
        this.onScroll$blueSlider();
        this.sizeSlider.setCurpos(size);
        this.onScroll$sizeSlider();
        for (Comboitem item : this.cbColour.getItems()) {
            if (item.getValue() == null || !item.getValue().equals(colourMode)) continue;
            this.cbColour.setSelectedItem(item);
            break;
        }
        if (type == 0) {
            this.pointtype.setSelectedItem(this.rGrid);
        } else if (type == 1) {
            this.pointtype.setSelectedItem(this.rCluster);
        } else if (type == 2) {
            this.pointtype.setSelectedItem(this.rPoint);
        }
        this.chkUncertaintySize.setChecked(uncertainty);
        this.updateUserColourDiv();
        this.updateLegendImage();
        this.setupLayerControls(ml);
        this.updateAnimationDiv();
        String script = "mapFrame.stopAllAnimations();";
        this.getMapComposer().getOpenLayersJavascript().execute(script);
        this.inInit = false;
    }

    public int getRed() {
        return this.redSlider.getCurpos();
    }

    public int getGreen() {
        return this.greenSlider.getCurpos();
    }

    public int getBlue() {
        return this.blueSlider.getCurpos();
    }

    public int getSize() {
        return this.sizeSlider.getCurpos();
    }

    public int getOpacity() {
        return this.opacitySlider.getCurpos();
    }

    public String getColourMode() {
        if (this.pointtype.getSelectedItem() == this.rGrid) {
            return "grid";
        }
        return (String)this.cbColour.getSelectedItem().getValue();
    }

    public void onClick$btnApply(Event event) {
        MapComposer mc = this.getMapComposer();
        MapLayer ml = this.mapLayer;
        if (this.getRed() != ml.getRedVal() || this.getGreen() != ml.getGreenVal() || this.getBlue() != ml.getBlueVal() || this.getSize() != ml.getSizeVal() || this.getOpacity() != (int)(ml.getOpacity() * 100.0f) || ml.getColourMode() != null && !ml.getColourMode().equals(this.getColourMode()) || ml.isClustered() && this.getPointType() != 1 || ml.getSizeUncertain() != this.getUncertainty()) {
            ml.setRedVal(this.getRed());
            ml.setGreenVal(this.getGreen());
            ml.setBlueVal(this.getBlue());
            ml.setSizeVal(this.getSize());
            ml.setOpacity((float)this.getOpacity() / 100.0f);
            ml.setColourMode(this.getColourMode());
            ml.setClustered(this.getPointType() == 0);
            ml.setSizeUncertain(this.getUncertainty());
            mc.applyChange(ml);
        }
        if (!ml.getDisplayName().equals(this.getDisplayName())) {
            ml.setDisplayName(this.getDisplayName());
            mc.setLabelSelectedLayer(this.getDisplayName());
            mc.redrawLayersList();
        }
    }

    public void onClick$btnClose(Event event) {
        this.detach();
    }

    private void showPointsColourModeLegend(MapLayer m) {
        while (!this.legendHtml.getChildren().isEmpty()) {
            this.legendHtml.removeChild(this.legendHtml.getFirstChild());
        }
        String colourMode = (String)this.cbColour.getSelectedItem().getValue();
        if (this.pointtype.getSelectedItem() == this.rGrid) {
            colourMode = "grid";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("query", m.getSpeciesQuery());
        map.put("layer", m);
        map.put("readonly", "true");
        map.put("colourmode", colourMode);
        String colourmode = (String)this.cbColour.getSelectedItem().getValue();
        if (!"grid".equals(m.getColourMode()) && this.query.getLegend(colourmode).getCategoryNameOrder() != null) {
            map.put("checkmarks", "true");
        }
        try {
            LegendObject lo = m.getSpeciesQuery().getLegend(colourmode);
            if (lo != null) {
                m.setLegendObject(lo);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting legend for map layer: " + m.getName()), (Throwable)e);
        }
        try {
            Executions.createComponents((String)"/WEB-INF/zul/legend/LayerLegendClassification.zul", (Component)this.legendHtml, map);
        }
        catch (Exception e) {
            LOGGER.error((Object)("error opening classification legend: " + this.legendHtml), (Throwable)e);
        }
    }

    public int getPointType() {
        if (this.pointtype.getSelectedItem() == this.rGrid) {
            return 0;
        }
        if (this.pointtype.getSelectedItem() == this.rCluster) {
            return 1;
        }
        return 2;
    }

    public boolean getUncertainty() {
        return this.chkUncertaintySize.isChecked();
    }

    public void onCheck$chkUncertaintySize() {
        this.refreshLayer();
        this.uncertaintyLegend.setVisible(this.chkUncertaintySize.isChecked());
    }

    public void onCheck$pointtype(Event event) {
        Radio selectedItem = (Radio)((ForwardEvent)event).getOrigin().getTarget();
        this.pointtype.setSelectedItem(selectedItem);
        this.mapLayer.setHighlight(null);
        this.refreshLayer();
        this.setupLayerControls(this.mapLayer);
    }

    void refreshLayer() {
        if (!this.inInit) {
            this.sLayerName = this.txtLayerName.getValue();
            this.onClick$btnApply(null);
        }
    }

    public void setupLayerControls(MapLayer m) {
        MapLayer currentSelection = m;
        if (currentSelection != null) {
            if (currentSelection.isDynamicStyle()) {
                if ("grid".equals(m.getColourMode())) {
                    this.pointtype.setSelectedItem(this.rGrid);
                    this.uncertainty.setVisible(false);
                } else {
                    this.pointtype.setSelectedItem(this.rPoint);
                    this.uncertainty.setVisible(currentSelection.getSpeciesQuery() != null && currentSelection.getSpeciesQuery() instanceof BiocacheQuery);
                }
                this.setupCBColour(currentSelection);
                this.updateComboBoxesColour(currentSelection);
                this.updateAdhocGroupContols(currentSelection);
                if ("-1".equals(currentSelection.getColourMode())) {
                    this.divUserColours.setVisible(true);
                } else {
                    this.divUserColours.setVisible(false);
                }
                if (currentSelection.getGeometryType() != 25) {
                    this.sizeChooser.setVisible(false);
                    this.uncertainty.setVisible(false);
                } else {
                    this.sizeChooser.setVisible(this.pointtype.getSelectedItem() != this.rGrid);
                    if (m.getGeoJSON() != null && m.getGeoJSON().length() > 0) {
                        this.uncertainty.setVisible(false);
                    } else {
                        this.uncertainty.setVisible(!(this.query instanceof UserDataQuery));
                    }
                }
                this.colourChooser.setVisible(this.pointtype.getSelectedItem() != this.rGrid);
                this.uncertainty.setVisible(this.pointtype.getSelectedItem() != this.rGrid);
                if ((this.cbColour.getSelectedItem() != this.ciColourUser || this.pointtype.getSelectedItem() == this.rGrid) && m.isSpeciesLayer()) {
                    this.legendHtml.setVisible(true);
                    this.legendImg.setVisible(false);
                    this.showPointsColourModeLegend(m);
                } else {
                    this.legendImg.setVisible(true);
                    this.legendHtml.setVisible(false);
                }
            } else if (currentSelection.getSelectedStyle() != null) {
                String legendUri = currentSelection.getSelectedStyle().getLegendUri();
                if (legendUri != null && legendUri.contains(".zul")) {
                    while (!this.legendHtml.getChildren().isEmpty()) {
                        this.legendHtml.removeChild(this.legendHtml.getFirstChild());
                    }
                    HashMap<String, String> map = null;
                    if (legendUri.indexOf(63) > 0) {
                        String[] parameters = legendUri.substring(legendUri.indexOf(63) + 1, legendUri.length()).split("&");
                        if (parameters.length > 0) {
                            map = new HashMap<String, String>();
                            for (String p : parameters) {
                                String[] parameter = p.split("=");
                                if (parameter.length != 2) continue;
                                map.put(parameter[0], parameter[1]);
                            }
                        }
                        legendUri = legendUri.substring(0, legendUri.indexOf(63));
                    }
                    Executions.createComponents((String)legendUri, (Component)this.legendHtml, map);
                    this.legendHtml.setVisible(true);
                    this.legendImgUriDiv.setVisible(false);
                    this.legendLabel.setVisible(true);
                } else {
                    this.legendImgUri.setSrc(legendUri);
                    this.legendImgUriDiv.setVisible(true);
                    this.legendHtml.setVisible(false);
                    this.legendLabel.setVisible(false);
                }
                this.legendImg.setVisible(false);
                this.colourChooser.setVisible(false);
                this.sizeChooser.setVisible(false);
                this.cbColour.setVisible(false);
                this.uncertainty.setVisible(false);
            } else if (currentSelection.getCurrentLegendUri() != null) {
                this.legendImgUri.setSrc(currentSelection.getCurrentLegendUri());
                this.legendImgUriDiv.setVisible(true);
                this.legendHtml.setVisible(false);
                this.legendLabel.setVisible(false);
                this.legendImg.setVisible(false);
                this.colourChooser.setVisible(this.mapLayer.isPolygonLayer());
                if (this.mapLayer.isPolygonLayer()) {
                    this.cbColour.setVisible(false);
                    this.legendImgUriDiv.setVisible(false);
                }
                this.sizeChooser.setVisible(false);
                this.uncertainty.setVisible(false);
            } else {
                this.legendImgUriDiv.setVisible(false);
                this.legendHtml.setVisible(false);
                this.legendLabel.setVisible(false);
                this.legendImg.setVisible(false);
                this.colourChooser.setVisible(false);
                this.sizeChooser.setVisible(false);
                this.cbColour.setVisible(false);
                this.uncertainty.setVisible(false);
            }
            this.layerControls.setVisible(true);
            this.layerControls.setAttribute("activeLayerName", (Object)currentSelection.getName());
            this.setupForClassificationLayers();
        }
        if (m != null && m.isSpeciesLayer()) {
            this.clusterpoints.setVisible(true);
            this.cbColour.setDisabled(m.isClustered());
        } else {
            this.clusterpoints.setVisible(false);
            this.cbColour.setDisabled(true);
        }
        this.uncertaintyLegend.setVisible(this.chkUncertaintySize.isChecked());
    }

    public String getDisplayName() {
        return this.txtLayerName.getValue();
    }

    public void onOK$txtLayerName(Event event) {
        this.refreshLayer();
        this.btnLayerName.setDisabled(true);
    }

    public void onBlur$txtLayerName(Event event) {
        if (this.sLayerName.equals(this.txtLayerName.getValue())) {
            this.btnLayerName.setDisabled(true);
        }
    }

    private void setupCBColour(MapLayer m) {
        for (int i = this.cbColour.getItemCount() - 1; i >= 0; --i) {
            if (this.cbColour.getItemAtIndex(i) == this.ciColourUser) continue;
            this.cbColour.removeItemAt(i);
        }
        Query q = m.getSpeciesQuery();
        if (q != null) {
            List fields = q.getFacetFieldList();
            for (int i = fields.size() - 1; i >= 0; --i) {
                if (fields.get(i) != null) continue;
                fields.remove(i);
            }
            Collections.sort(fields, new QueryField.QueryFieldComparator());
            String lastGroup = null;
            for (QueryField field : fields) {
                String newGroup = field.getGroup().getName();
                if (!newGroup.equals(lastGroup)) {
                    Comboitem sep = new Comboitem("seperator");
                    sep.setLabel("---------------" + StringUtils.center((String)newGroup, (int)19) + "---------------");
                    sep.setParent((Component)this.cbColour);
                    sep.setDisabled(true);
                    lastGroup = newGroup;
                }
                Comboitem ci = new Comboitem(field.getDisplayName());
                ci.setValue((Object)field.getName());
                ci.setParent((Component)this.cbColour);
            }
        }
    }

    public void onClick$btnCreateGroupLayers(Event event) {
        Query q;
        if (this.mapLayer != null && (q = this.mapLayer.getSpeciesQuery()) != null && q.flagRecordCount() != 0) {
            Query inGroup = q.newFlaggedRecords(true);
            Query outGroup = q.newFlaggedRecords(false);
            this.getMapComposer().mapSpecies(inGroup, this.mapLayer.getDisplayName() + " in group", "species", -1, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
            this.getMapComposer().mapSpecies(outGroup, this.mapLayer.getDisplayName() + " out group", "species", -1, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
        }
    }

    private void updateAdhocGroupContols(MapLayer m) {
        if (m == null) {
            this.dGroupBox.setVisible(false);
            return;
        }
        Query q = m.getSpeciesQuery();
        if (q == null || q.flagRecordCount() == 0) {
            this.dGroupBox.setVisible(false);
        } else {
            this.dGroupBox.setVisible(true);
            this.lInGroupCount.setValue(q.flagRecordCount() + (q.flagRecordCount() == 1 ? " record" : " records"));
        }
    }

    private void setupForClassificationLayers() {
        if (this.mapLayer.isPolygonLayer()) {
            return;
        }
        String activeLayerName = "none";
        JSONObject layer = null;
        if (this.mapLayer != null && this.mapLayer.getUri() != null) {
            activeLayerName = this.mapLayer.getBaseUri() != null ? this.mapLayer.getBaseUri().replaceAll("^.*ALA:", "").replaceAll("&.*", "") : this.mapLayer.getUri().replaceAll("^.*ALA:", "").replaceAll("&.*", "");
            layer = CommonData.getLayer((String)activeLayerName);
        }
        LOGGER.debug((Object)("ACTIVE LAYER: " + activeLayerName));
        if (this.mapLayer != null && this.mapLayer.getSubType() == 14) {
            this.divClassificationPicker.setVisible(true);
            Integer groupCount = this.mapLayer.getClassificationGroupCount();
            if (groupCount == null) {
                this.mapLayer.setClassificationGroupCount(this.getClassificationGroupCount(this.mapLayer.getName().replace("aloc_", "")));
                groupCount = 0;
            }
            for (int i = this.cbClassificationGroup.getItemCount() - 1; i >= 0; --i) {
                this.cbClassificationGroup.removeItemAt(i);
            }
            Comboitem ci = new Comboitem("none");
            ci.setParent((Component)this.cbClassificationGroup);
            for (int i = 1; i <= groupCount; ++i) {
                new Comboitem("Group " + i).setParent((Component)this.cbClassificationGroup);
            }
            Integer groupSelection = this.mapLayer.getClassificationSelection();
            if (groupSelection == null) {
                groupSelection = 0;
                this.mapLayer.setClassificationSelection(groupSelection);
            }
            this.cbClassificationGroup.setSelectedIndex(groupSelection.intValue());
            this.getFellow("btnCreateArea").setVisible(false);
            this.cbClassificationGroup.setVisible(true);
            this.lbClassificationGroup.setVisible(false);
            this.hboxClassificationGroup.setVisible(false);
        } else if (layer != null && layer.containsKey((Object)"type") && layer.get((Object)"type").toString().equalsIgnoreCase("contextual") && layer.containsKey((Object)"fields")) {
            this.divClassificationPicker.setVisible(true);
            if (this.mapLayer.getClassificationGroupCount() == null || this.mapLayer.getClassificationGroupCount() == 0) {
                String fieldId = null;
                JSONArray ja = (JSONArray)layer.get((Object)"fields");
                for (int i = 0; i < ja.size(); ++i) {
                    if (!((JSONObject)ja.get(i)).get((Object)"defaultlayer").toString().equalsIgnoreCase("true")) continue;
                    fieldId = ((JSONObject)ja.get(i)).get((Object)"id").toString();
                }
                JSONParser jp = new JSONParser();
                JSONObject objJson = null;
                try {
                    objJson = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/field/" + fieldId)));
                }
                catch (ParseException e) {
                    LOGGER.error((Object)("failed to parse for: " + fieldId));
                }
                JSONArray objects = (JSONArray)objJson.get((Object)"objects");
                List list = objects.subList(0, objects.size());
                Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
                JSONArray obj = new JSONArray();
                obj.addAll((Collection)list);
                this.mapLayer.setClassificationGroupCount(Integer.valueOf(obj.size()));
                this.mapLayer.setClassificationObjects(obj);
            }
            Integer groupCount = this.mapLayer.getClassificationGroupCount();
            JSONArray groupObjects = this.mapLayer.getClassificationObjects();
            this.lbClassificationGroup.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
            this.lbClassificationGroup.addEventListener("onSelect", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
            ArrayList<JSONObject> model = new ArrayList<JSONObject>();
            for (int i = 0; i < groupCount; ++i) {
                model.add((JSONObject)groupObjects.get(i));
            }
            this.lbClassificationGroup.setModel((ListModel)new SimpleListModel(model));
            Integer groupSelection = this.mapLayer.getClassificationSelection();
            if (groupSelection == null) {
                groupSelection = 0;
                this.mapLayer.setClassificationSelection(groupSelection);
            }
            this.getFellow("btnCreateArea").setVisible(true);
            this.getFellow("btnCreateArea").setVisible(false);
            this.cbClassificationGroup.setVisible(false);
            this.lbClassificationGroup.setVisible(true);
            this.hboxClassificationGroup.setVisible(true);
        } else {
            this.getFellow("btnCreateArea").setVisible(false);
            this.divClassificationPicker.setVisible(false);
        }
    }

    private void determineCheckboxState(Checkbox cb, String name) {
        cb.setChecked(this.selectedList.contains(name));
    }

    private void createAreaEcho(String pid) {
        Events.echoEvent((String)"createArea", (Component)this, (String)pid);
    }

    private void highlightSelect(int idx) {
        block12: {
            if (idx == -1) {
                idx = 0;
            } else {
                JSONObject jo = (JSONObject)this.lbClassificationGroup.getModel().getElementAt(idx);
                for (int i = 0; i < this.mapLayer.getClassificationObjects().size(); ++i) {
                    if (!((JSONObject)this.mapLayer.getClassificationObjects().get(i)).get((Object)"id").equals(jo.get((Object)"id").toString())) continue;
                    idx = i + 1;
                    break;
                }
            }
            this.mapLayer.setClassificationSelection(Integer.valueOf(idx));
            String baseUri = this.mapLayer.getBaseUri();
            if (baseUri == null) {
                this.mapLayer.setBaseUri(this.mapLayer.getUri());
                int pos = this.mapLayer.getUri().indexOf("&sld_body=");
                if (pos > 0) {
                    int pos2 = this.mapLayer.getUri().indexOf("&", pos + 1);
                    baseUri = pos2 > 0 ? this.mapLayer.getUri().substring(0, pos) + this.mapLayer.getUri().substring(pos2) : this.mapLayer.getUri().substring(0, pos);
                }
            }
            String layername = this.mapLayer.getName();
            int n = idx;
            if (n > 0) {
                try {
                    if (this.mapLayer.getClassificationObjects() == null) {
                        String sldBodyParam = "&sld_body=" + this.formatSld(URLEncoder.encode(POLYGON_SLD, "UTF-8"), layername, String.valueOf(n - 1), String.valueOf(n), String.valueOf(n + 1));
                        this.mapLayer.setUri(baseUri + sldBodyParam);
                        break block12;
                    }
                    if (this.mapLayer.getChildCount() > 0) {
                        MapLayer child = this.mapLayer.getChild(0);
                        this.getMapComposer().deactiveLayer(child, false, true);
                        this.mapLayer.getChildren().remove(0);
                    }
                    MapLayer mlHighlight = (MapLayer)this.mapLayer.clone();
                    mlHighlight.setName(this.mapLayer.getName() + "_selection");
                    JSONParser jp = new JSONParser();
                    JSONObject obj = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/object/" + ((JSONObject)this.mapLayer.getClassificationObjects().get(n - 1)).get((Object)"pid"))));
                    String url = obj.get((Object)"wmsurl").toString();
                    mlHighlight.setUri(url);
                    this.mapLayer.addChild(mlHighlight);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error encoding this to UTF-8: <?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"><NamedLayer><Name>ALA:*layername*</Name><UserStyle><FeatureTypeStyle><Rule><RasterSymbolizer><Geometry></Geometry><ColorMap><ColorMapEntry color=\"0xff0000\" opacity=\"0\" quantity=\"*min_minus_one*\"/><ColorMapEntry color=\"0xff0000\" opacity=\"1\" quantity=\"*min*\"/><ColorMapEntry color=\"0xff0000\" opacity=\"0\" quantity=\"*max_plus_one*\"/></ColorMap></RasterSymbolizer></Rule></FeatureTypeStyle></UserStyle></NamedLayer></StyledLayerDescriptor>", (Throwable)e);
                }
            } else if (this.mapLayer.getChildCount() > 0) {
                MapLayer child = this.mapLayer.getChild(0);
                child.setUri(this.mapLayer.getUri());
                this.getMapComposer().deactiveLayer(child, false, true);
                this.getMapComposer().reloadMapLayerNowAndIndexes(this.mapLayer);
                this.mapLayer.getChildren().remove(0);
            }
        }
        this.getMapComposer().reloadMapLayerNowAndIndexes(this.mapLayer);
    }

    public void onSelect$cbClassificationGroup(Event event) {
        if (this.mapLayer != null) {
            this.highlightSelect(this.cbClassificationGroup.getSelectedIndex());
        }
    }

    private String formatSld(String sld, String layername, String minMinusOne, String min, String maxPlusOne) {
        return sld.replace(SUB_LAYERNAME, layername).replace(SUB_MIN_MINUS_ONE, minMinusOne).replace(SUB_MIN, min).replace(SUB_MAX_PLUS_ONE, maxPlusOne);
    }

    public Integer getClassificationGroupCount(String pid) {
        Integer i = 0;
        String url = CommonData.getSatServer() + "/output/aloc/" + pid + "/classification_means.csv";
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(url);
            get.addRequestHeader("Accept", "text/plain");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            String[] s = slist.split("\n");
            i = s.length - 1;
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting classification group counts:" + url), (Throwable)e);
        }
        return i;
    }

    public void onClick$clearSelection(Event event) {
        for (Listitem li : this.lbClassificationGroup.getItems()) {
            if (li.getFirstChild().getChildren().isEmpty() || !((Checkbox)li.getFirstChild().getFirstChild()).isChecked()) continue;
            ((Checkbox)li.getFirstChild().getFirstChild()).setChecked(false);
        }
        this.selectedList = new HashSet();
        this.lblSelectedCount.setValue(this.selectedList.size() + " checked");
    }

    public void onClick$createInGroup(Event e) {
        StringBuilder sb = new StringBuilder();
        String layer = ((JSONObject)this.mapLayer.getClassificationObjects().get(0)).get((Object)"fid").toString();
        for (Object n : this.selectedList) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(layer).append(":\"").append(n).append("\"");
        }
        String pids = "";
        String anyPid = "";
        Integer groupCount = this.mapLayer.getClassificationGroupCount();
        JSONArray groupObjects = this.mapLayer.getClassificationObjects();
        block5: for (Object name : this.selectedList) {
            for (int i = 0; i < groupCount; ++i) {
                if (!name.equals(((JSONObject)groupObjects.get(i)).get((Object)"name"))) continue;
                if (!pids.isEmpty()) {
                    pids = pids + "~";
                }
                anyPid = ((JSONObject)groupObjects.get(i)).get((Object)"pid").toString();
                pids = pids + anyPid;
                continue block5;
            }
        }
        JSONParser jp = new JSONParser();
        JSONObject obj = null;
        Double[] bbox = new Double[4];
        boolean firstPid = true;
        HashMap<Integer, String> urlParts = new HashMap<Integer, String>();
        try {
            obj = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/object/" + anyPid)));
            for (String p : pids.split("~")) {
                JSONObject jo = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/object/" + p)));
                String bbString = jo.get((Object)"bbox").toString();
                bbString = bbString.replace("POLYGON((", "").replace("))", "").replace(",", " ");
                String[] split = bbString.split(" ");
                String u = jo.get((Object)"wmsurl").toString();
                if (!u.contains("viewparams")) {
                    String s = u.split("ColorMap%3E")[1];
                    int pos = 0;
                    for (String c : s.split("%3CColorMapEntry")) {
                        int start = c.indexOf("quantity") + 14;
                        if (start <= 14) continue;
                        Integer qty = Integer.parseInt(c.substring(start, c.indexOf("%", start)));
                        if (pos != 1 && pos != 2 && urlParts.containsKey(qty)) continue;
                        urlParts.put(qty, c.replace("%3C%2F", ""));
                    }
                }
                if (firstPid || Double.parseDouble(split[0]) < bbox[0]) {
                    bbox[0] = Double.parseDouble(split[0]);
                }
                if (firstPid || Double.parseDouble(split[1]) < bbox[1]) {
                    bbox[1] = Double.parseDouble(split[1]);
                }
                if (firstPid || Double.parseDouble(split[4]) > bbox[2]) {
                    bbox[2] = Double.parseDouble(split[4]);
                }
                if (firstPid || Double.parseDouble(split[5]) > bbox[3]) {
                    bbox[3] = Double.parseDouble(split[5]);
                }
                firstPid = false;
            }
        }
        catch (ParseException er) {
            LOGGER.error((Object)("failed to parse for object: " + anyPid));
        }
        String bboxString = "POLYGON((" + bbox[0] + " " + bbox[1] + "," + bbox[0] + " " + bbox[3] + "," + bbox[2] + " " + bbox[3] + "," + bbox[2] + " " + bbox[1] + "," + bbox[0] + " " + bbox[1] + "))";
        String url = obj.get((Object)"wmsurl").toString();
        if (!url.contains("s:" + anyPid)) {
            String[] split = url.split("ColorMap%3E");
            String colours = "";
            ArrayList sorted = new ArrayList(urlParts.keySet());
            Collections.sort(sorted);
            for (int i = 0; i < sorted.size(); ++i) {
                colours = colours + "%3CColorMapEntry" + (String)urlParts.get(sorted.get(i));
            }
            colours = colours + "%3C%2F";
            url = split[0] + "ColorMap%3E" + colours + "ColorMap%3E" + split[2];
        } else {
            url = url.replace("s:" + anyPid, "s:" + pids);
        }
        String name = this.selectedList.size() + " areas: " + this.mapLayer.getDisplayName();
        MapLayer ml = this.getMapComposer().addWMSLayer(this.getMapComposer().getNextAreaLayerName(name), name, url, 0.6f, null, null, 11, null, null);
        String lname = ml.getName();
        int colour = Util.nextColour();
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        ml.setRedVal(r);
        ml.setGreenVal(g);
        ml.setBlueVal(b);
        ml.setDynamicStyle(true);
        ml.setPolygonLayer(true);
        Facet facet = Facet.parseFacet((String)sb.toString());
        JSONObject layerObj = CommonData.getLayer((String)((String)obj.get((Object)"fid")));
        ArrayList<Facet> facets = new ArrayList<Facet>();
        facets.add(facet);
        ml.setFacets(facets);
        ml.setWKT(bboxString);
        MapLayerMetadata md = ml.getMapLayerMetadata();
        md.setBbox(Arrays.asList(bbox));
        try {
            md.setMoreInfo(CommonData.getLayersServer() + "/layers/view/more/" + layerObj.get((Object)"id").toString());
        }
        catch (Exception er) {
            LOGGER.error((Object)("error setting map layer moreInfo: " + (layerObj != null ? layerObj.toString() : "layerObj is null")), (Throwable)er);
        }
        this.getMapComposer().applyChange(ml);
        this.getMapComposer().updateLayerControls();
        this.getMapComposer().reloadMapLayerNowAndIndexes(ml);
    }

    public void onClick$btnClearAreaSelection(Event event) {
        this.lbClassificationGroup.clearSelection();
        this.highlightSelect(-1);
    }

    public void createArea(Event event) {
        String pid = event.getData().toString();
        this.getMapComposer().addObjectByPid(pid, null, 1.0);
    }

    public void onClick$btnCreateArea(Event event) {
        int n = this.cbClassificationGroup.getSelectedIndex();
        if (n > 0) {
            String pid = ((JSONObject)this.mapLayer.getClassificationObjects().get(n - 1)).get((Object)"pid").toString();
            this.createAreaEcho(pid);
        }
    }

    public void onClick$btnAnimationStart(Event event) {
        Double interval;
        Integer monthOrYear = 0;
        if ("1".equals(this.cbAnimationDenomination.getValue()) || "Year".equalsIgnoreCase(this.cbAnimationDenomination.getValue())) {
            monthOrYear = 1;
        }
        LOGGER.debug((Object)("Animation: " + monthOrYear));
        Integer step = 1;
        if (monthOrYear != 0 && (step = this.intAnimationStep.getValue()) < 1) {
            step = 1;
            this.intAnimationStep.setValue(Integer.valueOf(1));
        }
        if ((interval = this.dblAnimationSeconds.getValue()) < 0.2) {
            interval = 0.2;
            this.dblAnimationSeconds.setValue(0.2);
        }
        this.mapLayer.setAnimationStep(step);
        this.mapLayer.setAnimationInterval(interval);
        Integer start = this.intAnimationYearStart.getValue();
        Integer end = this.intAnimationYearEnd.getValue();
        String script = "mapFrame.animateStart('" + this.mapLayer.getNameJS() + "'," + monthOrYear + "," + interval * 1000.0 + "," + start + "," + end + "," + step + ");";
        LOGGER.debug((Object)("Script: " + script));
        this.getMapComposer().getOpenLayersJavascript().execute(script);
        this.btnAnimationStop.setDisabled(false);
    }

    public void selectYearOrMonth() {
        if ("1".equals(this.cbAnimationDenomination.getValue()) || "Year".equals(this.cbAnimationDenomination.getValue())) {
            this.dAnimationStep.setVisible(true);
        } else {
            this.dAnimationStep.setVisible(false);
        }
    }

    private void updateAnimationDiv() {
        if (this.dblAnimationSeconds == null) {
            return;
        }
        Query q = this.mapLayer.getSpeciesQuery();
        if (q instanceof BiocacheQuery) {
            Double interval;
            Integer step;
            Integer firstYear = this.mapLayer.getFirstYear();
            Integer lastYear = this.mapLayer.getLastYear();
            if (firstYear == null) {
                try {
                    LegendObject lo = q.getLegend("occurrence_year");
                    if (lo != null && lo.getMinMax().length > 0) {
                        firstYear = (int)lo.getMinMax()[0];
                        lastYear = (int)lo.getMinMax()[1];
                        this.mapLayer.setFirstYear(firstYear);
                        this.mapLayer.setLastYear(lastYear);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((step = this.mapLayer.getAnimationStep()) != null) {
                this.intAnimationStep.setValue(step);
            }
            if ((interval = this.mapLayer.getAnimationInterval()) != null) {
                this.dblAnimationSeconds.setValue(interval);
            }
            if (firstYear != null && firstYear < lastYear) {
                this.intAnimationYearStart.setValue(firstYear);
                this.intAnimationYearEnd.setValue(lastYear);
                this.divAnimation.setVisible(true);
            }
        }
    }

    public void onClick$btnAnimationStop(Event event) {
        String script = "mapFrame.animateStop('" + this.mapLayer.getNameJS() + "');";
        this.getMapComposer().getOpenLayersJavascript().execute(script);
        this.btnAnimationStop.setDisabled(true);
    }

    public void onClick$btnPopupLegend(Event event) {
        List list = this.getRoot().getChildren();
        for (Component c : this.getRoot().getChildren()) {
            Image img;
            if (!(c instanceof Popup) || (img = (Image)((Popup)c).getFellowIfAny("img", true)) == null || !img.getSrc().equalsIgnoreCase(this.mapLayer.getCurrentLegendUri())) continue;
            return;
        }
        Popup layerWindow = (Popup)Executions.createComponents((String)"WEB-INF/zul/legend/Popup.zul", (Component)this.getRoot(), null);
        try {
            layerWindow.doOverlapped();
            layerWindow.setPosition("right,center");
            layerWindow.init(this.mapLayer.getDisplayName(), this.mapLayer.getCurrentLegendUri());
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to open popup layer legend", (Throwable)e);
        }
    }

    static /* synthetic */ Combobox access$000(LayerLegendGeneralComposer x0) {
        return x0.cbColour;
    }

    static /* synthetic */ Textbox access$100(LayerLegendGeneralComposer x0) {
        return x0.txtLayerName;
    }

    static /* synthetic */ MapLayer access$200(LayerLegendGeneralComposer x0) {
        return x0.mapLayer;
    }

    static /* synthetic */ Listbox access$300(LayerLegendGeneralComposer x0) {
        return x0.lbClassificationGroup;
    }

    static /* synthetic */ Set access$400(LayerLegendGeneralComposer x0) {
        return x0.selectedList;
    }

    static /* synthetic */ Label access$500(LayerLegendGeneralComposer x0) {
        return x0.lblSelectedCount;
    }

    static /* synthetic */ void access$600(LayerLegendGeneralComposer x0, int x1) {
        x0.highlightSelect(x1);
    }

    static /* synthetic */ void access$700(LayerLegendGeneralComposer x0, Checkbox x1, String x2) {
        x0.determineCheckboxState(x1, x2);
    }

    static /* synthetic */ void access$800(LayerLegendGeneralComposer x0, String x1) {
        x0.createAreaEcho(x1);
    }
}

