/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.composer.legend;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.legend.Facet;
import au.org.ala.legend.Legend;
import au.org.ala.legend.LegendObject;
import au.org.ala.legend.QueryField;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.composer.legend.ClassificationLegend;
import au.org.emii.portal.menu.MapLayer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Button;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.SimpleListModel;

public class ClassificationLegend
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(ClassificationLegend.class);
    private Listbox legend;
    private int sliderMax = 500;
    private Query query;
    private String pid;
    private String colourmode;
    private MapLayer mapLayer;
    private String imagePath = "";
    private Button createInGroup;
    private Button clearSelection;
    private List<String[]> legendLines;
    private boolean readonly = false;
    private boolean checkmarks = false;
    private Doublebox dmin;
    private Doublebox dmax;
    private double minValue;
    private double maxValue;
    private double gMinValue;
    private double gMaxValue;
    private Label dlabel;
    private Div divContinous;
    private Checkbox dunknown;
    private Button dbutton;
    private boolean intContinous = false;
    private boolean isMonth = false;
    private boolean isNumber = false;
    private boolean disableselection = false;
    private Map<String, String> legendFacets = null;
    private Facet facet;
    private Div dCreateButtons;
    private Listheader lhFirstColumn;
    private Listheader lhSecondColumn;
    private Listheader lhThirdColumn;
    private Listheader lhFourthColumn;
    private Label lblSelectedCount;
    private Set selectedList = new HashSet();

    public void afterCompose() {
        super.afterCompose();
        this.query = (Query)Executions.getCurrent().getArg().get("query");
        LOGGER.debug((Object)("Query q:" + this.query.getQ()));
        this.mapLayer = (MapLayer)Executions.getCurrent().getArg().get("layer");
        this.readonly = Executions.getCurrent().getArg().get("readonly") != null;
        this.colourmode = (String)Executions.getCurrent().getArg().get("colourmode");
        this.pid = (String)Executions.getCurrent().getArg().get("pid");
        this.checkmarks = Executions.getCurrent().getArg().get("checkmarks") != null;
        boolean bl = this.disableselection = Executions.getCurrent().getArg().get("disableselection") != null;
        if (this.disableselection) {
            this.dCreateButtons.setVisible(false);
            this.lhFirstColumn.setWidth("0px");
            this.lhSecondColumn.setWidth("190px");
            this.lhThirdColumn.setWidth("15px");
            this.lhThirdColumn.setLabel("");
            this.lhFourthColumn.setWidth("50px");
            this.legend.setWidth("280px");
        }
        this.buildLegend();
        this.getFellow("btnSearch").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getFellow("btnClear").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        3 labelComparatorAsc = new /* Unavailable Anonymous Inner Class!! */;
        4 labelComparatorDesc = new /* Unavailable Anonymous Inner Class!! */;
        5 countComparatorAsc = new /* Unavailable Anonymous Inner Class!! */;
        6 countComparatorDesc = new /* Unavailable Anonymous Inner Class!! */;
        this.lhSecondColumn.setSortAscending((Comparator)labelComparatorAsc);
        this.lhSecondColumn.setSortDescending((Comparator)labelComparatorDesc);
        this.lhFourthColumn.setSortAscending((Comparator)countComparatorAsc);
        this.lhFourthColumn.setSortDescending((Comparator)countComparatorDesc);
    }

    private void rebuildSelectedList() {
        for (Listitem li : this.legend.getItems()) {
            if (li.getFirstChild().getChildren().isEmpty()) continue;
            String v = ((Listcell)li.getChildren().get(1)).getLabel();
            if (((Checkbox)li.getFirstChild().getFirstChild()).isChecked()) {
                this.selectedList.add(v);
                continue;
            }
            this.selectedList.remove(v);
        }
        this.lblSelectedCount.setValue(this.selectedList.size() + " selected");
        if (this.selectedList.size() > 0) {
            this.createInGroup.setVisible(true);
            this.clearSelection.setVisible(true);
        } else {
            this.createInGroup.setVisible(false);
            this.clearSelection.setVisible(false);
        }
    }

    public void onClick$createInGroup(Event e) {
        this.getMapComposer().mapSpecies(this.query.newFacet(this.facet, true), "Facet of " + this.mapLayer.getDisplayName(), "species", -1, 21, null, -1, 3, 0.6f, Util.nextColour(), false);
    }

    int[] getState() {
        int countChecked = 0;
        boolean unknownChecked = false;
        for (Listitem li : this.legend.getItems()) {
            if (li.getFirstChild().getChildren().isEmpty() || !((Checkbox)li.getFirstChild().getFirstChild()).isChecked()) continue;
            String v = ((Listcell)li.getChildren().get(1)).getLabel();
            v = this.displayToActualLabel(v);
            if ((this.query instanceof BiocacheQuery || this.divContinous.isVisible()) && "Unknown".equals(v) || v.length() == 0) {
                unknownChecked = true;
                continue;
            }
            ++countChecked;
        }
        int[] state = new int[]{this.selectedList.size(), unknownChecked ? 1 : 0};
        return state;
    }

    public void onClick$clearSelection(Event e) {
        this.uncheckAll();
        if (this.divContinous.isVisible()) {
            this.setEnableContinousControls(true);
            this.minValue = this.gMinValue;
            this.maxValue = this.gMaxValue;
            this.dunknown.setChecked(true);
            this.updateD();
        } else {
            this.mapLayer.setHighlight(this.getSelectionFacet());
            this.getMapComposer().applyChange(this.mapLayer);
        }
    }

    void buildLegend() {
        try {
            StringBuilder slist = new StringBuilder();
            if (this.query != null) {
                if ("grid".equals(this.colourmode)) {
                    slist.append("name,red,green,blue,count");
                    for (int i = 0; i < 600; i += 100) {
                        slist.append(">");
                        slist.append("\n").append(i).append(",").append(LegendObject.getRGB((int)Legend.getLinearColour((double)i, (double)0.0, (double)500.0, (int)-256, (int)-65536))).append(",");
                    }
                } else {
                    slist.append(this.query.getLegend(this.colourmode).getTable());
                }
            } else {
                return;
            }
            try {
                this.legendLines = new CSVReader((Reader)new StringReader(slist.toString())).readAll();
                this.uncheckAll();
            }
            catch (IOException e) {
                LOGGER.error((Object)"failed to read legend list as csv", (Throwable)e);
            }
            this.legendLines.remove(0);
            String h = this.mapLayer.getHighlight();
            this.facet = Facet.parseFacet((String)h);
            this.divContinous.setVisible(false);
            if (this.legendLines.size() > 1) {
                String first = ((String[])this.legendLines.get(0))[0];
                if (first == null || first.length() == 0 || first.startsWith("Unknown")) {
                    first = ((String[])this.legendLines.get(1))[0];
                }
                if (!this.checkmarks && this.query.getLegend(this.colourmode) != null && this.query.getLegend(this.colourmode).getNumericLegend() != null) {
                    this.setupForNumericalList(h);
                } else if ("occurrence_year".equals(this.colourmode)) {
                    this.setupForBiocacheNumber(h, this.colourmode, true);
                } else if ("occurrence_year_decade".equals(this.colourmode) || "decade".equals(this.colourmode)) {
                    this.setupForBiocacheDecade();
                } else if ("coordinate_uncertainty".equals(this.colourmode) || "uncertainty".equals(this.colourmode)) {
                    this.setupForBiocacheNumber(h, this.colourmode, false);
                } else if ("month".equals(this.colourmode)) {
                    this.setupForBiocacheMonth();
                }
            }
            this.legend.setItemRenderer((ListitemRenderer)new /* Unavailable Anonymous Inner Class!! */);
            this.legend.setModel((ListModel)new SimpleListModel(this.legendLines));
            this.createInGroup.setVisible(!this.disableselection && this.mapLayer.getHighlight() != null && this.mapLayer.getHighlight().length() > 0);
            this.clearSelection.setVisible(!this.disableselection && this.mapLayer.getHighlight() != null && this.mapLayer.getHighlight().length() > 0);
            if (this.divContinous.isVisible()) {
                int[] state = this.getState();
                if (state[0] > 1) {
                    this.setEnableContinousControls(false);
                } else {
                    this.updateD();
                }
                this.getFellow("txtSearch").setVisible(false);
            } else {
                this.getFellow("txtSearch").setVisible(true);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error building classification legend, pid: " + this.pid), (Throwable)e);
        }
    }

    String getSelectionFacet() {
        String unknownSearch;
        StringBuilder values = new StringBuilder();
        boolean unknown = false;
        for (Object selectedItem : this.selectedList) {
            String v = (String)selectedItem;
            v = this.displayToActualLabel(v);
            if (!(this.legendFacets == null || "Unknown".equals(v) || v.contains("occurrence_year") || v.contains("uncertainty") || v.contains("coordinate_uncertainty"))) {
                v = (String)this.legendFacets.get(v);
            }
            if (v.length() == 0 || (this.query instanceof BiocacheQuery || this.divContinous.isVisible()) && "Unknown".equals(v)) {
                unknown = true;
                continue;
            }
            if (values.length() > 0) {
                values.append(" OR ");
            }
            if (this.legendFacets != null) {
                values.append(v);
                continue;
            }
            values.append(this.colourmode).append(":\"");
            values.append(v).append("\"");
        }
        String string = unknownSearch = this.divContinous.isVisible() ? ":[* TO *]" : ":*";
        if (unknown) {
            if (values.length() > 0) {
                String newValues = "-(" + this.colourmode + unknownSearch + " AND -" + values.toString().replace(" OR ", " AND -") + ")";
                values = new StringBuilder();
                values.append(newValues);
            } else {
                values.append("-").append(this.colourmode).append(unknownSearch);
            }
        }
        if (!(values.length() != 0 || this.minValue == this.gMinValue && this.maxValue == this.gMaxValue && this.dunknown.isChecked())) {
            if (this.dunknown.isChecked()) {
                if (this.intContinous) {
                    values.append(String.format("-(%s:[* TO *] AND -%s:[%d TO %d])", this.colourmode, this.colourmode, (int)this.minValue, (int)this.maxValue));
                } else {
                    values.append(String.format("-(%s:[* TO *] AND -%s:[%f TO %f])", this.colourmode, this.colourmode, this.minValue, this.maxValue));
                }
            } else if (this.intContinous) {
                values.append(String.format("%s:[%d TO %d]", this.colourmode, (int)this.minValue, (int)this.maxValue));
            } else {
                values.append(String.format("%s:[%f TO %f]", this.colourmode, this.minValue, this.maxValue));
            }
        }
        if (values.length() > 0) {
            this.facet = Facet.parseFacet((String)values.toString());
            return this.facet.toString();
        }
        this.facet = null;
        return "";
    }

    public void onScroll$dslider(Event event) {
        if (!this.dmax.isDisabled()) {
            this.uncheckAll();
            this.updateD();
        }
    }

    public void onOK$dmin(Event event) {
        this.uncheckAll();
        this.minValue = this.dmin.getValue();
        this.updateD();
    }

    public void onChange$dmin(Event event) {
        this.uncheckAll();
        this.minValue = this.dmin.getValue();
        this.updateD();
    }

    public void onOK$dmax(Event event) {
        this.uncheckAll();
        this.maxValue = this.dmax.getValue();
        this.updateD();
    }

    public void onChange$dmax(Event event) {
        this.uncheckAll();
        this.maxValue = this.dmax.getValue();
        this.updateD();
    }

    public void onClick$dbutton(Event event) {
        this.uncheckAll();
        this.minValue = this.dmin.getValue();
        this.maxValue = this.dmax.getValue();
        this.updateD();
    }

    public void onCheck$dunknown(Event event) {
        this.uncheckAll();
        this.updateD();
    }

    void uncheckAll() {
        for (Listitem li : this.legend.getItems()) {
            if (li.getFirstChild().getChildren().isEmpty() || !((Checkbox)li.getFirstChild().getFirstChild()).isChecked()) continue;
            ((Checkbox)li.getFirstChild().getFirstChild()).setChecked(false);
        }
        this.selectedList = new HashSet();
        this.lblSelectedCount.setValue(this.selectedList.size() + " selected");
    }

    void updateD() {
        if (!this.dmin.isDisabled()) {
            double range = this.gMaxValue - this.gMinValue;
            if (range > 0.0) {
                this.dmin.setValue(this.minValue);
                this.dmax.setValue(this.maxValue);
                this.mapLayer.setHighlight(this.getSelectionFacet());
                Facet f = Facet.parseFacet((String)this.getSelectionFacet());
                int occurrencesCount = this.query.getOccurrenceCount();
                if (f != null) {
                    occurrencesCount = this.query.newFacet(f, false).getOccurrenceCount();
                }
                String minText = this.minValue == (double)((int)this.minValue) ? String.valueOf((int)this.minValue) : String.format("%f", this.minValue);
                String maxText = this.maxValue == (double)((int)this.maxValue) ? String.valueOf((int)this.maxValue) : String.format("%f", this.maxValue);
                String unknownText = this.dunknown.isChecked() ? " +Unknown" : " ";
                String selectedText = occurrencesCount == this.query.getOccurrenceCount() ? String.format(" (all of %d records selected)", occurrencesCount) : String.format(" (%d of %d records selected)", occurrencesCount, this.query.getOccurrenceCount());
                this.createInGroup.setVisible(!this.disableselection && occurrencesCount != 0 && occurrencesCount != this.query.getOccurrenceCount());
                this.clearSelection.setVisible(!this.disableselection && occurrencesCount != 0 && occurrencesCount != this.query.getOccurrenceCount());
                this.dlabel.setValue(minText + " to " + maxText + unknownText + selectedText);
                this.getMapComposer().applyChange(this.mapLayer);
            }
        } else {
            this.dlabel.setValue("list selection underway, range selection disabled");
        }
    }

    void setEnableContinousControls(boolean enable) {
        this.dmax.setDisabled(!enable);
        this.dmin.setDisabled(!enable);
        this.dbutton.setDisabled(!enable);
        if (!enable) {
            this.dlabel.setValue("list selection underway, range selection disabled");
        }
        this.dunknown.setDisabled(!enable);
    }

    private void setupForNumericalList(String facetString) {
        String h = facetString;
        this.legendFacets = new HashMap();
        try {
            this.divContinous.setVisible(!this.disableselection);
            LegendObject lo = this.mapLayer.getLegendObject();
            if (lo.getFieldType() == QueryField.FieldType.INT || lo.getFieldType() == QueryField.FieldType.LONG) {
                this.intContinous = true;
            }
            this.gMinValue = this.minValue = (double)lo.getMinMax()[0];
            this.gMaxValue = this.maxValue = (double)lo.getMinMax()[1];
            double rng = this.gMaxValue - this.gMinValue;
            if (this.intContinous && rng < (double)this.sliderMax && rng > 0.0) {
                this.sliderMax = (int)rng;
            }
            try {
                if (this.facet != null) {
                    boolean nulls = h.startsWith("-") || h.length() > 1 && h.charAt(1) == '-' || h.length() > 2 && h.charAt(2) == '-';
                    int countOr = h.split(" OR ").length;
                    if (countOr == 1 || nulls && countOr == 2) {
                        this.minValue = this.facet.getMin();
                        this.maxValue = this.facet.getMax();
                        if (Double.isInfinite(this.minValue)) {
                            this.minValue = this.gMinValue;
                        }
                        if (Double.isInfinite(this.maxValue)) {
                            this.maxValue = this.gMaxValue;
                        }
                    }
                    this.dunknown.setChecked(nulls);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"error setting up the numerical listing", (Throwable)e);
            }
            for (int j = 0; j < this.legendLines.size(); ++j) {
                String strFacet;
                String range;
                double nextmin;
                double max;
                double min;
                String label = ((String[])this.legendLines.get(j))[0];
                if (label.charAt(0) == '-') {
                    this.legendFacets.put("Unknown", ((String[])this.legendLines.get(j))[0]);
                    ((String[])this.legendLines.get((int)j))[0] = "Unknown";
                    continue;
                }
                String s = ((String[])this.legendLines.get(j))[0];
                String[] ss = s.substring(s.indexOf(91)).replace("[", "").replace("]", "").replace("-12-31T00:00:00Z", "").replace("-01-01T00:00:00Z", "").split(" TO ");
                float[] cutoffs = lo.getNumericLegend().getCutoffFloats();
                float[] cutoffMins = lo.getNumericLegend().getCutoffMinFloats();
                if (ss.length <= 1) continue;
                if ("*".equals(ss[0])) {
                    min = cutoffMins[0];
                    max = cutoffs[0];
                    nextmin = cutoffMins.length > 1 ? (double)cutoffMins[1] : (double)cutoffMins[0];
                } else if ("*".equals(ss[1])) {
                    min = cutoffMins[cutoffMins.length - 1];
                    max = this.gMaxValue;
                    nextmin = this.gMaxValue;
                } else {
                    double v = Double.parseDouble(ss[1]);
                    int pos = 0;
                    while (v > (double)cutoffs[pos]) {
                        ++pos;
                    }
                    min = cutoffMins[pos];
                    max = cutoffs[pos];
                    double d = nextmin = cutoffMins.length > pos + 1 ? (double)cutoffMins[pos + 1] : (double)cutoffMins[pos];
                }
                if (this.intContinous) {
                    range = min == this.gMinValue && max == this.gMaxValue ? String.format(">= %d and <= %d", (int)min, (int)max) : (min == this.gMinValue ? String.format(">= %d and < %d", (int)min, (int)nextmin) : (max == this.gMaxValue ? String.format("<= %d", (int)max) : String.format("< %d", (int)nextmin)));
                    strFacet = this.colourmode + ":[" + (int)min + " TO " + (int)max + "]";
                } else {
                    range = min == this.gMinValue && max == this.gMaxValue ? String.format(">= %g and <= %g", min, max) : (min == this.gMinValue ? String.format(">= %g and < %g", min, nextmin) : (max == this.gMaxValue ? String.format("<= %g", max) : String.format("< %g", nextmin)));
                    strFacet = this.colourmode + ":[" + min + " TO " + max + "]";
                }
                ((String[])this.legendLines.get((int)j))[0] = range;
                this.legendFacets.put(range, strFacet);
            }
            this.checkmarks = true;
        }
        catch (Exception e) {
            this.divContinous.setVisible(false);
            LOGGER.error((Object)"error setting up continous legend listing", (Throwable)e);
        }
    }

    private void setupForBiocacheNumber(String facetString, String facetName, boolean integer) {
        String h = facetString;
        this.isNumber = true;
        this.intContinous = integer;
        this.legendFacets = new HashMap();
        LegendObject lo = this.mapLayer.getLegendObject();
        if (lo != null) {
            this.divContinous.setVisible(!this.disableselection);
            this.gMinValue = this.minValue = (double)lo.getMinMax()[0];
            this.gMaxValue = this.maxValue = (double)lo.getMinMax()[1];
            if (this.intContinous) {
                this.sliderMax = Math.min(this.sliderMax, (int)(this.gMaxValue - this.gMinValue));
            }
            try {
                if (this.facet != null) {
                    boolean nulls = h.contains("-(" + facetName + ":") || h.contains("-" + facetName + ":");
                    int countOr = h.split(" OR ").length;
                    if (countOr == 1 || nulls && countOr == 2) {
                        this.minValue = this.facet.getMin();
                        this.maxValue = this.facet.getMax();
                        if (Double.isInfinite(this.minValue)) {
                            this.minValue = this.gMinValue;
                        }
                        if (Double.isInfinite(this.maxValue)) {
                            this.maxValue = this.gMaxValue;
                        }
                    }
                    this.dunknown.setChecked(nulls);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"error seting up numerical listing", (Throwable)e);
            }
            for (int j = 0; j < this.legendLines.size(); ++j) {
                String strFacet;
                String range;
                String label = ((String[])this.legendLines.get(j))[0];
                if (label.charAt(0) == '-') {
                    this.legendFacets.put("Unknown", ((String[])this.legendLines.get(j))[0]);
                    ((String[])this.legendLines.get((int)j))[0] = "Unknown";
                    continue;
                }
                String s = ((String[])this.legendLines.get(j))[0];
                String[] ss = s.substring(s.indexOf(91)).replace("[", "").replace("]", "").replace("-12-31T00:00:00Z", "").replace("-01-01T00:00:00Z", "").split(" TO ");
                float[] cutoffs = lo.getNumericLegend().getCutoffFloats();
                float[] cutoffMins = lo.getNumericLegend().getCutoffMinFloats();
                if (ss.length <= 1) continue;
                if ("*".equals(ss[0])) {
                    if (this.intContinous) {
                        range = cutoffs.length > 1 ? String.format(">= %d and < %d", (int)cutoffMins[0], (int)cutoffMins[1]) : String.format(">= %d and <= %d", (int)cutoffMins[0], (int)cutoffs[0]);
                        if ("occurrence_year".equals(this.colourmode) || "occurrence_year_decade".equals(this.colourmode) || "decade".equals(this.colourmode)) {
                            String minyear = String.valueOf((int)cutoffMins[0]);
                            while (minyear.length() < 4) {
                                minyear = "0" + minyear;
                            }
                            strFacet = "" + facetName + ":[" + minyear + "-01-01T00:00:00Z TO " + (int)cutoffs[0] + "-12-31T00:00:00Z]";
                        } else {
                            strFacet = "" + facetName + ":[" + (int)cutoffMins[0] + " TO " + (int)cutoffs[0] + "]";
                        }
                    } else {
                        range = cutoffs.length > 1 ? String.format(">= %.2f and < %.2f", Float.valueOf(cutoffMins[0]), Float.valueOf(cutoffMins[1])) : String.format(">= %.2f and <= %.2f", Float.valueOf(cutoffMins[0]), Float.valueOf(cutoffs[0]));
                        strFacet = "" + facetName + ":[" + cutoffMins[0] + " TO " + cutoffs[0] + "]";
                    }
                } else if ("*".equals(ss[1])) {
                    if (this.intContinous) {
                        range = String.format("<= %d", (int)this.gMaxValue);
                        if ("occurrence_year".equals(this.colourmode) || "occurrence_year_decade".equals(this.colourmode) || "decade".equals(this.colourmode)) {
                            String minyear = String.valueOf((int)cutoffMins[cutoffMins.length - 1]);
                            while (minyear.length() < 4) {
                                minyear = "0" + minyear;
                            }
                            strFacet = "" + facetName + ":[" + minyear + "-01-01T00:00:00Z TO " + (int)this.gMaxValue + "-12-31T00:00:00Z]";
                        } else {
                            strFacet = "" + facetName + ":[" + (int)cutoffMins[cutoffMins.length - 1] + " TO " + (int)this.gMaxValue + "]";
                        }
                    } else {
                        range = String.format("<= %.2f", this.gMaxValue);
                        strFacet = "" + facetName + ":[" + cutoffMins[cutoffMins.length - 1] + " TO " + this.gMaxValue + "]";
                    }
                } else {
                    double v = Double.parseDouble(ss[1]);
                    int pos = 0;
                    while (v > (double)cutoffs[pos]) {
                        ++pos;
                    }
                    if (this.intContinous) {
                        range = pos + 1 < cutoffs.length ? String.format("< %d", (int)cutoffMins[pos + 1]) : String.format("<= %d", (int)cutoffs[pos]);
                        if ("occurrence_year".equals(this.colourmode) || "occurrence_year_decade".equals(this.colourmode) || "decade".equals(this.colourmode)) {
                            String minyear = String.valueOf((int)cutoffMins[pos]);
                            while (minyear.length() < 4) {
                                minyear = "0" + minyear;
                            }
                            strFacet = "" + facetName + ":[" + minyear + "-01-01T00:00:00Z TO " + (int)cutoffs[pos] + "-12-31T00:00:00Z]";
                        } else {
                            strFacet = "" + facetName + ":[" + (int)cutoffMins[pos] + " TO " + (int)cutoffs[pos] + "]";
                        }
                    } else {
                        range = pos + 1 < cutoffs.length ? String.format("< %.2f", Float.valueOf(cutoffMins[pos + 1])) : String.format("<= %.2f", Float.valueOf(cutoffs[pos]));
                        strFacet = "" + facetName + ":[" + cutoffMins[pos] + " TO " + cutoffs[pos] + "]";
                    }
                }
                ((String[])this.legendLines.get((int)j))[0] = range;
                this.legendFacets.put(range, strFacet);
            }
        }
    }

    private void setupForBiocacheDecade() {
        this.isNumber = false;
        this.intContinous = true;
        this.legendFacets = new HashMap();
        LegendObject lo = this.mapLayer.getLegendObject();
        if (lo != null) {
            for (int j = 0; j < this.legendLines.size(); ++j) {
                String label = ((String[])this.legendLines.get(j))[0];
                if (label.charAt(0) == '-') {
                    this.legendFacets.put("Unknown", ((String[])this.legendLines.get(j))[0]);
                    ((String[])this.legendLines.get((int)j))[0] = "Unknown";
                    continue;
                }
                String[] ss = ((String[])this.legendLines.get(j))[0].split(" TO ");
                if (ss.length <= 1) continue;
                String yr = ss[1].substring(0, ss[1].length() - 2);
                String range = String.format("%s0s", yr);
                String strFacet = "occurrence_year:[" + yr + "0-01-01T00:00:00Z TO " + yr + "9-12-31T00:00:00Z]";
                ((String[])this.legendLines.get((int)j))[0] = range;
                this.legendFacets.put(range, strFacet);
            }
        }
    }

    private void setupForBiocacheMonth() {
        this.isMonth = true;
        this.legendFacets = new HashMap();
        for (int j = 0; j < this.legendLines.size(); ++j) {
            String label = ((String[])this.legendLines.get(j))[0];
            if (label.charAt(0) == '-') {
                this.legendFacets.put("Unknown", ((String[])this.legendLines.get(j))[0]);
                ((String[])this.legendLines.get((int)j))[0] = "Unknown";
                continue;
            }
            String s = ((String[])this.legendLines.get(j))[0];
            String[] ss = (s = s.substring(s.indexOf(91) + 1, s.indexOf(93))).split(" TO ");
            if (ss.length > 1) {
                if ("01".equals(ss[1])) {
                    s = "January";
                } else if ("02".equals(ss[1])) {
                    s = "February";
                } else if ("03".equals(ss[1])) {
                    s = "March";
                } else if ("04".equals(ss[1])) {
                    s = "April";
                } else if ("05".equals(ss[1])) {
                    s = "May";
                } else if ("06".equals(ss[1])) {
                    s = "June";
                } else if ("07".equals(ss[1])) {
                    s = "July";
                } else if ("08".equals(ss[1])) {
                    s = "August";
                } else if ("09".equals(ss[1])) {
                    s = "September";
                } else if ("10".equals(ss[1])) {
                    s = "October";
                } else if ("11".equals(ss[1])) {
                    s = "November";
                } else if ("12".equals(ss[1])) {
                    s = "December";
                }
            }
            this.legendFacets.put(s, "month:[" + ss[1] + " TO " + ss[1] + "]");
            ((String[])this.legendLines.get((int)j))[0] = s;
        }
    }

    public void checkboxClick(Event event) {
        if (this.mapLayer != null) {
            this.mapLayer.setHighlight(this.getSelectionFacet());
            this.createInGroup.setVisible(!this.disableselection && this.mapLayer.getHighlight() != null && this.mapLayer.getHighlight().length() > 0);
            this.clearSelection.setVisible(!this.disableselection && this.mapLayer.getHighlight() != null && this.mapLayer.getHighlight().length() > 0);
            if (this.divContinous.isVisible()) {
                int[] state = this.getState();
                this.dunknown.setChecked(state[1] > 0);
                this.setEnableContinousControls(state[0] <= 1);
                if (state[0] > 0 || state[1] > 0) {
                    this.minValue = this.facet.getMin();
                    this.maxValue = this.facet.getMax();
                    if (Double.isInfinite(this.minValue)) {
                        this.minValue = this.gMinValue;
                    }
                    if (Double.isInfinite(this.maxValue)) {
                        this.maxValue = this.gMaxValue;
                    }
                } else {
                    this.minValue = this.gMinValue;
                    this.maxValue = this.gMaxValue;
                    if (state[1] == 0) {
                        this.dunknown.setChecked(true);
                    }
                }
                if (state[0] <= 1) {
                    this.updateD();
                }
            }
        }
        this.getMapComposer().applyChange(this.mapLayer);
    }

    private void determineCheckboxState(Checkbox cb, String value) {
        block41: {
            if (!this.disableselection && this.mapLayer.getHighlight() != null && this.mapLayer.getHighlight().length() > 0) {
                String f = this.mapLayer.getHighlight();
                if (this.isMonth) {
                    boolean found = false;
                    if (value.startsWith("Unknown")) {
                        found = f.startsWith("-");
                    } else if ("January".equals(value)) {
                        found = f.contains(" 01");
                    } else if ("February".equals(value)) {
                        found = f.contains(" 02");
                    } else if ("March".equals(value)) {
                        found = f.contains(" 03");
                    } else if ("April".equals(value)) {
                        found = f.contains(" 04");
                    } else if ("May".equals(value)) {
                        found = f.contains(" 05");
                    } else if ("June".equals(value)) {
                        found = f.contains(" 06");
                    } else if ("July".equals(value)) {
                        found = f.contains(" 07");
                    } else if ("August".equals(value)) {
                        found = f.contains(" 08");
                    } else if ("September".equals(value)) {
                        found = f.contains(" 09");
                    } else if ("October".equals(value)) {
                        found = f.contains(" 10");
                    } else if ("November".equals(value)) {
                        found = f.contains(" 11");
                    } else if ("December".equals(value)) {
                        found = f.contains("11 TO *");
                    }
                    if (found) {
                        cb.setChecked(true);
                    }
                } else if (!f.contains(":\"") && !f.contains(":*")) {
                    try {
                        if (this.facet != null) {
                            if (value == null || value.length() == 0 || (this.query instanceof BiocacheQuery || this.divContinous.isVisible()) && "Unknown".equals(value)) {
                                cb.setChecked(this.facet.isValid(""));
                            } else {
                                cb.setChecked(f.contains((CharSequence)this.legendFacets.get(value)));
                            }
                            break block41;
                        }
                        LOGGER.debug((Object)("Error parsing: " + this.mapLayer.getHighlight()));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"error with continous values", (Throwable)e);
                    }
                } else {
                    Facet fct = Facet.parseFacet((String)f);
                    if (fct != null) {
                        if (value == null || value.length() == 0 || (this.query instanceof BiocacheQuery || this.divContinous.isVisible()) && "Unknown".equals(value)) {
                            cb.setChecked(fct.isValid(""));
                        } else {
                            cb.setChecked(fct.isValid(value));
                        }
                        if (cb.isChecked()) {
                            this.selectedList.add(value);
                            this.lblSelectedCount.setValue(this.selectedList.size() + " selected");
                        }
                    } else {
                        LOGGER.debug((Object)("Error parsing: " + this.mapLayer.getHighlight()));
                    }
                }
            }
        }
    }

    public void onClick$selectAll(Event event) {
        if (this.legend != null) {
            for (Listitem li : this.legend.getItems()) {
                if (li.getFirstChild().getChildren().isEmpty() || ((Checkbox)li.getFirstChild().getFirstChild()).isChecked()) continue;
                ((Checkbox)li.getFirstChild().getFirstChild()).setChecked(true);
                String v = ((Listcell)li.getChildren().get(1)).getLabel();
                this.selectedList.add(v);
            }
            this.updateD();
            this.mapLayer.setHighlight(this.getSelectionFacet());
            this.getMapComposer().applyChange(this.mapLayer);
            this.dCreateButtons.setVisible(true);
            this.clearSelection.setVisible(true);
            this.createInGroup.setVisible(true);
            this.lblSelectedCount.setValue(this.selectedList.size() + " selected");
        }
    }

    private String displayToActualLabel(String v) {
        String actual = null;
        for (String key : CommonData.getI18nPropertiesList((String)this.colourmode)) {
            String s = CommonData.getI18nProperty((String)key);
            if (!s.equals(v)) continue;
            int pos = key.indexOf(46);
            if (pos > 0) {
                actual = key.substring(pos + 1);
                continue;
            }
            actual = key;
        }
        if (actual == null) {
            actual = v;
        }
        return actual;
    }

    private String actualToDisplayLabel(String v) {
        String s = CommonData.getI18nProperty((String)(this.colourmode + "." + v));
        if (s == null) {
            s = v;
        }
        return s;
    }

    static /* synthetic */ List access$000(ClassificationLegend x0) {
        return x0.legendLines;
    }

    static /* synthetic */ Listbox access$100(ClassificationLegend x0) {
        return x0.legend;
    }

    static /* synthetic */ boolean access$200(ClassificationLegend x0) {
        return x0.checkmarks;
    }

    static /* synthetic */ Set access$300(ClassificationLegend x0) {
        return x0.selectedList;
    }

    static /* synthetic */ Label access$400(ClassificationLegend x0) {
        return x0.lblSelectedCount;
    }

    static /* synthetic */ Button access$500(ClassificationLegend x0) {
        return x0.createInGroup;
    }

    static /* synthetic */ Button access$600(ClassificationLegend x0) {
        return x0.clearSelection;
    }

    static /* synthetic */ void access$700(ClassificationLegend x0, Checkbox x1, String x2) {
        x0.determineCheckboxState(x1, x2);
    }

    static /* synthetic */ boolean access$800(ClassificationLegend x0) {
        return x0.disableselection;
    }

    static /* synthetic */ boolean access$900(ClassificationLegend x0) {
        return x0.readonly;
    }

    static /* synthetic */ String access$1000(ClassificationLegend x0, String x1) {
        return x0.actualToDisplayLabel(x1);
    }

    static /* synthetic */ Logger access$1100() {
        return LOGGER;
    }

    static /* synthetic */ Listheader access$1200(ClassificationLegend x0) {
        return x0.lhFourthColumn;
    }

    static /* synthetic */ Listheader access$1300(ClassificationLegend x0) {
        return x0.lhThirdColumn;
    }

    static /* synthetic */ Div access$1400(ClassificationLegend x0) {
        return x0.dCreateButtons;
    }
}

