/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.composer;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.legend.QueryField;
import au.org.ala.spatial.sampling.Sampling;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.menu.MapLayer;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.zkoss.zul.Filedownload;

public final class SamplingDownloadUtil {
    private static final Logger LOGGER = Logger.getLogger(SamplingDownloadUtil.class);

    private SamplingDownloadUtil() {
    }

    public static void downloadSecond(MapComposer mc, Query downloadSecondQuery, String[] downloadSecondLayers) {
        block12: {
            LOGGER.debug((Object)("attempting to sample biocache records with analysis layers: " + downloadSecondQuery));
            if (downloadSecondQuery != null) {
                try {
                    ArrayList<QueryField> fields = new ArrayList<QueryField>();
                    fields.add(new QueryField(downloadSecondQuery.getRecordIdFieldName()));
                    fields.add(new QueryField(downloadSecondQuery.getRecordLongitudeFieldName()));
                    fields.add(new QueryField(downloadSecondQuery.getRecordLatitudeFieldName()));
                    String results = downloadSecondQuery.sample(fields);
                    if (results == null) break block12;
                    CSVReader csvreader = new CSVReader((Reader)new StringReader(results));
                    List csv = csvreader.readAll();
                    csvreader.close();
                    int longitudeColumn = Util.findInArray((String)downloadSecondQuery.getRecordLongitudeFieldDisplayName(), (String[])((String[])csv.get(0)));
                    int latitudeColumn = Util.findInArray((String)downloadSecondQuery.getRecordLatitudeFieldDisplayName(), (String[])((String[])csv.get(0)));
                    int idColumn = Util.findInArray((String)downloadSecondQuery.getRecordIdFieldDisplayName(), (String[])((String[])csv.get(0)));
                    double[] points = new double[(csv.size() - 1) * 2];
                    String[] ids = new String[csv.size() - 1];
                    int pos = 0;
                    for (int i = 1; i < csv.size(); ++i) {
                        try {
                            points[pos] = Double.parseDouble(((String[])csv.get(i))[longitudeColumn]);
                            points[pos + 1] = Double.parseDouble(((String[])csv.get(i))[latitudeColumn]);
                        }
                        catch (Exception e) {
                            points[pos] = Double.NaN;
                            points[pos + 1] = Double.NaN;
                        }
                        ids[pos / 2] = ((String[])csv.get(i))[idColumn];
                        pos += 2;
                    }
                    double[][] p = new double[points.length / 2][2];
                    for (int i = 0; i < points.length; i += 2) {
                        p[i / 2][0] = points[i];
                        p[i / 2][1] = points[i + 1];
                    }
                    ArrayList<String> layers = new ArrayList<String>();
                    StringBuilder sb = new StringBuilder();
                    sb.append("id,longitude,latitude");
                    for (String layer : downloadSecondLayers) {
                        sb.append(",");
                        String name = CommonData.getLayerDisplayName((String)layer);
                        if (name == null && (name = CommonData.getFacetLayerDisplayNameDefault((String)layer)) == null) {
                            MapLayer ml = mc.getMapLayer(layer);
                            name = ml == null ? layer : ml.getDisplayName();
                        }
                        sb.append(name);
                        layers.add(CommonData.getLayerFacetName((String)layer));
                    }
                    List sample = Sampling.sampling(layers, (double[][])p);
                    if (!sample.isEmpty()) {
                        for (int j = 0; j < ((String[])sample.get(0)).length; ++j) {
                            sb.append("\n");
                            sb.append(ids[j]).append(",").append(p[j][0]).append(",").append(p[j][1]);
                            for (int i = 0; i < sample.size(); ++i) {
                                sb.append(",").append(((String[])sample.get(i))[j]);
                            }
                        }
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ZipOutputStream zos = new ZipOutputStream(baos);
                    ZipEntry anEntry = new ZipEntry("analysis_output_intersect.csv");
                    zos.putNextEntry(anEntry);
                    zos.write(sb.toString().getBytes());
                    zos.close();
                    Filedownload.save((byte[])baos.toByteArray(), (String)"application/zip", (String)"analysis_output_intersect.zip");
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error downloading samping records", (Throwable)e);
                }
            }
        }
    }
}

