/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.composer;

import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.util.PrintMapComposer;
import au.org.emii.portal.value.BoundingBox;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Textbox;

public class PrintingComposer
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(PrintingComposer.class);
    private Textbox txtHeader;
    private Checkbox chkGrid;
    private Combobox cbFormat;
    private Combobox cbResolution;
    private String tbxPrintHack;
    private String baseMap;
    private BoundingBox boundingBox;
    private List<MapLayer> mapLayers;

    public void afterCompose() {
        super.afterCompose();
        Map m = Executions.getCurrent().getArg();
        if (m != null) {
            for (Map.Entry o : m.entrySet()) {
                Object key = o.getKey();
                if (!(key instanceof String)) continue;
                if (key.equals("print_params")) {
                    this.tbxPrintHack = (String)o.getValue();
                    continue;
                }
                if (key.equals("base_layer")) {
                    this.baseMap = (String)o.getValue();
                    continue;
                }
                if (key.equals("bounding_box")) {
                    this.boundingBox = (BoundingBox)o.getValue();
                    continue;
                }
                if (!key.equals("layers")) continue;
                this.mapLayers = (List)o.getValue();
            }
        }
        this.cbFormat.setSelectedIndex(0);
        this.cbResolution.setSelectedIndex(0);
        if (!"outline".equalsIgnoreCase(this.getMapComposer().getBaseMap())) {
            this.getFellow("hboxImageResolution").setVisible(false);
        }
        this.txtHeader.setValue(new SimpleDateFormat("dd/MM/yyyy").format(new Date()));
    }

    public void onClick$btnExport(Event event) {
        String header = this.txtHeader.getValue();
        double grid = 0.0;
        if (this.chkGrid.isChecked()) {
            grid = 1.0;
        }
        String format = this.cbFormat.getValue();
        int resolution = this.cbResolution.getSelectedIndex();
        this.print(header, grid, format, resolution, false);
        this.detach();
    }

    void print(String header, double grid, String format, int resolution, boolean preview) {
        LOGGER.debug((Object)("tbxPrintHack:" + this.tbxPrintHack));
        String[] ps = this.tbxPrintHack.split(",");
        double[] extents = new double[]{Double.parseDouble(ps[2]), Double.parseDouble(ps[3]), Double.parseDouble(ps[4]), Double.parseDouble(ps[5])};
        int[] windowSize = new int[]{Integer.parseInt(ps[0]), Integer.parseInt(ps[1])};
        if ("png".equalsIgnoreCase(format)) {
            Filedownload.save((byte[])new PrintMapComposer(this.baseMap, this.mapLayers, this.boundingBox, extents, windowSize, header, "png", resolution).get(), (String)"image/png", (String)"map_export.png");
        } else if ("pdf".equalsIgnoreCase(format)) {
            Filedownload.save((byte[])new PrintMapComposer(this.baseMap, this.mapLayers, this.boundingBox, extents, windowSize, header, "pdf", resolution).get(), (String)"application/pdf", (String)"map_export.pdf");
        } else {
            Filedownload.save((byte[])new PrintMapComposer(this.baseMap, this.mapLayers, this.boundingBox, extents, windowSize, header, "jpg", resolution).get(), (String)"image/jpeg", (String)"map_export.jpg");
        }
    }
}

