/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.composer;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.legend.Facet;
import au.org.ala.legend.LegendObject;
import au.org.ala.spatial.composer.sandbox.SandboxEmbeddedController;
import au.org.ala.spatial.composer.sandbox.SandboxPasteController;
import au.org.ala.spatial.composer.species.SpeciesAutoCompleteComponent;
import au.org.ala.spatial.dto.ScatterplotDataDTO;
import au.org.ala.spatial.dto.WKTReducedDTO;
import au.org.ala.spatial.logger.RemoteLogger;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayerSelection;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.QueryUtil;
import au.org.ala.spatial.util.UserDataQuery;
import au.org.ala.spatial.util.UserShapes;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.ErrorMessageComposer;
import au.org.emii.portal.composer.ExternalContentComposer;
import au.org.emii.portal.composer.GenericAutowireAutoforwardComposer;
import au.org.emii.portal.composer.LeftMenuSearchComposer;
import au.org.emii.portal.composer.MapComposer;
import au.org.emii.portal.composer.SamplingDownloadUtil;
import au.org.emii.portal.databinding.ActiveLayerRenderer;
import au.org.emii.portal.javascript.OpenLayersJavascript;
import au.org.emii.portal.lang.LanguagePack;
import au.org.emii.portal.menu.HasMapLayer;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.MapLayerMetadata;
import au.org.emii.portal.menu.SelectedArea;
import au.org.emii.portal.net.HttpConnection;
import au.org.emii.portal.session.PortalSession;
import au.org.emii.portal.settings.Settings;
import au.org.emii.portal.util.PortalSessionUtilities;
import au.org.emii.portal.util.RemoteMap;
import au.org.emii.portal.value.BoundingBox;
import au.org.emii.portal.web.SessionInitImpl;
import au.org.emii.portal.wms.WMSStyle;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.persistence.FilePersistenceStrategy;
import com.thoughtworks.xstream.persistence.PersistenceStrategy;
import com.thoughtworks.xstream.persistence.XmlArrayList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlMacroComponent;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Html;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Window;

public class MapComposer
extends GenericAutowireAutoforwardComposer {
    public static final int DEFAULT_POINT_SIZE = 3;
    public static final float DEFAULT_POINT_OPACITY = 0.6f;
    private static final Logger LOGGER = Logger.getLogger(MapComposer.class);
    private static final long serialVersionUID = 1L;
    private String featuresCSV;
    private MapLayer llc2MapLayer;
    private Query downloadSecondQuery = null;
    private String[] downloadSecondLayers = null;
    private Listbox activeLayersList;
    private ActiveLayerRenderer activeLayerRenderer = null;
    private HtmlMacroComponent contextualMenu;
    private int mapZoomLevel = 4;
    private Map activeLayerMapProperties;
    private Label lblSelectedLayer;
    private String useSpeciesWMSCache = "on";
    private List<LayerSelection> selectedLayers = new ArrayList();
    private String tbxLayerLoaded;
    private Map<String, EventListener> layerLoadedChangeEvents = new HashMap();
    private RemoteLogger remoteLogger;
    private Textbox currentLayerExtent;
    private boolean mp = true;
    private EventListener layerLegendNameRefresh = null;
    private EventListener contextualMenuRefreshListener;
    private EventListener facetsOpenListener = null;
    private Properties settingsSupplementary = null;
    private RemoteMap remoteMap = null;
    private Iframe rawMessageIframeHack;
    private Div rawMessageHackHolder;
    private Div layerControls;
    private LanguagePack languagePack = null;
    private OpenLayersJavascript openLayersJavascript = null;
    private HttpConnection httpConnection = null;
    private PortalSessionUtilities portalSessionUtilities = null;
    private Settings settings = null;
    private Pattern layerNameParamPattern = Pattern.compile("ly\\.[0-9]{1,}");

    public void onClick$removeAllLayers() {
        if (this.safeToPerformMapAction()) {
            List activeLayers = this.getPortalSession().getActiveLayers();
            StringBuilder script = new StringBuilder();
            while (activeLayers.size() > 1) {
                MapLayer mapLayer = (MapLayer)activeLayers.get(0);
                if (mapLayer.getType() == 12) continue;
                script.append(this.openLayersJavascript.removeMapLayer(mapLayer));
                this.deactiveLayer(mapLayer, false, false);
            }
            this.updateLayerControls();
            this.refreshContextualMenu();
            this.openLayersJavascript.execute(this.openLayersJavascript.getIFrameReferences() + script.toString());
        }
    }

    public void safeToLoadMap(Event event) {
        this.mapLoaded("true");
        1 el = new /* Unavailable Anonymous Inner Class!! */;
        this.getLeftmenuSearchComposer().addViewportEventListener("onReloadLayers", (EventListener)el);
    }

    public void zoomToExtent(MapLayer selectedLayer) {
        if (selectedLayer != null) {
            LOGGER.debug((Object)("zooming to extent " + selectedLayer.getId()));
            if (selectedLayer.getType() == 5 || selectedLayer.getType() == 11 || selectedLayer.getType() == 4) {
                this.openLayersJavascript.zoomGeoJsonExtentNow(selectedLayer);
            } else {
                this.openLayersJavascript.zoomLayerExtent(selectedLayer);
            }
        }
    }

    public void applyChange(MapLayer selectedLayer) {
        if (selectedLayer != null) {
            if (selectedLayer.isDynamicStyle()) {
                Color c = new Color(selectedLayer.getRedVal(), selectedLayer.getGreenVal(), selectedLayer.getBlueVal());
                String hexColour = Integer.toHexString(c.getRGB() & 0xFFFFFF);
                String rgbColour = "rgb(" + selectedLayer.getRedVal() + "," + selectedLayer.getGreenVal() + "," + selectedLayer.getBlueVal() + ")";
                selectedLayer.setEnvColour(rgbColour);
                if (selectedLayer.getType() == 5) {
                    this.openLayersJavascript.redrawFeatures(selectedLayer);
                } else if (selectedLayer.getType() == 11) {
                    this.openLayersJavascript.redrawWKTFeatures(selectedLayer);
                } else {
                    MapLayer highlightLayer;
                    LegendObject lo;
                    String envString = "";
                    envString = "-1".equals(selectedLayer.getColourMode()) ? envString + "color:" + hexColour : ((lo = selectedLayer.getLegendObject()) != null && lo.getColourMode() != null ? envString + "colormode:" + lo.getColourMode() : envString + "colormode:" + selectedLayer.getColourMode());
                    envString = envString + ";name:circle;size:" + selectedLayer.getSizeVal();
                    if ((selectedLayer.getHighlight() == null || selectedLayer.getHighlight().length() == 0 || !"grid".equals(selectedLayer.getColourMode())) && selectedLayer.getSizeUncertain()) {
                        envString = envString + ";uncertainty:1";
                    }
                    selectedLayer.setEnvParams(envString + ";opacity:1");
                    if (selectedLayer.hasChildren() && (highlightLayer = selectedLayer.getChild(0)).getName().equals(selectedLayer.getName() + "_highlight")) {
                        String highlightEnv = "color:000000;size:" + selectedLayer.getSizeVal() + ";opacity:0";
                        highlightLayer.setOpacity(1.0f);
                        if (selectedLayer.getHighlight() != null && selectedLayer.getHighlight().length() > 0 && !"grid".equals(selectedLayer.getColourMode())) {
                            if (selectedLayer.getSpeciesQuery() instanceof UserDataQuery) {
                                try {
                                    highlightLayer.setEnvParams(highlightEnv + ";sel:" + selectedLayer.getHighlight().replace(";", "%3B"));
                                }
                                catch (Exception e) {
                                    LOGGER.error((Object)("error encoding highlight to UTF-8: " + selectedLayer.getHighlight()), (Throwable)e);
                                }
                            } else {
                                highlightLayer.setEnvParams(highlightEnv + ";sel:" + selectedLayer.getHighlight().replace(";", "%3B"));
                            }
                            highlightLayer.setHighlightState("show");
                        } else {
                            highlightLayer.setHighlightState("hide");
                            highlightLayer.setEnvParams(highlightEnv);
                        }
                    }
                    if (selectedLayer.isDisplayed()) {
                        this.reloadMapLayerNowAndIndexes(selectedLayer);
                    }
                }
            } else if (selectedLayer.getSelectedStyle() != null) {
                LOGGER.debug((Object)"******** is this ever reached? **********");
                selectedLayer.setOpacity(selectedLayer.getOpacity());
                String legendUri = selectedLayer.getSelectedStyle().getLegendUri();
                if (legendUri.contains(".zul")) {
                    this.addImageLayer(selectedLayer.getId(), selectedLayer.getName(), selectedLayer.getUri(), selectedLayer.getOpacity(), null, 14);
                } else if (selectedLayer.isDisplayed()) {
                    this.reloadMapLayerNowAndIndexes(selectedLayer);
                }
            } else if (selectedLayer.isDisplayed()) {
                this.reloadMapLayerNowAndIndexes(selectedLayer);
            }
        }
    }

    public void reloadMapLayerNowAndIndexes(MapLayer selectedLayer) {
        if (this.safeToPerformMapAction()) {
            PortalSession portalSession = (PortalSession)Executions.getCurrent().getDesktop().getSession().getAttribute("portalSession");
            this.openLayersJavascript.execute(this.openLayersJavascript.getIFrameReferences() + this.openLayersJavascript.reloadMapLayer(selectedLayer) + this.openLayersJavascript.updateMapLayerIndexes(portalSession.getActiveLayers()));
        }
    }

    public void mapSpeciesFromAutocompleteComponent(SpeciesAutoCompleteComponent sacc, SelectedArea sa, boolean[] geospatialKosher, boolean mapExpertDistributions) {
        if (!sacc.hasValidAnnotatedItemSelected()) {
            return;
        }
        String[] details = sacc.getSelectedTaxonDetails();
        if (details.length > 0) {
            String taxon = details[0];
            String rank = details[1];
            Query query = sacc.getQuery((Map)this.getSession().getAttribute("userpoints"), false, geospatialKosher);
            Query q = QueryUtil.queryFromSelectedArea((Query)query, (SelectedArea)sa, (boolean)false, (boolean[])geospatialKosher);
            this.mapSpecies(q, taxon, rank, 0, 21, null, -1, 3, 0.6f, Util.nextColour(), mapExpertDistributions);
            LOGGER.debug((Object)(">>>>> " + taxon + ", " + rank + " <<<<<"));
        }
    }

    public void reorderList(Listitem dragged, Listitem dropped) {
        LOGGER.debug((Object)(dragged.getLabel() + " dropped on " + dropped.getLabel()));
        List activeLayers = this.getPortalSession().getActiveLayers();
        int droppedIndex = activeLayers.indexOf(dropped.getValue());
        ListModelList model = (ListModelList)this.activeLayersList.getModel();
        model.remove(dragged.getValue());
        model.add(droppedIndex, dragged.getValue());
        this.openLayersJavascript.updateMapLayerIndexesNow(activeLayers);
        this.redrawLayersList();
        this.refreshContextualMenu();
    }

    public void refreshActiveLayer(MapLayer mapLayer) {
        ListModelList model = (ListModelList)this.activeLayersList.getModel();
        int index = model.indexOf((Object)mapLayer);
        if (index >= 0) {
            model.remove(index);
            model.add(index, (Object)mapLayer);
            this.activeLayersList.setSelectedIndex(index);
        }
        this.adjustActiveLayersList();
    }

    public void activateLink(String uri, String label, boolean isExternal) {
        this.activateLink(uri, label, isExternal, "");
    }

    public void activateLink(String uri, String label, boolean isExternal, String downloadPid) {
        this.closeExternalContentWindow();
        Window externalContentWindow = (Window)Executions.createComponents((String)"WEB-INF/zul/ExternalContent.zul", (Component)this.layerControls, null);
        if (isExternal) {
            Clients.evalJavaScript((String)("window.location.href ='" + uri + "';"));
        } else {
            Iframe iframe = (Iframe)externalContentWindow.getFellow("externalContentIframe");
            Html html = (Html)externalContentWindow.getFellow("externalContentHTML");
            String newUri = uri;
            if (newUri.charAt(0) == '*') {
                String content;
                newUri = newUri.substring(1);
                iframe.setHeight("0px");
                iframe.setSrc("");
                if ("download".equalsIgnoreCase(label)) {
                    String fastDownloadUrl = newUri.replaceFirst("/occurrences/download", "/occurrences/index/download");
                    StringBuilder sbContent = new StringBuilder();
                    sbContent.append("<p id='termsOfUseDownload' style='padding:10px; margin-bottom: 0;'>");
                    sbContent.append("By downloading this content you are agreeing to use it in accordance ");
                    sbContent.append("with the Atlas of Living Australia <a href='http://www.ala.org.au/about/terms-of-use/#TOUusingcontent'>Terms of Use</a>");
                    sbContent.append(" and any Data Provider Terms associated with the data download. ");
                    sbContent.append("<br/><br/>");
                    sbContent.append("Please provide the following details before downloading (* required)");
                    sbContent.append("</p>");
                    sbContent.append("    <form id='downloadForm' onSubmit='downloadSubmitButtonClick(); return false;' style='padding:10px;'>");
                    sbContent.append("        <input type='hidden' name='url' id='downloadUrl' value='").append(uri).append("'/>");
                    sbContent.append("        <input type='hidden' name='url' id='fastDownloadUrl' value='").append(fastDownloadUrl).append("'/>");
                    sbContent.append("        <fieldset>");
                    sbContent.append("            <p><label for='email'>Email</label>");
                    sbContent.append("                <input type='text' name='email' id='email' value='' size='30'  />");
                    sbContent.append("            </p>");
                    sbContent.append("            <p><label for='filename'>File Name</label>");
                    sbContent.append("                <input type='text' name='filename' id='filename' value='data' size='30'  />");
                    sbContent.append("            </p>");
                    sbContent.append("            <p><label for='reasonTypeId' style='vertical-align: top'>Download Reason *</label>");
                    sbContent.append("            <select name='reasonTypeId' id='reasonTypeId'>");
                    sbContent.append("            <option value=''>-- select a reason --</option>");
                    JSONArray dlreasons = CommonData.getDownloadReasons();
                    for (int i = 0; i < dlreasons.size(); ++i) {
                        JSONObject dlr = (JSONObject)dlreasons.get(i);
                        sbContent.append("            <option value='").append((Long)dlr.get((Object)"id")).append("'>").append(dlr.get((Object)"name")).append("</option>");
                    }
                    sbContent.append("            <select></p>");
                    sbContent.append("                    <input style='display:none' type='radio' name='downloadType' value='fast' class='tooltip' checked='checked' title='Faster download but fewer fields are included'>");
                    sbContent.append("            <p style='clear:both;'>&nbsp;</p>");
                    sbContent.append("            <p style='text-align:center;'><input type='submit' value='Download All Records' id='downloadSubmitButton'/></p>");
                    sbContent.append("        </fieldset>");
                    sbContent.append("    </form>");
                    content = sbContent.toString();
                } else {
                    content = newUri;
                }
                html.setContent(content);
                html.setStyle("overflow: scroll;padding: 0 10px;");
                ((ExternalContentComposer)externalContentWindow).setSrc("");
                externalContentWindow.getFellow("breakout").setVisible(false);
                externalContentWindow.setContentStyle("overflow:auto");
            } else {
                iframe.setHeight("100%");
                iframe.setSrc(newUri);
                html.setContent("");
                ((ExternalContentComposer)externalContentWindow).setSrc(newUri);
                ((Toolbarbutton)externalContentWindow.getFellow("breakout")).setHref(newUri);
                externalContentWindow.getFellow("breakout").setVisible(true);
                externalContentWindow.setContentStyle("overflow:visible");
            }
            if (StringUtils.isNotBlank((String)downloadPid)) {
                String downloadUrl = CommonData.getSatServer() + "/ws/download/" + downloadPid;
                if (downloadPid.startsWith("http")) {
                    downloadUrl = downloadPid;
                }
                ((Toolbarbutton)externalContentWindow.getFellow("download")).setHref(downloadUrl);
                externalContentWindow.getFellow("download").setVisible(true);
            } else {
                ((Toolbarbutton)externalContentWindow.getFellow("download")).setHref("");
                externalContentWindow.getFellow("download").setVisible(false);
            }
            ((Caption)externalContentWindow.getFellow("caption")).setLabel(label);
            externalContentWindow.setPosition("center");
            try {
                externalContentWindow.setParent((Component)this.layerControls);
                externalContentWindow.doModal();
            }
            catch (Exception e) {
                LOGGER.error((Object)"error opening information popup", (Throwable)e);
            }
        }
    }

    public boolean activateLayer(MapLayer mapLayer, boolean doJavaScript) {
        return this.activateLayer(mapLayer, doJavaScript, false);
    }

    public boolean activateLayer(MapLayer mapLayer, boolean doJavaScript, boolean skipTree) {
        List activeLayers = this.getPortalSession().getActiveLayers();
        boolean layerAdded = false;
        if (!(this.activeLayersList.getModel() instanceof ListModelList)) {
            LOGGER.debug((Object)"changing model for Active Layers to ListModelList");
            this.activeLayersList.setModel((ListModel)new ListModelList(activeLayers, true));
        }
        if (!activeLayers.contains(mapLayer)) {
            this.activeLayersList.setItemRenderer((ListitemRenderer)this.activeLayerRenderer);
            ((ListModelList)this.activeLayersList.getModel()).add(0, (Object)mapLayer);
            this.activeLayersList.setSelectedIndex(0);
            if (doJavaScript) {
                this.openLayersJavascript.activateMapLayerNow(mapLayer);
            }
            this.updateLayerControls();
            layerAdded = true;
        } else {
            LOGGER.debug((Object)"not displaying map layer because its already listed or is marked non-displayable");
        }
        this.adjustActiveLayersList();
        this.refreshContextualMenu();
        return layerAdded;
    }

    public void deactiveLayer(MapLayer itemToRemove, boolean updateMapAndLayerControls, boolean recursive) {
        this.deactiveLayer(itemToRemove, updateMapAndLayerControls, recursive, false);
    }

    public void deactiveLayer(MapLayer itemToRemove, boolean updateMapAndLayerControls, boolean recursive, boolean updateOnly) {
        if (itemToRemove != null) {
            List activeLayers;
            Query q = itemToRemove.getSpeciesQuery();
            if (q instanceof UserDataQuery) {
                String pid = q.getQ();
                Map htUserSpecies = (Map)this.getMapComposer().getSession().getAttribute("userpoints");
                if (htUserSpecies != null) {
                    htUserSpecies.remove(pid);
                }
            }
            if ((activeLayers = this.getPortalSession().getActiveLayers()) != null) {
                LOGGER.debug((Object)("obtained activelayers arraylist from session, count: " + activeLayers.size()));
                if (!activeLayers.isEmpty()) {
                    ListModelList listmodel = (ListModelList)this.activeLayersList.getModel();
                    if (listmodel != null) {
                        listmodel.remove((Object)itemToRemove);
                        if (activeLayers.isEmpty()) {
                            this.lblSelectedLayer.setValue("No layers added");
                        }
                    }
                } else {
                    LOGGER.debug((Object)"active layers list is empty, so not updating it");
                }
            }
            if (updateMapAndLayerControls) {
                if (!updateOnly) {
                    this.openLayersJavascript.removeMapLayerNow(itemToRemove);
                }
                this.updateLayerControls();
                this.removeFromSession(itemToRemove.getName());
            }
            if (recursive && itemToRemove.hasChildren()) {
                for (MapLayer child : itemToRemove.getChildren()) {
                    this.deactiveLayer(child, updateMapAndLayerControls, true);
                }
            }
        }
        this.refreshContextualMenu();
    }

    public void removeFromList(MapLayer itemToRemove) {
        List activeLayers;
        if (itemToRemove != null && (activeLayers = this.getPortalSession().getActiveLayers()) != null) {
            LOGGER.debug((Object)("obtained activelayers arraylist from session, count: " + activeLayers.size()));
            if (!activeLayers.isEmpty()) {
                ListModelList listmodel = (ListModelList)this.activeLayersList.getModel();
                if (listmodel != null) {
                    listmodel.remove((Object)itemToRemove);
                }
            } else {
                LOGGER.debug((Object)"active layers list is empty, so not updating it");
            }
        }
        this.refreshContextualMenu();
    }

    public void showMessage(String message) {
        ErrorMessageComposer window = (ErrorMessageComposer)Executions.createComponents((String)"WEB-INF/zul/ErrorMessage.zul", null, null);
        window.setMessage(message);
        window.doOverlapped();
    }

    public void showMessage(String message, Component parent) {
        ErrorMessageComposer window = (ErrorMessageComposer)Executions.createComponents((String)"WEB-INF/zul/ErrorMessage.zul", (Component)parent, null);
        window.setMessage(message);
        if (this.mp) {
            try {
                window.setParent(parent);
                window.doModal();
            }
            catch (Exception e) {
                LOGGER.error((Object)"error opening message window", (Throwable)e);
            }
        } else {
            window.doOverlapped();
        }
    }

    public void showMessage(String message, String messageDetail) {
        this.showMessage(this.languagePack.getLang("default_message_title"), message, messageDetail);
    }

    public void showMessage(String title, String message, String messageDetail) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("messageTitle", title);
        params.put("message", message);
        params.put("messageDetail", messageDetail);
        Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/ErrorMessageWithDetail.zul", null, params);
        window.doOverlapped();
    }

    public void showMessage(String title, String message, String messageDetail, String linkTitle, String linkHref, String rawMessageTitle, String rawMessage) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("messageTitle", title);
        params.put("message", message);
        params.put("messageDetail", messageDetail);
        params.put("linkTitle", linkTitle);
        params.put("linkHref", linkHref);
        params.put("rawMessageTitle", rawMessageTitle);
        this.rawMessageIframeHack.setContent(null);
        Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/ErrorMessageWithDetailAndRawData.zul", null, params);
        Component holder = window.getFellow("rawMessageHolder");
        this.rawMessageIframeHack.setParent(holder);
        window.doOverlapped();
        this.rawMessageIframeHack.setParent((Component)this.rawMessageHackHolder);
    }

    public void addUserDefinedLayerToMenu(MapLayer mapLayer, boolean activate) {
        if (this.safeToPerformMapAction()) {
            this.activateLayer(mapLayer, true, true);
            LOGGER.debug((Object)"leaving addUserDefinedLayerToMenu");
        }
    }

    public void load() {
        LOGGER.debug((Object)"entering loadMapLayers");
        PortalSession portalSession = this.getPortalSession();
        List activeLayers = portalSession.getActiveLayers();
        ListModelList activeLayerModel = new ListModelList(activeLayers, true);
        if (activeLayers.isEmpty()) {
            MapLayer ml = this.remoteMap.createLocalLayer(12, "Map options");
            ml.setRemoveable(false);
            activeLayers.add(ml);
        }
        this.activeLayersList.setModel((ListModel)activeLayerModel);
        this.activeLayersList.setItemRenderer((ListitemRenderer)this.activeLayerRenderer);
        this.activeLayersList.setSelectedIndex(activeLayerModel.size() - 1);
        this.updateLayerControls();
        this.refreshContextualMenu();
    }

    public MapLayer addObjectByPid(String pid, String displayName, double radiusKm) {
        JSONParser jp = new JSONParser();
        JSONObject obj = null;
        try {
            obj = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/object/" + pid)));
        }
        catch (ParseException e) {
            LOGGER.error((Object)("failed to parse for object: " + pid));
        }
        String areaName = obj.get((Object)"name").toString();
        MapLayer mapLayer = this.getMapComposer().addWMSLayer("PID:" + pid, displayName == null ? areaName : displayName, obj.get((Object)"wmsurl").toString(), 0.6f, null, null, 11, null, null);
        if (mapLayer == null) {
            return null;
        }
        mapLayer.setPolygonLayer(true);
        String bbox = obj.get((Object)"bbox").toString();
        String fid = obj.get((Object)"fid").toString();
        MapLayerMetadata md = mapLayer.getMapLayerMetadata();
        Facet facet = null;
        if (CommonData.getLayer((String)fid) != null && CommonData.getFacetLayerNameDefault((String)fid) != null) {
            JSONObject field = null;
            try {
                field = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/field/" + fid + "?pageSize=0")));
            }
            catch (ParseException e) {
                LOGGER.error((Object)("failed to parse for field: " + fid));
            }
            if (field.containsKey((Object)"indb") && "true".equalsIgnoreCase(field.get((Object)"indb").toString())) {
                String spid = field.get((Object)"spid").toString();
                md.setMoreInfo(CommonData.getLayersServer() + "/layers/view/more/" + spid);
                facet = Util.getFacetForObject((String)areaName, (String)fid);
            }
        }
        try {
            List dbb = Util.getBoundingBox((String)obj.get((Object)"bbox").toString());
            boolean point = false;
            if (((Double)dbb.get(0)).floatValue() == ((Double)dbb.get(2)).floatValue() && ((Double)dbb.get(1)).floatValue() == ((Double)dbb.get(3)).floatValue()) {
                point = true;
                mapLayer.setWKT("POINT(" + ((Double)dbb.get(0)).floatValue() + " " + ((Double)dbb.get(1)).floatValue() + ")");
                double radius = radiusKm * 1000.0;
                String wkt = Util.createCircleJs((double)((Double)dbb.get(0)).floatValue(), (double)((Double)dbb.get(1)).floatValue(), (double)radius);
                this.getMapComposer().removeLayer(displayName);
                mapLayer = this.getMapComposer().addWKTLayer(wkt, displayName, displayName);
                dbb = Util.getBoundingBox((String)wkt);
            }
            md.setBbox(dbb);
            mapLayer.setAreaSqKm(obj.get((Object)"area_km").toString());
        }
        catch (Exception e) {
            LOGGER.debug((Object)("failed to parse: " + bbox), (Throwable)e);
        }
        if (facet != null) {
            ArrayList<Facet> facets = new ArrayList<Facet>();
            facets.add(facet);
            mapLayer.setFacets(facets);
            if (!CommonData.getLayer((String)fid).get((Object)"path_orig").toString().contains("diva")) {
                mapLayer.setWktUrl(CommonData.getLayersServer() + "/shape/wkt/" + pid);
            }
        } else {
            mapLayer.setWKT(Util.readUrl((String)(CommonData.getLayersServer() + "/shape/wkt/" + pid)));
        }
        int colour = Util.nextColour();
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        mapLayer.setRedVal(r);
        mapLayer.setGreenVal(g);
        mapLayer.setBlueVal(b);
        mapLayer.setDynamicStyle(true);
        this.getMapComposer().applyChange(mapLayer);
        this.getMapComposer().updateLayerControls();
        return mapLayer;
    }

    public MapLayer addWMSLayer(String name, String displayName, String uri, float opacity, String metadata, String legendUri, int subType, String cqlfilter, String envParams) {
        return this.addWMSLayer(name, displayName, uri, opacity, metadata, legendUri, subType, cqlfilter, envParams, null);
    }

    public MapLayer addWMSLayer(String name, String displayName, String uri, float opacity, String metadata, String legendUri, int subType, String cqlfilter, String envParams, Query q) {
        MapLayer mapLayer = null;
        if (this.safeToPerformMapAction()) {
            if (this.portalSessionUtilities.getUserDefinedById(this.getPortalSession(), uri) == null) {
                mapLayer = this.remoteMap.createAndTestWMSLayer(name, uri, opacity);
                mapLayer.setDisplayName(displayName);
                if (q != null) {
                    mapLayer.setSpeciesQuery(q);
                }
                mapLayer.setSubType(subType);
                mapLayer.setCql(cqlfilter);
                mapLayer.setEnvParams(envParams);
                String newUri = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=9&LAYER=" + mapLayer.getLayer();
                mapLayer.setDefaultStyleLegendUri(newUri);
                if (metadata != null && metadata.startsWith("http")) {
                    mapLayer.getMapLayerMetadata().setMoreInfo(metadata + "\n" + displayName);
                } else {
                    mapLayer.getMapLayerMetadata().setMoreInfo(metadata);
                }
                if (legendUri != null) {
                    WMSStyle style = new WMSStyle();
                    style.setName("Default");
                    style.setDescription("Default style");
                    style.setTitle("Default");
                    style.setLegendUri(legendUri);
                    mapLayer.addStyle(style);
                    mapLayer.setSelectedStyleIndex(1);
                    LOGGER.debug((Object)("adding WMSStyle with legendUri: " + legendUri));
                    mapLayer.setDefaultStyleLegendUriSet(true);
                }
                this.addUserDefinedLayerToMenu(mapLayer, true);
            } else {
                this.showMessage(this.languagePack.getLang("wms_layer_already_exists"));
                LOGGER.debug((Object)("refusing to add a new layer with URI " + uri + " because it already exists in the menu"));
            }
        }
        return mapLayer;
    }

    public MapLayer getMapLayer(String label) {
        List udl = this.getPortalSession().getActiveLayers();
        Iterator iudl = udl.iterator();
        LOGGER.debug((Object)("session active layers: " + udl.size() + " looking for: " + label));
        while (iudl.hasNext()) {
            MapLayer ml = (MapLayer)iudl.next();
            LOGGER.debug((Object)("layer: " + ml.getName() + " - " + ml.getId() + " - " + ml.getNameJS()));
            if (!ml.getName().equals(label)) continue;
            return ml;
        }
        return this.getMapLayerDisplayName(label);
    }

    public int getMapLayerIdxInLegend(String label) {
        List udl = this.getPortalSession().getActiveLayers();
        Iterator iudl = udl.iterator();
        LOGGER.debug((Object)("session active layers: " + udl.size() + " looking for: " + label));
        int pos = -1;
        while (iudl.hasNext()) {
            ++pos;
            MapLayer ml = (MapLayer)iudl.next();
            LOGGER.debug((Object)("layer: " + ml.getName() + " - " + ml.getId() + " - " + ml.getNameJS()));
            if (!ml.getName().equals(label)) continue;
            return pos;
        }
        return 0;
    }

    public MapLayer getMapLayerDisplayName(String label) {
        List udl = this.getPortalSession().getActiveLayers();
        Iterator iudl = udl.iterator();
        LOGGER.debug((Object)("session active layers: " + udl.size() + " looking for: " + label));
        while (iudl.hasNext()) {
            MapLayer ml = (MapLayer)iudl.next();
            LOGGER.debug((Object)("layer: " + ml.getName() + " - " + ml.getId() + " - " + ml.getNameJS()));
            if (!ml.getDisplayName().equals(label)) continue;
            return ml;
        }
        return null;
    }

    public void removeLayer(String label) {
        if (this.safeToPerformMapAction()) {
            MapLayer mapLayer = this.getMapLayer(label);
            if (mapLayer != null) {
                this.deactiveLayer(mapLayer, true, false);
            } else {
                this.showMessage(this.languagePack.getLang("wms_layer_remove_error"));
                LOGGER.debug((Object)("unable to remove layer with label" + label));
            }
        }
    }

    public MapLayer addImageLayer(String id, String label, String uri, float opacity, List<Double> bbox, int subType) {
        MapLayer imageLayer = this.getMapLayer(label);
        if (this.safeToPerformMapAction()) {
            if (imageLayer == null) {
                LOGGER.debug((Object)"activating new layer");
                imageLayer = new MapLayer();
                imageLayer.setType(9);
                imageLayer.setName(label);
                imageLayer.setSubType(subType);
                imageLayer.setId(label);
                imageLayer.setLayer("wms.png");
                imageLayer.setUri(uri);
                imageLayer.setOpacity(opacity);
                imageLayer.getMapLayerMetadata().setBbox(bbox);
                this.activateLayer(imageLayer, true, true);
            } else {
                LOGGER.debug((Object)"refreshing exisiting layer");
                imageLayer.setUri(uri);
                imageLayer.setOpacity(opacity);
                this.openLayersJavascript.reloadMapLayerNow(imageLayer);
            }
        }
        return imageLayer;
    }

    public MapLayer getActiveLayersSelection(boolean alertOnNoSelection) {
        MapLayer mapLayer = null;
        Listitem selected = this.activeLayersList.getSelectedItem();
        if (selected != null) {
            mapLayer = (MapLayer)selected.getValue();
        } else if (alertOnNoSelection) {
            this.showMessage(this.languagePack.getLang("active_layer_not_selected"));
        }
        return mapLayer;
    }

    public void mapLoaded(String text) {
        boolean loaded = Boolean.parseBoolean(text);
        this.getPortalSession().setMapLoaded(loaded);
        BoundingBox bb = this.getPortalSession().getDefaultBoundingBox();
        if (loaded) {
            LOGGER.debug((Object)"map is now loaded. let's try mapping.");
            MapLayer ml = this.loadUrlParameters();
            if (ml == null) {
                this.openLayersJavascript.useAdditionalScript();
            }
        }
        this.openLayersJavascript.zoomToBoundingBox(bb, false);
    }

    public boolean safeToPerformMapAction() {
        boolean safe;
        if (this.openLayersJavascript.mapLoaded()) {
            safe = true;
        } else {
            this.showMessage(this.languagePack.getLang("map_load_error"));
            safe = false;
        }
        return safe;
    }

    public void afterCompose() {
        super.afterCompose();
        this.applyWindowParams();
        this.load();
    }

    void applyWindowParams() {
        String s = Executions.getCurrent().getParameter("p");
        if (s != null) {
            String[] pa = s.split(",");
            this.setWidth(pa[0] + "px");
            if (pa.length > 1) {
                this.setHeight(pa[1] + "px");
            }
        }
    }

    public String getCookieValue(String cookieName) {
        try {
            for (Cookie c : ((HttpServletRequest)Executions.getCurrent().getNativeRequest()).getCookies()) {
                if (!c.getName().equals(cookieName)) continue;
                return c.getValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void mapMultiQueryLayers(boolean[] geospatialKosher, String baseBiocacheUrl, String baseWSBiocacheUrl, boolean supportDynamic) {
        Map userParams = this.getQueryParameterMap(Executions.getCurrent().getDesktop().getQueryString());
        if (userParams != null) {
            for (Map.Entry entry : userParams.entrySet()) {
                String key = (String)entry.getKey();
                if (!this.layerNameParamPattern.matcher(key).find()) continue;
                String layerName = (String)entry.getValue();
                String query = (String)userParams.get(key + ".q");
                String style = (String)userParams.get(key + ".s");
                LOGGER.debug((Object)String.format("Add layer: '%s', query: '%s', style: '%s', key: '%s'", layerName, query, style, key));
                if (query != null && query.contains(",")) {
                    Object[] queryComponents = query.split(",");
                    query = StringUtils.join((Object[])queryComponents, (String)" OR ");
                }
                if (query == null || style == null || layerName == null) continue;
                BiocacheQuery q = new BiocacheQuery(null, null, query, null, true, geospatialKosher, baseBiocacheUrl, baseWSBiocacheUrl, supportDynamic);
                this.mapSpecies((Query)q, layerName, "species", q.getOccurrenceCount(), 21, null, 0, 4, 0.8f, Integer.decode(style).intValue(), false);
            }
        }
    }

    public void mapLayerFromParams() {
        Map userParams = this.getQueryParameterMap(Executions.getCurrent().getDesktop().getQueryString());
        if (userParams != null) {
            String[] layers;
            String layersCSV = (String)userParams.get("layers");
            if (StringUtils.trimToNull((String)layersCSV) == null) {
                return;
            }
            for (String s : layers = layersCSV.split(",")) {
                JSONArray layerlist = CommonData.getLayerListJSONArray();
                for (int j = 0; j < layerlist.size(); ++j) {
                    JSONObject jo = (JSONObject)layerlist.get(j);
                    String name = jo.get((Object)"name").toString();
                    if (!name.equalsIgnoreCase(s)) continue;
                    String uid = jo.get((Object)"id").toString();
                    String type = jo.get((Object)"type").toString();
                    String treeName = StringUtils.capitalize((String)jo.get((Object)"displayname").toString());
                    String treePath = jo.get((Object)"displaypath").toString();
                    String legendurl = CommonData.getGeoServer() + "/wms?REQUEST=GetLegendGraphic&VERSION=1.0.0&FORMAT=image/png&WIDTH=20&HEIGHT=9&LAYER=" + s;
                    String metadata = CommonData.getLayersServer() + "/layers/view/more/" + uid;
                    this.getMapComposer().addWMSLayer(s, treeName, treePath, 0.75f, metadata, legendurl, "environmental".equalsIgnoreCase(type) ? 20 : 19, null, null, null);
                }
            }
        }
    }

    public void mapObjectFromParams() {
        Map userParams = this.getQueryParameterMap(Executions.getCurrent().getDesktop().getQueryString());
        if (userParams != null) {
            String pidsAsString = (String)userParams.get("pid");
            if (StringUtils.trimToNull((String)pidsAsString) == null) {
                return;
            }
            String[] pids = pidsAsString.trim().split(",");
            List mapLayers = this.getMapComposer().getPortalSession().getActiveLayers();
            HashMap<String, MapLayer> names = new HashMap<String, MapLayer>();
            for (MapLayer ml : mapLayers) {
                names.put(ml.getName(), ml);
            }
            for (String pid : pids) {
                MapLayer mapLayer;
                if (names.get("PID:" + pid) == null) {
                    mapLayer = this.getMapComposer().addObjectByPid(pid, null, 1.0);
                    if (pids.length != 1) continue;
                    this.getMapComposer().zoomToExtent(mapLayer);
                    continue;
                }
                if (pids.length != 1) continue;
                mapLayer = (MapLayer)names.get("PID:" + pid);
                this.getMapComposer().zoomToExtent(mapLayer);
            }
        }
    }

    private MapLayer loadUrlParameters() {
        MapLayer mapLayer = null;
        String params = null;
        try {
            String analysisLayerSelections = this.getCookieValue("analysis_layer_selections");
            if (analysisLayerSelections != null) {
                String[] s = URLDecoder.decode(analysisLayerSelections, "UTF-8").split("\n");
                for (int i = 0; i < s.length; ++i) {
                    String[] ls = s[i].split(" // ");
                    if (ls.length <= 1) continue;
                    this.selectedLayers.add(new LayerSelection(ls[0], ls[1]));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error loading url parameters", (Throwable)e);
        }
        String tool = null;
        String toolParameters = null;
        try {
            params = Executions.getCurrent().getDesktop().getQueryString();
            LOGGER.debug((Object)("User params: " + params));
            List userParams = Util.getQueryParameters((String)params);
            StringBuilder sb = new StringBuilder();
            String qc = null;
            String bs = null;
            String ws = null;
            String wkt = null;
            int size = 4;
            float opacity = 0.6f;
            int colour = 0xFF0000;
            String pointtype = "auto";
            String bb = null;
            Double lat = null;
            Double lon = null;
            Double radius = null;
            String colourBy = null;
            String savedsession = "";
            String s = null;
            boolean[] geospatialKosher = null;
            boolean supportDynamic = false;
            String qname = null;
            Boolean includeDistributions = true;
            for (int i = 0; i < userParams.size(); ++i) {
                String key = (String)((Map.Entry)userParams.get(i)).getKey();
                String value = (String)((Map.Entry)userParams.get(i)).getValue();
                if ("wmscache".equals(key)) {
                    this.useSpeciesWMSCache = value;
                }
                if ("tool".equals(key)) {
                    tool = value;
                }
                if ("toolParameters".equals(key)) {
                    toolParameters = value;
                }
                if ("species_lsid".equals(key)) {
                    sb.append("lsid:").append(value);
                    continue;
                }
                if ("q".equals(key)) {
                    s = value;
                    if (!value.startsWith("(") || !value.endsWith(")") || value.contains(" ")) continue;
                    s = value.substring(1, value.length() - 2);
                    continue;
                }
                if ("qname".equals(key)) {
                    qname = value;
                    continue;
                }
                if ("fq".equals(key)) {
                    boolean[] gk = BiocacheQuery.parseGeospatialKosher((String)value);
                    if (gk != null) {
                        geospatialKosher = gk;
                        continue;
                    }
                    sb.append("&").append(key).append("=").append(value);
                    continue;
                }
                if ("qc".equals(key)) {
                    qc = "&qc=" + URLEncoder.encode(value, "UTF-8");
                    continue;
                }
                if ("bs".equals(key)) {
                    bs = value;
                    continue;
                }
                if ("ws".equals(key)) {
                    ws = value;
                    continue;
                }
                if ("wkt".equals(key)) {
                    wkt = value;
                    continue;
                }
                if ("psize".equals(key)) {
                    size = Integer.parseInt(value);
                    continue;
                }
                if ("popacity".equals(key)) {
                    opacity = Float.parseFloat(value);
                    continue;
                }
                if ("pcolour".equals(key)) {
                    colour = Integer.parseInt(value, 16);
                    continue;
                }
                if ("ptype".equals(key)) {
                    pointtype = value;
                    continue;
                }
                if ("bbox".equals(key)) {
                    bb = value;
                    continue;
                }
                if ("lat".equals(key)) {
                    lat = Double.parseDouble(value);
                    continue;
                }
                if ("lon".equals(key)) {
                    lon = Double.parseDouble(value);
                    continue;
                }
                if ("radius".equals(key)) {
                    radius = Double.parseDouble(value);
                    continue;
                }
                if ("ss".equals(key)) {
                    savedsession = value.trim();
                    continue;
                }
                if ("dynamic".equals(key)) {
                    supportDynamic = Boolean.parseBoolean(value);
                    continue;
                }
                if ("cm".equals(key)) {
                    colourBy = value.trim();
                    continue;
                }
                if (!"includeDistributions".equals(key)) continue;
                try {
                    includeDistributions = Boolean.parseBoolean(value.trim());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (lat != null && lon != null && radius != null) {
                wkt = Util.createCircleJs((double)lon, (double)lat, (double)(radius * 1000.0));
            }
            if (StringUtils.isNotBlank((String)savedsession)) {
                this.loadUserSession(savedsession);
            } else {
                LOGGER.debug((Object)"No saved session to load");
            }
            LOGGER.debug((Object)("url query: " + sb.toString()));
            if (sb.length() > 0 || s != null && s.length() > 0) {
                s = s != null ? s + sb.toString() : sb.toString();
                BiocacheQuery q = new BiocacheQuery(null, wkt, s, null, true, geospatialKosher, bs, ws, supportDynamic);
                if (qc != null) {
                    q.setQc(qc);
                }
                if (this.getMapLayerDisplayName(q.getSolrName()) == null) {
                    if (bb == null) {
                        List bbox = q.getBBox();
                        String script = "map.zoomToExtent(new OpenLayers.Bounds(" + bbox.get(0) + "," + bbox.get(1) + "," + bbox.get(2) + "," + bbox.get(3) + ")" + ".transform(" + "  new OpenLayers.Projection('EPSG:4326')," + "  map.getProjectionObject()));";
                        this.openLayersJavascript.setAdditionalScript(script);
                    }
                    int setGrid = -1;
                    if (pointtype.equals("grid")) {
                        setGrid = 1;
                    } else if ("point".equals(pointtype)) {
                        setGrid = 0;
                    }
                    mapLayer = this.mapSpecies((Query)q, qname != null ? qname : q.getSolrName(), "species", q.getOccurrenceCount(), 21, null, setGrid, size, opacity, colour, colourBy, includeDistributions.booleanValue());
                }
            }
            this.mapMultiQueryLayers(geospatialKosher, bs, ws, supportDynamic);
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Error loading url parameters: " + params), (Throwable)e);
        }
        this.mapLayerFromParams();
        this.mapObjectFromParams();
        if (tool != null) {
            try {
                JSONParser jp = new JSONParser();
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (toolParameters != null) {
                    JSONObject jo = (JSONObject)jp.parse(toolParameters);
                    for (Object key : jo.keySet()) {
                        map.put(key.toString(), jo.get(key));
                    }
                }
                if ("phylogeneticdiversity".equals(tool)) {
                    this.openModal("WEB-INF/zul/tool/PhylogeneticDiversity.zul", map, "addtoolwindow");
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("failed to open tool: " + tool), (Throwable)e);
            }
        }
        return mapLayer;
    }

    public void onActivateLink(ForwardEvent event) {
        Component component = event.getOrigin().getTarget();
        Object oLink = component.getAttribute("link");
        if (oLink instanceof String) {
            String uri = (String)oLink;
            String label = (String)component.getAttribute("label");
            this.activateLink(uri, label, false);
        }
    }

    public MapLayer addPointsOfInterestLayer(String wkt, String label, String displayName) {
        MapLayer mapLayer = null;
        if (this.safeToPerformMapAction()) {
            if (this.portalSessionUtilities.getUserDefinedById(this.getPortalSession(), label) == null) {
                mapLayer = this.remoteMap.createWKTLayer(wkt, label);
                mapLayer.setDisplayName(displayName);
                mapLayer.setPointsOfInterestWS(CommonData.getLayersServer() + "/intersect/poi/wkt");
                mapLayer.setOpacity(0.4f);
                mapLayer.setDynamicStyle(true);
                this.activateLayer(mapLayer, true, true);
            } else {
                this.showMessage("WKT layer already exists");
                LOGGER.debug((Object)("refusing to add a new layer with name " + label + " because it already exists in the menu"));
            }
        }
        return mapLayer;
    }

    public MapLayer addWKTLayer(String wkt, String label, String displayName) {
        if (wkt != null) {
            wkt = Util.fixWkt((String)wkt);
        }
        MapLayer mapLayer = null;
        if (this.safeToPerformMapAction()) {
            if (this.portalSessionUtilities.getUserDefinedById(this.getPortalSession(), label) == null) {
                mapLayer = this.remoteMap.createWKTLayer(wkt, label);
                mapLayer.setDisplayName(displayName);
                mapLayer.setOpacity(0.4f);
                mapLayer.setDynamicStyle(true);
                this.activateLayer(mapLayer, true, true);
            } else {
                this.showMessage("WKT layer already exists");
                LOGGER.debug((Object)("refusing to add a new layer with name " + label + " because it already exists in the menu"));
            }
        }
        return mapLayer;
    }

    public void onClick$reloadPortal() {
        try {
            Messagebox.show((String)"Reset map to initial empty state, with no layers and default settings?", (String)"Reset Map", (int)48, (String)"z-messagebox-icon z-messagebox-question", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error reloading portal", (Throwable)e);
        }
    }

    void reloadPortal() {
        PortalSession portalSession = this.getPortalSession();
        this.getSession().removeAttribute("speciesfilters");
        SessionInitImpl sessionInit = new SessionInitImpl();
        try {
            sessionInit.init(Sessions.getCurrent(), null);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Error creating replacement session information after user clicked reload portal", (Throwable)ex);
        }
        portalSession = this.getPortalSession();
        if (portalSession == null) {
            LOGGER.error((Object)"Null portal session created after clicking reset map, sending user to error page");
            try {
                Executions.getCurrent().forward("/WEB-INF/jsp/Error.jsp");
            }
            catch (IOException ex) {
                LOGGER.error((Object)"error redirecting to error page", (Throwable)ex);
            }
        } else {
            Executions.getCurrent().sendRedirect(CommonData.getWebportalServer() + "/");
        }
    }

    public void onReloadLayers(Event event) {
        String tbxReloadLayers;
        if (event == null) {
            this.mapZoomLevel = this.getLeftmenuSearchComposer().getZoom();
            tbxReloadLayers = new StringBuffer().append("z=").append(String.valueOf(this.mapZoomLevel)).append("&amp;b=").append(this.getLeftmenuSearchComposer().getViewportBoundingBox().toString()).toString();
        } else {
            String s = tbxReloadLayers = (String)event.getData();
            int s1 = s.indexOf("z=");
            int s2 = s.indexOf(38);
            if (s1 >= 0) {
                this.mapZoomLevel = s2 >= 0 ? Integer.parseInt(s.substring(s1 + 2, s2)) : Integer.parseInt(s.substring(s1 + 2));
            }
        }
        LOGGER.debug((Object)("tbxReloadLayers.getValue(): " + tbxReloadLayers));
        List udl = this.getPortalSession().getActiveLayers();
        Iterator iudl = udl.iterator();
        ArrayList<String> processedLayers = new ArrayList<String>();
        String reloadScript = "";
        while (iudl.hasNext()) {
            MapLayer ml = (MapLayer)iudl.next();
            if (processedLayers.contains(ml.getName())) {
                LOGGER.debug((Object)(ml.getName() + " already processed."));
                continue;
            }
            LOGGER.debug((Object)("checking reload layer: " + ml.getName() + " - " + ml.getId() + " - " + ml.getNameJS() + " -> type: " + ml.getType() + "," + ml.getGeometryType()));
            processedLayers.add(ml.getName());
        }
        if (reloadScript.length() > 0) {
            this.openLayersJavascript.execute(this.openLayersJavascript.getIFrameReferences() + reloadScript);
        }
    }

    public void onClick$onPrint(Event event) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("print_params", event.getData());
        params.put("base_layer", this.getBaseMap());
        params.put("bounding_box", this.getLeftmenuSearchComposer().getViewportBoundingBox());
        params.put("layers", this.getPortalSession().getActiveLayers());
        this.openModal("WEB-INF/zul/Printing.zul", params, "printingwindow");
    }

    public void onLayerLoaded(Event event) {
        this.tbxLayerLoaded = (String)event.getData();
        for (EventListener el : this.layerLoadedChangeEvents.values()) {
            try {
                el.onEvent(null);
            }
            catch (Exception ex) {
                LOGGER.error((Object)"error firing layer loaded listener", (Throwable)ex);
            }
        }
    }

    public String getLayerLoaded() {
        return this.tbxLayerLoaded;
    }

    public void addLayerLoadedEventListener(String eventName, EventListener eventListener) {
        this.layerLoadedChangeEvents.put(eventName, eventListener);
    }

    public void removeLayerLoadedEventListener(String eventName) {
        this.layerLoadedChangeEvents.remove(eventName);
    }

    public MapLayer mapPointsOfInterest(String wkt, String label, String displayName) {
        return this.addPointsOfInterestLayer(wkt, label, displayName);
    }

    public MapLayer mapSpecies(Query sq, String species, String rank, int count, int subType, String wkt, int setGrid, int size, float opacity, int colour, boolean mapExpertDistribution) {
        return this.mapSpecies(sq, species, rank, count, subType, wkt, setGrid, size, opacity, colour, null, mapExpertDistribution);
    }

    public MapLayer mapSpecies(Query sq, String species, String rank, int count, int subType, String wkt, int setGrid, int size, float opacity, int colour, String colourBy, boolean mapExpertDistribution) {
        boolean grid;
        MapLayer ml;
        int newCount;
        String newSpecies = species;
        String newRank = rank;
        if (newSpecies == null) {
            newSpecies = sq.getName();
            newRank = sq.getRank();
        }
        if ((newCount = count) < 0) {
            newCount = sq.getOccurrenceCount();
        }
        if ((ml = this.mapSpeciesFilter(sq, newSpecies, newRank, newCount, subType, wkt, grid = setGrid == 0 ? false : setGrid == 1 || sq.getOccurrenceCount() > Integer.parseInt(this.getSettingsSupplementary().getProperty("points_cluster_threshold")), size, opacity, colour, mapExpertDistribution)) != null) {
            if (colourBy != null) {
                ml.setColourMode(colourBy);
            }
            ml.getMapLayerMetadata().setOccurrencesCount(newCount);
            String layerType = "Species - Search";
            if (newSpecies.startsWith("Occurrences in ")) {
                layerType = "Species - Occurrences";
            } else if ("Species assemblage".equals(newSpecies)) {
                layerType = "Species - Assemblage";
            } else if (newSpecies.contains("My facet")) {
                layerType = "Species - Facet";
            }
            if (subType == 23) {
                layerType = "Import - Species";
            }
            if (subType == 21 && "user".equals(newRank)) {
                layerType = "Import - LSID";
            }
            if (sq instanceof BiocacheQuery) {
                BiocacheQuery bq = (BiocacheQuery)sq;
                String extra = bq.getWS() + "|" + bq.getBS() + "|" + bq.getFullQ(false);
                this.remoteLogger.logMapSpecies(ml.getDisplayName(), bq.getLsids(), wkt, layerType, extra);
            } else if (sq instanceof UserDataQuery) {
                this.remoteLogger.logMapSpecies(ml.getDisplayName(), "user-" + sq.getSpeciesCount() + " records", wkt, layerType, sq.getMetadataHtml());
            } else {
                this.remoteLogger.logMapSpecies(ml.getDisplayName(), newSpecies, wkt, layerType, sq.getMetadataHtml());
            }
            this.updateLayerControls();
            this.refreshContextualMenu();
            if (colourBy != null) {
                this.applyChange(ml);
            }
        }
        return ml;
    }

    void addLsidBoundingBoxToMetadata(MapLayerMetadata md, Query query) {
        List bb = query.getBBox();
        md.setBbox(bb);
    }

    public String getLayerBoundingBox(MapLayer ml) {
        String bbox = null;
        if (ml.getMapLayerMetadata().getBboxString() != null) {
            bbox = ml.getMapLayerMetadata().getBboxString();
        } else {
            Clients.evalJavaScript((String)("jq('$currentLayerExtent')[0].innerHTML=map.getLayersByName('" + ml.getName() + "')[0].getExtent().transform(map.getProjectionObject()," + "new OpenLayers.Projection('EPSG:4326')).toString();"));
            String bboxstr = this.currentLayerExtent.getValue();
            LOGGER.debug((Object)("Got bboxstr: " + bboxstr));
            if (bboxstr != null) {
                String[] b = bboxstr.split(",");
                ArrayList<Double> bb = new ArrayList<Double>();
                bb.add(Double.parseDouble(b[0]));
                bb.add(Double.parseDouble(b[1]));
                bb.add(Double.parseDouble(b[2]));
                bb.add(Double.parseDouble(b[3]));
                ml.getMapLayerMetadata().setBbox(bb);
                bbox = bboxstr;
            }
        }
        return bbox;
    }

    /*
     * Unable to fully structure code
     */
    private void loadDistributionMap(String lsids, String wkt) {
        newWkt = wkt;
        if ("POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))".equals(newWkt)) {
            newWkt = null;
        }
        wmsNames = CommonData.getSpeciesDistributionWMS((String)lsids);
        spcode = CommonData.getSpeciesDistributionSpcode((String)lsids);
        jp = new JSONParser();
        if (wmsNames.length > 0 && (newWkt == null || newWkt.equals("POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))"))) {
            for (i = 0; i < wmsNames.length; ++i) {
                if (this.getMapLayerWMS(wmsNames[i]) != null) continue;
                try {
                    jo = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/distribution/" + spcode[i] + "?nowkt=true")));
                    scientific = jo.get((Object)"scientific").toString();
                    distributionAreaName = jo.get((Object)"area_name").toString();
                    layerName = this.getNextAreaLayerName(scientific);
                    html = Util.getMetadataHtmlForDistributionOrChecklist((String)spcode[i], null, (String)layerName);
                    ml = this.addWMSLayer(layerName, this.getNextAreaLayerName(distributionAreaName), wmsNames[i], 0.35f, html, null, 11, null, null);
                    ml.setSPCode(spcode[i]);
                    this.setupMapLayerAsDistributionArea(ml);
                    continue;
                }
                catch (Exception e) {
                    MapComposer.LOGGER.error((Object)("failed to parse for distribution: " + spcode[i]));
                }
            }
        } else if (wmsNames.length > 0 && newWkt != null && !newWkt.equals("POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))")) {
            url = CommonData.getLayersServer() + "/distributions";
            try {
                client = new HttpClient();
                post = new PostMethod(url);
                post.addParameter("wkt", newWkt);
                post.addParameter("lsids", lsids);
                post.addRequestHeader("Accept", "application/json, text/javascript, */*");
                result = client.executeMethod((HttpMethod)post);
                if (result != 200) ** GOTO lbl55
                txt = post.getResponseBodyAsString();
                ja = (JSONArray)jp.parse(txt);
                found = new ArrayList<String>();
                for (i = 0; i < ja.size(); ++i) {
                    jo = (JSONObject)ja.get(i);
                    if (!jo.containsKey((Object)"wmsurl")) continue;
                    found.add(jo.get((Object)"wmsurl").toString());
                }
                for (i = 0; i < wmsNames.length; ++i) {
                    if (this.getMapLayerWMS(wmsNames[i]) != null) continue;
                    scientific = ((JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/distribution/" + spcode[i] + "?nowkt=true")))).get((Object)"scientific").toString();
                    layerName = this.getNextAreaLayerName(scientific + " area " + (i + 1));
                    html = Util.getMetadataHtmlForDistributionOrChecklist((String)spcode[i], null, (String)layerName);
                    ml = this.addWMSLayer(layerName, this.getNextAreaLayerName("Expert distribution: " + scientific), (String)found.get(i), 0.35f, html, null, 11, null, null);
                    ml.setSPCode(spcode[i]);
                    this.setupMapLayerAsDistributionArea(ml);
                }
            }
            catch (Exception e) {
                MapComposer.LOGGER.error((Object)("error posting distributions: " + url));
            }
        }
lbl55:
        // 6 sources

        this.openChecklistSpecies(lsids, newWkt, true);
    }

    void openChecklistSpecies(String lsids, String wkt, boolean mapIfOnlyOne) {
        block10: {
            try {
                String[] finallist = Util.getDistributionsOrChecklists((String)"checklists", (String)wkt, (String)lsids, null);
                if (finallist.length <= 1) break block10;
                if (mapIfOnlyOne && finallist.length == 2) {
                    try {
                        CSVReader csv = new CSVReader((Reader)new StringReader(finallist[1]));
                        String[] row = csv.readNext();
                        csv.close();
                        if (this.getMapLayerWMS(CommonData.getSpeciesChecklistWMSFromSpcode((String)row[0])[1]) == null) {
                            String[] mapping = CommonData.getSpeciesChecklistWMSFromSpcode((String)row[0]);
                            String displayName = mapping[0] + " area";
                            if (row[11] != null && row[11].length() > 0) {
                                displayName = row[11];
                            }
                            String layerName = this.getNextAreaLayerName(row[0] + " area");
                            String html = Util.getMetadataHtmlForDistributionOrChecklist((String)row[0], (String[])row, (String)layerName);
                            MapLayer ml = this.getMapComposer().addWMSLayer(layerName, displayName, mapping[1], 0.6f, html, null, 11, null, null);
                            ml.setSPCode(row[0]);
                            this.setupMapLayerAsDistributionArea(ml);
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"error opening checklist species", (Throwable)e);
                    }
                    break block10;
                }
                if (this.hasFellow("distributionresults")) {
                    this.getFellowIfAny("distributionresults").detach();
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("title", "Checklist species");
                params.put("size", String.valueOf(finallist.length - 1));
                params.put("table", finallist);
                Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/results/AnalysisDistributionResults.zul", (Component)this, params);
                try {
                    window.setParent((Component)this);
                    window.doModal();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error opening checklist species dialog", (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"error opening distribution area dialog", (Throwable)e);
            }
        }
    }

    void openAreaChecklist(String geomIdx, String lsids, String wkt) {
        try {
            String[] finallist = Util.getDistributionsOrChecklists((String)"checklists", (String)wkt, (String)lsids, (String)geomIdx);
            if (this.hasFellow("distributionresults")) {
                this.getFellowIfAny("distributionresults").detach();
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("title", "Checklist species");
            params.put("size", String.valueOf(finallist.length - 1));
            params.put("table", finallist);
            Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/results/AnalysisDistributionResults.zul", (Component)this, params);
            try {
                window.setParent((Component)this);
                window.doModal();
            }
            catch (Exception e) {
                LOGGER.error((Object)"error opening checklist species dialog", (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error opening distribution area dialog", (Throwable)e);
        }
    }

    void openDistributionSpecies(String lsids, String wkt) {
        try {
            String[] distributions = Util.getDistributionsOrChecklists((String)"distributions", (String)wkt, (String)lsids, null);
            if (distributions.length > 0) {
                if (this.hasFellow("distributionresults")) {
                    this.getFellowIfAny("distributionresults").detach();
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("table", distributions);
                params.put("title", "Expert distributions");
                params.put("size", String.valueOf(distributions.length - 1));
                Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/results/AnalysisDistributionResults.zul", (Component)this, params);
                try {
                    window.setParent((Component)this);
                    window.doModal();
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error opening analysisdistributionresults.zul", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error opening distribution species", (Throwable)e);
        }
    }

    public void setupMapLayerAsDistributionArea(MapLayer mapLayer) {
        try {
            JSONObject object;
            String spcode = mapLayer.getSPCode();
            String url = CommonData.getLayersServer() + "/distribution/" + spcode;
            String jsontxt = Util.readUrl((String)url);
            if (jsontxt == null || jsontxt.length() == 0) {
                url = CommonData.getLayersServer() + "/checklist/" + spcode;
                jsontxt = Util.readUrl((String)url);
            }
            if (jsontxt == null || jsontxt.length() == 0) {
                LOGGER.debug((Object)("******** failed to find wkt for " + mapLayer.getUri() + " > " + spcode));
                return;
            }
            JSONParser jp = new JSONParser();
            JSONObject jo = (JSONObject)jp.parse(jsontxt);
            if (!jo.containsKey((Object)"geometry")) {
                return;
            }
            mapLayer.setWKT(jo.get((Object)"geometry").toString());
            mapLayer.setPolygonLayer(true);
            Facet facet = null;
            if (jo.containsKey((Object)"pid") && jo.containsKey((Object)"area_name") && CommonData.getLayer((String)((String)(object = (JSONObject)jp.parse(Util.readUrl((String)(CommonData.getLayersServer() + "/object/" + jo.containsKey((Object)"pid"))))).get((Object)"fid"))) != null) {
                facet = Util.getFacetForObject((String)jo.get((Object)"area_name").toString(), (String)((String)object.get((Object)"fid")));
            }
            if (facet != null) {
                ArrayList<Facet> facets = new ArrayList<Facet>();
                facets.add(facet);
                mapLayer.setFacets(facets);
            }
            MapLayerMetadata md = mapLayer.getMapLayerMetadata();
            try {
                List bbox = jo.containsKey((Object)"bounding_box") ? Util.getBoundingBox((String)jo.get((Object)"bounding_box").toString()) : Util.getBoundingBox((String)jo.get((Object)"geometry").toString());
                md.setBbox(bbox);
            }
            catch (Exception e) {
                LOGGER.error((Object)("failed to parse wkt in : " + url), (Throwable)e);
            }
            int colour = Util.nextColour();
            int r = colour >> 16 & 0xFF;
            int g = colour >> 8 & 0xFF;
            int b = colour & 0xFF;
            mapLayer.setRedVal(r);
            mapLayer.setGreenVal(g);
            mapLayer.setBlueVal(b);
            mapLayer.setDynamicStyle(true);
            this.getMapComposer().applyChange(mapLayer);
            this.warnForLargeWKT(mapLayer);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error setting up distributions map layer", (Throwable)e);
        }
    }

    public void warnForLargeWKT(MapLayer ml) {
        if (ml.getFacets() == null) {
            WKTReader wktReader = new WKTReader();
            try {
                Geometry g = wktReader.read(ml.getWKT());
                if (g.getNumPoints() > Integer.parseInt(CommonData.getSettings().getProperty("max_q_wkt_points", "200"))) {
                    WKTReducedDTO reduced = Util.reduceWKT((String)ml.getWKT());
                    ml.setWKT(reduced.getReducedWKT());
                    Geometry gsimplified = wktReader.read(ml.getWKT());
                    this.getMapComposer().showMessage("WARNING: The polygon has more than the maximum number of points and has been simplified, \r\n\r\noriginal points: " + g.getNumPoints() + "\r\nmax points: " + CommonData.getSettings().getProperty("max_q_wkt_points", "200") + "\r\nsimplified points: " + gsimplified.getNumPoints());
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"error testing and reducing WKT", (Throwable)e);
            }
        }
    }

    MapLayer mapSpeciesFilter(Query q, String species, String rank, int count, int subType, String wkt, boolean grid, int size, float opacity, int colour, boolean mapExpertDistributions) {
        MapLayer ml;
        String filter = q.getQ();
        if (mapExpertDistributions) {
            try {
                if (q instanceof BiocacheQuery) {
                    String lsids = ((BiocacheQuery)q).getLsids();
                    List extraLsids = ((BiocacheQuery)q).getLsidFromExtraParams();
                    if (lsids != null && lsids.length() > 0) {
                        this.loadDistributionMap(lsids, wkt);
                    }
                    for (String extraLsid : extraLsids) {
                        if (extraLsid == null || extraLsid.length() <= 0) continue;
                        LOGGER.debug((Object)("loading layer for: " + extraLsid));
                        this.loadDistributionMap(extraLsid, wkt);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to map species distribution areas", (Throwable)e);
            }
        }
        if ((ml = this.mapSpeciesWMSByFilter(this.getNextAreaLayerName(species), filter, subType, q, grid, size, opacity, colour)) != null) {
            this.addToSession(ml.getName(), filter);
            MapLayerMetadata md = ml.getMapLayerMetadata();
            md.setOccurrencesCount(count);
            ml.setClustered(false);
            if (grid) {
                ml.setColourMode("grid");
            }
            this.addLsidBoundingBoxToMetadata(md, q);
        }
        return ml;
    }

    MapLayer mapSpeciesWMSByFilter(String label, String filter, int subType, Query query, boolean grid, int size, float opacity, int colour) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        int sz = size;
        int uncertaintyCheck = 0;
        float op = opacity;
        if (this.activeLayerMapProperties != null) {
            r = (Integer)this.activeLayerMapProperties.get("red");
            b = (Integer)this.activeLayerMapProperties.get("blue");
            g = (Integer)this.activeLayerMapProperties.get("green");
            sz = (Integer)this.activeLayerMapProperties.get("size");
            op = ((Float)this.activeLayerMapProperties.get("opacity")).floatValue();
            uncertaintyCheck = (Integer)this.activeLayerMapProperties.get("uncertainty");
        }
        if (subType == 17) {
            r = 0;
            g = 0;
            b = 255;
            op = 1.0f;
            sz = 4;
        }
        Color c = new Color(r, g, b);
        String hexColour = Integer.toHexString(c.getRGB() & 0xFFFFFF);
        String envString = "";
        envString = grid ? envString + "colormode:grid" : "color:" + hexColour;
        envString = envString + ";name:circle;size:" + sz + ";opacity:1";
        if (uncertaintyCheck > 0) {
            envString = envString + ";uncertainty:1";
        }
        String uri = query.getUrl();
        uri = uri + "service=WMS&version=1.1.0&request=GetMap&styles=&format=image/png";
        uri = uri + "&layers=ALA:occurrences";
        uri = uri + "&transparent=true";
        uri = uri + (query.getQc() == null ? "" : query.getQc());
        uri = uri + "&CACHE=" + this.useSpeciesWMSCache;
        uri = uri + "&CQL_FILTER=";
        LOGGER.debug((Object)("Mapping: " + label + " with " + uri + filter));
        try {
            if (this.safeToPerformMapAction()) {
                if (this.getMapLayer(label) == null) {
                    MapLayer ml = this.addWMSLayer(label, label, uri + filter, op, null, null, subType, "", envString, query);
                    if (ml != null) {
                        ml.setDynamicStyle(true);
                        ml.setEnvParams(envString);
                        ml.setGeometryType(25);
                        ml.setBlueVal(b);
                        ml.setGreenVal(g);
                        ml.setRedVal(r);
                        ml.setSizeVal(sz);
                        ml.setOpacity(op);
                        ml.setClustered(false);
                        ml.setSpeciesQuery(query);
                        this.updateLayerControls();
                        MapLayer mlHighlight = (MapLayer)ml.clone();
                        mlHighlight.setName(ml.getName() + "_highlight");
                        ml.addChild(mlHighlight);
                        return ml;
                    }
                    LOGGER.debug((Object)"adding WMS layer failed ");
                } else {
                    this.openLayersJavascript.useAdditionalScript();
                    LOGGER.debug((Object)("refusing to add a new layer with URI " + uri + " because it already exists in the menu"));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error mapSpeciesByNameRank:", (Throwable)ex);
        }
        return null;
    }

    public LeftMenuSearchComposer getLeftmenuSearchComposer() {
        return (LeftMenuSearchComposer)this.getFellow("leftMenuSearch").getFellow("leftSearch");
    }

    public Iframe getRawMessageIframeHack() {
        return this.rawMessageIframeHack;
    }

    public void setRawMessageIframeHack(Iframe rawMessageIframeHack) {
        this.rawMessageIframeHack = rawMessageIframeHack;
    }

    public Div getRawMessageHackHolder() {
        return this.rawMessageHackHolder;
    }

    public void setRawMessageHackHolder(Div rawMessageHackHolder) {
        this.rawMessageHackHolder = rawMessageHackHolder;
    }

    public LanguagePack getLanguagePack() {
        return this.languagePack;
    }

    public void setLanguagePack(LanguagePack languagePack) {
        this.languagePack = languagePack;
    }

    public Properties getSettingsSupplementary() {
        this.settingsSupplementary = CommonData.getSettings();
        return CommonData.getSettings();
    }

    public void setSettingsSupplementary(Properties settingsSupplementary) {
        this.settingsSupplementary = settingsSupplementary;
    }

    public OpenLayersJavascript getOpenLayersJavascript() {
        return this.openLayersJavascript;
    }

    public void setOpenLayersJavascript(OpenLayersJavascript openLayersJavascript) {
        this.openLayersJavascript = openLayersJavascript;
    }

    public HttpConnection getHttpConnection() {
        return this.httpConnection;
    }

    public void setHttpConnection(HttpConnection httpConnection) {
        this.httpConnection = httpConnection;
    }

    public RemoteMap getRemoteMap() {
        return this.remoteMap;
    }

    public void setRemoteMap(RemoteMap remoteMap) {
        this.remoteMap = remoteMap;
    }

    public ActiveLayerRenderer getActiveLayerRenderer() {
        return this.activeLayerRenderer;
    }

    public void setActiveLayerRenderer(ActiveLayerRenderer activeLayerRenderer) {
        this.activeLayerRenderer = activeLayerRenderer;
    }

    public PortalSessionUtilities getPortalSessionUtilities() {
        return this.portalSessionUtilities;
    }

    public void setPortalSessionUtilities(PortalSessionUtilities portalSessionUtilities) {
        this.portalSessionUtilities = portalSessionUtilities;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isLayerControlVisible() {
        return this.layerControls.isVisible();
    }

    public void openUrl(Event event) {
        String s = (String)event.getData();
        LOGGER.debug((Object)("\n\n******\n\ns: " + s + "\n\n******\n\n"));
        Object url = "";
        Object header = "";
        Object download = "";
        Object[] data = s.split("\n");
        if (!ArrayUtils.isEmpty((Object[])data)) {
            LOGGER.debug((Object)("data.length: " + data.length));
            if (data.length == 1) {
                url = data[0];
            }
            if (data.length == 2) {
                url = data[0];
                header = data[1];
                if (((String)header).startsWith("pid:")) {
                    download = header;
                    header = "";
                }
            }
            if (data.length == 3) {
                url = data[0];
                header = data[1];
                download = data[2];
            }
            if (((String)download).length() > 0 && ((String)download).startsWith("pid")) {
                download = ((String)download).substring(4);
            }
            this.activateLink((String)url, (String)header, false, (String)download);
        }
    }

    public void openHTML(Event event) {
        String html = (String)event.getData();
        String[] lines = html.split("\n");
        String header = lines[0];
        String url = "*" + html.substring(header.length()).trim();
        this.activateLink(url, header, false);
    }

    public String getViewArea() {
        BoundingBox bb = this.getMapComposer().getLeftmenuSearchComposer().getViewportBoundingBox();
        return "POLYGON((" + bb.getMinLongitude() + " " + bb.getMinLatitude() + "," + bb.getMaxLongitude() + " " + bb.getMinLatitude() + "," + bb.getMaxLongitude() + " " + bb.getMaxLatitude() + "," + bb.getMinLongitude() + " " + bb.getMaxLatitude() + "," + bb.getMinLongitude() + " " + bb.getMinLatitude() + "))";
    }

    public Session getSession() {
        return Sessions.getCurrent();
    }

    public int getMapZoom() {
        return this.mapZoomLevel;
    }

    public void addToSession(String species, String filter) {
        HashMap<String, String> speciesfilters = (HashMap<String, String>)this.getSession().getAttribute("speciesfilters");
        if (speciesfilters == null) {
            speciesfilters = new HashMap<String, String>();
        }
        speciesfilters.put(species, filter);
        this.getSession().setAttribute("speciesfilters", speciesfilters);
    }

    public void removeFromSession(String species) {
        Map speciesfilters = (Map)Sessions.getCurrent().getAttribute("speciesfilters");
        if (speciesfilters != null) {
            speciesfilters.remove(species);
            this.getSession().setAttribute("speciesfilters", (Object)speciesfilters);
        }
    }

    public void loadScatterplot(ScatterplotDataDTO data, String lyrName) {
        MapLayer ml = this.mapSpecies(data.getQuery(), data.getSpeciesName(), "species", 0, 17, null, 0, 3, 0.6f, Util.nextColour(), false);
        ml.setDisplayName(lyrName);
        ml.setSubType(17);
        ml.setType(17);
        ml.setScatterplotDataDTO(data);
        this.addUserDefinedLayerToMenu(ml, true);
        this.updateLayerControls();
        this.refreshContextualMenu();
    }

    public String getNextAreaLayerName(String layerPrefix) {
        String newLayerPrefix = layerPrefix;
        if (this.getMapLayer(newLayerPrefix) == null && this.getMapLayerDisplayName(newLayerPrefix) == null) {
            return newLayerPrefix;
        }
        newLayerPrefix = newLayerPrefix + " ";
        int i = 1;
        while (this.getMapLayer(newLayerPrefix + i) != null || this.getMapLayerDisplayName(newLayerPrefix + i) != null) {
            ++i;
        }
        return newLayerPrefix + i;
    }

    public String getNextActiveAreaLayerName(String areaName) {
        String newAreaName = areaName;
        if (newAreaName == null) {
            newAreaName = "Active area";
        } else if (newAreaName.trim().isEmpty()) {
            newAreaName = "Active area";
        }
        return "Occurrences in " + newAreaName + " ";
    }

    public void onClick$btnAddSpecies(Event event) {
        this.openModal("WEB-INF/zul/add/AddSpecies.zul", null, "addspecieswindow");
    }

    public void onClick$btnAddArea(Event event) {
        this.openModal("WEB-INF/zul/add/AddArea.zul", null, "addareawindow");
    }

    public void onClick$btnAddLayer(Event event) {
        this.openModal("WEB-INF/zul/add/AddLayer.zul", null, "addlayerwindow");
    }

    public void onClick$btnAddFacet(Event event) {
        this.openModal("WEB-INF/zul/add/AddFacet.zul", null, "addfacetwindow");
    }

    public void onClick$btnAddWMSLayer(Event event) {
        this.openModal("WEB-INF/zul/add/AddWMSLayer.zul", null, "addwmslayerwindow");
    }

    public void onClick$btnAddGDM(Event event) {
        this.openModal("WEB-INF/zul/tool/GDM.zul", null, "addtoolwindow");
    }

    public void onClick$btnAddMaxent(Event event) {
        this.openModal("WEB-INF/zul/tool/Maxent.zul", null, "addtoolwindow");
    }

    public void onClick$btnAddAooEoo(Event event) {
        this.openModal("WEB-INF/zul/tool/AOOEOO.zul", null, "addtoolwindow");
    }

    public void onClick$btnAddSampling(Event event) {
        this.openModal("WEB-INF/zul/tool/Sampling.zul", null, "addtoolwindow");
    }

    public void onClick$btnAddAloc(Event event) {
        this.openModal("WEB-INF/zul/tool/ALOC.zul", null, "addtoolwindow");
    }

    public void onClick$btnAddScatterplot(Event event) {
        this.openModal("WEB-INF/zul/tool/Scatterplot.zul", null, "addtoolwindow");
    }

    public void onClick$btnAddScatterplotList(Event event) {
        this.openModal("WEB-INF/zul/tool/ScatterplotList.zul", null, "addtoolwindow");
    }

    public void runTabulation(Event event) {
        this.openModal("WEB-INF/zul/tool/Tabulation.zul", null, "addtoolwindow");
    }

    public void onClick$btnAreaReport(Event event) {
        this.openModal("WEB-INF/zul/tool/AreaReport.zul", null, "addtoolwindow");
    }

    public void onClick$btnInOut(Event event) {
        this.openModal("WEB-INF/zul/tool/InOut.zul", null, "addtoolwindow");
    }

    public void onClick$btnAreaReportPDF(Event event) {
        this.openModal("WEB-INF/zul/tool/AreaReportPDF.zul", null, "addtoolwindow");
    }

    public void runNearestLocalityAction(Event event) {
        this.remoteLogger.logMapAnalysis("Nearest locality", "Tool - Nearest locality", "", "", "", "", "", "");
    }

    public void runPointComparisons(Event event) {
        this.openOverlapped("WEB-INF/zul/results/PointComparison.zul");
    }

    public void onClick$btnSpeciesList(Event event) {
        this.openModal("WEB-INF/zul/tool/SpeciesList.zul", null, "addtoolwindow");
    }

    public void onClick$btnSitesBySpecies(Event event) {
        this.openModal("WEB-INF/zul/tool/SitesBySpecies.zul", null, "addtoolwindow");
    }

    public void onClick$btnPhylogeneticDiversity(Event event) {
        this.openModal("WEB-INF/zul/tool/PhylogeneticDiversity.zul", null, "addtoolwindow");
    }

    public Window openModal(String page, Map<String, Object> params, String windowname) {
        if (windowname != null && this.getFellowIfAny(windowname) != null) {
            this.getFellowIfAny(windowname).detach();
        }
        Window window = (Window)Executions.createComponents((String)page, (Component)this, params);
        try {
            window.setParent((Component)this);
            window.doModal();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error opening dialog: " + page), (Throwable)e);
        }
        return window;
    }

    void openOverlapped(String page) {
        Window window = (Window)Executions.createComponents((String)page, (Component)this, null);
        try {
            window.doOverlapped();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error opening overlapped dialog: " + page), (Throwable)e);
        }
    }

    public void updateLayerControls() {
        String page;
        this.adjustActiveLayersList();
        Component c = this.getFellowIfAny("scatterplotlayerlegend");
        if (c != null) {
            c.detach();
        }
        for (int i = this.layerControls.getChildren().size() - 1; i >= 0; --i) {
            ((Component)this.layerControls.getChildren().get(i)).detach();
        }
        MapLayer selectedLayer = this.getActiveLayersSelection(false);
        if (selectedLayer == null) {
            if (this.activeLayersList.getItemCount() > 0) {
                this.activeLayersList.setSelectedIndex(0);
                selectedLayer = (MapLayer)this.activeLayersList.getModel().getElementAt(0);
            } else {
                return;
            }
        }
        this.lblSelectedLayer.setValue(selectedLayer.getDisplayName());
        if (selectedLayer.getType() == 17) {
            page = "WEB-INF/zul/legend/LayerLegendScatterplot.zul";
        } else if (selectedLayer.getType() == 12) {
            page = "WEB-INF/zul/legend/MapOptions.zul";
        } else {
            HashMap<String, MapLayer> params = new HashMap<String, MapLayer>();
            this.llc2MapLayer = selectedLayer;
            params.put("map_layer", this.llc2MapLayer);
            Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/legend/LayerLegendGeneral.zul", (Component)this.layerControls, params);
            try {
                window.doEmbedded();
            }
            catch (Exception e) {
                LOGGER.error((Object)"error setting up layer legend", (Throwable)e);
            }
            return;
        }
        Window window = (Window)Executions.createComponents((String)page, (Component)this.layerControls, null);
        try {
            if (window instanceof HasMapLayer) {
                ((HasMapLayer)window).setMapLayer(selectedLayer);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to set map layer to window: " + (window != null ? window.getId() : "window is null")), (Throwable)e);
        }
        try {
            window.doEmbedded();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error setting layer legend", (Throwable)e);
        }
    }

    public void redrawLayersList() {
        int idx = this.activeLayersList.getSelectedIndex();
        List activeLayers = this.getPortalSession().getActiveLayers();
        this.activeLayersList.setModel((ListModel)new ListModelList(activeLayers, true));
        this.activeLayersList.setSelectedIndex(idx);
        if (this.layerLegendNameRefresh != null) {
            try {
                this.layerLegendNameRefresh.onEvent((Event)new ForwardEvent("", (Component)this, null, (Object)this.llc2MapLayer.getDisplayName()));
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to refresh legend name with current map layer", (Throwable)e);
            }
        }
        this.lblSelectedLayer.setValue(this.llc2MapLayer.getDisplayName());
        this.adjustActiveLayersList();
    }

    public void onSelect$activeLayersList(Event event) {
        this.updateLayerControls();
        this.refreshContextualMenu();
    }

    public List<MapLayer> getPolygonLayers() {
        ArrayList<MapLayer> list = new ArrayList<MapLayer>();
        List allLayers = this.getPortalSession().getActiveLayers();
        for (int i = 0; i < allLayers.size(); ++i) {
            if (!((MapLayer)allLayers.get(i)).isPolygonLayer()) continue;
            list.add((MapLayer)allLayers.get(i));
        }
        return list;
    }

    public List<MapLayer> getSpeciesLayers() {
        ArrayList<MapLayer> list = new ArrayList<MapLayer>();
        List allLayers = this.getPortalSession().getActiveLayers();
        for (int i = 0; i < allLayers.size(); ++i) {
            if (((MapLayer)allLayers.get(i)).getSpeciesQuery() == null) continue;
            list.add((MapLayer)allLayers.get(i));
        }
        return list;
    }

    public List<MapLayer> getGridLayers() {
        ArrayList<MapLayer> list = new ArrayList<MapLayer>();
        List allLayers = this.getPortalSession().getActiveLayers();
        for (int i = 0; i < allLayers.size(); ++i) {
            if (!((MapLayer)allLayers.get(i)).isGridLayer() || ((MapLayer)allLayers.get(i)).getSubType() == 15 || ((MapLayer)allLayers.get(i)).getSubType() == 16 || ((MapLayer)allLayers.get(i)).getSubType() == 14) continue;
            list.add((MapLayer)allLayers.get(i));
        }
        return list;
    }

    public List<MapLayer> getAnalysisLayers() {
        ArrayList<MapLayer> list = new ArrayList<MapLayer>();
        List allLayers = this.getPortalSession().getActiveLayers();
        for (int i = 0; i < allLayers.size(); ++i) {
            if (((MapLayer)allLayers.get(i)).getSubType() != 15 && ((MapLayer)allLayers.get(i)).getSubType() != 16 && ((MapLayer)allLayers.get(i)).getSubType() != 14 && ((MapLayer)allLayers.get(i)).getSubType() != 24 && ((MapLayer)allLayers.get(i)).getSubType() != 25) continue;
            list.add((MapLayer)allLayers.get(i));
        }
        return list;
    }

    public List<MapLayer> getContextualLayers() {
        ArrayList<MapLayer> list = new ArrayList<MapLayer>();
        List allLayers = this.getPortalSession().getActiveLayers();
        for (int i = 0; i < allLayers.size(); ++i) {
            if (!((MapLayer)allLayers.get(i)).isContextualLayer() || ((MapLayer)allLayers.get(i)).getSubType() == 14) continue;
            list.add((MapLayer)allLayers.get(i));
        }
        return list;
    }

    public boolean isSelectedLayer(MapLayer ml) {
        return ml == this.getActiveLayersSelection(false);
    }

    public void setContextualMenuRefreshListener(EventListener contextualMenuRefreshListener) {
        this.contextualMenuRefreshListener = contextualMenuRefreshListener;
    }

    public void refreshContextualMenu() {
        if (this.contextualMenuRefreshListener != null) {
            try {
                this.contextualMenuRefreshListener.onEvent(null);
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to refresh contextual menu", (Throwable)e);
            }
        }
        this.adjustActiveLayersList();
    }

    public void exportArea(Event event) {
        this.openModal("WEB-INF/zul/output/ExportLayer.zul", null, "addtoolwindow");
    }

    public void onBaseMap(Event event) {
        String newBaseMap = (String)event.getData();
        this.getPortalSession().setBaseLayer(newBaseMap);
    }

    public String getBaseMap() {
        return this.getPortalSession().getBaseLayer();
    }

    public void adjustActiveLayersList() {
        if (this.activeLayersList != null && this.activeLayersList.getItems() != null) {
            for (Listitem li : this.activeLayersList.getItems()) {
                if (li.getValue() == null || ((MapLayer)li.getValue()).getType() != 12) continue;
                Listcell lc = (Listcell)li.getLastChild();
                int checkedCount = 0;
                for (Listitem i : this.activeLayersList.getItems()) {
                    if (i.getFirstChild().getFirstChild() == null || !((Checkbox)i.getFirstChild().getFirstChild()).isChecked()) continue;
                    ++checkedCount;
                }
                Div div = (Div)lc.getLastChild();
                Button unsel = (Button)div.getLastChild();
                Button sel = (Button)unsel.getPreviousSibling();
                Button remove = (Button)sel.getPreviousSibling();
                if (this.activeLayersList.getItemCount() == 1) {
                    sel.setVisible(false);
                    unsel.setVisible(false);
                    remove.setVisible(false);
                    continue;
                }
                if (checkedCount == this.activeLayersList.getItemCount()) {
                    sel.setDisabled(true);
                    unsel.setDisabled(false);
                    sel.setVisible(true);
                    unsel.setVisible(true);
                    remove.setVisible(true);
                    continue;
                }
                if (checkedCount == 1) {
                    sel.setDisabled(false);
                    unsel.setDisabled(true);
                    sel.setVisible(true);
                    unsel.setVisible(true);
                    remove.setVisible(true);
                    continue;
                }
                sel.setDisabled(false);
                unsel.setDisabled(false);
                sel.setVisible(true);
                unsel.setVisible(true);
                remove.setVisible(true);
            }
        }
    }

    public void setLayersVisible(boolean show) {
        PortalSession portalSession = (PortalSession)Executions.getCurrent().getDesktop().getSession().getAttribute("portalSession");
        for (Listitem li : this.activeLayersList.getItems()) {
            if (li.getValue() != null && "Map options".equals(((MapLayer)li.getValue()).getName())) continue;
            Checkbox cb = (Checkbox)li.getFirstChild().getFirstChild();
            if (show && !cb.isChecked()) {
                this.openLayersJavascript.execute(this.openLayersJavascript.getIFrameReferences() + this.openLayersJavascript.activateMapLayer((MapLayer)li.getValue(), false, true) + this.openLayersJavascript.updateMapLayerIndexes(portalSession.getActiveLayers()));
            } else if (!show && cb.isChecked()) {
                this.openLayersJavascript.removeMapLayerNow((MapLayer)li.getValue());
            }
            cb.setChecked(show);
            cb.setTooltiptext(show ? "Hide" : "Show");
        }
        this.refreshContextualMenu();
    }

    public void importAnalysis(Event event) {
        this.openModal("WEB-INF/zul/input/ImportAnalysis.zul", null, "importanalysis");
    }

    private Map<String, String> getQueryParameterMap(String params) {
        if (params == null || params.length() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : params.split("&")) {
            String[] keyvalue = s.split("=");
            if (keyvalue.length < 2) continue;
            String key = keyvalue[0];
            String value = keyvalue[1];
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error((Object)("error decoding to UTF-8: " + value), (Throwable)e);
            }
            map.put(key, value);
        }
        return map;
    }

    public List<LayerSelection> getLayerSelections() {
        return this.selectedLayers;
    }

    public void addLayerSelection(LayerSelection ls) {
        for (int i = 0; i < this.selectedLayers.size(); ++i) {
            if (!((LayerSelection)this.selectedLayers.get(i)).equalsList(ls)) continue;
            ((LayerSelection)this.selectedLayers.get(i)).setLastUse(System.currentTimeMillis());
            return;
        }
        this.selectedLayers.add(ls);
        if (this.selectedLayers.size() > 20) {
            int oldestIdx = 0;
            for (int i = 1; i < this.selectedLayers.size(); ++i) {
                if (((LayerSelection)this.selectedLayers.get(i)).getLastUse() >= ((LayerSelection)this.selectedLayers.get(oldestIdx)).getLastUse()) continue;
                oldestIdx = i;
            }
            this.selectedLayers.remove(oldestIdx);
        }
    }

    public void onClick$openDistributions(Event event) {
        String lsids = (String)event.getData();
        if (lsids != null && lsids.length() > 0) {
            this.closeExternalContentWindow();
            this.openDistributionSpecies(lsids, null);
        }
    }

    public void onClick$openChecklists(Event event) {
        String lsids = (String)event.getData();
        if (lsids != null && lsids.length() > 0) {
            this.closeExternalContentWindow();
            this.openChecklistSpecies(lsids, null, false);
        }
    }

    public void onClick$openAreaChecklist(Event event) {
        String geomIdx = (String)event.getData();
        if (geomIdx != null && geomIdx.length() > 0) {
            this.closeExternalContentWindow();
            this.openAreaChecklist(geomIdx, null, null);
        }
    }

    void closeExternalContentWindow() {
        try {
            Component c = this.getFellowIfAny("externalContentWindow");
            if (c != null) {
                LOGGER.debug((Object)"found externalContentWindow, closing");
                c.detach();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error closing externalContentWindow window", (Throwable)e);
        }
    }

    public Object getMapLayerWMS(String wmsurl) {
        List udl = this.getPortalSession().getActiveLayers();
        for (MapLayer ml : udl) {
            if (ml.getUri() == null || !ml.getUri().equals(wmsurl)) continue;
            return ml;
        }
        return null;
    }

    public void importSpecies(Event event) {
        String type = (String)event.getData();
        if (type != null && type.length() > 0) {
            if ("assemblage".equalsIgnoreCase(type)) {
                HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                params.put("enableImportAssemblage", true);
                this.openModal("WEB-INF/zul/add/AddSpecies.zul", params, "addspecieswindow");
            } else if (StringUtils.isNotEmpty((String)CommonData.getSettings().getProperty("sandbox.url", null)) && CommonData.getSettings().getProperty("import.points.layers-service", "false").equals("false")) {
                String sandboxEmbedded = CommonData.getSettings().getProperty("sandbox.embedded", "false");
                if (sandboxEmbedded != null && Boolean.parseBoolean(sandboxEmbedded)) {
                    SandboxEmbeddedController spc = (SandboxEmbeddedController)Executions.createComponents((String)"WEB-INF/zul/sandbox/SandboxEmbedded.zul", (Component)this.getMapComposer(), null);
                    spc.setAddToMap(true);
                    spc.setParent((Component)this.getMapComposer());
                    spc.doModal();
                } else {
                    SandboxPasteController spc = (SandboxPasteController)Executions.createComponents((String)"WEB-INF/zul/sandbox/SandboxPaste.zul", (Component)this.getMapComposer(), null);
                    spc.setAddToMap(true);
                    spc.setParent((Component)this.getMapComposer());
                    spc.doModal();
                }
            } else {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("setTbInstructions", "3. Select file (comma separated ID (text), longitude (decimal degrees), latitude(decimal degrees))");
                params.put("addToMap", true);
                this.openModal("WEB-INF/zul/input/UploadSpecies.zul", params, "uploadspecieswindow");
            }
        }
    }

    public void generatePoints(Event event) {
        this.openModal("WEB-INF/zul/tool/PointGeneration.zul", null, "addtoolwindow");
    }

    public void importAreas(Event event) {
        this.openModal("WEB-INF/zul/input/ImportAreas.zul", null, "addareawindow");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUserSession(Event event) {
        LOGGER.debug((Object)"saving session");
        PrintWriter out = null;
        try {
            String sfld;
            File sessfolder;
            String jsessionid = this.getCookieValue("JSESSIONID");
            if (jsessionid == null) {
                jsessionid = "test";
            }
            if (!(sessfolder = new File((sfld = this.getSettingsSupplementary().getProperty("analysis_output_dir") + "session/" + jsessionid) + "/")).exists()) {
                sessfolder.mkdirs();
            } else {
                FileUtils.deleteDirectory((File)sessfolder);
                sessfolder.mkdirs();
            }
            StringBuilder sbSession = new StringBuilder();
            sbSession.append(String.valueOf(this.mapZoomLevel)).append(",").append(this.getLeftmenuSearchComposer().getViewportBoundingBox().toString());
            sbSession.append(System.getProperty("line.separator"));
            FilePersistenceStrategy strategy = new FilePersistenceStrategy(new File(sfld));
            XmlArrayList list = new XmlArrayList((PersistenceStrategy)strategy);
            String scatterplotNames = "";
            List udl = this.getPortalSession().getActiveLayers();
            for (MapLayer ml : udl) {
                if (ml.getType() == 12) continue;
                if (ml.getSubType() == 17) {
                    list.add(ml.getScatterplotDataDTO());
                    scatterplotNames = scatterplotNames + (scatterplotNames.length() > 1 ? "___" + ml.getName() : ml.getName());
                    continue;
                }
                list.add(ml);
            }
            sbSession.append("scatterplotNames=").append(scatterplotNames);
            sbSession.append(System.getProperty("line.separator"));
            out = new PrintWriter(new BufferedWriter(new FileWriter(sfld + "/details.txt")));
            out.write(sbSession.toString());
            out.close();
            String sessionurl = CommonData.getWebportalServer() + "/?ss=" + jsessionid;
            this.activateLink("*<p>Your session has been saved and now available to share at <br /><a href='" + sessionurl + "'>" + sessionurl + "</a>" + "<br />(Right-click on the link and to copy the link to clipboard)" + "</p>", "Saved session", false, "");
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Unable to save session data: ", (Throwable)ex);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserSession(String sessionid) {
        Scanner scanner = null;
        try {
            String sfld = this.getSettingsSupplementary().getProperty("analysis_output_dir") + "session/" + sessionid;
            File sessfolder = new File(sfld);
            if (!sessfolder.exists()) {
                this.showMessage("Session information does not exist. Please provide a valid session id");
                return;
            }
            scanner = new Scanner(new File(sfld + "/details.txt"));
            String[] mapdetails = scanner.nextLine().split(",");
            BoundingBox bb = new BoundingBox();
            bb.setMinLongitude(Float.parseFloat(mapdetails[1]));
            bb.setMinLatitude(Float.parseFloat(mapdetails[2]));
            bb.setMaxLongitude(Float.parseFloat(mapdetails[3]));
            bb.setMaxLatitude(Float.parseFloat(mapdetails[4]));
            this.openLayersJavascript.setAdditionalScript(this.openLayersJavascript.zoomToBoundingBox(bb, true));
            String[] scatterplotNames = null;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.startsWith("scatterplotNames")) continue;
                scatterplotNames = line.substring(17).split("___");
            }
            ArrayUtils.reverse(scatterplotNames);
            3 xstream = new /* Unavailable Anonymous Inner Class!! */;
            FilePersistenceStrategy strategy = new FilePersistenceStrategy(new File(sfld), (XStream)xstream);
            XmlArrayList list = new XmlArrayList((PersistenceStrategy)strategy);
            ListIterator it = list.listIterator(list.size());
            int scatterplotIndex = 0;
            while (it.hasPrevious()) {
                Object o = it.previous();
                MapLayer ml = null;
                if (o instanceof MapLayer) {
                    ml = (MapLayer)o;
                    LOGGER.debug((Object)("Loading " + ml.getName() + " -> " + ml.isDisplayed()));
                    this.addUserDefinedLayerToMenu(ml, false);
                } else if (o instanceof ScatterplotDataDTO) {
                    ScatterplotDataDTO spdata = (ScatterplotDataDTO)o;
                    this.loadScatterplot(spdata, "My Scatterplot " + scatterplotIndex++);
                }
                if (ml == null) continue;
                this.addUserDefinedLayerToMenu(ml, true);
            }
        }
        catch (Exception e) {
            try {
                File f = new File("/data/sessions/" + sessionid + ".txt");
                PrintWriter pw = new PrintWriter(f);
                e.printStackTrace(pw);
                pw.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            LOGGER.error((Object)"Unable to load session data", (Throwable)e);
            this.showMessage("Unable to load session data");
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            try {
                File f = new File("/data/sessions/ok/" + sessionid + ".txt");
                FileUtils.writeStringToFile((File)f, (String)"ok");
            }
            catch (Exception exception) {}
        }
    }

    public void updateAdhocGroup(Event event) {
        Query query;
        String[] params = ((String)event.getData()).split("\n");
        MapLayer ml = this.getMapLayer(params[0]);
        if (ml != null && (query = ml.getSpeciesQuery()) != null) {
            query.flagRecord(params[1], "true".equalsIgnoreCase(params[2]));
        }
        this.updateLayerControls();
    }

    public void downloadSecond(Event event) {
        SamplingDownloadUtil.downloadSecond((MapComposer)this, (Query)this.downloadSecondQuery, (String[])this.downloadSecondLayers);
    }

    public void openFacets(Event event) {
        if (this.facetsOpenListener != null) {
            try {
                this.facetsOpenListener.onEvent(null);
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to open the colour (facets) list", (Throwable)e);
            }
        }
    }

    public void onClick$downloadFeaturesCSV(Event event) {
        if (this.featuresCSV != null) {
            Filedownload.save((String)this.featuresCSV, (String)"application/csv", (String)"pointFeatures.csv");
        }
    }

    public void replaceWKTwithWMS(MapLayer ml) {
        if (ml.getFacets() != null || ml.getWKT() == null || ml.getWKT().startsWith("ENVELOPE") || ml.getUri() != null) {
            return;
        }
        String pid = UserShapes.upload((String)ml.getWKT(), (String)ml.getDisplayName(), (String)ml.getDescription(), (String)Util.getUserEmail(), (String)CommonData.getSettings().getProperty("api_key"));
        if (pid != null) {
            this.deactiveLayer(ml, true, false);
            MapLayer newml = this.addObjectByPid(pid, ml.getDisplayName(), 1.0);
            newml.setMapLayerMetadata(ml.getMapLayerMetadata());
            newml.setAreaSqKm(ml.getAreaSqKm());
            newml.setUserDefinedLayer(ml.isUserDefinedLayer());
            newml.setDescription(ml.getDescription());
            newml.setWKT(ml.getWKT());
        }
    }

    public void setLabelSelectedLayer(String labelSelectedLayer) {
        this.lblSelectedLayer.setValue(labelSelectedLayer);
    }

    public void setFacetsOpenListener(EventListener facetsOpenListener) {
        this.facetsOpenListener = facetsOpenListener;
    }

    public void setLayerLegendNameRefresh(EventListener layerLegendNameRefresh) {
        this.layerLegendNameRefresh = layerLegendNameRefresh;
    }

    public void setFeaturesCSV(String featuresCSV) {
        this.featuresCSV = featuresCSV;
    }

    public void setDownloadSecondQuery(Query downloadSecondQuery) {
        this.downloadSecondQuery = downloadSecondQuery;
    }

    public void setDownloadSecondLayers(String[] downloadSecondLayers) {
        this.downloadSecondLayers = downloadSecondLayers == null ? null : (String[])downloadSecondLayers.clone();
    }
}

