/*
 * Decompiled with CFR 0.152.
 */
package au.org.emii.portal.composer;

import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.value.BoundingBox;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;

public class LeftMenuSearchComposer
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(LeftMenuSearchComposer.class);
    private static final long serialVersionUID = 2540820748110129339L;
    private Map<String, EventListener> viewportChangeEvents = new HashMap();
    private double north;
    private double south;
    private double east;
    private double west;
    private int zoom;

    public BoundingBox getViewportBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        bbox.setMaxLatitude((float)this.north);
        bbox.setMinLatitude((float)this.south);
        bbox.setMinLongitude((float)this.west);
        bbox.setMaxLongitude((float)this.east);
        return bbox;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setExtents(Event event) {
        String[] extents = ((String)event.getData()).split(",");
        this.west = Double.parseDouble(extents[0]);
        this.north = Double.parseDouble(extents[1]);
        this.east = Double.parseDouble(extents[2]);
        this.south = Double.parseDouble(extents[3]);
        this.zoom = Integer.parseInt(extents[4]);
        Events.echoEvent((String)"triggerViewportChange", (Component)this, null);
    }

    public void triggerViewportChange(Event e) throws Exception {
        BoundingBox bb = new BoundingBox();
        bb.setMinLatitude((float)this.south);
        bb.setMaxLatitude((float)this.north);
        bb.setMinLongitude((float)this.west);
        bb.setMaxLongitude((float)this.east);
        if (this.getPortalSession().isMapLoaded()) {
            this.getMapComposer().getPortalSession().setDefaultBoundingbox(bb);
        }
        for (EventListener el : this.viewportChangeEvents.values()) {
            try {
                el.onEvent(null);
            }
            catch (Exception ex) {
                LOGGER.error((Object)"error running viewport change listener", (Throwable)ex);
            }
        }
    }

    public void addViewportEventListener(String eventName, EventListener eventListener) {
        this.viewportChangeEvents.put(eventName, eventListener);
    }

    public void removeViewportEventListener(String eventName) {
        this.viewportChangeEvents.remove(eventName);
    }
}

