/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.legend.Facet;
import au.org.ala.legend.LegendObject;
import au.org.ala.spatial.dto.WKTReducedDTO;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.zkoss.zk.ui.Executions;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Util {
    private static final Logger LOGGER = Logger.getLogger(Util.class);
    private static int currentColourIdx = 0;

    private Util() {
    }

    public static String createCircle(double x, double y, double radius, int sides) {
        try {
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
            String wkt4326 = "GEOGCS[\"WGS 84\",  DATUM[    \"WGS_1984\",    SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],    TOWGS84[0,0,0,0,0,0,0],    AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"DMSH\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],  AXIS[\"Lat\",NORTH],  AXIS[\"Long\",EAST],  AUTHORITY[\"EPSG\",\"4326\"]]";
            String wkt900913 = "PROJCS[\"WGS84 / Google Mercator\",   GEOGCS[\"WGS 84\",    DATUM[\"World Geodetic System 1984\",    SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],   AUTHORITY[\"EPSG\",\"6326\"]],  PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],  UNIT[\"degree\", 0.017453292519943295],  AXIS[\"Longitude\", EAST],  AXIS[\"Latitude\", NORTH],  AUTHORITY[\"EPSG\",\"4326\"]],  PROJECTION[\"Mercator_1SP\"],  PARAMETER[\"semi_minor\", 6378137.0],  PARAMETER[\"latitude_of_origin\", 0.0], PARAMETER[\"central_meridian\", 0.0],  PARAMETER[\"scale_factor\", 1.0],  PARAMETER[\"false_easting\", 0.0],  PARAMETER[\"false_northing\", 0.0],  UNIT[\"m\", 1.0],  AXIS[\"x\", EAST],  AXIS[\"y\", NORTH],  AUTHORITY[\"EPSG\",\"3857\"]] ";
            CoordinateReferenceSystem wgsCRS = CRS.parseWKT((String)wkt4326);
            CoordinateReferenceSystem googleCRS = CRS.parseWKT((String)wkt900913);
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)wgsCRS, (CoordinateReferenceSystem)googleCRS);
            Point point = geometryFactory.createPoint(new Coordinate(y, x));
            Geometry geom = JTS.transform((Geometry)point, (MathTransform)transform);
            Point gPoint = geometryFactory.createPoint(new Coordinate(geom.getCoordinate()));
            LOGGER.debug((Object)("Google point:" + gPoint.getCoordinate().x + "," + gPoint.getCoordinate().y));
            MathTransform reverseTransform = CRS.findMathTransform((CoordinateReferenceSystem)googleCRS, (CoordinateReferenceSystem)wgsCRS);
            Coordinate[] coords = new Coordinate[sides + 1];
            for (int i = 0; i < sides; ++i) {
                double angle = (double)i / (double)sides * Math.PI * 2.0;
                double dx = Math.cos(angle) * radius;
                double dy = Math.sin(angle) * radius;
                geom = JTS.transform((Geometry)geometryFactory.createPoint(new Coordinate(gPoint.getCoordinate().x + dx, gPoint.getCoordinate().y + dy)), (MathTransform)reverseTransform);
                coords[i] = new Coordinate(geom.getCoordinate().y, geom.getCoordinate().x);
            }
            coords[sides] = coords[0];
            LinearRing ring = geometryFactory.createLinearRing(coords);
            Polygon polygon = geometryFactory.createPolygon(ring, null);
            WKTWriter writer = new WKTWriter();
            String wkt = writer.write((Geometry)polygon);
            return wkt.replaceAll("POLYGON ", "POLYGON").replaceAll(", ", ",");
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Circle fail!");
            return "none";
        }
    }

    public static String wktFromJSON(String json) {
        try {
            StringBuilder sb = new StringBuilder();
            boolean isPolygon = json.contains("\"type\":\"Polygon\"");
            sb.append("MULTIPOLYGON(");
            if (isPolygon) {
                sb.append("(");
            }
            int pos = json.indexOf("coordinates") + "coordinates".length() + 3;
            int end = json.indexOf(125, pos);
            char c = json.charAt(pos);
            int prevC = 32;
            ++pos;
            while (pos < end) {
                char nextC = json.charAt(pos);
                if (c == '[') {
                    if (nextC != '-' && (nextC < '0' || nextC > '9')) {
                        sb.append('(');
                    }
                } else if (c == ']') {
                    if (prevC < 48 || prevC > 57) {
                        sb.append(')');
                    }
                } else if (c == ',' && prevC >= 48 && prevC <= 57) {
                    sb.append(' ');
                } else {
                    sb.append(c);
                }
                prevC = c;
                c = nextC;
                ++pos;
            }
            sb.append(")");
            if (isPolygon) {
                sb.append(")");
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "none";
        }
    }

    public static double calculateArea(String wkt) {
        double sumarea = 0.0;
        String areaWorking = wkt;
        ArrayList<String> stringsList = new ArrayList<String>();
        if (areaWorking.startsWith("GEOMETRYCOLLECTION")) {
            areaWorking = areaWorking.replace("GEOMETRYCOLLECTION", "");
            int p1 = areaWorking.indexOf("POLYGON", 0);
            int p2 = areaWorking.indexOf("MULTIPOLYGON", 0);
            int posStart = p1 < 0 ? p2 : (p2 < 0 ? p1 : Math.min(p1, p2));
            p1 = areaWorking.indexOf("POLYGON", posStart + 10);
            p2 = areaWorking.indexOf("MULTIPOLYGON", posStart + 10);
            while (p1 > 0 || p2 > 0) {
                int posEnd = p1 < 0 ? p2 : (p2 < 0 ? p1 : Math.min(p1, p2));
                stringsList.add(areaWorking.substring(posStart, posEnd - 1));
                posStart = posEnd;
                p1 = areaWorking.indexOf("POLYGON", posStart + 10);
                p2 = areaWorking.indexOf("MULTIPOLYGON", posStart + 10);
            }
            stringsList.add(areaWorking.substring(posStart, areaWorking.length()));
        } else {
            stringsList.add(areaWorking);
        }
        for (String w : stringsList) {
            if (w.contains("ENVELOPE")) continue;
            try {
                String[] areas = w.split("\\),\\(");
                double shapearea = 0.0;
                for (String area : areas) {
                    area = StringUtils.replace((String)area, (String)" (", (String)"");
                    area = StringUtils.replace((String)area, (String)", ", (String)",");
                    area = StringUtils.replace((String)area, (String)"MULTIPOLYGON", (String)"");
                    area = StringUtils.replace((String)area, (String)"POLYGON", (String)"");
                    area = StringUtils.replace((String)area, (String)")", (String)"");
                    area = StringUtils.replace((String)area, (String)"(", (String)"");
                    String[] areaarr = area.split(",");
                    boolean isWorld = true;
                    for (int i = 0; i < areaarr.length - 1 && isWorld; ++i) {
                        String[] darea = areaarr[i].split(" ");
                        if (Double.parseDouble(darea[0]) < -174.0 && Double.parseDouble(darea[1]) < -84.0 || Double.parseDouble(darea[0]) < -174.0 && Double.parseDouble(darea[1]) > 84.0 || Double.parseDouble(darea[0]) > 174.0 && Double.parseDouble(darea[1]) > 84.0 || Double.parseDouble(darea[0]) > 174.0 && Double.parseDouble(darea[1]) < -84.0) continue;
                        isWorld = false;
                    }
                    if (isWorld) {
                        return 5.1E14;
                    }
                    double totalarea = 0.0;
                    String d = areaarr[0];
                    for (int f = 1; f < areaarr.length - 2; ++f) {
                        totalarea += Util.mh((String)d, (String)areaarr[f], (String)areaarr[f + 1]);
                    }
                    shapearea += totalarea * 6378137.0 * 6378137.0;
                }
                sumarea += Math.abs(shapearea);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error in calculateArea", (Throwable)e);
            }
        }
        return sumarea;
    }

    private static double mh(String a, String b, String c) {
        return Util.nh((String)a, (String)b, (String)c) * Util.hi((String)a, (String)b, (String)c);
    }

    private static double nh(String a, String b, String c) {
        int i;
        String[] poly = new String[]{a, b, c, a};
        double[] area = new double[3];
        double j = 0.0;
        for (i = 0; i < 3; ++i) {
            area[i] = Util.vd((String)poly[i], (String)poly[i + 1]);
            j += area[i];
        }
        double f = Math.tan((j /= 2.0) / 2.0);
        for (i = 0; i < 3; ++i) {
            f *= Math.tan((j - area[i]) / 2.0);
        }
        return 4.0 * Math.atan(Math.sqrt(Math.abs(f)));
    }

    private static double hi(String a, String b, String c) {
        String[] d = new String[]{a, b, c};
        double[][] bb = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            String[] coords = d[i].split(" ");
            double lng = Double.parseDouble(coords[0]);
            double lat = Double.parseDouble(coords[1]);
            double y = Util.uc((double)lat);
            double x = Util.uc((double)lng);
            bb[i][0] = Math.cos(y) * Math.cos(x);
            bb[i][1] = Math.cos(y) * Math.sin(x);
            bb[i][2] = Math.sin(y);
        }
        return bb[0][0] * bb[1][1] * bb[2][2] + bb[1][0] * bb[2][1] * bb[0][2] + bb[2][0] * bb[0][1] * bb[1][2] - bb[0][0] * bb[2][1] * bb[1][2] - bb[1][0] * bb[0][1] * bb[2][2] - bb[2][0] * bb[1][1] * bb[0][2] > 0.0 ? 1.0 : -1.0;
    }

    private static double vd(String a, String b) {
        String[] coords1 = a.split(" ");
        double lng1 = Double.parseDouble(coords1[0]);
        double lat1 = Double.parseDouble(coords1[1]);
        String[] coords2 = b.split(" ");
        double lng2 = Double.parseDouble(coords2[0]);
        double lat2 = Double.parseDouble(coords2[1]);
        double c = Util.uc((double)lat1);
        double d = Util.uc((double)lat2);
        return 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin((c - d) / 2.0), 2.0) + Math.cos(c) * Math.cos(d) * Math.pow(Math.sin((Util.uc((double)lng1) - Util.uc((double)lng2)) / 2.0), 2.0)));
    }

    private static double uc(double a) {
        return a * (Math.PI / 180);
    }

    public static String createCircleJs(double longitude, double latitude, double radius) {
        boolean belowMinus180 = false;
        double[][] points = new double[360][];
        for (int i = 0; i < 360; ++i) {
            points[i] = Util.computeOffset((double)latitude, (double)0.0, (double)radius, (int)i);
            if (!(points[i][0] + longitude < -180.0)) continue;
            belowMinus180 = true;
        }
        double dist = (double)(belowMinus180 ? 360 : 0) + longitude;
        StringBuilder s = new StringBuilder();
        s.append("POLYGON").append("((");
        for (int i = 0; i < 360; ++i) {
            s.append(points[i][0] + dist).append(" ").append(points[i][1]).append(",");
        }
        s.append(points[0][0] + dist).append(" ").append(points[0][1]);
        s.append("))");
        return s.toString();
    }

    static double[] computeOffset(double lat, double lng, double radius, int angle) {
        double b = radius / 6378137.0;
        double c = (double)angle * (Math.PI / 180);
        double e = lat * (Math.PI / 180);
        double d = Math.cos(b);
        b = Math.sin(b);
        double f = Math.sin(e);
        e = Math.cos(e);
        double g = d * f + b * e * Math.cos(c);
        double x = (lng * (Math.PI / 180) + Math.atan2(b * e * Math.sin(c), d - f * g)) / (Math.PI / 180);
        double y = Math.asin(g) / (Math.PI / 180);
        return new double[]{x, y};
    }

    public static String breakString(String message, int length) {
        StringBuilder newMessage = new StringBuilder();
        StringBuilder lastWord = new StringBuilder();
        for (int i = 0; i < message.length(); ++i) {
            if (i % length == 0 && i != 0) {
                if (lastWord.length() > 0) {
                    newMessage.delete(newMessage.length() - lastWord.length(), newMessage.length());
                    newMessage.append("\n");
                    newMessage.append((CharSequence)lastWord);
                    newMessage.append(message.charAt(i));
                    lastWord = new StringBuilder();
                    continue;
                }
                newMessage.append("\n");
                continue;
            }
            if (message.charAt(i) == ' ') {
                lastWord = new StringBuilder();
            } else {
                lastWord.append(message.charAt(i));
            }
            newMessage.append(message.charAt(i));
        }
        return newMessage.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrl(String feature) {
        StringBuilder content = new StringBuilder();
        HttpURLConnection conn = null;
        try {
            String line;
            URL url = new URL(feature);
            conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            while ((line = rd.readLine()) != null) {
                content.append(line).append("\n");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to read from: " + feature), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.disconnect();
                }
                catch (Exception e) {
                    LOGGER.error((Object)("failed to close url: " + feature), (Throwable)e);
                }
            }
        }
        return content.toString();
    }

    public static Facet getFacetForObject(String value, String id) {
        Facet f = new Facet(id, "\"" + value + "\"", true);
        ArrayList<Facet> facets = new ArrayList<Facet>();
        facets.add(f);
        if (new BiocacheQuery(null, null, null, facets, false, null).getOccurrenceCount() > 0) {
            return f;
        }
        return null;
    }

    public static String getStringValue(String startAt, String tag, String json) {
        String typeStart = "\"" + tag + "\":\"";
        String typeEnd = "\"";
        int beginning = startAt == null ? 0 : json.indexOf(startAt) + startAt.length();
        int start = json.indexOf(typeStart, beginning) + typeStart.length();
        int end = json.indexOf(typeEnd, start);
        return json.substring(start, end);
    }

    public static int findInArray(String lookFor, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(lookFor)) continue;
            return i;
        }
        return -1;
    }

    public static int nextColour() {
        int colour = LegendObject.colours[currentColourIdx % LegendObject.colours.length];
        ++currentColourIdx;
        return colour;
    }

    public static List<Map.Entry<String, String>> getQueryParameters(String params) {
        if (params == null || params.length() == 0) {
            return new ArrayList<Map.Entry<String, String>>();
        }
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>();
        for (String s : params.split("&")) {
            String[] keyvalue = s.split("=");
            if (keyvalue.length < 2) continue;
            String key = keyvalue[0];
            String value = keyvalue[1];
            try {
                value = URLDecoder.decode(value, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error((Object)("error decoding to UTF-8: " + value), (Throwable)e);
            }
            list.add(new AbstractMap.SimpleEntry<String, String>(key, value));
        }
        return list;
    }

    public static String getUserEmail() {
        String useremail = null;
        try {
            if (Executions.getCurrent().getUserPrincipal() != null) {
                Principal principal = Executions.getCurrent().getUserPrincipal();
                if (principal instanceof AttributePrincipal) {
                    AttributePrincipal ap = (AttributePrincipal)principal;
                    useremail = (String)ap.getAttributes().get("email");
                } else {
                    useremail = principal.getName();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"no user available", (Throwable)e);
        }
        if (useremail == null) {
            return "guest@ala.org.au";
        }
        return useremail;
    }

    public static boolean isLoggedIn() {
        return Util.getUserEmail() != null;
    }

    public static WKTReducedDTO reduceWKT(String originalWKT) {
        String wkt = originalWKT;
        String reducedBy = "No reduction.";
        if (wkt == null) {
            return new WKTReducedDTO(null, null, "Invalid WKT.");
        }
        try {
            WKTReader wktReader = new WKTReader();
            Geometry g = wktReader.read(wkt);
            int maxPoints = Integer.parseInt(CommonData.getSettings().getProperty("max_q_wkt_points", "200"));
            Geometry bestReduction = g;
            for (double distance = 1.0E-4; maxPoints > 0 && g.getNumPoints() > maxPoints && distance < 10.0; distance *= 2.0) {
                Geometry gsimplified;
                bestReduction = gsimplified = TopologyPreservingSimplifier.simplify((Geometry)g, (double)distance);
                reducedBy = "Simplified using distance tolerance " + distance;
            }
            wkt = bestReduction.toText();
            LOGGER.info((Object)("user WKT of length: " + wkt.length()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to reduce WKT size", (Throwable)e);
        }
        return new WKTReducedDTO(originalWKT, wkt.replace(" (", "(").replace(", ", ","), reducedBy);
    }

    public static String readUrlPost(String url, NameValuePair[] params) {
        try {
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(url);
            post.setRequestBody(params);
            int result = client.executeMethod((HttpMethod)post);
            if (result == 200) {
                return post.getResponseBodyAsString();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to read url: " + url), (Throwable)e);
        }
        return null;
    }

    public static String[] getDistributionOrChecklist(String spcode) {
        try {
            StringBuilder sbProcessUrl = new StringBuilder();
            sbProcessUrl.append("/distribution/").append(spcode).append("?nowkt=true");
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(CommonData.getLayersServer() + sbProcessUrl.toString());
            LOGGER.debug((Object)(CommonData.getLayersServer() + sbProcessUrl.toString()));
            get.addRequestHeader("Accept", "application/json, text/javascript, */*");
            int result = client.executeMethod((HttpMethod)get);
            if (result == 200) {
                JSONParser jp = new JSONParser();
                String txt = get.getResponseBodyAsString();
                JSONObject jo = (JSONObject)jp.parse(txt);
                if (jo == null) {
                    return new String[0];
                }
                String[] output = new String[14];
                String scientific = jo.containsKey((Object)"scientific") ? jo.get((Object)"scientific").toString() : "";
                String auth = jo.containsKey((Object)"authority_") ? jo.get((Object)"authority_").toString() : "";
                String common = jo.containsKey((Object)"common_nam") ? jo.get((Object)"common_nam").toString() : "";
                String family = jo.containsKey((Object)"family") ? jo.get((Object)"family").toString() : "";
                String genus = jo.containsKey((Object)"genus") ? jo.get((Object)"genus").toString() : "";
                String name = jo.containsKey((Object)"specific_n") ? jo.get((Object)"specific_n").toString() : "";
                String min = jo.containsKey((Object)"min_depth") ? jo.get((Object)"min_depth").toString() : "";
                String max = jo.containsKey((Object)"max_depth") ? jo.get((Object)"max_depth").toString() : "";
                String md = jo.containsKey((Object)"metadata_u") ? jo.get((Object)"metadata_u").toString() : "";
                String lsid = jo.containsKey((Object)"lsid") ? jo.get((Object)"lsid").toString() : "";
                String areaName = jo.containsKey((Object)"area_name") ? jo.get((Object)"area_name").toString() : "";
                String areaKm = jo.containsKey((Object)"area_km") ? jo.get((Object)"area_km").toString() : "";
                String dataResourceId = jo.containsKey((Object)"data_resource_uid") ? jo.get((Object)"data_resource_uid").toString() : "";
                output[0] = spcode;
                output[1] = scientific;
                output[2] = auth;
                output[3] = common;
                output[4] = family;
                output[5] = genus;
                output[6] = name;
                output[7] = min;
                output[8] = max;
                output[9] = md;
                output[10] = lsid;
                output[11] = areaName;
                output[12] = areaKm;
                output[13] = dataResourceId;
                return output;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error building distributions list", (Throwable)e);
        }
        return new String[0];
    }

    public static String[] getDistributionsOrChecklists(String type, String wkt, String lsids, String geomIdx) {
        try {
            StringBuilder sbProcessUrl = new StringBuilder();
            sbProcessUrl.append("/").append(type);
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(CommonData.getLayersServer() + sbProcessUrl.toString());
            LOGGER.debug((Object)(CommonData.getLayersServer() + sbProcessUrl.toString()));
            if (wkt != null) {
                post.addParameter("wkt", wkt);
            }
            if (lsids != null) {
                post.addParameter("lsids", lsids);
            }
            if (geomIdx != null) {
                post.addParameter("geom_idx", geomIdx);
            }
            post.addRequestHeader("Accept", "application/json, text/javascript, */*");
            int result = client.executeMethod((HttpMethod)post);
            if (result == 200) {
                JSONParser jp = new JSONParser();
                String txt = post.getResponseBodyAsString();
                JSONArray ja = (JSONArray)jp.parse(txt);
                if (ja == null || ja.isEmpty()) {
                    return new String[0];
                }
                String[] lines = new String[ja.size() + 1];
                lines[0] = "SPCODE,SCIENTIFIC_NAME,AUTHORITY_FULL,COMMON_NAME,FAMILY,GENUS_NAME,SPECIFIC_NAME,MIN_DEPTH,MAX_DEPTH,METADATA_URL,LSID,AREA_NAME,AREA_SQ_KM";
                for (int i = 0; i < ja.size(); ++i) {
                    JSONObject jo = (JSONObject)ja.get(i);
                    String spcode = jo.containsKey((Object)"spcode") ? jo.get((Object)"spcode").toString() : "";
                    String scientific = jo.containsKey((Object)"scientific") ? jo.get((Object)"scientific").toString() : "";
                    String auth = jo.containsKey((Object)"authority_") ? jo.get((Object)"authority_").toString() : "";
                    String common = jo.containsKey((Object)"common_nam") ? jo.get((Object)"common_nam").toString() : "";
                    String family = jo.containsKey((Object)"family") ? jo.get((Object)"family").toString() : "";
                    String genus = jo.containsKey((Object)"genus") ? jo.get((Object)"genus").toString() : "";
                    String name = jo.containsKey((Object)"specific_n") ? jo.get((Object)"specific_n").toString() : "";
                    String min = jo.containsKey((Object)"min_depth") ? jo.get((Object)"min_depth").toString() : "";
                    String max = jo.containsKey((Object)"max_depth") ? jo.get((Object)"max_depth").toString() : "";
                    String md = jo.containsKey((Object)"metadata_u") ? jo.get((Object)"metadata_u").toString() : "";
                    String lsid = jo.containsKey((Object)"lsid") ? jo.get((Object)"lsid").toString() : "";
                    String areaName = jo.containsKey((Object)"area_name") ? jo.get((Object)"area_name").toString() : "";
                    String areaKm = jo.containsKey((Object)"area_km") ? jo.get((Object)"area_km").toString() : "";
                    String dataResourceUid = jo.containsKey((Object)"data_resource_uid") ? jo.get((Object)"data_resource_uid").toString() : "";
                    lines[i + 1] = spcode + "," + Util.wrap((String)scientific) + "," + Util.wrap((String)auth) + "," + Util.wrap((String)common) + "," + Util.wrap((String)family) + "," + Util.wrap((String)genus) + "," + Util.wrap((String)name) + "," + min + "," + max + "," + Util.wrap((String)md) + "," + Util.wrap((String)lsid) + "," + Util.wrap((String)areaName) + "," + Util.wrap((String)areaKm) + "," + Util.wrap((String)dataResourceUid);
                }
                return lines;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error building distribution or checklist csv", (Throwable)e);
        }
        return new String[0];
    }

    public static String wrap(String s) {
        return "\"" + s.replace("\"", "\"\"").replace("\\", "\\\\") + "\"";
    }

    public static String[] getAreaChecklists(String[] records) {
        String[] lines = null;
        try {
            if (records != null && records.length > 0) {
                String[][] data = new String[records.length - 1][];
                for (int i = 1; i < records.length; ++i) {
                    CSVReader csv = new CSVReader((Reader)new StringReader(records[i]));
                    data[i - 1] = csv.readNext();
                    csv.close();
                }
                Arrays.sort(data, new /* Unavailable Anonymous Inner Class!! */);
                lines = new String[records.length];
                lines[0] = "SPCODE,SCIENTIFIC_NAME,AUTHORITY_FULL,COMMON_NAME,FAMILY,GENUS_NAME,SPECIFIC_NAME,MIN_DEPTH,MAX_DEPTH,METADATA_URL,LSID,AREA_NAME,AREA_SQ_KM,SPECIES_COUNT";
                lines[0] = "SPCODE,SCIENTIFIC_NAME,AUTHORITY_FULL,COMMON_NAME,FAMILY,GENUS_NAME,SPECIFIC_NAME,MIN_DEPTH,MAX_DEPTH,METADATA_URL,LSID,AREA_NAME,AREA_SQ_KM,SPECIES_COUNT";
                int len = 1;
                int thisCount = 0;
                for (int i = 0; i < data.length; ++i) {
                    ++thisCount;
                    if (i != data.length - 1 && CommonData.getSpeciesChecklistWMSFromSpcode((String)data[i][0])[1].equals(CommonData.getSpeciesChecklistWMSFromSpcode((String)data[i + 1][0])[1])) continue;
                    StringBuilder sb = new StringBuilder();
                    for (int j = 0; j < data[i].length; ++j) {
                        if (j > 0) {
                            sb.append(",");
                        }
                        if (j != 0 && (j < 9 || j == 10)) continue;
                        sb.append(Util.wrap((String)data[i][j]));
                    }
                    sb.append(",").append(thisCount);
                    lines[len] = sb.toString();
                    ++len;
                    thisCount = 0;
                }
                lines = Arrays.copyOf(lines, len);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error building species checklist", (Throwable)e);
            lines = null;
        }
        return lines;
    }

    public static String getMetadataHtmlForDistributionOrChecklist(String spcode, String[] row, String layerName) {
        if (CommonData.getSpeciesDistributionWMSFromSpcode((String)spcode) != null && CommonData.getSpeciesDistributionWMSFromSpcode((String)spcode)[0] != null) {
            return Util.getMetadataHtmlForExpertDistribution((String[])Util.getDistributionOrChecklist((String)spcode));
        }
        return Util.getMetadataHtmlForAreaChecklist((String)spcode, (String)layerName);
    }

    public static String getMetadataHtmlForExpertDistribution(String[] row) {
        if (row.length == 0) {
            return null;
        }
        String scientificName = row[1];
        String commonName = row[3];
        String familyName = row[4];
        String minDepth = row[7];
        String maxDepth = row[8];
        String metadataLink = row[9];
        String lsid = row[10];
        String area = row[12];
        String dataResourceUid = row[13];
        String[] distributionCollectoryDetails = Util.getDistributionCollectoryDetails((String)dataResourceUid);
        String websiteUrl = distributionCollectoryDetails[0];
        String citation = distributionCollectoryDetails[1];
        String logoUrl = distributionCollectoryDetails[2];
        String speciesPageUrl = CommonData.getBieServer() + "/species/" + lsid;
        String html = "Expert Distribution\n";
        html = html + "<table class='md_table'>";
        html = html + "<tr class='md_grey-bg'><td class='md_th'>Scientific name: </td><td class='md_spacer'/><td class='md_value'><a target='_blank' href='" + speciesPageUrl + "'>" + scientificName + "</a></td></tr>";
        html = html + "<tr><td class='md_th'>Common name: </td><td class='md_spacer'/><td class='md_value'>" + commonName + "</td></tr>";
        html = html + "<tr class='md_grey-bg'><td class='md_th'>Family name: </td><td class='md_spacer'/><td class='md_value'>" + familyName + "</td></tr>";
        String lastClass = "";
        if (row[7] != null && row[7].length() > 0) {
            html = html + "<tr class='" + lastClass + "'><td class='md_th'>Min depth: </td><td class='md_spacer'/><td class='md_value'>" + minDepth + "</td></tr>";
            String string = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
        }
        if (row[8] != null && row[8].length() > 0) {
            html = html + "<tr class='" + lastClass + "'><td class='md_th'>Max depth: </td><td class='md_spacer'/><td class='md_value'>" + maxDepth + "</td></tr>";
            String string = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
        }
        if (row[9] != null && row[9].length() > 0) {
            html = html + "<tr class='" + lastClass + "'><td class='md_th'>Metadata link: </td><td class='md_spacer'/><td class='md_value'><a target='_blank' href='" + metadataLink + "'>" + metadataLink + "</a></td></tr>";
            String string = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
        }
        if (row[12] != null && row[12].length() > 0) {
            html = html + "<tr class='" + lastClass + "'><td class='md_th'>Area sq km: </td><td class='md_spacer'/><td class='md_value'>" + area + "</td></tr>";
            lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
        }
        html = html + "<tr class='" + lastClass + "'><td class='md_th'>Source website: </td><td class='md_spacer'/><td class='md_value'><a target='_blank' href='" + websiteUrl + "'>" + websiteUrl + "</a></td></tr>";
        String string = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
        if (citation != null) {
            html = html + "<tr class='" + lastClass + "'><td class='md_th'>Citation: </td><td class='md_spacer'/><td class='md_value'>" + citation + "</td></tr>";
            String string2 = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
        }
        if (logoUrl != null) {
            html = html + "<tr class='" + lastClass + "'><td class='md_th'></td><td class='md_spacer'/><td class='md_value'><img src=\"" + logoUrl + "\"/></td></tr>";
        }
        html = html + "</table>";
        return html;
    }

    public static String[] getDistributionCollectoryDetails(String dataResourceUid) {
        try {
            String url = CommonData.collectoryServer + "/dataResource/" + dataResourceUid;
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(url);
            LOGGER.debug((Object)url);
            get.addRequestHeader("Accept", "application/json, text/javascript, */*");
            int result = client.executeMethod((HttpMethod)get);
            if (result == 200) {
                JSONObject logoObject;
                JSONParser jp = new JSONParser();
                String txt = get.getResponseBodyAsString();
                JSONObject jo = (JSONObject)jp.parse(txt);
                if (jo == null) {
                    return new String[0];
                }
                String[] output = new String[13];
                String websiteUrl = jo.containsKey((Object)"websiteUrl") ? jo.get((Object)"websiteUrl").toString() : "";
                String citation = jo.containsKey((Object)"citation") && jo.containsValue((Object)"citation") ? jo.get((Object)"citation").toString() : null;
                String logoUrl = null;
                if (jo.containsKey((Object)"logoRef") && (logoObject = (JSONObject)jo.get((Object)"logoRef")).containsKey((Object)"uri")) {
                    logoUrl = logoObject.get((Object)"uri").toString();
                }
                output[0] = websiteUrl;
                output[1] = citation;
                output[2] = logoUrl;
                return output;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error fetching collectory details for distributions area", (Throwable)e);
        }
        return new String[0];
    }

    public static String getMetadataHtmlForAreaChecklist(String spcode, String layerName) {
        if (spcode == null) {
            return null;
        }
        try {
            int count = CommonData.getSpeciesChecklistCountByWMS((String)CommonData.getSpeciesChecklistWMSFromSpcode((String)spcode)[1]);
            String url = CommonData.getLayersServer() + "/checklist/" + spcode;
            String jsontxt = Util.readUrl((String)url);
            if (jsontxt == null || jsontxt.length() == 0) {
                return null;
            }
            JSONParser jp = new JSONParser();
            JSONObject jo = (JSONObject)jp.parse(jsontxt);
            String html = "Checklist area\n";
            html = html + "<table class='md_table'>";
            String lastClass = "";
            html = layerName != null && jo.containsKey((Object)"geom_idx") ? html + "<tr class='" + lastClass + "'><td class='md_th'>Number of scientific names: </td><td class='md_spacer'/><td class='md_value'><a href='#' onClick='openAreaChecklist(\"" + jo.get((Object)"geom_idx") + "\")'>" + count + "</a></td></tr>" : html + "<tr class='" + lastClass + "'><td class='md_th'>Number of scientific names: </td><td class='md_spacer'/><td class='md_value'>" + count + "</td></tr>";
            String string = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            if (jo != null && jo.containsKey((Object)"metadata_u")) {
                html = html + "<tr class='" + lastClass + "'><td class='md_th'>Metadata link: </td><td class='md_spacer'/><td class='md_value'><a target='_blank' href='" + jo.get((Object)"metadata_u") + "'>" + jo.get((Object)"metadata_u") + "</a></td></tr>";
                String string2 = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            }
            if (jo != null && jo.containsKey((Object)"area_name")) {
                html = html + "<tr class='" + lastClass + "'><td class='md_th'>Area name: </td><td class='md_spacer'/><td class='md_value'>" + jo.get((Object)"area_name") + "</td></tr>";
                String string3 = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            }
            if (jo != null && jo.containsKey((Object)"area_km")) {
                html = html + "<tr class='" + lastClass + "'><td class='md_th'>Area sq km: </td><td class='md_spacer'/><td class='md_value'>" + jo.get((Object)"area_km") + "</td></tr>";
                lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            }
            try {
                if (jo != null && jo.containsKey((Object)"pid") && jo.containsKey((Object)"area_name")) {
                    String fid = Util.getStringValue(null, (String)"fid", (String)Util.readUrl((String)(CommonData.getLayersServer() + "/object/" + jo.get((Object)"pid"))));
                    String spid = Util.getStringValue((String)("\"id\":\"" + fid + "\""), (String)"spid", (String)Util.readUrl((String)(CommonData.getLayersServer() + "/fields")));
                    if (spid != null) {
                        String layerInfoUrl = CommonData.getLayersServer() + "/layers/view/more/" + spid;
                        html = html + "<tr class='" + lastClass + "'><td class='md_th'>More about this area: </td><td class='md_spacer'/><td class='md_value'><a target='_blank' href='" + layerInfoUrl + "'>" + layerInfoUrl + "</a></td></tr>";
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"error building metadata HTML", (Throwable)e);
            }
            html = html + "</table>";
            return html;
        }
        catch (Exception e) {
            LOGGER.error((Object)("error building html metadata for distributions area spcode=" + spcode), (Throwable)e);
            return null;
        }
    }

    public static String fixWkt(String wkt) {
        if (wkt == null || !wkt.startsWith("POLYGON") && !wkt.startsWith("MULTIPOLYGON")) {
            return wkt;
        }
        String newWkt = wkt;
        try {
            IsValidOp op;
            WKTReader wktReader = new WKTReader();
            Geometry g = wktReader.read(wkt);
            Envelope env = g.getEnvelopeInternal();
            if (env.getMinX() < -180.0 || env.getMaxX() > 180.0) {
                int minx = -180;
                while ((double)minx > env.getMinX()) {
                    minx -= 360;
                }
                int maxx = 180;
                while ((double)maxx < env.getMaxX()) {
                    maxx += 360;
                }
                Geometry newGeometry = null;
                for (int i = minx; i < maxx; i += 360) {
                    Geometry cutter = wktReader.read("POLYGON((" + i + " -90," + i + " 90," + (i + 360) + " 90," + (i + 360) + " -90," + i + " -90))");
                    Geometry part = cutter.intersection(g);
                    if (i != -180) {
                        AffineTransformation at = AffineTransformation.translationInstance((double)(-180 - i), (double)0.0);
                        part.apply((CoordinateSequenceFilter)at);
                    }
                    if (!(part.getArea() > 0.0)) continue;
                    newGeometry = newGeometry == null ? part : newGeometry.union(part);
                }
                newWkt = newGeometry.toText();
            }
            if (!(op = new IsValidOp(g)).isValid()) {
                g = g.buffer(0.0);
                op = new IsValidOp(g);
            }
            if (op.isValid() && g.isRectangle()) {
                Envelope envelope = g.getEnvelopeInternal();
                newWkt = "POLYGON((" + envelope.getMinX() + " " + envelope.getMinY() + "," + envelope.getMaxX() + " " + envelope.getMinY() + "," + envelope.getMaxX() + " " + envelope.getMaxY() + "," + envelope.getMinX() + " " + envelope.getMaxY() + "," + envelope.getMinX() + " " + envelope.getMinY() + "))";
            }
        }
        catch (ParseException parseException) {
            LOGGER.error((Object)"error fixing WKT", (Throwable)parseException);
        }
        return newWkt;
    }

    public static List<Double> getBoundingBox(String wkt) {
        try {
            WKTReader wktReader = new WKTReader();
            Geometry g = wktReader.read(wkt);
            ArrayList<Double> bbox = new ArrayList<Double>();
            bbox.add(g.getEnvelopeInternal().getMinX());
            bbox.add(g.getEnvelopeInternal().getMinY());
            bbox.add(g.getEnvelopeInternal().getMaxX());
            bbox.add(g.getEnvelopeInternal().getMaxY());
            return bbox;
        }
        catch (Exception e) {
            return Util.getBoundingBox((String)"POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))");
        }
    }

    public static String[] getDomain(JSONObject layerObject) {
        if (!layerObject.containsKey((Object)"domain")) {
            return new String[0];
        }
        String ds = layerObject.get((Object)"domain").toString();
        if (ds != null) {
            String[] d = ds.split(",");
            for (int i = 0; i < d.length; ++i) {
                d[i] = d[i].trim();
            }
            return d;
        }
        return new String[0];
    }

    public static boolean isSameDomain(String[] domain1, String[] domain2) {
        if (domain1.length == 0 || domain2.length == 0) {
            return true;
        }
        for (String s1 : domain1) {
            for (String s2 : domain2) {
                if (!s1.equalsIgnoreCase(s2)) continue;
                return true;
            }
        }
        return false;
    }
}

