/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import au.org.ala.legend.Facet;
import au.org.ala.legend.LegendObject;
import au.org.ala.legend.QueryField;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Query;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class UserDataQuery
implements Query {
    static final String SAMPLING_SERVICE_CSV_GZIP = "/userdata/occurrences.gz?";
    static final String SAMPLING_SERVICE = "/userdata/occurrences?";
    static final String DOWNLOAD_URL = "/userdata/sample?";
    static final String LEGEND_SERVICE_CSV = "/userdata/legend?";
    static final Pattern QUERY_PARAMS_PATTERN = Pattern.compile("&([a-zA-Z0-9_\\-]+)=");
    static final String DEFAULT_VALIDATION = "";
    static final String WMS_URL = "/userdata/wms/reflect?";
    private static final Logger LOGGER = Logger.getLogger(UserDataQuery.class);
    private String name;
    private String udHeaderId;
    private List<Facet> facets;
    private String wkt;
    private String qc;
    private String layersServiceServer;
    private boolean forMapping;
    private int occurrenceCount = -1;
    private List<Double> bbox = null;
    private String metadata;
    private Map<String, LegendObject> legends = new HashMap();
    private Set<String> flaggedRecords = new HashSet();
    private List<QueryField> facetFieldList = null;

    public UserDataQuery(String udHeaderId) {
        this.udHeaderId = udHeaderId;
        this.layersServiceServer = CommonData.getLayersServer();
        StringBuilder sbProcessUrl = new StringBuilder();
        sbProcessUrl.append(CommonData.getLayersServer()).append("/userdata/facet");
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(sbProcessUrl.toString());
        post.addRequestHeader("Accept", "application/json");
        post.addParameter("id", udHeaderId);
        try {
            LOGGER.debug((Object)("calling facet user data ws: " + sbProcessUrl.toString()));
            client.executeMethod((HttpMethod)post);
            JSONObject jo = (JSONObject)new JSONParser().parse(post.getResponseBodyAsString());
            String facetId = jo.containsKey((Object)"facet_id") ? ":" + jo.get((Object)"facet_id") : DEFAULT_VALIDATION;
            this.udHeaderId = udHeaderId.split(":")[0] + facetId;
            if (jo.containsKey((Object)"metadata")) {
                JSONObject j = (JSONObject)new JSONParser().parse((String)jo.get((Object)"metadata"));
                if (j.containsKey((Object)"bbox")) {
                    String[] b = ((String)j.get((Object)"bbox")).split(",");
                    this.bbox = new ArrayList();
                    this.bbox.add(Double.parseDouble(b[0]));
                    this.bbox.add(Double.parseDouble(b[1]));
                    this.bbox.add(Double.parseDouble(b[2]));
                    this.bbox.add(Double.parseDouble(b[3]));
                }
                if (j.containsKey((Object)"number_of_records")) {
                    this.occurrenceCount = ((Long)j.get((Object)"number_of_records")).intValue();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to create the facet", (Throwable)e);
        }
    }

    public UserDataQuery(String udHeaderId, String wkt, List<Facet> facets) {
        if (facets != null) {
            this.facets = new ArrayList(facets.size());
            for (int i = 0; i < facets.size(); ++i) {
                this.facets.add(facets.get(i));
            }
        }
        this.wkt = wkt != null && wkt.equals("POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))") ? null : wkt;
        this.udHeaderId = udHeaderId;
        this.layersServiceServer = CommonData.getLayersServer();
        StringBuilder sbProcessUrl = new StringBuilder();
        sbProcessUrl.append(CommonData.getLayersServer()).append("/userdata/facet");
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(sbProcessUrl.toString());
        post.addRequestHeader("Accept", "application/json");
        if (wkt != null) {
            post.addParameter("wkt", wkt);
        }
        if (facets != null) {
            int i = 0;
            for (Facet f : facets) {
                post.addParameter("facet" + i, f.toString());
                ++i;
            }
        }
        post.addParameter("id", udHeaderId);
        try {
            LOGGER.debug((Object)("calling facet user data ws: " + sbProcessUrl.toString()));
            client.executeMethod((HttpMethod)post);
            JSONObject jo = (JSONObject)new JSONParser().parse(post.getResponseBodyAsString());
            String facetId = jo.containsKey((Object)"facet_id") ? ":" + jo.get((Object)"facet_id") : DEFAULT_VALIDATION;
            this.udHeaderId = udHeaderId.split(":")[0] + facetId;
            if (jo.containsKey((Object)"metadata")) {
                JSONObject j = (JSONObject)new JSONParser().parse((String)jo.get((Object)"metadata"));
                if (j.containsKey((Object)"bbox")) {
                    String[] b = ((String)j.get((Object)"bbox")).split(",");
                    this.bbox = new ArrayList();
                    this.bbox.add(Double.parseDouble(b[0]));
                    this.bbox.add(Double.parseDouble(b[1]));
                    this.bbox.add(Double.parseDouble(b[2]));
                    this.bbox.add(Double.parseDouble(b[3]));
                }
                if (j.containsKey((Object)"number_of_records")) {
                    this.occurrenceCount = ((Long)j.get((Object)"number_of_records")).intValue();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to create the facet", (Throwable)e);
        }
    }

    public UserDataQuery newFacet(Facet facet, boolean forMapping) {
        if (facet == null) {
            return this;
        }
        ArrayList<Facet> newFacets = new ArrayList<Facet>();
        if (this.facets != null) {
            newFacets.addAll(this.facets);
        }
        newFacets.add(facet);
        return new UserDataQuery(this.udHeaderId, this.wkt, newFacets);
    }

    public UserDataQuery newWkt(String wkt, boolean forMapping) {
        if (wkt == null || wkt.equals("POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))") || wkt.equals(this.wkt)) {
            return this;
        }
        UserDataQuery sq = null;
        try {
            String newWkt = wkt;
            if (this.wkt != null) {
                Geometry newGeom = new WKTReader().read(wkt);
                Geometry thisGeom = new WKTReader().read(this.wkt);
                Geometry intersectionGeom = thisGeom.intersection(newGeom);
                newWkt = new WKTWriter().write(intersectionGeom).replace(" (", "(").replace(", ", ",").replace(") ", ")");
            }
            sq = new UserDataQuery(this.udHeaderId, newWkt, this.facets);
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to filter user uploaded points with WKT: " + this.udHeaderId + ", " + wkt));
        }
        return sq;
    }

    public String sample(List<QueryField> fields) {
        HttpClient client = new HttpClient();
        String url = this.layersServiceServer + SAMPLING_SERVICE_CSV_GZIP + "&q=" + this.getQ() + this.paramQueryFields(fields);
        LOGGER.debug((Object)url);
        GetMethod get = new GetMethod(url);
        String sample = null;
        long start = System.currentTimeMillis();
        try {
            client.executeMethod((HttpMethod)get);
            sample = this.decompressGz(get.getResponseBodyAsStream());
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to sample for: " + url), (Throwable)e);
        }
        LOGGER.debug((Object)("get sample in " + (System.currentTimeMillis() - start) + "ms"));
        return sample;
    }

    public String speciesList() {
        return null;
    }

    public String endemicSpeciesList() {
        return null;
    }

    public int getOccurrenceCount() {
        return this.occurrenceCount;
    }

    public int getSpeciesCount() {
        return 1;
    }

    public int getEndemicSpeciesCount() {
        return 1;
    }

    String paramQueryFields(List<QueryField> fields) {
        StringBuilder sb = new StringBuilder();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fields.get(i).getName());
            }
        }
        return sb.length() > 0 ? "&fl=" + sb.toString() : DEFAULT_VALIDATION;
    }

    public String getQ() {
        return this.udHeaderId;
    }

    public String getFullQ(boolean encode) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.metadata).append("\n");
        if (this.wkt != null && this.wkt.length() > 0) {
            sb.append(this.wkt).append("\n");
        }
        for (int i = 0; i < this.facets.size(); ++i) {
            sb.append(((Facet)this.facets.get(i)).toString()).append("\n");
        }
        return sb.toString();
    }

    public String getName() {
        if (this.name == null) {
            this.name = "User uploaded points";
        }
        return this.name;
    }

    public String getRank() {
        return "species";
    }

    private String decompressGz(InputStream gzipped) throws IOException {
        String s = null;
        try {
            int size;
            GZIPInputStream gzip = new GZIPInputStream(gzipped);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x100000);
            byte[] buffer = new byte[0x100000];
            while ((size = gzip.read(buffer)) >= 0) {
                baos.write(buffer, 0, size);
            }
            s = new String(baos.toByteArray());
        }
        catch (Exception e) {
            LOGGER.error((Object)"error decompressing gz", (Throwable)e);
        }
        gzipped.close();
        return s;
    }

    public List<QueryField> getFacetFieldList() {
        if (this.facetFieldList == null) {
            ArrayList fields = new ArrayList();
            fields.addAll(this.getQueryFields());
            this.facetFieldList = fields;
        }
        return this.facetFieldList;
    }

    private List<QueryField> getQueryFields() {
        ArrayList<QueryField> fields = new ArrayList<QueryField>();
        try {
            ObjectMapper om = new ObjectMapper();
            List ja = (List)om.readValue(new URL(CommonData.getLayersServer() + "/userdata/list?id=" + this.udHeaderId), List.class);
            for (int i = 0; i < ja.size(); ++i) {
                fields.add(this.getQueryField((String)ja.get(i)));
            }
            for (QueryField f : CommonData.getDefaultUploadSamplingFields()) {
                fields.add(this.getQueryField(f.getName()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to create the facet", (Throwable)e);
        }
        return fields;
    }

    private QueryField getQueryField(String field) {
        ObjectMapper om = new ObjectMapper();
        try {
            return (QueryField)om.readValue(new URL(CommonData.getLayersServer() + "/userdata/getqf?id=" + this.udHeaderId + "&field=" + URLEncoder.encode(field, "UTF-8")), QueryField.class);
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting query field header: " + this.udHeaderId + " field: " + field), (Throwable)e);
            return null;
        }
    }

    public String getSpeciesIdFieldName() {
        return "null";
    }

    public String getRecordIdFieldName() {
        return "id";
    }

    public String getRecordLongitudeFieldName() {
        return "longitude";
    }

    public String getRecordLatitudeFieldName() {
        return "latitude";
    }

    public String getRecordIdFieldDisplayName() {
        return "id";
    }

    public String getRecordLongitudeFieldDisplayName() {
        return "longitude";
    }

    public String getRecordLatitudeFieldDisplayName() {
        return "latitude";
    }

    public LegendObject getLegend(String colourmode) {
        if ("-1".equals(colourmode) || "grid".equals(colourmode)) {
            return null;
        }
        LegendObject lo = (LegendObject)this.legends.get(colourmode);
        if (lo == null) {
            for (int i = 0; i < this.facetFieldList.size(); ++i) {
                if (!((QueryField)this.facetFieldList.get(i)).getName().equals(colourmode)) continue;
                return ((QueryField)this.facetFieldList.get(i)).getLegend();
            }
            QueryField qf = this.getQueryField(colourmode);
            if (qf != null) {
                this.facetFieldList.add(qf);
                return qf.getLegend();
            }
        }
        return lo;
    }

    public Query newFacets(List<Facet> facets, boolean forMapping) {
        if (!(facets != null && !facets.isEmpty() || !this.forMapping && forMapping)) {
            return this;
        }
        ArrayList<Facet> newFacets = new ArrayList<Facet>();
        if (this.facets != null) {
            newFacets.addAll(this.facets);
        }
        newFacets.addAll(facets);
        return new UserDataQuery(this.udHeaderId, this.wkt, newFacets);
    }

    public String getUrl() {
        return CommonData.getLayersServer() + WMS_URL;
    }

    public List<Double> getBBox() {
        return this.bbox;
    }

    public String getMetadataHtml() {
        return "user uploaded points";
    }

    public String getDownloadUrl(String[] extraFields) {
        ArrayList fieldsAlreadyIncluded = new ArrayList();
        StringBuilder sb = new StringBuilder();
        if (extraFields != null && extraFields.length > 0) {
            for (int i = 0; i < extraFields.length; ++i) {
                if (fieldsAlreadyIncluded.contains(extraFields[i])) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                } else {
                    sb.append("&fl=");
                }
                sb.append(extraFields[i]);
            }
        }
        return this.layersServiceServer + DOWNLOAD_URL + "q=" + this.getQ() + sb.toString();
    }

    public String getQc() {
        return DEFAULT_VALIDATION;
    }

    public void setQc(String qc) {
    }

    public String getRecordFieldDisplayName(String colourMode) {
        return colourMode;
    }

    public void flagRecord(String id, boolean set) {
        if (set) {
            this.flaggedRecords.add(id);
        } else {
            this.flaggedRecords.remove(id);
        }
    }

    public int flagRecordCount() {
        return this.flaggedRecords.size();
    }

    public String getFlaggedRecords() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.flaggedRecords) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public Query newFlaggedRecords(boolean include) {
        if (this.flagRecordCount() == 0) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        if (include) {
            for (String s : this.flaggedRecords) {
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("id:").append(s);
            }
        } else {
            for (String s : this.flaggedRecords) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append("-id:").append(s);
            }
        }
        ArrayList<Facet> newFacets = new ArrayList<Facet>();
        if (this.facets != null) {
            newFacets.addAll(this.facets);
        }
        newFacets.add(Facet.parseFacet((String)sb.toString()));
        return new UserDataQuery(this.udHeaderId, this.wkt, newFacets);
    }

    public String getAutoComplete(String facet, String value, int limit) {
        return null;
    }

    public String getBS() {
        return CommonData.getLayersServer();
    }

    public String[] getDefaultDownloadFields() {
        return new String[0];
    }
}

