/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import au.org.ala.spatial.dto.SpeciesListDTO;
import au.org.ala.spatial.dto.SpeciesListItemDTO;
import au.org.ala.spatial.util.CommonData;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.zkoss.json.JSONValue;

/*
 * Exception performing whole class analysis ignored.
 */
@Component(value="listUtil")
public class SpeciesListUtil {
    private static final Logger LOGGER = Logger.getLogger(SpeciesListUtil.class);
    private static Map<String, String> speciesListMap = new HashMap();

    public static Map<String, String> getSpeciesListMap() {
        return speciesListMap;
    }

    public static int getNumberOfPublicSpeciesLists(String user) {
        JSONObject jobject = SpeciesListUtil.getLists((String)user, (Integer)0, (Integer)0, null, null, null);
        if (jobject != null) {
            return Integer.parseInt(jobject.get((Object)"listCount").toString());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getLists(String user, Integer offset, Integer max, String sort, String order, String searchTerm) {
        StringBuilder sb = new StringBuilder(CommonData.getSpeciesListServer());
        sb.append("/ws/speciesList");
        sb.append("?user=");
        if (user != null && !"guest@ala.org.au".equals(user)) {
            sb.append(user);
        }
        if (offset != null) {
            sb.append("&offset=").append(offset.toString());
        }
        if (max != null) {
            sb.append("&max=").append(max);
        }
        if (sort != null) {
            sb.append("&sort=").append(sort);
        }
        if (order != null) {
            sb.append("&order=").append(order);
        }
        if (searchTerm != null) {
            try {
                sb.append("&q=" + URLEncoder.encode(searchTerm, "UTF-8"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(sb.toString());
        try {
            if (user != null) {
                get.addRequestHeader("Cookie", "ALA-Auth=" + URLEncoder.encode(user, "UTF-8"));
            }
            get.addRequestHeader("Content-type", "text/plain");
            int result = client.executeMethod((HttpMethod)get);
            if (result == 200) {
                String rawJSON = get.getResponseBodyAsString();
                JSONParser jp = new JSONParser();
                JSONObject jSONObject = (JSONObject)jp.parse(rawJSON);
                return jSONObject;
            }
            LOGGER.error((Object)("Unable to retrieve species list. " + result + " > " + get.getResponseBodyAsString()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error retrieving public species list.", (Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
        return null;
    }

    public static Collection getPublicSpeciesLists(String user, Integer offset, Integer max, String sort, String order, String searchTerm, MutableInt listSize) {
        JSONObject jobject = SpeciesListUtil.getLists((String)user, (Integer)offset, (Integer)max, (String)sort, (String)order, (String)searchTerm);
        ArrayList<SpeciesListDTO> list = new ArrayList<SpeciesListDTO>();
        try {
            JSONArray ja = (JSONArray)jobject.get((Object)"lists");
            for (int i = 0; i < ja.size(); ++i) {
                JSONObject jo = (JSONObject)ja.get(i);
                SpeciesListDTO sli = new SpeciesListDTO();
                if (jo.containsKey((Object)"dataResourceUid")) {
                    sli.setDataResourceUid(jo.get((Object)"dataResourceUid") == null ? "" : jo.get((Object)"dataResourceUid").toString());
                }
                if (jo.containsKey((Object)"dateCreated")) {
                    sli.setDateCreated(jo.get((Object)"dateCreated") == null ? "" : jo.get((Object)"dateCreated").toString());
                }
                if (jo.containsKey((Object)"firstName")) {
                    sli.setFirstName(jo.get((Object)"firstName") == null ? "" : jo.get((Object)"firstName").toString());
                }
                if (jo.containsKey((Object)"fullName")) {
                    sli.setFullName(jo.get((Object)"fullName") == null ? "" : jo.get((Object)"fullName").toString());
                }
                if (jo.containsKey((Object)"itemCount")) {
                    sli.setItemCount(Integer.valueOf(Integer.parseInt(jo.get((Object)"itemCount") == null ? "0" : jo.get((Object)"itemCount").toString())));
                }
                if (jo.containsKey((Object)"listName")) {
                    sli.setListName(jo.get((Object)"listName") == null ? "" : jo.get((Object)"listName").toString());
                }
                if (jo.containsKey((Object)"listType")) {
                    sli.setListType(jo.get((Object)"listType") == null ? "" : jo.get((Object)"listType").toString());
                }
                if (jo.containsKey((Object)"surname")) {
                    sli.setSurname(jo.get((Object)"surname") == null ? "" : jo.get((Object)"surname").toString());
                }
                if (jo.containsKey((Object)"username")) {
                    sli.setUsername(jo.get((Object)"username") == null ? "" : jo.get((Object)"username").toString());
                }
                list.add(sli);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error getting species lists", (Throwable)e);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<SpeciesListItemDTO> getListItems(String listUid) {
        String url = CommonData.getSpeciesListServer() + "/ws/speciesListItems/" + listUid;
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(url);
        try {
            get.addRequestHeader("Content-type", "text/plain");
            int result = client.executeMethod((HttpMethod)get);
            if (result == 200) {
                String rawJSON = get.getResponseBodyAsString();
                JSONParser jp = new JSONParser();
                JSONArray ja = (JSONArray)jp.parse(rawJSON);
                ArrayList<SpeciesListItemDTO> list = new ArrayList<SpeciesListItemDTO>();
                for (int i = 0; i < ja.size(); ++i) {
                    JSONObject jo = (JSONObject)ja.get(i);
                    SpeciesListItemDTO sli = new SpeciesListItemDTO();
                    if (jo.containsKey((Object)"lsid") && jo.get((Object)"lsid") != null) {
                        sli.setLsid(jo.get((Object)"lsid").toString());
                    }
                    if (jo.containsKey((Object)"name") && jo.get((Object)"name") != null) {
                        sli.setName(jo.get((Object)"name").toString());
                    }
                    list.add(sli);
                }
                ArrayList<SpeciesListItemDTO> arrayList = list;
                return arrayList;
            }
            LOGGER.error((Object)("Unable to retrieve species list items for " + listUid + ". " + result + " > " + get.getResponseBodyAsString()));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error retrieving list items.", (Throwable)e);
        }
        finally {
            get.releaseConnection();
        }
        return new ArrayList<SpeciesListItemDTO>();
    }

    public static String createNewList(String name, String items, String description, String url, String user, boolean makePrivate) {
        String postUrl = CommonData.getSpeciesListServer() + "/ws/speciesList/";
        HttpClient client = new HttpClient();
        PostMethod post = new PostMethod(postUrl);
        try {
            post.setRequestHeader("Cookie", "ALA-Auth=" + URLEncoder.encode(user, "UTF-8"));
        }
        catch (Exception e) {
            LOGGER.error((Object)("failed to encode user: " + user), (Throwable)e);
        }
        LOGGER.debug((Object)post.getRequestHeader("Cookie"));
        if (name != null && items != null) {
            try {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("listName", name);
                if (description != null) {
                    map.put("description", description);
                }
                if (url != null) {
                    map.put("url", url);
                }
                map.put("listItems", items);
                map.put("listType", "SPATIAL_PORTAL");
                map.put("isPrivate", makePrivate);
                String content = JSONValue.toJSONString(map);
                LOGGER.debug((Object)("create new list : " + content + " for user " + user));
                String contentType = "application/json";
                String charset = "UTF-8";
                StringRequestEntity requestEntity = new StringRequestEntity(content, contentType, charset);
                post.setRequestEntity((RequestEntity)requestEntity);
                int result = client.executeMethod((HttpMethod)post);
                LOGGER.debug((Object)result);
                LOGGER.debug((Object)post.getResponseBodyAsString());
                if (result == 201) {
                    return post.getResponseHeader("druid").getValue();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error uploading list", (Throwable)e);
            }
        }
        return null;
    }

    @Scheduled(fixedDelay=43200000L)
    public void reloadCache() {
        int num = SpeciesListUtil.getNumberOfPublicSpeciesLists(null);
        int total = 0;
        int max = 50;
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        while (total < num) {
            Collection batch = SpeciesListUtil.getPublicSpeciesLists(null, (Integer)total, (Integer)max, null, null, null, null);
            for (SpeciesListDTO item : batch) {
                tmpMap.put(item.getDataResourceUid(), item.getListName());
                ++total;
            }
            LOGGER.debug((Object)("Cached lists: " + tmpMap));
        }
        speciesListMap = tmpMap;
    }
}

