/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFinder;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.GeometryBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ShapefileUtils {
    private static final Logger LOGGER = Logger.getLogger(ShapefileUtils.class);

    private ShapefileUtils() {
    }

    public static Map loadShapefile(File shpfile) {
        try {
            FileDataStore store = FileDataStoreFinder.getDataStore((File)shpfile);
            LOGGER.debug((Object)"Loading shapefile. Reading content:");
            LOGGER.debug((Object)store.getTypeNames()[0]);
            SimpleFeatureSource featureSource = store.getFeatureSource(store.getTypeNames()[0]);
            FeatureCollection featureCollection = featureSource.getFeatures();
            FeatureIterator it = featureCollection.features();
            HashMap<String, String> shape = new HashMap<String, String>();
            StringBuilder sb = new StringBuilder();
            StringBuilder sbGeometryCollection = new StringBuilder();
            boolean isGeometryCollection = false;
            while (it.hasNext()) {
                SimpleFeature feature = (SimpleFeature)it.next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                WKTWriter wkt = new WKTWriter();
                String wktString = wkt.write(geom);
                wktString = wktString.replaceAll(", ", ",");
                boolean valid = true;
                boolean multipolygon = false;
                boolean polygon = false;
                boolean geometrycollection = false;
                if (wktString.startsWith("MULTIPOLYGON ")) {
                    wktString = wktString.substring("MULTIPOLYGON (".length(), wktString.length() - 1);
                    multipolygon = true;
                } else if (wktString.startsWith("POLYGON ")) {
                    wktString = wktString.substring("POLYGON ".length());
                    polygon = true;
                } else if (wktString.startsWith("GEOMETRYCOLLECTION (")) {
                    wktString = wktString.substring("GEOMETRYCOLLECTION (".length(), wktString.length() - 1);
                    geometrycollection = true;
                    isGeometryCollection = true;
                } else {
                    valid = false;
                }
                if (!valid) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                    sbGeometryCollection.append(",");
                }
                sb.append(wktString);
                if (multipolygon) {
                    sbGeometryCollection.append("MULTIPOLYGON").append("(").append(wktString.replace("(((", "(("));
                    if (wktString.endsWith(")))")) continue;
                    sbGeometryCollection.append(")");
                    continue;
                }
                if (polygon) {
                    sbGeometryCollection.append("POLYGON").append(wktString);
                    continue;
                }
                if (!geometrycollection) continue;
                sbGeometryCollection.append(wktString);
            }
            if (!isGeometryCollection) {
                if (!sb.toString().contains(")))")) {
                    sb.append(")");
                }
                shape.put("wkt", "MULTIPOLYGON(" + sb.toString().replace("(((", "(("));
            } else {
                sbGeometryCollection.append(")");
                shape.put("wkt", "GEOMETRYCOLLECTION(" + sbGeometryCollection);
            }
            try {
                it.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            return shape;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load shapefile: ", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveShapefile(File shpfile, String wktString, String name) {
        try {
            SimpleFeatureType type = ShapefileUtils.createFeatureType();
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(type);
            WKTReader wkt = new WKTReader();
            Geometry geom = wkt.read(wktString);
            if (geom instanceof GeometryCollection) {
                GeometryCollection gc = (GeometryCollection)geom;
                for (int i = 0; i < gc.getNumGeometries(); ++i) {
                    Geometry g = gc.getGeometryN(i);
                    if (g instanceof Polygon) {
                        g = new GeometryBuilder().multiPolygon(new Polygon[]{(Polygon)g});
                    }
                    featureBuilder.add((Object)g);
                    SimpleFeature feature = featureBuilder.buildFeature(null);
                    feature.setAttribute("name", (Object)name);
                    features.add(feature);
                }
            } else {
                Geometry g = geom;
                if (g instanceof Polygon) {
                    g = new GeometryBuilder().multiPolygon(new Polygon[]{(Polygon)g});
                }
                featureBuilder.add((Object)g);
                SimpleFeature feature = featureBuilder.buildFeature(null);
                features.add(feature);
            }
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", shpfile.toURI().toURL());
            params.put("create spatial index", Boolean.TRUE);
            ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
            newDataStore.createSchema(type);
            newDataStore.forceSchemaCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            DefaultTransaction transaction = new DefaultTransaction("create");
            String typeName = newDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
            if (featureSource instanceof SimpleFeatureStore) {
                SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
                DefaultFeatureCollection collection = new DefaultFeatureCollection();
                collection.addAll(features);
                featureStore.setTransaction((Transaction)transaction);
                try {
                    featureStore.addFeatures((FeatureCollection)collection);
                    transaction.commit();
                }
                catch (Exception problem) {
                    LOGGER.error((Object)("error pricessing shape file: " + shpfile.getAbsolutePath()), (Throwable)problem);
                    transaction.rollback();
                }
                finally {
                    transaction.close();
                }
            }
            LOGGER.debug((Object)("Active Area shapefile written to: " + shpfile.getAbsolutePath()));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Unable to save shapefile: " + shpfile.getAbsolutePath()), (Throwable)e);
        }
    }

    private static SimpleFeatureType createFeatureType() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("ActiveArea");
        builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        builder.add("the_geom", MultiPolygon.class);
        builder.add("name", String.class);
        return builder.buildFeatureType();
    }
}

