/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.json.simple.JSONObject;

public class SPLFilter {
    private int count = 0;
    private JSONObject layer;
    private String layername = "";
    private int[] catagories = null;
    private String[] catagoryNames = null;
    private double minimumValue = 0.0;
    private boolean changed;
    private String filterString;
    private double maximumValue = 0.0;
    private double minimumInitial = 0.0;
    private double maximumInitial = 0.0;

    public SPLFilter() {
    }

    public SPLFilter(JSONObject layer, int[] catagories, String[] catagoryNames, double minimum, double maximum) {
        this.layer = layer;
        if (layer != null) {
            this.layername = layer.get((Object)"name").toString();
        }
        this.catagories = catagories == null ? null : (int[])catagories.clone();
        this.catagoryNames = catagoryNames == null ? null : (String[])catagoryNames.clone();
        this.minimumValue = minimum;
        this.maximumValue = maximum;
        this.minimumInitial = minimum;
        this.maximumInitial = maximum;
    }

    public JSONObject getLayer() {
        return this.layer;
    }

    public void setLayer(JSONObject layer) {
        this.layer = layer;
    }

    public String getLayername() {
        return this.layername;
    }

    public void setLayername(String layername) {
        this.layername = layername;
    }

    public int[] getCatagories() {
        return this.catagories;
    }

    public void setCatagories(int[] catagories) {
        this.catagories = catagories == null ? null : (int[])catagories.clone();
    }

    public String[] getCatagoryNames() {
        return this.catagoryNames;
    }

    public void setCatagoryNames(String[] catagoryNames) {
        this.catagoryNames = catagoryNames == null ? null : (String[])catagoryNames.clone();
    }

    public double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(double minimumValue) {
        this.minimumValue = minimumValue;
    }

    public double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(double maximumValue) {
        this.maximumValue = maximumValue;
    }

    public double getMinimumInitial() {
        return this.minimumInitial;
    }

    public void setMinimumInitial(double minimumInitial) {
        this.minimumInitial = minimumInitial;
    }

    public double getMaximumInitial() {
        return this.maximumInitial;
    }

    public void setMaximumInitial(double maximumInitial) {
        this.maximumInitial = maximumInitial;
    }

    public boolean isChanged() {
        return this.changed || this.minimumValue != this.minimumInitial || this.maximumValue != this.maximumInitial || this.catagories != null && this.catagoryNames != null && this.catagories.length != this.catagoryNames.length;
    }

    public void setChanged(boolean isChanged) {
        this.changed = isChanged;
    }

    public boolean equals(Object o) {
        if (o instanceof SPLFilter) {
            SPLFilter f = (SPLFilter)o;
            return this.layername.equals(f.layername) && (this.catagories == null || f.catagories == null || this.catagories.length == f.catagories.length) && this.minimumValue == f.minimumValue && this.maximumValue == f.maximumValue;
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder(71, 13).append((Object)this.layername).append(this.catagories == null ? 0 : this.catagories.length).append(this.minimumValue).append(this.maximumValue).toHashCode();
    }

    public String getFilterString() {
        if (this.catagoryNames != null) {
            if (this.catagories == null || this.catagories.length == 0) {
                this.filterString = "include none";
            } else if (this.catagories.length == this.catagoryNames.length) {
                this.filterString = "include all";
            } else {
                StringBuilder string = new StringBuilder();
                for (int i : this.catagories) {
                    if (string.length() == 0) {
                        string.append("only; ");
                        string.append(this.catagoryNames[i]);
                        continue;
                    }
                    string.append(", ");
                    string.append(this.catagoryNames[i]);
                }
                this.filterString = string.toString();
            }
        } else {
            this.filterString = String.format("%.4f", Float.valueOf((float)this.minimumValue)) + " to " + String.format("%.4f", Float.valueOf((float)this.maximumValue));
        }
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }
}

