/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.spatial.util.CommonData;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;

public class LsidCounts {
    private static final Logger LOGGER = Logger.getLogger(LsidCounts.class);
    private Long[] lft;
    private Long[] count;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LsidCounts() {
        HttpClient client = new HttpClient();
        CSVReader csv = null;
        String url = null;
        try {
            String[] row;
            url = CommonData.getBiocacheServer() + "/webportal/legend?cm=lft&q=" + URLEncoder.encode("geospatial_kosher:*", "UTF-8") + CommonData.getBiocacheQc();
            LOGGER.debug((Object)url);
            GetMethod get = new GetMethod(url);
            HashMap<Long, Long> map = new HashMap<Long, Long>();
            client.getHttpConnectionManager().getParams().setSoTimeout(30000);
            client.executeMethod((HttpMethod)get);
            csv = new CSVReader((Reader)new InputStreamReader(get.getResponseBodyAsStream()));
            while ((row = csv.readNext()) != null) {
                try {
                    long name = Long.parseLong(row[0]);
                    long c = Long.parseLong(row[4]);
                    map.put(name, c);
                }
                catch (NumberFormatException e) {}
            }
            this.lft = new Long[map.size()];
            map.keySet().toArray(this.lft);
            Arrays.sort((Object[])this.lft);
            this.count = new Long[map.size()];
            for (int i = 0; i < this.lft.length; ++i) {
                this.count[i] = (Long)map.get(this.lft[i]);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting LSID count for : " + url), (Throwable)e);
        }
        finally {
            try {
                if (csv != null) {
                    csv.close();
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed to close csv", (Throwable)e);
            }
        }
    }

    public long getCount(long left, long right) {
        if (this.lft == null) {
            return 0L;
        }
        int pos = Arrays.binarySearch((Object[])this.lft, (Object)left);
        if (pos < 0) {
            pos = -1 * pos - 1;
        }
        long sum = 0L;
        while (this.lft[pos] < right) {
            sum += this.count[pos++].longValue();
        }
        return sum;
    }

    public int getSize() {
        return this.lft == null ? 0 : this.lft.length;
    }
}

