/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import java.text.SimpleDateFormat;
import java.util.Date;

public class LayerSelection {
    private String displayString;
    private String layerName;
    private String analysisType;
    private long created;
    private long lastUse;
    private String layers;

    public LayerSelection(String displayString, String layersString) {
        this.displayString = displayString;
        this.layers = layersString;
    }

    public LayerSelection(String analysisType, String layerName, long created, String layersString) {
        this.layerName = layerName;
        this.analysisType = analysisType;
        this.created = created;
        this.lastUse = created;
        this.layers = layersString;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public String getAnalysisType() {
        return this.analysisType;
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastUse() {
        return this.lastUse;
    }

    public void setLastUse(long lastUse) {
        this.lastUse = lastUse;
    }

    public boolean contains(String layerId) {
        String lookFor = "(" + layerId + ")";
        return this.layers.contains(lookFor);
    }

    public String getLayers() {
        return this.layers;
    }

    public String toString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy hh:mm:ss");
        int len = this.layers.split(",").length;
        if (len != 1) {
            return this.layerName + " | " + sdf.format(new Date(this.created)) + " | " + len + " layers";
        }
        return this.layerName + " | " + sdf.format(new Date(this.created)) + " | " + len + " layer";
    }

    public boolean equalsList(LayerSelection ls) {
        boolean found;
        String[] thisList = this.layers.split(",");
        String[] thatList = ls.layers.split(",");
        for (int i = 0; i < thisList.length; ++i) {
            found = false;
            for (int j = 0; j < thatList.length; ++j) {
                if (!thisList[i].equals(thatList[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        for (int j = 0; j < thatList.length; ++j) {
            found = false;
            for (int i = 0; i < thisList.length; ++i) {
                if (!thisList[i].equals(thatList[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

