/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import au.org.ala.legend.QueryField;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.FacetCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestOperations;

@Component(value="facetCache")
public class FacetCacheImpl
implements FacetCache {
    private static final String FACET_SUFFIX = "/search/grouped/facets";
    private static final Logger LOGGER = Logger.getLogger(FacetCacheImpl.class);
    private static List<QueryField> facetQueryFieldList;
    @Inject
    private RestOperations restTemplate;
    @Inject
    private AbstractMessageSource messageSource;

    public static List<QueryField> getFacetQueryFieldList() {
        return facetQueryFieldList;
    }

    @Scheduled(fixedDelay=43200000L)
    public void reloadCache() {
        LinkedHashMap<String, String[][]> tmpMap = new LinkedHashMap<String, String[][]>();
        ArrayList<QueryField> tmpList = new ArrayList<QueryField>();
        List values = (List)this.restTemplate.getForObject(CommonData.getBiocacheServer() + FACET_SUFFIX, List.class, new Object[0]);
        LOGGER.debug((Object)values);
        Map dataTypes = this.getDataTypes();
        for (Map value : values) {
            String title = value.get("title").toString();
            List facets = (List)value.get("facets");
            String[][] facetValues = new String[facets.size()][2];
            int i = 0;
            for (Map facet : facets) {
                String field = (String)facet.get("field");
                if (CommonData.ignoredFacets.contains(field)) continue;
                String i18n = this.messageSource.getMessage("facet." + field, null, field, Locale.getDefault());
                if ("data_provider".equals(field)) {
                    i18n = "Data Provider";
                }
                try {
                    String layername = CommonData.getFacetLayerName((String)field);
                    if (i18n == null || layername != null) {
                        i18n = CommonData.getLayerDisplayName((String)layername);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                facetValues[i][0] = field;
                facetValues[i][1] = i18n;
                QueryField.FieldType ftype = dataTypes.containsKey(field) ? (QueryField.FieldType)dataTypes.get(field) : QueryField.FieldType.STRING;
                QueryField qf = new QueryField(field, i18n, QueryField.GroupType.getGroupType((String)title), ftype);
                tmpList.add(qf);
                ++i;
            }
            tmpMap.put(title, facetValues);
        }
        for (String f : CommonData.customFacets) {
            String i18n = this.messageSource.getMessage("facet." + f, null, f, Locale.getDefault());
            tmpList.add(new QueryField(f, i18n, QueryField.GroupType.CUSTOM, QueryField.FieldType.STRING));
        }
        facetQueryFieldList = tmpList;
        LOGGER.debug((Object)("Grouped Facets: " + tmpMap));
        LOGGER.debug((Object)("facet query list : " + facetQueryFieldList));
    }

    private Map<String, QueryField.FieldType> getDataTypes() {
        HashMap<String, QueryField.FieldType> map = new HashMap<String, QueryField.FieldType>();
        List values = (List)this.restTemplate.getForObject(CommonData.getBiocacheServer() + FACET_SUFFIX, List.class, new Object[0]);
        for (Map mvalues : values) {
            String name = (String)mvalues.get("name");
            String dtype = (String)mvalues.get("dataType");
            if ("string".equals(dtype) || "textgen".equals(dtype)) {
                map.put(name, QueryField.FieldType.STRING);
                continue;
            }
            if ("int".equals(dtype) || "tint".equals(dtype) || "tdate".equals(dtype)) {
                map.put(name, QueryField.FieldType.INT);
                continue;
            }
            if ("double".equals(dtype) || "tdouble".equals(dtype)) {
                map.put(name, QueryField.FieldType.DOUBLE);
                continue;
            }
            map.put(name, QueryField.FieldType.STRING);
        }
        return map;
    }
}

