/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.legend.QueryField;
import au.org.ala.spatial.dto.SpeciesListItemDTO;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayerSelection;
import au.org.ala.spatial.util.LsidCountsDynamic;
import au.org.ala.spatial.util.SpeciesListUtil;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.lang.LanguagePack;
import au.org.emii.portal.lang.LanguagePackImpl;
import au.org.emii.portal.util.PortalProperties;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.JSONParser;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CommonData {
    public static final String WORLD_WKT = "POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))";
    public static final String AUSTRALIA_WKT = "default.wkt";
    public static final String AUSTRALIA_NAME = "default.name";
    public static final String PHYLOLIST_URL = "phylolist_url";
    private static final String SAT_URL = "sat_url";
    private static final String GEOSERVER_URL = "geoserver_url";
    private static final String LAYERS_URL = "layers_url";
    private static final String WEBPORTAL_URL = "webportal_url";
    private static final String BIE_URL = "bie_url";
    private static final String BIOCACHE_SERVICE_URL = "biocache_service_url";
    private static final String BIOCACHE_WEBAPP_URL = "biocache_webapp_url";
    private static final String SPECIES_LIST_URL = "species_list_url";
    private static final String COLLECTORY_URL = "collectory_url";
    private static final String DEFAULT_UPLOAD_SAMPLING = "default_upload_sampling";
    private static final String MAX_Q_LENGTH = "max_q_length";
    private static final String BIOCACHE_QC = "biocache_qc";
    private static final String ANALYSIS_LAYER_SETS = "analysis_layer_sets";
    private static final String MAX_AREA_FOR_ENDEMIC = "max_area_endemic";
    private static final String EXTRA_DOWNLOAD_FIELDS = "occurrence_extra_download";
    private static final String DISPLAY_POINTS_OF_INTEREST = "display_points_of_interest";
    private static final String CUSTOM_FACETS = "custom_facets";
    private static final String AREA_REPORT_FACETS = "area_report_facets";
    private static final String IGNORED_FACETS = "default_facets_ignored";
    private static final String I18N_URL = "i18nURL";
    private static final String I18N_IGNORE_THESE_PREFIXES = "i18nIgnoreThesePrefixes";
    private static final Logger LOGGER = Logger.getLogger(CommonData.class);
    protected static String collectoryServer;
    protected static String[] customFacets;
    protected static List<String> ignoredFacets;
    private static String satServer;
    private static String geoServer;
    private static String layersServer;
    private static String webportalServer;
    private static String bieServer;
    private static String biocacheServer;
    private static String biocacheWebServer;
    private static String speciesListServer;
    private static int maxQLength;
    private static Properties settings;
    private static LsidCountsDynamic lsidCounts;
    private static String biocacheQc;
    private static List<LayerSelection> analysisLayerSets;
    private static String[][] facetNameExceptions;
    private static Set<String> biocacheLayerList;
    private static int maxEndemicArea;
    private static String extraDownloadFields;
    private static boolean displayPointsOfInterest;
    private static String[] areaReportFacets;
    private static String i18nURL;
    private static List<String> i18nIgnoredPrefixes;
    private static JSONObject distances;
    private static Map<String, Map<String, Double>> distancesMap;
    private static JSONObject copyDistances;
    private static Map<String, Map<String, Double>> copyDistancesMap;
    private static JSONArray layerlistJSON;
    private static JSONArray copyLayerlistJSON;
    private static String defaultFieldString;
    private static Map<String, String[]> speciesWmsLayers;
    private static Map<String, String[]> copySpeciesWmsLayers;
    private static Map<String, String[]> speciesMetadataLayers;
    private static Map<String, String[]> copySpeciesMetadataLayers;
    private static Map<String, String[]> speciesSpcodeLayers;
    private static Map<String, String[]> copySpeciesSpcodeLayers;
    private static Map<String, String[]> speciesWmsLayersBySpcode;
    private static Map<String, String[]> copySpeciesWmsLayersBySpcode;
    private static Map<String, String[]> checklistspeciesWmsLayers;
    private static Map<String, String[]> copyChecklistspeciesWmsLayers;
    private static Map<String, String[]> checklistspeciesMetadataLayers;
    private static Map<String, String[]> copyChecklistspeciesMetadataLayers;
    private static Map<String, String[]> checklistspeciesSpcodeLayers;
    private static Map<String, String[]> copyChecklistspeciesSpcodeLayers;
    private static Map<String, String[]> checklistspeciesWmsLayersBySpcode;
    private static Map<String, String[]> copyChecklistspeciesWmsLayersBySpcode;
    private static JSONArray downloadReasons;
    private static JSONArray copyDownloadReasons;
    private static Map<String, JSONObject> layerToFacet;
    private static Map<String, JSONObject> facetToLayer;
    private static Map<String, JSONObject> layerToFacetDefault;
    private static Map<String, JSONObject> facetToLayerDefault;
    private static Properties i18nProperites;
    private static LanguagePack languagePack;
    private static Map speciesListCounts;
    private static Long speciesListCountsUpdated;
    private static Map speciesListCountsKosher;
    private static Long speciesListCountsUpdatedKosher;
    private static Map<String, Map<String, List<String>>> speciesListAdditionalColumns;
    static List<JSONObject> journalMapArticles;
    static List<JournalMapLocation> journalMapLocations;
    public static String speciesListThreatened;
    public static String speciesListInvasive;

    private CommonData() {
    }

    public static void init(Properties settings) {
        boolean readFromCache = false;
        if (CommonData.settings == null) {
            readFromCache = CommonData.loadFromCache();
        }
        CommonData.settings = settings;
        satServer = settings.getProperty("sat_url");
        geoServer = settings.getProperty("geoserver_url");
        layersServer = settings.getProperty("layers_url");
        webportalServer = settings.getProperty("webportal_url");
        bieServer = settings.getProperty("bie_url");
        biocacheServer = settings.getProperty("biocache_service_url");
        biocacheWebServer = settings.getProperty("biocache_webapp_url");
        speciesListServer = settings.getProperty("species_list_url");
        collectoryServer = settings.getProperty("collectory_url");
        defaultFieldString = settings.getProperty("default_upload_sampling");
        maxQLength = Integer.parseInt(settings.getProperty("max_q_length"));
        String maxendemic = settings.getProperty("max_area_endemic") != null ? settings.getProperty("max_area_endemic") : "50000";
        maxEndemicArea = Integer.parseInt(maxendemic);
        biocacheQc = ((PortalProperties)settings).getProperty("biocache_qc", false);
        if (biocacheQc == null) {
            biocacheQc = "";
        }
        facetNameExceptions = CommonData.parseFacetNameExceptions((String)settings.getProperty("facet_name_exceptions"));
        customFacets = settings.containsKey("custom_facets") ? settings.getProperty("custom_facets").split(",") : new String[]{};
        ignoredFacets = Arrays.asList(settings.containsKey("default_facets_ignored") ? settings.getProperty("default_facets_ignored").split(",") : new String[]{});
        String[] stringArray = areaReportFacets = settings.containsKey("area_report_facets") ? settings.getProperty("area_report_facets").split(",") : new String[]{};
        if (settings.containsKey("occurrence_extra_download")) {
            extraDownloadFields = settings.getProperty("occurrence_extra_download");
        }
        displayPointsOfInterest = settings.containsKey("display_points_of_interest") && Boolean.parseBoolean(settings.getProperty("display_points_of_interest"));
        i18nURL = settings.getProperty("i18nURL");
        String tmp = settings.getProperty("i18nIgnoreThesePrefixes");
        i18nIgnoredPrefixes = tmp != null ? Arrays.asList(tmp.split(" ")) : new ArrayList();
        CommonData.initLanguagePack();
        CommonData.setupAnalysisLayerSets();
        CommonData.initJournalmap();
        if (!readFromCache) {
            CommonData.refreshCachedData();
        }
    }

    private static void refreshCachedData() {
        CommonData.initLayerDistances();
        CommonData.initLayerList();
        CommonData.initSpeciesWMSLayers();
        CommonData.readLayerInfo();
        lsidCounts.clear();
        speciesListAdditionalColumns = CommonData.initSpeciesListAdditionalColumns();
        CommonData.initDownloadReasons();
        if (copyDownloadReasons != null) {
            downloadReasons = copyDownloadReasons;
        }
        CommonData.initBiocacheLayerList();
        if (CommonData.getSettings().containsKey("endemic.sp.method") && CommonData.getSettings().getProperty("endemic.sp.method").equals("true")) {
            CommonData.getSpeciesListCountsKosher((boolean)true);
            CommonData.getSpeciesListCounts((boolean)true);
        }
        if (copyDistances != null) {
            distances = copyDistances;
        }
        if (copyDistancesMap != null) {
            distancesMap = copyDistancesMap;
        }
        if (copyLayerlistJSON != null) {
            layerlistJSON = copyLayerlistJSON;
        }
        if (copySpeciesWmsLayers != null) {
            speciesWmsLayers = copySpeciesWmsLayers;
        }
        if (copySpeciesMetadataLayers != null) {
            speciesMetadataLayers = copySpeciesMetadataLayers;
        }
        if (copySpeciesSpcodeLayers != null) {
            speciesSpcodeLayers = copySpeciesSpcodeLayers;
        }
        if (copySpeciesWmsLayersBySpcode != null) {
            speciesWmsLayersBySpcode = copySpeciesWmsLayersBySpcode;
        }
        if (copyChecklistspeciesWmsLayers != null) {
            checklistspeciesWmsLayers = copyChecklistspeciesWmsLayers;
        }
        if (copyChecklistspeciesMetadataLayers != null) {
            checklistspeciesMetadataLayers = copyChecklistspeciesMetadataLayers;
        }
        if (copyChecklistspeciesSpcodeLayers != null) {
            checklistspeciesSpcodeLayers = copyChecklistspeciesSpcodeLayers;
        }
        if (copyChecklistspeciesWmsLayersBySpcode != null) {
            checklistspeciesWmsLayersBySpcode = copyChecklistspeciesWmsLayersBySpcode;
        }
        CommonData.initI18nProperies();
        CommonData.writeToCache();
    }

    private static void writeToCache() {
        try {
            String path = "/data/webportal/cache/";
            new File(path).mkdirs();
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(path + "commondata"));
            oos.writeObject(layerToFacet);
            oos.writeObject(facetToLayer);
            oos.writeObject(layerToFacetDefault);
            oos.writeObject(facetToLayerDefault);
            oos.writeObject(speciesListAdditionalColumns);
            oos.writeObject(downloadReasons);
            oos.writeObject(biocacheLayerList);
            oos.writeObject(speciesListCountsKosher);
            oos.writeObject(speciesListCounts);
            oos.writeObject(speciesWmsLayers);
            oos.writeObject(distancesMap);
            oos.writeObject(distances);
            oos.writeObject(layerlistJSON);
            oos.writeObject(speciesWmsLayers);
            oos.writeObject(speciesMetadataLayers);
            oos.writeObject(speciesSpcodeLayers);
            oos.writeObject(checklistspeciesWmsLayers);
            oos.writeObject(checklistspeciesMetadataLayers);
            oos.writeObject(checklistspeciesSpcodeLayers);
            oos.writeObject(checklistspeciesWmsLayersBySpcode);
            oos.writeObject(i18nProperites);
            oos.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"cannot write common data to cache", (Throwable)e);
        }
    }

    private static boolean loadFromCache() {
        try {
            String path = "/data/webportal/cache/";
            if (!new File(path + "commondata").exists()) {
                return false;
            }
            ObjectInputStream oos = new ObjectInputStream(new FileInputStream(path + "commondata"));
            layerToFacet = (Map)oos.readObject();
            facetToLayer = (Map)oos.readObject();
            layerToFacetDefault = (Map)oos.readObject();
            facetToLayerDefault = (Map)oos.readObject();
            speciesListAdditionalColumns = (Map)oos.readObject();
            downloadReasons = (JSONArray)oos.readObject();
            biocacheLayerList = (Set)oos.readObject();
            speciesListCountsKosher = (Map)oos.readObject();
            speciesListCounts = (Map)oos.readObject();
            speciesWmsLayers = (Map)oos.readObject();
            distancesMap = (Map)oos.readObject();
            distances = (JSONObject)oos.readObject();
            layerlistJSON = (JSONArray)oos.readObject();
            speciesWmsLayers = (Map)oos.readObject();
            speciesMetadataLayers = (Map)oos.readObject();
            speciesSpcodeLayers = (Map)oos.readObject();
            checklistspeciesWmsLayers = (Map)oos.readObject();
            checklistspeciesMetadataLayers = (Map)oos.readObject();
            checklistspeciesSpcodeLayers = (Map)oos.readObject();
            checklistspeciesWmsLayersBySpcode = (Map)oos.readObject();
            i18nProperites = (Properties)oos.readObject();
            oos.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"cannot read common data from cache", (Throwable)e);
            return false;
        }
        return true;
    }

    public static JSONArray getDownloadReasons() {
        return downloadReasons;
    }

    public static JSONObject getDistances() {
        return distances;
    }

    public static void initLayerDistances() {
        copyDistances = null;
        copyDistancesMap = null;
        LOGGER.debug((Object)"CommonData::initLayerDistances()");
        String url = satServer + "/ws/layerdistances";
        try {
            LOGGER.debug((Object)url);
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(url);
            int result = client.executeMethod((HttpMethod)get);
            if (result == 200) {
                JSONParser jp = new JSONParser();
                copyDistances = (JSONObject)jp.parse(get.getResponseBodyAsString());
                copyDistancesMap = new HashMap();
                for (Object okey : copyDistances.keySet()) {
                    Double d = (Double)copyDistances.get((Object)((String)okey));
                    String[] parts = ((String)okey).split(" ");
                    Map<String, Double> part = (HashMap<String, Double>)copyDistancesMap.get(parts[0]);
                    if (part == null) {
                        part = new HashMap<String, Double>();
                        copyDistancesMap.put(parts[0], part);
                    }
                    part.put(parts[1], d);
                    part = (Map)copyDistancesMap.get(parts[1]);
                    if (part == null) {
                        part = new HashMap();
                        copyDistancesMap.put(parts[1], part);
                    }
                    part.put(parts[0], d);
                }
            }
        }
        catch (Exception e) {
            copyDistances = null;
            copyDistancesMap = null;
            LOGGER.error((Object)"error getting layer distances", (Throwable)e);
        }
    }

    public static Map<String, Map<String, Double>> getDistancesMap() {
        return distancesMap;
    }

    static void initLayerList() {
        copyLayerlistJSON = null;
        String layersListURL = layersServer + "/layers";
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(layersListURL);
            get.addRequestHeader("Accept", "application/json, text/javascript, */*");
            int result = client.executeMethod((HttpMethod)get);
            if (result == 200) {
                JSONParser jp = new JSONParser();
                copyLayerlistJSON = (JSONArray)jp.parse(get.getResponseBodyAsString());
            }
            CommonData.addFieldsToLayers((JSONArray)copyLayerlistJSON);
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting layers list: " + layersListURL), (Throwable)e);
            copyLayerlistJSON = null;
        }
    }

    static void addFieldsToLayers(JSONArray joLayers) throws Exception {
        HttpClient client = new HttpClient();
        String fieldsURL = layersServer + "/fields";
        GetMethod get = new GetMethod(fieldsURL);
        int result = client.executeMethod((HttpMethod)get);
        if (result != 200) {
            LOGGER.error((Object)("cannot retrive field list: " + fieldsURL));
            return;
        }
        String fields = get.getResponseBodyAsString();
        JSONParser jp = new JSONParser();
        JSONArray ja = (JSONArray)jp.parse(fields);
        for (int j = 0; j < joLayers.size(); ++j) {
            JSONObject layer = (JSONObject)joLayers.get(j);
            if (!layer.containsKey((Object)"id")) continue;
            for (int i = 0; i < ja.size(); ++i) {
                JSONObject jo = (JSONObject)ja.get(i);
                if (!jo.containsKey((Object)"spid") || !jo.get((Object)"spid").toString().equals(layer.get((Object)"id").toString())) continue;
                if (!layer.containsKey((Object)"fields")) {
                    layer.put((Object)"fields", (Object)new JSONArray());
                }
                ((JSONArray)layer.get((Object)"fields")).add((Object)jo);
            }
        }
    }

    public static JSONArray getLayerListJSONArray() {
        return layerlistJSON;
    }

    private static void initSpeciesWMSLayers() {
        try {
            String layersListURL = layersServer + "/distributions";
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(layersListURL);
            get.addRequestHeader("Accept", "application/json, text/javascript, */*");
            get.addRequestHeader("Accept-Encoding", "gzip");
            copySpeciesWmsLayers = new HashMap();
            copySpeciesMetadataLayers = new HashMap();
            copySpeciesSpcodeLayers = new HashMap();
            copySpeciesWmsLayersBySpcode = new HashMap();
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONArray ja = (JSONArray)jp.parse(slist);
            LOGGER.debug((Object)(ja.size() + " species wms distributions"));
            for (int i = 0; i < ja.size(); ++i) {
                String[] newMd;
                String[] md;
                JSONObject jo = (JSONObject)ja.get(i);
                if (!jo.containsKey((Object)"lsid") || !jo.containsKey((Object)"wmsurl")) continue;
                String lsid = jo.get((Object)"lsid").toString();
                String[] urls = (String[])copySpeciesWmsLayers.get(lsid);
                if (urls != null) {
                    String[] newUrls = new String[urls.length + 1];
                    System.arraycopy(urls, 0, newUrls, 0, urls.length);
                    newUrls[newUrls.length - 1] = jo.get((Object)"wmsurl").toString();
                    urls = newUrls;
                } else {
                    urls = new String[]{jo.get((Object)"wmsurl").toString()};
                }
                copySpeciesWmsLayers.put(lsid, urls);
                String m = "";
                if (jo.containsKey((Object)"metadata_u")) {
                    m = jo.get((Object)"metadata_u").toString();
                }
                if ((md = (String[])copySpeciesMetadataLayers.get(lsid)) != null) {
                    newMd = new String[md.length + 1];
                    System.arraycopy(md, 0, newMd, 0, md.length);
                    newMd[newMd.length - 1] = m;
                    md = newMd;
                } else {
                    md = new String[]{m};
                }
                copySpeciesMetadataLayers.put(lsid, md);
                m = "";
                if (jo.containsKey((Object)"spcode")) {
                    m = jo.get((Object)"spcode").toString();
                }
                if ((md = (String[])copySpeciesSpcodeLayers.get(lsid)) != null) {
                    newMd = new String[md.length + 1];
                    System.arraycopy(md, 0, newMd, 0, md.length);
                    newMd[newMd.length - 1] = m;
                    md = newMd;
                } else {
                    md = new String[]{m};
                }
                copySpeciesSpcodeLayers.put(lsid, md);
                String spcode = null;
                if (jo.containsKey((Object)"spcode")) {
                    spcode = jo.get((Object)"spcode").toString();
                }
                lsid = null;
                if (jo.containsKey((Object)"lsid")) {
                    lsid = jo.get((Object)"lsid").toString();
                }
                String pid = null;
                if (jo.containsKey((Object)"pid")) {
                    pid = jo.get((Object)"pid").toString();
                }
                String type = null;
                if (jo.containsKey((Object)"type")) {
                    type = jo.get((Object)"type").toString();
                }
                copySpeciesWmsLayersBySpcode.put(spcode, new String[]{jo.get((Object)"scientific").toString(), jo.get((Object)"wmsurl").toString(), m, lsid, pid, type});
            }
            layersListURL = layersServer + "/checklists";
            client = new HttpClient();
            get = new GetMethod(layersListURL);
            get.addRequestHeader("Accept", "application/json, text/javascript, */*");
            client.executeMethod((HttpMethod)get);
            get.addRequestHeader("Accept-Encoding", "gzip");
            int result = client.executeMethod((HttpMethod)get);
            copyChecklistspeciesWmsLayers = new HashMap();
            copyChecklistspeciesMetadataLayers = new HashMap();
            copyChecklistspeciesSpcodeLayers = new HashMap();
            copyChecklistspeciesWmsLayersBySpcode = new HashMap();
            if (result == 200) {
                slist = get.getResponseBodyAsString();
                ja = (JSONArray)jp.parse(slist);
                LOGGER.debug((Object)(ja.size() + " species wms checklists"));
                for (int i = 0; i < ja.size(); ++i) {
                    String[] newMd;
                    String[] md;
                    JSONObject jo = (JSONObject)ja.get(i);
                    if (!jo.containsKey((Object)"lsid") || !jo.containsKey((Object)"wmsurl")) continue;
                    String lsid = jo.get((Object)"lsid").toString();
                    String[] urls = (String[])copyChecklistspeciesWmsLayers.get(lsid);
                    if (urls != null) {
                        String[] newUrls = new String[urls.length + 1];
                        System.arraycopy(urls, 0, newUrls, 0, urls.length);
                        newUrls[newUrls.length - 1] = jo.get((Object)"wmsurl").toString();
                        urls = newUrls;
                    } else {
                        urls = new String[]{jo.get((Object)"wmsurl").toString()};
                    }
                    copyChecklistspeciesWmsLayers.put(lsid, urls);
                    String m = "";
                    if (jo.containsKey((Object)"metadata_u")) {
                        m = jo.get((Object)"metadata_u").toString();
                    }
                    if ((md = (String[])copyChecklistspeciesMetadataLayers.get(lsid)) != null) {
                        newMd = new String[md.length + 1];
                        System.arraycopy(md, 0, newMd, 0, md.length);
                        newMd[newMd.length - 1] = m;
                        md = newMd;
                    } else {
                        md = new String[]{m};
                    }
                    copyChecklistspeciesMetadataLayers.put(lsid, md);
                    m = "";
                    if (jo.containsKey((Object)"spcode")) {
                        m = jo.get((Object)"spcode").toString();
                    }
                    if ((md = (String[])copyChecklistspeciesSpcodeLayers.get(lsid)) != null) {
                        newMd = new String[md.length + 1];
                        System.arraycopy(md, 0, newMd, 0, md.length);
                        newMd[newMd.length - 1] = m;
                        md = newMd;
                    } else {
                        md = new String[]{m};
                    }
                    copyChecklistspeciesSpcodeLayers.put(lsid, md);
                    String spcode = jo.get((Object)"spcode").toString();
                    copyChecklistspeciesWmsLayersBySpcode.put(spcode, new String[]{jo.get((Object)"scientific").toString(), jo.get((Object)"wmsurl").toString(), m});
                }
            }
        }
        catch (Exception e) {
            copySpeciesWmsLayers = null;
            copySpeciesMetadataLayers = null;
            copySpeciesSpcodeLayers = null;
            copySpeciesWmsLayersBySpcode = null;
            copyChecklistspeciesWmsLayers = null;
            copyChecklistspeciesMetadataLayers = null;
            copyChecklistspeciesSpcodeLayers = null;
            copyChecklistspeciesWmsLayersBySpcode = null;
            LOGGER.error((Object)"error getting species and distributions checklists", (Throwable)e);
        }
    }

    public static String[] getSpeciesDistributionWMS(String lsids) {
        if (speciesWmsLayers == null || lsids == null) {
            return new String[0];
        }
        String[] lsid = lsids.split(",");
        ArrayList<String[]> wmsurls = new ArrayList<String[]>();
        int count = 0;
        for (String string : lsid) {
            String[] urls = (String[])speciesWmsLayers.get(string);
            if (urls == null) continue;
            count += urls.length;
            wmsurls.add(urls);
        }
        String[] wms = new String[]{};
        if (count > 0) {
            wms = new String[count];
            int pos = 0;
            for (String[] stringArray : wmsurls) {
                System.arraycopy(stringArray, 0, wms, pos, stringArray.length);
                pos += stringArray.length;
            }
        }
        return wms;
    }

    public static String[] getSpeciesDistributionMetadata(String lsids) {
        String[] wms;
        if (speciesWmsLayers == null) {
            return new String[0];
        }
        String[] lsid = lsids.split(",");
        ArrayList<String[]> wmsurls = new ArrayList<String[]>();
        int count = 0;
        for (String string : lsid) {
            String[] urls = (String[])speciesMetadataLayers.get(string);
            if (urls == null) continue;
            count += urls.length;
            wmsurls.add(urls);
        }
        if (count > 0) {
            wms = new String[count];
            int pos = 0;
            for (String[] stringArray : wmsurls) {
                System.arraycopy(stringArray, 0, wms, pos, stringArray.length);
                pos += stringArray.length;
            }
        } else {
            wms = new String[]{};
        }
        return wms;
    }

    public static String[] getSpeciesDistributionSpcode(String lsids) {
        String[] wms;
        if (speciesWmsLayers == null) {
            return new String[0];
        }
        String[] lsid = lsids.split(",");
        ArrayList<String[]> wmsurls = new ArrayList<String[]>();
        int count = 0;
        for (String string : lsid) {
            String[] urls = (String[])speciesSpcodeLayers.get(string);
            if (urls == null) continue;
            count += urls.length;
            wmsurls.add(urls);
        }
        if (count > 0) {
            wms = new String[count];
            int pos = 0;
            for (String[] stringArray : wmsurls) {
                System.arraycopy(stringArray, 0, wms, pos, stringArray.length);
                pos += stringArray.length;
            }
        } else {
            wms = new String[]{};
        }
        return wms;
    }

    public static String[] getSpeciesChecklistWMS(String lsids) {
        String[] wms;
        if (checklistspeciesWmsLayers == null || lsids == null) {
            return new String[0];
        }
        String[] lsid = lsids.split(",");
        ArrayList<String[]> wmsurls = new ArrayList<String[]>();
        int count = 0;
        for (String string : lsid) {
            String[] urls = (String[])checklistspeciesWmsLayers.get(string);
            if (urls == null) continue;
            count += urls.length;
            wmsurls.add(urls);
        }
        if (count > 0) {
            wms = new String[count];
            int pos = 0;
            for (String[] stringArray : wmsurls) {
                System.arraycopy(stringArray, 0, wms, pos, stringArray.length);
            }
        } else {
            wms = new String[]{};
        }
        return wms;
    }

    public static String getLayerFacetName(String layer) {
        String facetName = layer;
        JSONObject f = (JSONObject)layerToFacet.get(layer.toLowerCase());
        facetName = f != null ? f.get((Object)"id").toString() : CommonData.getLayerFacetNameDefault((String)layer);
        return facetName;
    }

    public static String getLayerFacetNameDefault(String layer) {
        String facetName = layer;
        JSONObject f = (JSONObject)layerToFacetDefault.get(layer.toLowerCase());
        if (f != null) {
            facetName = f.get((Object)"id").toString();
        }
        return facetName;
    }

    public static String getFacetLayerName(String facet) {
        JSONObject jo = (JSONObject)facetToLayer.get(facet);
        if (jo != null) {
            return jo.get((Object)"name").toString();
        }
        return CommonData.getFacetLayerNameDefault((String)facet);
    }

    public static String getFacetLayerNameDefault(String facet) {
        JSONObject jo = (JSONObject)facetToLayerDefault.get(facet);
        if (jo != null) {
            return jo.get((Object)"name").toString();
        }
        return null;
    }

    public static String getFacetLayerDisplayName(String facet) {
        JSONObject layer = (JSONObject)facetToLayer.get(facet);
        if (layer != null && layer.containsKey((Object)"displayname")) {
            return layer.get((Object)"displayname").toString();
        }
        return CommonData.getFacetLayerDisplayNameDefault((String)facet);
    }

    public static String getFacetLayerDisplayNameDefault(String facet) {
        JSONObject layer = (JSONObject)facetToLayerDefault.get(facet);
        if (layer != null && layer.containsKey((Object)"displayname")) {
            return layer.get((Object)"displayname").toString();
        }
        return null;
    }

    public static String getLayerDisplayName(String name) {
        for (int i = 0; i < layerlistJSON.size(); ++i) {
            JSONObject layer = (JSONObject)layerlistJSON.get(i);
            if (!layer.get((Object)"name").toString().equalsIgnoreCase(name) || !layer.containsKey((Object)"displayname")) continue;
            return layer.get((Object)"displayname").toString();
        }
        return null;
    }

    private static void readLayerInfo() {
        try {
            HashMap<String, JSONObject> ftl = new HashMap<String, JSONObject>();
            HashMap<String, JSONObject> ltf = new HashMap<String, JSONObject>();
            HashMap<String, JSONObject> ftldefault = new HashMap<String, JSONObject>();
            HashMap<String, JSONObject> ltfdefault = new HashMap<String, JSONObject>();
            if (copyLayerlistJSON != null) {
                for (int i = 0; i < copyLayerlistJSON.size(); ++i) {
                    JSONObject jo = (JSONObject)copyLayerlistJSON.get(i);
                    if (!jo.containsKey((Object)"fields")) continue;
                    JSONArray ja = (JSONArray)jo.get((Object)"fields");
                    for (int j = 0; j < ja.size(); ++j) {
                        String facet;
                        String layer;
                        JSONObject f = (JSONObject)ja.get(j);
                        if (f.containsKey((Object)"indb") && f.get((Object)"indb").toString().equalsIgnoreCase("true")) {
                            LOGGER.debug((Object)("adding indb: " + jo.get((Object)"name") + ", " + f.get((Object)"id")));
                            layer = jo.get((Object)"name").toString();
                            facet = f.get((Object)"id").toString();
                            ltf.put(layer.toLowerCase(), f);
                            ftl.put(facet, jo);
                        }
                        if (!f.containsKey((Object)"defaultlayer") || !f.get((Object)"defaultlayer").toString().equalsIgnoreCase("true")) continue;
                        LOGGER.debug((Object)("adding defaultlayer: " + jo.get((Object)"name") + ", " + f.get((Object)"id")));
                        layer = jo.get((Object)"name").toString();
                        facet = f.get((Object)"id").toString();
                        ltfdefault.put(layer.toLowerCase(), f);
                        ftldefault.put(facet, jo);
                    }
                }
            }
            if (layerToFacet == null || !ltf.isEmpty()) {
                layerToFacet = ltf;
                facetToLayer = ftl;
                layerToFacetDefault = ltfdefault;
                facetToLayerDefault = ftldefault;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error reading layer info", (Throwable)e);
        }
    }

    public static List<QueryField> getDefaultUploadSamplingFields() {
        String[] fl = defaultFieldString.split(",");
        ArrayList<QueryField> fields = new ArrayList<QueryField>();
        for (int i = 0; i < fl.length; ++i) {
            fields.add(new QueryField(fl[i], CommonData.getFacetLayerDisplayName((String)fl[i]), QueryField.FieldType.AUTO));
        }
        return fields;
    }

    static void initI18nProperies() {
        try {
            Properties p = new Properties();
            p.load(new URL(i18nURL).openStream());
            JSONArray layers = CommonData.getLayerListJSONArray();
            if (layers != null) {
                for (Object o : layers) {
                    JSONObject jo = (JSONObject)o;
                    String facetId = CommonData.getLayerFacetName((String)jo.get((Object)"name").toString());
                    if (facetId == null) continue;
                    p.put("facet." + facetId, ((JSONObject)o).get((Object)"displayname").toString());
                }
            } else {
                LOGGER.error((Object)"layers not added to cached i18n");
            }
            i18nProperites = p;
        }
        catch (Exception e) {
            LOGGER.error((Object)("error loading properties file URL: " + i18nURL), (Throwable)e);
        }
    }

    public static String getI18nProperty(String key) {
        return i18nProperites.getProperty(key);
    }

    public static List<String> getI18nPropertiesList(String key) {
        ArrayList<String> list = new ArrayList<String>();
        if (!i18nIgnoredPrefixes.contains(key)) {
            String startsWith = key + ".";
            for (String k : i18nProperites.stringPropertyNames()) {
                if (!k.startsWith(startsWith)) continue;
                list.add(k);
            }
        }
        return list;
    }

    static void setupAnalysisLayerSets() {
        ArrayList<LayerSelection> a = new ArrayList<LayerSelection>();
        try {
            if (CommonData.getSettings().getProperty("analysis_layer_sets") != null) {
                String[] list;
                for (String row : list = settings.getProperty("analysis_layer_sets").split("\\|")) {
                    String[] cells;
                    if (row.length() <= 0 || (cells = row.split("//")).length != 2) continue;
                    a.add(new LayerSelection(cells[0].trim(), cells[1].trim()));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error setting up analysis layer sets", (Throwable)e);
        }
        analysisLayerSets = a;
    }

    public static String[] getSpeciesDistributionWMSFromSpcode(String spcode) {
        if (speciesWmsLayersBySpcode == null) {
            return new String[0];
        }
        String[] ret = (String[])speciesWmsLayersBySpcode.get(spcode);
        return ret == null ? new String[]{} : ret;
    }

    public static String[] getSpeciesChecklistWMSFromSpcode(String spcode) {
        if (checklistspeciesWmsLayersBySpcode == null) {
            return new String[]{null, null};
        }
        String[] ret = (String[])checklistspeciesWmsLayersBySpcode.get(spcode);
        if (ret == null) {
            LOGGER.error((Object)("failed to find species checklist for spcode=" + spcode));
            return new String[]{null, null};
        }
        return ret;
    }

    public static int getSpeciesChecklistCountByWMS(String lookForWMS) {
        int count = 0;
        if (checklistspeciesWmsLayers != null) {
            for (String[] wms : checklistspeciesWmsLayers.values()) {
                for (int i = 0; i < wms.length; ++i) {
                    if (!wms[i].equals(lookForWMS)) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static void initDownloadReasons() {
        copyDownloadReasons = null;
        LOGGER.debug((Object)"CommonData::initDownloadReasons()");
        String url = CommonData.getSettings().getProperty("logger.url") + "/service/logger/reasons";
        try {
            LOGGER.debug((Object)url);
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(url);
            int result = client.executeMethod((HttpMethod)get);
            if (result == 200) {
                JSONParser jp = new JSONParser();
                copyDownloadReasons = (JSONArray)jp.parse(get.getResponseBodyAsString());
            }
        }
        catch (Exception e) {
            copyDownloadReasons = null;
            LOGGER.error((Object)("error getting reasons: " + url), (Throwable)e);
        }
    }

    private static String[][] parseFacetNameExceptions(String list) {
        String[] terms = list.split(",");
        String[][] output = new String[terms.length][];
        for (int i = 0; i < terms.length; ++i) {
            output[i] = terms[i].split(":");
        }
        return output;
    }

    public static JSONObject getLayer(String name) {
        JSONObject found = null;
        block0: for (int i = 0; i < layerlistJSON.size() && found == null; ++i) {
            JSONObject layer = (JSONObject)layerlistJSON.get(i);
            if (layer.get((Object)"name").toString().equalsIgnoreCase(name)) {
                found = layer;
                continue;
            }
            for (int j = 0; (List)layer.get((Object)"fields") != null && j < ((List)layer.get((Object)"fields")).size(); ++j) {
                JSONObject field = (JSONObject)((List)layer.get((Object)"fields")).get(j);
                if (!field.get((Object)"id").toString().equals(name)) continue;
                found = layer;
                continue block0;
            }
        }
        return found;
    }

    static void initBiocacheLayerList() {
        String url = biocacheServer + "/index/fields";
        try {
            LOGGER.debug((Object)url);
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(url);
            int result = client.executeMethod((HttpMethod)get);
            LOGGER.debug((Object)("initBiocacheLayerList: " + url + " > " + result));
            if (result == 200) {
                int i;
                HashSet<String> set = new HashSet<String>();
                JSONParser jp = new JSONParser();
                JSONArray ja = (JSONArray)jp.parse(get.getResponseBodyAsString());
                LOGGER.debug((Object)("size: " + ja.size()));
                for (i = 0; i < ja.size(); ++i) {
                    String layer = ((JSONObject)ja.get(i)).get((Object)"name").toString();
                    set.add(layer);
                }
                if (!ja.isEmpty()) {
                    for (i = 0; i < facetNameExceptions.length; ++i) {
                        if (!set.contains(facetNameExceptions[i][0])) continue;
                        set.remove(facetNameExceptions[i][1]);
                    }
                    biocacheLayerList = set;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting: " + url), (Throwable)e);
        }
    }

    public static String lang(String key) {
        return languagePack.getLang(key);
    }

    static void initLanguagePack() {
        languagePack = new LanguagePackImpl();
    }

    public static String getSatServer() {
        return satServer;
    }

    public static String getGeoServer() {
        return geoServer;
    }

    public static String getLayersServer() {
        return layersServer;
    }

    public static String getWebportalServer() {
        return webportalServer;
    }

    public static Properties getSettings() {
        return settings;
    }

    public static String getSpeciesListServer() {
        return speciesListServer;
    }

    public static String getBiocacheWebServer() {
        return biocacheWebServer;
    }

    public static String[] getAreaReportFacets() {
        int extra = (speciesListInvasive.length() == 0 ? 0 : 1) + (speciesListThreatened.length() == 0 ? 0 : 1);
        String[] ret = new String[areaReportFacets.length + extra];
        System.arraycopy(areaReportFacets, 0, ret, extra, areaReportFacets.length);
        int pos = 0;
        if (speciesListInvasive.length() > 0) {
            ret[pos++] = speciesListInvasive;
        }
        if (speciesListThreatened.length() > 0) {
            ret[pos++] = speciesListThreatened;
        }
        return ret;
    }

    public static boolean getDisplayPointsOfInterest() {
        return displayPointsOfInterest;
    }

    public static List<LayerSelection> getAnalysisLayerSets() {
        return analysisLayerSets;
    }

    public static String getBieServer() {
        return bieServer;
    }

    public static LsidCountsDynamic getLsidCounts() {
        return lsidCounts;
    }

    public static int getMaxEndemicArea() {
        return maxEndemicArea;
    }

    public static String getBiocacheServer() {
        return biocacheServer;
    }

    public static Set<String> getBiocacheLayerList() {
        return biocacheLayerList;
    }

    public static String getBiocacheQc() {
        return biocacheQc;
    }

    public static String[][] getFacetNameExceptions() {
        return facetNameExceptions;
    }

    public static int getMaxQLength() {
        return maxQLength;
    }

    public static String getExtraDownloadFields() {
        return extraDownloadFields;
    }

    public static Map getSpeciesListCounts(boolean refresh) {
        if (speciesListCounts == null || refresh) {
            HashMap<String, Long> m = new HashMap<String, Long>();
            HttpClient client = new HttpClient();
            String url = biocacheServer + "/occurrences/facets/download?facets=species_guid&count=true" + "&q=geospatial_kosher:*";
            LOGGER.debug((Object)url);
            GetMethod get = new GetMethod(url);
            try {
                String[] row;
                client.executeMethod((HttpMethod)get);
                CSVReader csv = new CSVReader((Reader)new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream())));
                csv.readNext();
                while ((row = csv.readNext()) != null) {
                    try {
                        m.put(row[0], Long.parseLong(row[1]));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("error getting species_guid,count: " + url), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("error getting species list from: " + url));
            }
            speciesListCountsUpdated = System.currentTimeMillis();
            speciesListCounts = m;
        }
        return speciesListCounts;
    }

    public static Map getSpeciesListCountsKosher(boolean refresh) {
        if (speciesListCountsKosher == null || refresh) {
            HashMap<String, Long> m = new HashMap<String, Long>();
            HttpClient client = new HttpClient();
            String url = biocacheServer + "/occurrences/facets/download?facets=species_guid&count=true" + "&q=geospatial_kosher:true";
            LOGGER.debug((Object)url);
            GetMethod get = new GetMethod(url);
            try {
                String[] row;
                client.executeMethod((HttpMethod)get);
                CSVReader csv = new CSVReader((Reader)new BufferedReader(new InputStreamReader(get.getResponseBodyAsStream())));
                csv.readNext();
                while ((row = csv.readNext()) != null) {
                    try {
                        m.put(row[0], Long.parseLong(row[1]));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("error getting species_guid,count (kosher): " + url), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("error getting species list from: " + url));
            }
            speciesListCountsUpdatedKosher = System.currentTimeMillis();
            speciesListCountsKosher = m;
        }
        return speciesListCountsKosher;
    }

    private static void initJournalmap() {
        if (journalMapArticles != null && journalMapArticles.size() > 0) {
            return;
        }
        journalMapArticles = new ArrayList();
        journalMapLocations = new ArrayList();
        try {
            String journalmapUrl = CommonData.getSettings().getProperty("journalmap.url", null);
            String journalmapKey = CommonData.getSettings().getProperty("journalmap.api_key", null);
            File jaFile = new File("/data/webportal/journalmapArticles.json");
            if (jaFile.exists()) {
                JSONParser jp = new JSONParser();
                JSONArray ja = (JSONArray)jp.parse(FileUtils.readFileToString((File)jaFile));
                for (int i = 0; i < ja.size(); ++i) {
                    journalMapArticles.add((JSONObject)ja.get(i));
                }
            } else if (journalmapKey != null && !journalmapKey.isEmpty()) {
                int page = 1;
                int maxpage = 0;
                ArrayList<String> publicationsIds = new ArrayList<String>();
                while (page == 1 || page <= maxpage) {
                    HttpClient client = new HttpClient();
                    String url = journalmapUrl + "api/publications.json?version=1.0&key=" + journalmapKey + "&page=" + page;
                    ++page;
                    LOGGER.debug((Object)("journalmap url: " + url));
                    GetMethod get = new GetMethod(url);
                    int result = client.executeMethod((HttpMethod)get);
                    maxpage = Integer.parseInt(get.getResponseHeader("X-Pages").getValue());
                    JSONParser jp = new JSONParser();
                    JSONArray jcollection = (JSONArray)jp.parse(get.getResponseBodyAsString());
                    for (int i = 0; i < jcollection.size(); ++i) {
                        if (!((JSONObject)jcollection.get(i)).containsKey((Object)"id")) continue;
                        publicationsIds.add(((JSONObject)jcollection.get(i)).get((Object)"id").toString());
                        LOGGER.debug((Object)("found publication: " + ((JSONObject)jcollection.get(i)).get((Object)"id").toString() + ", article_count: " + ((JSONObject)jcollection.get(i)).get((Object)"articles_count").toString()));
                    }
                }
                for (String publicationsId : publicationsIds) {
                    try {
                        page = 1;
                        maxpage = 0;
                        while (page == 1 || page <= maxpage) {
                            HttpClient client = new HttpClient();
                            String url = journalmapUrl + "api/articles.json?version=1.0&key=" + journalmapKey + "&page=" + page + "&publication_id=" + publicationsId;
                            ++page;
                            LOGGER.debug((Object)("journalmap url: " + url));
                            GetMethod get = new GetMethod(url);
                            int result = client.executeMethod((HttpMethod)get);
                            maxpage = Integer.parseInt(get.getResponseHeader("X-Pages").getValue());
                            JSONParser jp = new JSONParser();
                            JSONArray jarticles = (JSONArray)jp.parse(get.getResponseBodyAsString());
                            for (int j = 0; j < jarticles.size(); ++j) {
                                JSONObject o = (JSONObject)jarticles.get(j);
                                if (!o.containsKey((Object)"locations")) continue;
                                journalMapArticles.add(o);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("journalmap - failure to get articles from publicationsId: " + publicationsId));
                    }
                }
                FileWriter fw = new FileWriter(jaFile);
                JSONValue.writeJSONString((Object)journalMapArticles, (Writer)fw);
                fw.flush();
                fw.close();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error initialising journalmap data", (Throwable)e);
        }
        for (int i = 0; i < journalMapArticles.size(); ++i) {
            JSONArray locations = (JSONArray)((JSONObject)journalMapArticles.get(i)).get((Object)"locations");
            for (int j = 0; j < locations.size(); ++j) {
                JSONObject l = (JSONObject)locations.get(j);
                double longitude = Double.parseDouble(l.get((Object)"longitude").toString());
                double latitude = Double.parseDouble(l.get((Object)"latitude").toString());
                journalMapLocations.add(new JournalMapLocation(longitude, latitude, i));
            }
        }
    }

    public static List<JSONObject> filterJournalMapArticles(String wkt) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        HashSet<Integer> set = new HashSet<Integer>();
        try {
            WKTReader wktReader = new WKTReader();
            Geometry g = wktReader.read(wkt);
            for (JournalMapLocation l : journalMapLocations) {
                if (set.contains(l.idx) || !g.contains((Geometry)l.point)) continue;
                list.add((JSONObject)journalMapArticles.get(l.idx));
                set.add(l.idx);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error intersecting wkt with journal map articles", (Throwable)e);
        }
        return list;
    }

    private static Map<String, Map<String, List<String>>> initSpeciesListAdditionalColumns() {
        String[] columns;
        HashMap<String, Map<String, List<String>>> map = new HashMap<String, Map<String, List<String>>>();
        String slac = settings.getProperty("species.list.additional.columns", "");
        slac = slac + CommonData.dynamicSpeciesListColumns();
        for (String line : columns = slac.split("\\|")) {
            String[] parts = line.split(",");
            if (parts[0].equals("Conservation")) {
                speciesListThreatened = "species_list_uid:" + StringUtils.join((Object[])Arrays.copyOfRange(parts, 1, parts.length), (String)" OR species_list_uid:");
            }
            if (parts[0].equals("Invasive")) {
                speciesListInvasive = "species_list_uid:" + StringUtils.join((Object[])Arrays.copyOfRange(parts, 1, parts.length), (String)" OR species_list_uid:");
            }
            if (parts.length <= 1) continue;
            String columnTitle = parts[0];
            for (int i = 1; i < parts.length; ++i) {
                try {
                    JSONParser jp = new JSONParser();
                    InputStream is = new URL(CommonData.getSpeciesListServer() + "/ws/speciesList?druid=" + parts[i]).openStream();
                    String listName = ((JSONObject)jp.parse(IOUtils.toString((InputStream)is))).get((Object)"listName").toString();
                    is.close();
                    HashMap m = (HashMap)map.get(columnTitle);
                    if (m == null) {
                        m = new HashMap();
                    }
                    ArrayList<String> sp = new ArrayList<String>();
                    Collection list = SpeciesListUtil.getListItems((String)parts[i]);
                    for (SpeciesListItemDTO item : list) {
                        if (item.getLsid() == null || item.getLsid().isEmpty()) continue;
                        sp.add(item.getLsid());
                    }
                    Collections.sort(sp);
                    m.put(listName, sp);
                    map.put(columnTitle, m);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("error reading list: " + parts[i]), (Throwable)e);
                }
            }
        }
        return map;
    }

    private static String dynamicSpeciesListColumns() {
        StringBuilder sb = new StringBuilder();
        try {
            JSONObject[] lists;
            JSONParser jp = new JSONParser();
            JSONObject threatened = (JSONObject)jp.parse(Util.readUrl((String)(settings.getProperty("species_list_url", "") + "/ws/speciesList/?isThreatened=eq:true&isAuthoritative=eq:true")));
            JSONObject invasive = (JSONObject)jp.parse(Util.readUrl((String)(settings.getProperty("species_list_url", "") + "/ws/speciesList/?isInvasive=eq:true&isAuthoritative=eq:true")));
            for (JSONObject o : lists = new JSONObject[]{threatened, invasive}) {
                if (sb.length() == 0) {
                    sb.append("Conservation");
                } else {
                    sb.append("|Invasive");
                }
                JSONArray ja = (JSONArray)o.get((Object)"lists");
                for (int i = 0; i < ja.size(); ++i) {
                    sb.append(",").append(((JSONObject)ja.get(i)).get((Object)"dataResourceUid"));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to get species lists for threatened or invasive species", (Throwable)e);
        }
        return sb.toString();
    }

    public static List<String> getSpeciesListAdditionalColumnsHeader() {
        return new ArrayList<String>(speciesListAdditionalColumns.keySet());
    }

    public static List<String> getSpeciesListAdditionalColumns(List<String> headers, String lsid) {
        if (lsid != null && lsid.contains("|") && lsid.split("\\|").length > 1) {
            lsid = lsid.split("\\|")[1];
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < headers.size(); ++i) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : ((Map)speciesListAdditionalColumns.get(headers.get(i))).entrySet()) {
                List sorted = (List)entry.getValue();
                if (sorted == null || Collections.binarySearch(sorted, lsid) < 0) continue;
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append((String)entry.getKey());
            }
            list.add(sb.toString());
        }
        return list;
    }

    static {
        extraDownloadFields = "coordinateUncertaintyInMeters";
        layerlistJSON = null;
        copyLayerlistJSON = null;
        defaultFieldString = null;
        speciesWmsLayers = null;
        copySpeciesWmsLayers = null;
        speciesMetadataLayers = null;
        copySpeciesMetadataLayers = null;
        speciesSpcodeLayers = null;
        copySpeciesSpcodeLayers = null;
        speciesWmsLayersBySpcode = null;
        copySpeciesWmsLayersBySpcode = null;
        checklistspeciesWmsLayers = null;
        copyChecklistspeciesWmsLayers = null;
        checklistspeciesMetadataLayers = null;
        copyChecklistspeciesMetadataLayers = null;
        checklistspeciesSpcodeLayers = null;
        copyChecklistspeciesSpcodeLayers = null;
        checklistspeciesWmsLayersBySpcode = null;
        copyChecklistspeciesWmsLayersBySpcode = null;
        i18nProperites = null;
        languagePack = null;
        speciesListCountsUpdated = 0L;
        speciesListCountsUpdatedKosher = 0L;
        speciesListAdditionalColumns = new HashMap();
        journalMapArticles = null;
        journalMapLocations = null;
        speciesListThreatened = "";
        speciesListInvasive = "";
    }
}

