/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.legend.Facet;
import au.org.ala.legend.Legend;
import au.org.ala.legend.LegendObject;
import au.org.ala.legend.QueryField;
import au.org.ala.spatial.util.BiocacheLegendObject;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.FacetCacheImpl;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.Util;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

/*
 * Exception performing whole class analysis ignored.
 */
public class BiocacheQuery
implements Query,
Serializable {
    static final String SAMPLING_SERVICE_CSV_GZIP = "/webportal/occurrences.gz?";
    static final String SAMPLING_SERVICE = "/webportal/occurrences?";
    static final String SPECIES_LIST_SERVICE_CSV = "/occurrences/facets/download?facets=names_and_lsid&lookup=true&count=true&";
    static final String SPECIES_COUNT_SERVICE = "/occurrence/facets?facets=names_and_lsid";
    static final String DOWNLOAD_URL = "/occurrences/download?";
    static final String DATA_PROVIDERS_SERVICE = "/webportal/dataProviders?";
    static final String QUERY_TITLE_URL = "/occurrences/search?";
    static final String LEGEND_SERVICE_CSV = "/webportal/legend?";
    static final String BOUNDING_BOX_CSV = "/webportal/bbox?";
    static final String INDEXED_FIELDS_LIST = "/indexed/fields?";
    static final String POST_SERVICE = "/webportal/params?";
    static final String QID_DETAILS = "/webportal/params/details/";
    static final String ENDEMIC_COUNT_SERVICE = "/explore/counts/endemic?";
    static final String ENDEMIC_SPECIES_SERVICE_CSV = "/explore/endemic/species.csv?";
    static final String DEFAULT_ROWS = "pageSize=1000000";
    static final String DEFAULT_ROWS_LARGEST = "pageSize=1000000";
    static final Pattern QUERY_PARAMS_PATTERN = Pattern.compile("&([a-zA-Z0-9_\\-]+)=");
    static final String DEFAULT_VALIDATION = "";
    static final String BIE_SPECIES = "/species/";
    static final String WMS_URL = "/webportal/wms/reflect?";
    private static final Logger LOGGER = Logger.getLogger(BiocacheQuery.class);
    private static final String[] COMMON_TAXON_RANKS = new String[]{"cultivar", "superfamily", "subgenus", "unranked", "infrageneric", "subfamily", "subspecies", "section", "infraspecific", "hybrid", "variety", "form", "series", "tribe"};
    private String name;
    private String rank;
    private String lsids;
    private String[] rawNames;
    private List<Facet> facets;
    private String wkt;
    private String extraParams;
    private String paramId;
    private String qc;
    private String biocacheWebServer;
    private String biocacheServer;
    private boolean supportsDynamicFacets;
    private boolean forMapping;
    private String speciesList = null;
    private String endemicSpeciesList = null;
    private int speciesCount = -1;
    private int endemicSpeciesCount = -1;
    private int occurrenceCount = -1;
    private String solrName = null;
    private Map<String, LegendObject> legends = new HashMap();
    private Set<String> flaggedRecords = new HashSet();
    private int speciesCountKosher = -1;
    private int speciesCountCoordinates = -1;
    private int speciesCountAny = -1;
    private int occurrenceCountKosher = -1;
    private int occurrenceCountCoordinates = -1;
    private int occurrenceCountAny = -1;
    private List<QueryField> facetFieldList = null;
    private List<Double> bbox = null;
    private Pattern lsidPattern = Pattern.compile("(?:lsid:)\"?([a-z0-9\\:\\.\\-]*)\"?");

    public BiocacheQuery(String lsids, String wkt, String extraParams, List<Facet> facets, boolean forMapping, boolean[] geospatialKosher) {
        this(lsids, null, wkt, extraParams, facets, forMapping, geospatialKosher);
    }

    public BiocacheQuery(String lsids, String[] rawNames, String wkt, String extraParams, List<Facet> facets, boolean forMapping, boolean[] geospatialKosher) {
        this(lsids, rawNames, wkt, extraParams, facets, forMapping, geospatialKosher, null, null, false);
    }

    public BiocacheQuery(String lsids, String wkt, String extraParams, List<Facet> facets, boolean forMapping, boolean[] geospatialKosher, String biocacheServer, String biocacheWebServer, boolean supportsDynamicFacets) {
        this(lsids, null, wkt, extraParams, facets, forMapping, geospatialKosher, biocacheServer, biocacheWebServer, supportsDynamicFacets);
    }

    public BiocacheQuery(String lsids, String[] rawNames, String wkt, String extraParams, List<Facet> facets, boolean forMapping, boolean[] geospatialKosher, String biocacheServer, String biocacheWebServer, boolean supportsDynamicFacets) {
        if (biocacheServer != null && biocacheWebServer != null) {
            this.biocacheWebServer = biocacheWebServer;
            this.biocacheServer = biocacheServer;
        } else {
            this.biocacheWebServer = CommonData.getBiocacheWebServer();
            this.biocacheServer = CommonData.getBiocacheServer();
        }
        if (facets != null || extraParams != null) {
            int i;
            String newExtraParams = null;
            int n = i = facets == null ? -1 : facets.size() - 1;
            while (i >= -1) {
                String term = i >= 0 ? facets.get(i).toString() : extraParams;
                if (term != null && term.startsWith("qid:")) {
                    if (i == -1) {
                        extraParams = null;
                    }
                    JSONObject jo = this.getQidDetails(term);
                    try {
                        StringBuilder sb = new StringBuilder();
                        if (jo.containsKey((Object)"q") && jo.get((Object)"q").toString().length() > 0 && !jo.get((Object)"q").toString().equals("*:*")) {
                            sb.append("&fq=").append(jo.get((Object)"q"));
                        }
                        if (jo.containsKey((Object)"fqs")) {
                            JSONArray ja = (JSONArray)jo.get((Object)"fqs");
                            for (int j = 0; j < ja.size(); ++j) {
                                if (ja.get(j).toString().length() <= 0 || ja.get(j).toString().equals("*:*")) continue;
                                sb.append("&fq=").append(ja.get(j));
                            }
                        }
                        newExtraParams = newExtraParams == null ? sb.toString().replace("\\", "") : newExtraParams + sb.toString().replace("\\", "");
                        if (jo.containsKey((Object)"wkt") && jo.get((Object)"wkt").toString().length() > 0) {
                            String qidWkt = jo.get((Object)"wkt").toString();
                            if (wkt == null) {
                                wkt = qidWkt;
                            } else {
                                try {
                                    WKTReader wktReader = new WKTReader();
                                    Geometry g1 = wktReader.read(wkt);
                                    Geometry g2 = wktReader.read(qidWkt);
                                    wkt = g1.union(g2).toText().replace(", ", ",").replace(" (", "(");
                                }
                                catch (Exception e) {
                                    LOGGER.error((Object)("failed to union wkt: " + wkt + " and " + qidWkt));
                                }
                            }
                        }
                        if (jo.containsKey((Object)"displayString")) {
                            this.name = jo.get((Object)"displayString").toString();
                            this.solrName = jo.get((Object)"displayString").toString();
                        }
                        if (i >= 0) {
                            facets.remove(i);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("failed to merge " + facets.get(i).toString()), (Throwable)e);
                    }
                }
                --i;
            }
            if (newExtraParams != null) {
                extraParams = extraParams == null ? newExtraParams : extraParams + newExtraParams;
            }
        }
        this.lsids = lsids;
        String[] stringArray = this.rawNames = rawNames == null ? null : (String[])rawNames.clone();
        if (facets != null) {
            this.facets = new ArrayList(facets.size());
            this.facets.addAll(facets);
        }
        this.wkt = wkt != null && wkt.equals("POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))") ? null : Util.fixWkt((String)wkt);
        this.extraParams = extraParams;
        this.forMapping = forMapping;
        this.qc = CommonData.getBiocacheQc();
        this.supportsDynamicFacets = supportsDynamicFacets;
        if (geospatialKosher != null) {
            this.addGeospatialKosher(geospatialKosher);
        }
        this.makeParamId();
    }

    static final String translateFieldForSolr(String facetName) {
        String newFacetName = facetName;
        if (newFacetName == null) {
            return null;
        }
        for (String[] s : CommonData.getFacetNameExceptions()) {
            if (!newFacetName.equals(s[0])) continue;
            newFacetName = s[1];
            break;
        }
        if ("occurrence_year_individual".equals(newFacetName)) {
            newFacetName = "occurrence_year";
        }
        if ("occurrence_year_decade".equals(newFacetName)) {
            newFacetName = "occurrence_year";
        }
        return newFacetName;
    }

    static Facet makeFacetGeospatialKosher(boolean includeTrue, boolean includeFalse, boolean includeNull) {
        if (includeTrue && includeFalse && includeNull) {
            return null;
        }
        if (!(includeTrue || includeFalse || includeNull)) {
            return new Facet("*", "*", false);
        }
        if (includeTrue && !includeFalse && !includeNull) {
            return new Facet("geospatial_kosher", "true", true);
        }
        if (!includeTrue && includeFalse && !includeNull) {
            return new Facet("geospatial_kosher", "false", true);
        }
        if (!includeTrue && !includeFalse && includeNull) {
            return new Facet("geospatial_kosher", "*", false);
        }
        if (includeTrue && includeFalse && !includeNull) {
            return new Facet("geospatial_kosher", "*", true);
        }
        if (includeTrue && !includeFalse && includeNull) {
            return new Facet("geospatial_kosher", "false", false);
        }
        return new Facet("geospatial_kosher", "true", false);
    }

    public static boolean[] parseGeospatialKosher(String facet) {
        boolean[] geospatialKosher = null;
        if (facet != null) {
            String f = facet.replace("\"", "").replace("(", "").replace(")", "");
            if ("geospatial_kosher:true".equals(f)) {
                geospatialKosher = new boolean[]{true, false, false};
            } else if ("geospatial_kosher:false".equals(f)) {
                geospatialKosher = new boolean[]{false, true, false};
            } else if ("-geospatial_kosher:*".equals(f)) {
                geospatialKosher = new boolean[]{false, false, true};
            } else if ("geospatial_kosher:*".equals(f)) {
                geospatialKosher = new boolean[]{true, true, false};
            } else if ("-geospatial_kosher:false".equals(f)) {
                geospatialKosher = new boolean[]{true, false, true};
            } else if ("-geospatial_kosher:true".equals(f)) {
                geospatialKosher = new boolean[]{false, true, true};
            }
        }
        return geospatialKosher;
    }

    private static String[] splitOnParams(String query) {
        String[] totals = query.split(QUERY_PARAMS_PATTERN.toString());
        int i = 1;
        if (totals.length > 1) {
            Matcher m = QUERY_PARAMS_PATTERN.matcher(query);
            while (m.find()) {
                totals[i] = m.group(1) + "=" + totals[i];
                ++i;
            }
        }
        if (totals.length > 1 && StringUtils.isEmpty((String)totals[0])) {
            totals = Arrays.copyOfRange(totals, 1, totals.length);
        }
        return totals;
    }

    public static String getScientificNameRank(String lsid) {
        String snUrl = CommonData.getBieServer() + "/species/" + lsid + ".json";
        LOGGER.debug((Object)snUrl);
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(snUrl);
            get.addRequestHeader("Content-type", "application/json");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONObject jo = (JSONObject)jp.parse(slist);
            String scientficName = ((JSONObject)jo.get((Object)"taxonConcept")).get((Object)"nameString").toString();
            String r = ((JSONObject)jo.get((Object)"taxonConcept")).get((Object)"rankString").toString();
            LOGGER.debug((Object)("Arrays.binarySearch(COMMON_TAXON_RANKS, rank): " + Arrays.binarySearch(COMMON_TAXON_RANKS, r)));
            if (Arrays.binarySearch(COMMON_TAXON_RANKS, r) > -1) {
                r = "taxon";
            }
            return scientficName + "," + r;
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting scientific name:" + snUrl), (Throwable)e);
            return "occurrences";
        }
    }

    public static String getGuid(String name) {
        String url = CommonData.getBieServer() + "/ws/guid/" + name.replaceAll(" ", "%20");
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(url);
            get.addRequestHeader("Content-type", "application/json");
            client.executeMethod((HttpMethod)get);
            String body = get.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONArray ja = (JSONArray)jp.parse(body);
            if (ja != null && !ja.isEmpty()) {
                JSONObject jo = (JSONObject)ja.get(0);
                if (jo != null && jo.containsKey((Object)"acceptedIdentifier")) {
                    return jo.get((Object)"acceptedIdentifier").toString();
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting guid at: " + url), (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getClassification(String lsid) {
        String[] classificationList = new String[]{"kingdom", "phylum", "class", "order", "family", "genus", "species", "subspecies", "scientificName"};
        LinkedHashMap<String, String> classification = new LinkedHashMap<String, String>();
        String snUrl = CommonData.getBieServer() + "/species/" + lsid + ".json";
        LOGGER.debug((Object)snUrl);
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(snUrl);
            get.addRequestHeader("Content-type", "application/json");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONObject jo = (JSONObject)jp.parse(slist);
            JSONObject joOcc = (JSONObject)jo.get((Object)"classification");
            for (String c : classificationList) {
                String value;
                String s = c.replace("ss", "zz");
                if (!joOcc.containsKey((Object)s) || (value = joOcc.get((Object)s).toString()) == null) continue;
                classification.put(s, value);
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("Error getting scientific name for: " + lsid));
        }
        return classification;
    }

    void addGeospatialKosher(boolean[] geospatialKosher) {
        if (this.getGeospatialKosher() == null) {
            return;
        }
        Facet f = BiocacheQuery.makeFacetGeospatialKosher((boolean)geospatialKosher[0], (boolean)geospatialKosher[1], (boolean)geospatialKosher[2]);
        if (this.facets == null) {
            this.facets = new ArrayList();
        } else {
            for (int i = 0; i < this.facets.size(); ++i) {
                if (!((Facet)this.facets.get(i)).toString().contains("geospatial_kosher:")) continue;
                this.facets.remove(i);
                break;
            }
        }
        if (f != null) {
            this.facets.add(f);
        }
    }

    public boolean[] getGeospatialKosher() {
        boolean[] geospatialKosher = new boolean[]{true, true, true};
        if ((this.lsids + this.extraParams).contains("geospatial_kosher:")) {
            return geospatialKosher;
        }
        if (this.facets != null) {
            for (int i = 0; i < this.facets.size(); ++i) {
                String f = ((Facet)this.facets.get(i)).toString().replace("\"", "").replace("(", "").replace(")", "");
                if (!f.contains("geospatial_kosher:")) continue;
                if ("geospatial_kosher:true".equals(f)) {
                    geospatialKosher = new boolean[]{true, false, false};
                    break;
                }
                if ("geospatial_kosher:false".equals(f)) {
                    geospatialKosher = new boolean[]{false, true, false};
                    break;
                }
                if ("-geospatial_kosher:*".equals(f)) {
                    geospatialKosher = new boolean[]{false, false, true};
                    break;
                }
                if ("geospatial_kosher:*".equals(f)) {
                    geospatialKosher = new boolean[]{true, true, false};
                    break;
                }
                if ("-geospatial_kosher:false".equals(f)) {
                    geospatialKosher = new boolean[]{true, false, true};
                    break;
                }
                if (!"-geospatial_kosher:true".equals(f)) break;
                geospatialKosher = new boolean[]{false, true, true};
                break;
            }
        }
        return geospatialKosher;
    }

    public BiocacheQuery newFacetGeospatialKosher(boolean[] geospatialKosher, boolean forMapping) {
        boolean[] gk = this.getGeospatialKosher();
        if (gk == null) {
            LOGGER.error((Object)("Attempted to add a geospatial_kosher facet to an unsupported query: '" + this.lsids + "', '" + this.extraParams + "'"));
            return null;
        }
        int sum = 0;
        for (int i = 0; i < gk.length; ++i) {
            if (gk[i] != geospatialKosher[i]) continue;
            ++sum;
        }
        if (sum == gk.length) {
            return this.newFacet(null, forMapping);
        }
        ArrayList newFacets = new ArrayList();
        if (this.facets != null) {
            for (int i = 0; i < this.facets.size(); ++i) {
                if (((Facet)this.facets.get(i)).toString().contains("geospatial_kosher:")) continue;
                newFacets.add(this.facets.get(i));
            }
        }
        return new BiocacheQuery(this.lsids, this.rawNames, this.wkt, this.extraParams, newFacets, forMapping, geospatialKosher, this.biocacheServer, this.biocacheWebServer, this.supportsDynamicFacets);
    }

    public BiocacheQuery newFacet(Facet facet, boolean forMapping) {
        if (facet == null && (this.forMapping || !forMapping)) {
            return this;
        }
        ArrayList<Facet> newFacets = new ArrayList<Facet>();
        if (this.facets != null) {
            newFacets.addAll(this.facets);
        }
        if (facet != null) {
            newFacets.add(facet);
        }
        return new BiocacheQuery(this.lsids, this.rawNames, this.wkt, this.extraParams, newFacets, forMapping, null, this.biocacheServer, this.biocacheWebServer, this.supportsDynamicFacets);
    }

    public BiocacheQuery newWkt(String wkt, boolean forMapping) {
        if (wkt == null || wkt.equals("POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))") || wkt.equals(this.wkt)) {
            if (this.forMapping || !forMapping) {
                return this;
            }
            return new BiocacheQuery(this.lsids, this.rawNames, wkt, this.extraParams, this.facets, forMapping, null, this.biocacheServer, this.biocacheWebServer, this.supportsDynamicFacets);
        }
        BiocacheQuery sq = null;
        try {
            String newWkt = wkt;
            if (this.wkt != null) {
                Geometry newGeom = new WKTReader().read(wkt);
                Geometry thisGeom = new WKTReader().read(this.wkt);
                Geometry intersectionGeom = thisGeom.intersection(newGeom);
                newWkt = new WKTWriter().write(intersectionGeom).replace(" (", "(").replace(", ", ",").replace(") ", ")");
            }
            sq = new BiocacheQuery(this.lsids, this.rawNames, newWkt, this.extraParams, this.facets, forMapping, null, this.biocacheServer, this.biocacheWebServer, this.supportsDynamicFacets);
        }
        catch (Exception e) {
            LOGGER.error((Object)"error getting new WKT from an intersection", (Throwable)e);
        }
        return sq;
    }

    public String sample(List<QueryField> fields) {
        HttpClient client = new HttpClient();
        String url = this.biocacheServer + "/webportal/occurrences.gz?" + "pageSize=1000000" + "&q=" + this.getQ() + this.paramQueryFields(fields) + this.getQc();
        LOGGER.debug((Object)url);
        GetMethod get = new GetMethod(url);
        String sample = null;
        long start = System.currentTimeMillis();
        try {
            client.executeMethod((HttpMethod)get);
            sample = this.decompressGz(get.getResponseBodyAsStream());
            for (QueryField f : fields) {
                String t = BiocacheQuery.translateFieldForSolr((String)f.getName());
                if (f.getName().equals(t)) continue;
                sample = sample.replaceFirst(t, f.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error sampling", (Throwable)e);
        }
        LOGGER.debug((Object)("get sample in " + (System.currentTimeMillis() - start) + "ms"));
        return sample;
    }

    public String getAutoComplete(String facet, String value, int limit) {
        HttpClient client = new HttpClient();
        StringBuilder slist = new StringBuilder();
        if (value.length() >= 3 && StringUtils.isNotBlank((String)facet)) {
            try {
                String url = this.biocacheServer + "/occurrences/search?" + "q=" + this.getQ() + this.getQc() + "&facets=" + facet + "&fprefix=" + URLEncoder.encode(value, "UTF-8") + "&pageSize=0&flimit=" + limit;
                GetMethod get = new GetMethod(url);
                get.addRequestHeader("Content-type", "text/plain");
                int result = client.executeMethod((HttpMethod)get);
                if (result == 200) {
                    String rawJSON = get.getResponseBodyAsString();
                    JSONParser jp = new JSONParser();
                    JSONObject jo = (JSONObject)jp.parse(rawJSON);
                    JSONArray ja = (JSONArray)jo.get((Object)"facetResults");
                    for (int i = 0; i < ja.size(); ++i) {
                        JSONObject o = (JSONObject)ja.get(i);
                        if (!o.get((Object)"fieldName").equals(facet)) continue;
                        JSONArray values = (JSONArray)o.get((Object)"fieldResult");
                        for (int j = 0; j < values.size(); ++j) {
                            JSONObject vo = (JSONObject)values.get(j);
                            if (slist.length() > 0) {
                                slist.append("\n");
                            }
                            slist.append(vo.get((Object)"label")).append("//found ").append(vo.get((Object)"count").toString());
                        }
                    }
                } else {
                    LOGGER.warn((Object)("There was an issue performing the autocomplete from the biocache: " + result));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("failed to get autocomplete facet=" + facet + ", value=" + value), (Throwable)e);
            }
        }
        return slist.toString();
    }

    public String speciesList() {
        if (this.speciesList != null) {
            return this.speciesList;
        }
        HttpClient client = new HttpClient();
        String url = this.biocacheServer + "/occurrences/facets/download?facets=names_and_lsid&lookup=true&count=true&" + "&q=" + this.getQ() + this.getQc();
        LOGGER.debug((Object)url);
        GetMethod get = new GetMethod(url);
        try {
            String[] line;
            client.executeMethod((HttpMethod)get);
            this.speciesList = get.getResponseBodyAsString();
            List header = CommonData.getSpeciesListAdditionalColumnsHeader();
            StringBuilder newlist = new StringBuilder();
            int total = this.getOccurrenceCount();
            CSVReader csv = new CSVReader((Reader)new StringReader(this.speciesList));
            int count = 0;
            int lastpos = 0;
            while ((line = csv.readNext()) != null) {
                int nextpos = this.speciesList.indexOf(10, lastpos + 1);
                if (nextpos < 0) {
                    nextpos = this.speciesList.length();
                }
                newlist.append(this.speciesList.substring(lastpos, nextpos));
                List list = header;
                if (lastpos != 0) {
                    list = CommonData.getSpeciesListAdditionalColumns((List)header, (String)line[0]);
                }
                for (int i = 0; i < list.size(); ++i) {
                    newlist.append(",\"").append(((String)list.get(i)).replace("\"", "\"\"").replace("\\", "\\\\")).append("\"");
                }
                lastpos = nextpos;
                try {
                    count += Integer.parseInt(line[line.length - 1]);
                }
                catch (Exception e) {}
            }
            if (total - count > 0) {
                String correction = "\n,,,,,,,,,,Other (not species rank)," + (total - count);
                newlist.append(correction);
            }
            this.speciesList = newlist.toString();
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting species list from: " + url));
        }
        return this.speciesList;
    }

    public String endemicSpeciesList() {
        if (this.endemicSpeciesList != null) {
            return this.endemicSpeciesList;
        }
        if (CommonData.getSettings().containsKey("endemic.sp.method") && CommonData.getSettings().getProperty("endemic.sp.method").equals("true")) {
            String speciesList = this.speciesList();
            Map speciesCounts = this.getGeospatialKosher()[1] ? CommonData.getSpeciesListCounts((boolean)false) : CommonData.getSpeciesListCountsKosher((boolean)false);
            StringBuilder sb = new StringBuilder();
            int speciesCol = 0;
            int countCol = 11;
            try {
                String[] row;
                CSVReader csv = new CSVReader((Reader)new StringReader(speciesList));
                int currentPos = 0;
                int nextPos = speciesList.indexOf(10, currentPos + 1);
                sb.append(speciesList.substring(currentPos, nextPos));
                csv.readNext();
                while ((row = csv.readNext()) != null) {
                    Long c = (Long)speciesCounts.get(row[speciesCol]);
                    if (c != null && c <= Long.parseLong(row[countCol])) {
                        if (nextPos > speciesList.length()) {
                            nextPos = speciesList.length();
                        }
                        sb.append(speciesList.substring(currentPos, nextPos));
                    } else if (c == null) {
                        LOGGER.error((Object)("failed to find species_guid: " + row[speciesCol] + " in CommonData.getSpeciesListCounts()"));
                    }
                    currentPos = nextPos;
                    nextPos = speciesList.indexOf(10, currentPos + 1);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"failed generating endemic species list", (Throwable)e);
            }
            this.endemicSpeciesList = sb.toString();
        } else {
            HttpClient client = new HttpClient();
            String url = this.biocacheServer + "/explore/endemic/species.csv?" + "q=" + this.getQ() + this.getQc();
            if (this.wkt == null || this.wkt.isEmpty()) {
                url = url + "&wkt=POLYGON((-180%20-90%2C-180%2090%2C180%2090%2C180%20-90%2C-180%20-90))";
            }
            LOGGER.debug((Object)url);
            GetMethod get = new GetMethod(url);
            try {
                client.executeMethod((HttpMethod)get);
                this.endemicSpeciesList = get.getResponseBodyAsString();
            }
            catch (Exception e) {
                LOGGER.error((Object)"error getting endemic species result", (Throwable)e);
            }
        }
        return this.endemicSpeciesList;
    }

    public int getOccurrenceCount() {
        if (this.occurrenceCount >= 0) {
            return this.occurrenceCount;
        }
        HttpClient client = new HttpClient();
        String url = this.biocacheServer + "/webportal/occurrences?" + "pageSize=0&facet=false" + "&q=" + this.getQ() + this.getQc();
        LOGGER.debug((Object)url);
        GetMethod get = new GetMethod(url);
        try {
            client.executeMethod((HttpMethod)get);
            String response = get.getResponseBodyAsString();
            String start = "\"totalRecords\":";
            String end = ",";
            int startPos = response.indexOf(start) + start.length();
            this.occurrenceCount = Integer.parseInt(response.substring(startPos, response.indexOf(end, startPos)));
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting records count: " + url), (Throwable)e);
        }
        return this.occurrenceCount;
    }

    public int getSpeciesCount() {
        if (this.speciesCount >= 0) {
            return this.speciesCount;
        }
        HttpClient client = new HttpClient();
        String url = this.biocacheServer + "/occurrence/facets?facets=names_and_lsid" + "&q=" + this.getQ().replace("&fq=", "%20AND%20") + this.getQc();
        LOGGER.debug((Object)url);
        GetMethod get = new GetMethod(url);
        try {
            JSONObject jo;
            client.executeMethod((HttpMethod)get);
            String response = get.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONArray ja = (JSONArray)jp.parse(response);
            if (!ja.isEmpty() && (jo = (JSONObject)ja.get(0)).containsKey((Object)"count")) {
                this.speciesCount = Integer.parseInt(jo.get((Object)"count").toString());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting records count: " + url), (Throwable)e);
        }
        return this.speciesCount;
    }

    public int getEndemicSpeciesCount() {
        if (this.endemicSpeciesCount >= 0) {
            return this.endemicSpeciesCount;
        }
        this.endemicSpeciesList();
        this.endemicSpeciesCount = 0;
        int p = 0;
        while ((p = this.endemicSpeciesList.indexOf(10, p + 1)) > 0) {
            ++this.endemicSpeciesCount;
        }
        return this.endemicSpeciesCount;
    }

    public int getSpeciesCountKosher() {
        if (this.speciesCountKosher < 0) {
            this.speciesCountKosher = this.newFacetGeospatialKosher(new boolean[]{true, false, false}, false).getSpeciesCount();
        }
        return this.speciesCountKosher;
    }

    public int getSpeciesCountCoordinates() {
        if (this.speciesCountCoordinates < 0) {
            this.speciesCountCoordinates = this.newFacetGeospatialKosher(new boolean[]{true, true, false}, false).getSpeciesCount();
        }
        return this.speciesCountCoordinates;
    }

    public int getSpeciesCountAny() {
        if (this.speciesCountAny < 0) {
            this.speciesCountAny = this.newFacetGeospatialKosher(new boolean[]{true, true, true}, false).getSpeciesCount();
        }
        return this.speciesCountAny;
    }

    public int getOccurrenceCountKosher() {
        if (this.occurrenceCountKosher < 0) {
            this.occurrenceCountKosher = this.newFacetGeospatialKosher(new boolean[]{true, false, false}, false).getOccurrenceCount();
        }
        return this.occurrenceCountKosher;
    }

    public int getOccurrenceCountCoordinates() {
        if (this.occurrenceCountCoordinates < 0) {
            this.occurrenceCountCoordinates = this.newFacetGeospatialKosher(new boolean[]{true, true, false}, false).getOccurrenceCount();
        }
        return this.occurrenceCountCoordinates;
    }

    public int getOccurrenceCountAny() {
        if (this.occurrenceCountAny < 0) {
            this.occurrenceCountAny = this.newFacetGeospatialKosher(new boolean[]{true, true, true}, false).getOccurrenceCount();
        }
        return this.occurrenceCountAny;
    }

    String paramQueryFields(List<QueryField> fields) {
        StringBuilder sb = new StringBuilder();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fields.get(i).getName());
            }
        }
        return sb.length() > 0 ? "&fl=" + sb.toString() : "";
    }

    public final String getQ() {
        if (this.paramId != null) {
            return "qid:" + this.paramId;
        }
        return this.getFullQ(true);
    }

    private JSONObject getQidDetails(String qidTerm) {
        HttpClient client = new HttpClient();
        String url = this.biocacheServer + "/webportal/params/details/" + qidTerm.replace("qid:", "");
        GetMethod get = new GetMethod(url);
        try {
            int result = client.executeMethod((HttpMethod)get);
            String response = get.getResponseBodyAsString();
            if (result == 200) {
                JSONParser jp = new JSONParser();
                JSONObject jo = (JSONObject)jp.parse(response);
                return jo;
            }
            LOGGER.debug((Object)("error with url:" + url + " getting qid details for " + qidTerm + " > response_code:" + result + " response:" + response));
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting biocache param details from " + url), (Throwable)e);
        }
        return null;
    }

    public final String getFullQ(boolean encode) {
        StringBuilder sb = new StringBuilder();
        if (this.wkt != null && "POLYGON EMPTY".equals(this.wkt)) {
            this.wkt = null;
        }
        int queryTerms = 0;
        if (this.lsids != null) {
            for (String s : this.lsids.split(",")) {
                if (queryTerms > 0) {
                    sb.append(" OR ");
                } else {
                    sb.append("(");
                }
                sb.append("lsid:").append(s);
                ++queryTerms;
            }
        }
        if (this.rawNames != null && this.rawNames.length > 0) {
            for (String rawName : this.rawNames) {
                if (queryTerms > 0) {
                    sb.append(" OR ");
                } else {
                    sb.append("(");
                }
                sb.append("raw_name:\"").append(rawName).append("\"");
                ++queryTerms;
            }
        }
        if (queryTerms > 0) {
            sb.append(")");
        } else if ((this.facets == null || this.facets.isEmpty()) && "".length() == 0 && this.extraParams == null) {
            sb.append("*:*");
            ++queryTerms;
        }
        if (encode) {
            try {
                StringBuilder sb2 = new StringBuilder();
                sb2.append(URLEncoder.encode(sb.toString(), "UTF-8"));
                sb = sb2;
            }
            catch (Exception e) {
                LOGGER.error((Object)("error encoding: " + sb.toString()), (Throwable)e);
            }
        }
        if (this.facets != null && !this.facets.isEmpty()) {
            for (int i = 0; i < this.facets.size(); ++i) {
                String t;
                String f;
                String facet;
                int p;
                if (queryTerms > 0) {
                    sb.append("&fq=");
                }
                if ((p = (facet = ((Facet)this.facets.get(i)).toString()).indexOf(58)) > 0 && !(f = facet.substring(0, p)).equals(t = BiocacheQuery.translateFieldForSolr((String)f))) {
                    facet = t + facet.substring(p);
                }
                if (facet.contains(" OR ") && !facet.startsWith("-")) {
                    facet = "(" + facet + ")";
                }
                if (encode) {
                    try {
                        sb.append(URLEncoder.encode(facet, "UTF-8"));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("error encoding: " + facet), (Throwable)e);
                    }
                } else {
                    sb.append(facet);
                }
                ++queryTerms;
            }
        }
        if ("".length() > 0) {
            if (queryTerms > 0) {
                sb.append("&fq=");
            }
            ++queryTerms;
            if (encode) {
                try {
                    sb.append(URLEncoder.encode("", "UTF-8"));
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error encoding: ", (Throwable)e);
                }
            } else {
                sb.append("");
            }
        }
        if (this.extraParams != null) {
            if (queryTerms > 0) {
                sb.append("&fq=");
            }
            if (encode) {
                try {
                    String[] split = this.extraParams.split("&");
                    for (int i = 0; i < split.length; ++i) {
                        int e;
                        String key = "";
                        String value = split[i];
                        if (i > 0 && (e = split[i].indexOf("=")) > 0) {
                            key = split[i].substring(0, e);
                            value = split[i].substring(e + 1);
                        }
                        sb.append(key).append(URLEncoder.encode(value, "UTF-8"));
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)("error encoding: " + this.extraParams), (Throwable)e);
                }
            } else {
                sb.append(this.extraParams);
            }
        }
        if (this.wkt != null) {
            sb.append("&wkt=").append(this.wkt.replace(" ", ":"));
        }
        try {
            return sb.toString();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error returning a string", (Throwable)e);
            return "";
        }
    }

    final void makeParamId() {
        this.paramId = null;
        if (!this.forMapping && this.getFullQ(true).length() < CommonData.getMaxQLength()) {
            return;
        }
        this.wkt = Util.reduceWKT((String)this.wkt).getReducedWKT();
        HttpClient client = new HttpClient();
        String url = this.biocacheServer + "/webportal/params?" + this.getQc() + "&facet=false";
        PostMethod post = new PostMethod(url);
        try {
            String[] qs = BiocacheQuery.splitOnParams((String)this.getFullQ(false));
            for (int i = 0; i < qs.length; ++i) {
                String q = qs[i];
                int p = q.indexOf(61);
                if (p < 0) {
                    post.addParameter("q", q.substring(p + 1));
                    LOGGER.debug((Object)("param: q : " + q.substring(p + 1)));
                    continue;
                }
                post.addParameter(q.substring(0, p), q.substring(p + 1));
                LOGGER.debug((Object)("param: " + q.substring(0, p) + " : " + q.substring(p + 1)));
            }
            post.addParameter("bbox", this.forMapping ? "true" : "false");
            int result = client.executeMethod((HttpMethod)post);
            String response = post.getResponseBodyAsString();
            if (result == 200) {
                this.paramId = response;
                LOGGER.debug((Object)(url + " > " + this.paramId));
            } else {
                LOGGER.debug((Object)("error with url:" + url + " posting q: " + this.getQ() + " > response_code:" + result + " response:" + response));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting biocache param id from: " + url + " for " + this.getQ()), (Throwable)e);
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        this.name = this.lsids == null ? "All species" : (this.lsids.split(",").length == 1 ? BiocacheQuery.getScientificNameRank((String)this.lsids).split(",")[0] : "Selected species");
        return this.name;
    }

    public String getRank() {
        if (this.rank != null) {
            return this.rank;
        }
        if (this.lsids != null && this.lsids.split(",").length == 1) {
            this.rank = BiocacheQuery.getScientificNameRank((String)this.lsids).split(",")[1];
            if ("scientific name".equalsIgnoreCase(this.rank) || "scientific".equalsIgnoreCase(this.rank)) {
                this.rank = "taxon";
            }
        } else {
            this.rank = "scientific name";
        }
        return this.rank;
    }

    private String decompressGz(InputStream gzipped) throws IOException {
        String s = null;
        try {
            int size;
            GZIPInputStream gzip = new GZIPInputStream(gzipped);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(0x100000);
            byte[] buffer = new byte[0x100000];
            while ((size = gzip.read(buffer)) >= 0) {
                baos.write(buffer, 0, size);
            }
            s = new String(baos.toByteArray());
        }
        catch (Exception e) {
            LOGGER.error((Object)"error decompressing gz stream", (Throwable)e);
        }
        gzipped.close();
        return s;
    }

    private List<QueryField> retrieveCustomFacets() {
        ArrayList<QueryField> customFacets = new ArrayList<QueryField>();
        String jsonUri = this.biocacheServer + "/upload/dynamicFacets?q=" + this.getFullQ(true) + "&qc=" + this.getQc();
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(jsonUri);
            get.addRequestHeader("Content-type", "application/json");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONArray ja = (JSONArray)jp.parse(slist);
            for (Object arrayElement : ja) {
                JSONObject jsonObject = (JSONObject)arrayElement;
                String facetName = jsonObject.get((Object)"name").toString();
                String facetDisplayName = jsonObject.get((Object)"displayName").toString();
                if (facetDisplayName.contains("(Range)") && facetName.endsWith("_RNG")) continue;
                LOGGER.debug((Object)("Adding custom index : " + arrayElement));
                customFacets.add(new QueryField(facetName, facetDisplayName, QueryField.GroupType.CUSTOM, QueryField.FieldType.STRING));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error loading custom facets for: " + jsonUri), (Throwable)e);
        }
        return customFacets;
    }

    private List<String> retrieveCustomFields() {
        ArrayList<String> customFields = new ArrayList<String>();
        String jsonUri = this.biocacheServer + "/upload/dynamicFacets?q=" + this.getFullQ(true) + "&qc=" + this.getQc();
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(jsonUri);
            get.addRequestHeader("Content-type", "application/json");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONArray ja = (JSONArray)jp.parse(slist);
            for (Object arrayElement : ja) {
                JSONObject jsonObject = (JSONObject)arrayElement;
                String facetName = jsonObject.get((Object)"name").toString();
                if (facetName.endsWith("_RNG")) continue;
                customFields.add(facetName);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error loading custom facets for: " + jsonUri), (Throwable)e);
        }
        return customFields;
    }

    public List<QueryField> getFacetFieldList() {
        if (this.facetFieldList == null) {
            ArrayList fields = new ArrayList();
            fields.addAll(this.retrieveCustomFacets());
            fields.addAll(FacetCacheImpl.getFacetQueryFieldList());
            for (int i = 0; i < fields.size(); ++i) {
                ((QueryField)fields.get(i)).setStored(true);
            }
            this.facetFieldList = fields;
        }
        return this.facetFieldList;
    }

    public String getSpeciesIdFieldName() {
        return "taxon_concept_lsid";
    }

    public String getRecordIdFieldName() {
        return "id";
    }

    public String getRecordLongitudeFieldName() {
        return "longitude";
    }

    public String getRecordLatitudeFieldName() {
        return "latitude";
    }

    public String getRecordIdFieldDisplayName() {
        return "id";
    }

    public String getRecordLongitudeFieldDisplayName() {
        return "longitude";
    }

    public String getRecordLatitudeFieldDisplayName() {
        return "latitude";
    }

    public LegendObject getLegend(String colourmode) {
        if ("-1".equals(colourmode) || "grid".equals(colourmode)) {
            return null;
        }
        LegendObject lo = (LegendObject)this.legends.get(colourmode);
        if (lo != null && lo.getColourMode() != null && !lo.getColourMode().equals(colourmode)) {
            LOGGER.debug((Object)("lo not empty and lo=" + lo));
            lo = (LegendObject)this.legends.get(lo.getColourMode());
        }
        if (lo == null && this.getOccurrenceCount() > 0) {
            HttpClient client = new HttpClient();
            String facetToColourBy = "occurrence_year_decade".equals(colourmode) ? "occurrence_year" : BiocacheQuery.translateFieldForSolr((String)colourmode);
            try {
                String url = this.biocacheServer + "/webportal/legend?" + "pageSize=1000000" + "&q=" + this.getQ() + "&cm=" + URLEncoder.encode(facetToColourBy, "UTF-8") + this.getQc();
                LOGGER.debug((Object)url);
                GetMethod get = new GetMethod(url);
                get.addRequestHeader("Accept", "application/json");
                client.executeMethod((HttpMethod)get);
                String s = get.getResponseBodyAsString();
                String t = BiocacheQuery.translateFieldForSolr((String)colourmode);
                if (!colourmode.equals(t)) {
                    s = s.replaceFirst(t, colourmode);
                }
                lo = new BiocacheLegendObject(colourmode, s);
                if (!colourmode.contains(",") && ("uncertainty".equals(colourmode) || "decade".equals(colourmode) || "occurrence_year".equals(colourmode) || "coordinate_uncertainty".equals(colourmode))) {
                    Legend l = (lo = ((BiocacheLegendObject)lo).getAsIntegerLegend()).getNumericLegend();
                    if (l == null || l.getCutoffFloats() == null) {
                        return null;
                    }
                    float[] cutpoints = l.getCutoffFloats();
                    float[] cutpointmins = l.getCutoffMinFloats();
                    StringBuilder sb = new StringBuilder();
                    String newFacet = "decade".equals(colourmode) ? "occurrence_year" : colourmode;
                    sb.append(newFacet);
                    for (int i = 0; i < cutpoints.length; ++i) {
                        if (i != cutpoints.length - 1 && cutpoints[i] == cutpoints[i + 1]) continue;
                        if (i > 0) {
                            sb.append(",").append(cutpointmins[i]);
                            if ("occurrence_year".equals(colourmode) || "decade".equals(colourmode)) {
                                sb.append("-01-01T00:00:00Z");
                            }
                        } else {
                            sb.append(",*");
                        }
                        sb.append(",").append(cutpoints[i]);
                        if (!"occurrence_year".equals(colourmode) && !"decade".equals(colourmode)) continue;
                        sb.append("-12-31T00:00:00Z");
                    }
                    String newColourMode = sb.toString();
                    if ("occurrence_year".equals(colourmode) || "decade".equals(colourmode)) {
                        newColourMode = newColourMode.replace(".0", "");
                    }
                    lo.setColourMode(newColourMode);
                    this.legends.put(colourmode, lo);
                    LegendObject newlo = this.getLegend(newColourMode);
                    newlo.setColourMode(newColourMode);
                    newlo.setNumericLegend(lo.getNumericLegend());
                    this.legends.put(newColourMode, newlo);
                    lo = newlo;
                } else if ("month".equals(colourmode)) {
                    String newColourMode = "month,00,00,01,01,02,02,03,03,04,04,05,05,06,06,07,07,08,08,09,09,10,10,11,11,12,12";
                    lo.setColourMode(newColourMode);
                    this.legends.put(colourmode, lo);
                    LegendObject newlo = this.getLegend(newColourMode);
                    newlo.setColourMode(newColourMode);
                    newlo.setNumericLegend(lo.getNumericLegend());
                    this.legends.put(newColourMode, newlo);
                    lo = newlo;
                } else if (!colourmode.contains(",") && ("occurrence_year_decade".equals(colourmode) || "decade".equals(colourmode))) {
                    int i;
                    TreeSet<Integer> decades = new TreeSet<Integer>();
                    Iterator i$ = ((BiocacheLegendObject)lo).categoriesNumeric.keySet().iterator();
                    while (i$.hasNext()) {
                        double d = ((Float)i$.next()).floatValue();
                        decades.add((int)(d / 10.0));
                    }
                    ArrayList d = new ArrayList(decades);
                    StringBuilder sb = new StringBuilder();
                    sb.append("occurrence_year");
                    int n = i = !d.isEmpty() && (Integer)d.get(0) > 0 ? 0 : 1;
                    while (i < d.size()) {
                        if (i > 0) {
                            sb.append(",").append(d.get(i));
                            sb.append("0-01-01T00:00:00Z");
                        } else {
                            sb.append(",*");
                        }
                        sb.append(",").append(d.get(i));
                        sb.append("9-12-31T00:00:00Z");
                        ++i;
                    }
                    String newColourMode = sb.toString();
                    lo.setColourMode(newColourMode);
                    this.legends.put(colourmode, lo);
                    LegendObject newlo = this.getLegend(newColourMode);
                    newlo.setColourMode(newColourMode);
                    newlo.setNumericLegend(lo.getNumericLegend());
                    this.legends.put(newColourMode, newlo);
                    lo = newlo;
                } else {
                    this.legends.put(colourmode, lo);
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("error getting legend for : " + colourmode), (Throwable)e);
            }
        }
        return lo;
    }

    public Query newFacets(List<Facet> facets, boolean forMapping) {
        if (!(facets != null && !facets.isEmpty() || !this.forMapping && forMapping)) {
            return this;
        }
        ArrayList<Facet> newFacets = new ArrayList<Facet>();
        if (this.facets != null) {
            newFacets.addAll(this.facets);
        }
        newFacets.addAll(facets);
        return new BiocacheQuery(this.lsids, this.rawNames, this.wkt, this.extraParams, newFacets, forMapping, null, this.biocacheServer, this.biocacheWebServer, this.supportsDynamicFacets);
    }

    public String getUrl() {
        return this.biocacheServer + "/webportal/wms/reflect?";
    }

    public List<Double> getBBox() {
        if (this.bbox != null) {
            return this.bbox;
        }
        this.bbox = new ArrayList();
        HttpClient client = new HttpClient();
        String url = this.biocacheServer + "/webportal/bbox?" + "pageSize=1000000" + "&q=" + this.getQ() + this.getQc();
        GetMethod get = new GetMethod(url);
        try {
            client.executeMethod((HttpMethod)get);
            String[] s = get.getResponseBodyAsString().split(",");
            for (int i = 0; i < 4; ++i) {
                this.bbox.add(Double.parseDouble(s[i]));
            }
        }
        catch (Exception e) {
            this.bbox = Util.getBoundingBox((String)"POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))");
            LOGGER.error((Object)("error getting species layer bounding box from biocache:" + url), (Throwable)e);
        }
        return this.bbox;
    }

    public String getMetadataHtml() {
        String dataProviders;
        String spname = this.getSolrName();
        String lastClass = "md_grey-bg";
        StringBuilder html = new StringBuilder();
        html.append("Species layer\n");
        html.append("<table class='md_table'>");
        html.append("<tr class='").append(lastClass).append("'><td class='md_th'>Species name: </td><td class='md_spacer'/><td class='md_value'>").append(spname).append("</td></tr>");
        lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
        boolean[] gk = this.getGeospatialKosher();
        if (gk == null) {
            html.append("<tr class='md_grey-bg'><td class='md_th'>Number of species: </td><td class='md_spacer'/><td class='md_value'>").append(this.getSpeciesCount()).append("</td></tr>");
            lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            html.append("<tr class='").append(lastClass).append("'><td class='md_th'>Number of occurrences: </td><td class='md_spacer'/><td class='md_value'>").append(this.getOccurrenceCount()).append("</td></tr>");
            lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
        } else {
            if (this.wkt != null && !this.wkt.equals("POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))")) {
                html.append("<tr class='md_grey-bg'><td class='md_th'>Number of species: </td><td class='md_spacer'/><td class='md_value'>").append(this.getSpeciesCountKosher()).append(" without a flagged spatial issue<br>").append(this.getSpeciesCountCoordinates()).append(" with any coordinates</td></tr>");
                lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
                html.append("<tr class='").append(lastClass).append("'><td class='md_th'>Number of occurrences: </td><td class='md_spacer'/><td class='md_value'>").append(this.getOccurrenceCountKosher()).append(" without a flagged spatial issue<br>").append(this.getOccurrenceCountCoordinates()).append(" with any coordinates</td></tr>");
                lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
                html.append("<tr class='").append(lastClass).append("'><td class='md_th'>Number of endemic species: </td><td class='md_spacer'/><td class='md_value'>").append(this.getEndemicSpeciesCount()).append("</td></tr>");
                lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            } else {
                html.append("<tr class='md_grey-bg'><td class='md_th'>Number of species: </td><td class='md_spacer'/><td class='md_value'>").append(this.getSpeciesCountKosher()).append(" without a flagged spatial issue<br>").append(this.getSpeciesCountCoordinates()).append(" with any coordinates<br>").append(this.getSpeciesCountAny()).append(" total including records without coordinates</td></tr>");
                lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
                html.append("<tr class='").append(lastClass).append("'><td class='md_th'>Number of occurrences: </td><td class='md_spacer'/><td class='md_value'>").append(this.getOccurrenceCountKosher()).append(" without a flagged spatial issue<br>").append(this.getOccurrenceCountCoordinates()).append(" with any coordinates<br>").append(this.getOccurrenceCountAny()).append(" total including records without coordinates</td></tr>");
                lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            }
            String areamsg = "";
            if (this.wkt != null && !this.wkt.equals("POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))")) {
                areamsg = " in the area selected";
            }
            String msg = null;
            if (gk[0] && gk[1]) {
                msg = "Map layer displays records with and without geospatial issues " + areamsg;
            } else if (gk[0]) {
                msg = "Map layer only displays records without geospatial issues " + areamsg;
            } else if (gk[1]) {
                msg = "Map layer only displays records with geospatial issues " + areamsg;
            }
            if (msg != null) {
                html.append("<tr class='").append(lastClass).append("'><td class='md_th'></td><td class='md_spacer'/><td class='md_value'>").append(msg).append("</td></tr>");
                String string = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            }
        }
        if (this.lsids != null) {
            html.append("<tr class='").append(lastClass).append("'><td class='md_th'>Classification: </td><td class='md_spacer'/><td class='md_value'>");
            for (String s : this.lsids.split(",")) {
                Map classification = this.getSpeciesClassification(s);
                boolean first = true;
                for (Map.Entry o : classification.entrySet()) {
                    if (!first) {
                        html.append(" > ");
                    } else {
                        first = false;
                    }
                    html.append("<a href='").append(CommonData.getBieServer()).append("/species/").append((String)o.getValue()).append("' target='_blank'>").append((String)o.getKey()).append("</a> ");
                }
                html.append("<br />");
                html.append("More information for <a href='").append(CommonData.getBieServer()).append("/species/").append(s).append("' target='_blank'>").append(BiocacheQuery.getScientificNameRank((String)s).split(",")[0]).append("</a>");
                html.append("<br />");
                html.append("<br />");
            }
            html.append("</td></tr>");
            String string = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
        }
        if ((dataProviders = StringUtils.trimToNull((String)this.getDataProviders())) != null) {
            html.append("<tr class='").append(lastClass).append("'><td class='md_th'>Data providers: </td><td class='md_spacer'/><td class='md_value'>").append(this.getDataProviders()).append("</td></tr>");
        }
        String string = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
        if (this.lsids != null && this.lsids.length() > 0) {
            html.append("<tr class='").append(lastClass).append("'><td class='md_th'>List of LSIDs: </td><td class='md_spacer'/><td class='md_value'>").append(this.lsids).append("</td></tr>");
            lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            String[] wms = CommonData.getSpeciesDistributionWMS((String)this.lsids);
            if (wms.length > 0) {
                html.append("<tr class='").append(lastClass).append("'><td class='md_th'>Expert distributions</td><td class='md_spacer'/><td class='md_value'><a href='#' onClick='openDistributions(\"").append(this.lsids).append("\")'>").append(wms.length).append("</a></td><td class='md_spacer'/><td class='md_value'></td></tr>");
                String string2 = lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            }
            if ((wms = CommonData.getSpeciesChecklistWMS((String)this.lsids)).length > 0) {
                html.append("<tr class='").append(lastClass).append("'><td class='md_th'>Checklist species</td><td class='md_spacer'/><td class='md_value'><a href='#' onClick='openChecklists(\"").append(this.lsids).append("\")'>").append(wms.length).append("</a></td><td class='md_spacer'/><td class='md_value'></td></tr>");
                lastClass = lastClass.length() == 0 ? "md_grey-bg" : "";
            }
        }
        html.append("<tr class='").append(lastClass).append("'><td class='md_th' colspan=3><a href='").append(this.biocacheWebServer).append("/occurrences/search?q=").append(this.getQ()).append("' target='_blank'>Table view of these records</a></td><td class='md_spacer'/><td class='md_value'></td></tr>");
        html.append("</table>");
        return html.toString();
    }

    private Map<String, String> getSpeciesClassification(String lsid) {
        String[] classificationList = new String[]{"kingdom", "phylum", "class", "order", "family", "genus", "species", "subspecies"};
        LinkedHashMap<String, String> classification = new LinkedHashMap<String, String>();
        String snUrl = CommonData.getBieServer() + "/species/" + lsid + ".json";
        LOGGER.debug((Object)snUrl);
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(snUrl);
            get.addRequestHeader("Content-type", "application/json");
            client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            JSONParser jp = new JSONParser();
            JSONObject jo = (JSONObject)jp.parse(slist);
            String r = ((JSONObject)jo.get((Object)"taxonConcept")).get((Object)"rankString").toString();
            JSONObject joOcc = (JSONObject)jo.get((Object)"classification");
            for (String c : classificationList) {
                if (c.equals(r)) break;
                if (!joOcc.containsKey((Object)c.replace("ss", "zz"))) continue;
                classification.put(joOcc.get((Object)c.replace("ss", "zz")).toString(), joOcc.get((Object)(c.replace("ss", "zz") + "Guid")).toString());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting scientific name at: " + snUrl), (Throwable)e);
        }
        return classification;
    }

    public String getDownloadUrl(String[] extraFields) {
        ArrayList fieldsAlreadyIncluded = new ArrayList();
        String[] defaultFields = this.getDefaultDownloadFields();
        if (defaultFields.length > 0) {
            Collections.addAll(fieldsAlreadyIncluded, defaultFields);
        }
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("&fields=").append(URLEncoder.encode(CommonData.getSettings().getProperty("biocache_download_fields"), "UTF-8"));
            List customFields = this.retrieveCustomFields();
            for (int i = 0; i < customFields.size(); ++i) {
                sb.append(",").append((String)customFields.get(i));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"webportal-config.properties biocache_download_fields error while encoding to UTF-8", (Throwable)e);
        }
        sb.append("&extra=").append(CommonData.getExtraDownloadFields());
        if (extraFields != null && extraFields.length > 0) {
            for (int i = 0; i < extraFields.length; ++i) {
                if (fieldsAlreadyIncluded.contains(extraFields[i]) || BiocacheQuery.translateFieldForSolr((String)extraFields[i]) != null && !extraFields[i].equals(BiocacheQuery.translateFieldForSolr((String)extraFields[i])) || sb.length() <= 0) continue;
                sb.append(",").append(extraFields[i]);
            }
        }
        return this.biocacheServer + "/occurrences/download?" + "q=" + this.getQ() + sb.toString() + this.getQc();
    }

    private String getDataProviders() {
        HttpClient client = new HttpClient();
        String url = this.biocacheServer + "/webportal/dataProviders?" + "pageSize=1000000" + "&q=" + this.getQ() + this.getQc();
        LOGGER.debug((Object)url);
        GetMethod get = new GetMethod(url);
        try {
            int result = client.executeMethod((HttpMethod)get);
            String response = get.getResponseBodyAsString();
            if (result == 200) {
                StringBuilder html = new StringBuilder();
                JSONParser jp = new JSONParser();
                JSONArray ja = (JSONArray)jp.parse(response);
                for (int i = 0; i < ja.size(); ++i) {
                    JSONObject jo = (JSONObject)ja.get(i);
                    html.append("<a href='http://collections.ala.org.au/public/showDataProvider/").append(jo.get((Object)"id").toString()).append("' target='_blank'>").append(jo.get((Object)"name")).append("</a>: ").append(jo.get((Object)"count")).append(" records <br />");
                }
                return html.toString();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting query data providers for html:" + url), (Throwable)e);
        }
        return null;
    }

    public String getLsids() {
        return this.lsids;
    }

    public List<String> getLsidFromExtraParams() {
        ArrayList<String> extraLsids = new ArrayList<String>();
        if (this.extraParams != null) {
            Matcher matcher = this.lsidPattern.matcher(this.extraParams);
            while (matcher.find()) {
                extraLsids.add(matcher.group().replaceFirst("lsid:", "").replaceAll("\"", ""));
            }
        }
        return extraLsids;
    }

    public String getSolrName() {
        if (this.solrName != null) {
            return this.solrName;
        }
        HttpClient client = new HttpClient();
        String url = this.biocacheServer + "/occurrences/search?" + "&q=" + this.getQ() + this.getQc() + "&pageSize=0&facet=false";
        LOGGER.debug((Object)("Retrieving query metadata: " + url));
        GetMethod get = new GetMethod(url);
        try {
            JSONParser jp;
            JSONObject jo;
            int result = client.executeMethod((HttpMethod)get);
            String response = get.getResponseBodyAsString();
            if (result == 200 && (jo = (JSONObject)(jp = new JSONParser()).parse(response)).containsKey((Object)"queryTitle")) {
                String title = jo.get((Object)"queryTitle").toString();
                title = title.replace(" AND <span>null</span>", "");
                title = title.replace(" AND null", "");
                int p1 = title.indexOf("<span");
                while (p1 >= 0) {
                    int p2 = title.indexOf(62, p1);
                    int p3 = title.indexOf("</span>", p2);
                    title = title.substring(0, p1) + title.substring(p2 + 1, p3) + (p3 + 7 < title.length() ? title.substring(p3 + 7, title.length()) : "");
                    p1 = title.indexOf("<span");
                }
                this.solrName = title;
                LOGGER.debug((Object)("solrName12=" + this.solrName));
                return this.solrName;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting solr name for a query: " + url), (Throwable)e);
        }
        return null;
    }

    public final String getQc() {
        return this.qc;
    }

    public void setQc(String qc) {
        this.qc = qc;
    }

    public String getBS() {
        return this.biocacheServer;
    }

    public String[] getDefaultDownloadFields() {
        String s = CommonData.getSettings().getProperty("default_biocache_download_layer_fields");
        if (s != null && s.length() > 0) {
            return s.split(",");
        }
        return new String[0];
    }

    public String getWS() {
        return this.biocacheWebServer;
    }

    public String getRecordFieldDisplayName(String colourMode) {
        return colourMode;
    }

    public void flagRecord(String id, boolean set) {
        if (set) {
            this.flaggedRecords.add(id);
        } else {
            this.flaggedRecords.remove(id);
        }
    }

    public int flagRecordCount() {
        return this.flaggedRecords.size();
    }

    public String getFlaggedRecords() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.flaggedRecords) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public Query newFlaggedRecords(boolean include) {
        if (this.flagRecordCount() == 0) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        if (include) {
            for (String s : this.flaggedRecords) {
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("id:").append(s);
            }
        } else {
            for (String s : this.flaggedRecords) {
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append("-id:").append(s);
            }
        }
        ArrayList<Facet> newFacets = new ArrayList<Facet>();
        if (this.facets != null) {
            newFacets.addAll(this.facets);
        }
        newFacets.add(Facet.parseFacet((String)sb.toString()));
        return new BiocacheQuery(this.lsids, this.rawNames, this.wkt, this.extraParams, newFacets, this.forMapping, null, this.biocacheServer, this.biocacheWebServer, this.supportsDynamicFacets);
    }
}

