/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.util;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.legend.Legend;
import au.org.ala.legend.LegendBuilder;
import au.org.ala.legend.LegendObject;
import au.org.ala.legend.QueryField;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BiocacheLegendObject
extends LegendObject {
    private static final Logger LOGGER = Logger.getLogger(BiocacheLegendObject.class);
    protected Map<Float, int[]> categoriesNumeric;
    private String csvLegend;
    private String colourMode;

    public BiocacheLegendObject(String colourMode, String legend) {
        super((Legend)null, null);
        this.colourMode = colourMode;
        this.categories = new HashMap();
        this.categoriesNumeric = new HashMap();
        if (legend != null && legend.startsWith("name,red,green,blue,count")) {
            this.loadFromCsv(legend);
        } else {
            this.loadFromJson(legend);
        }
    }

    private void loadFromJson(String legend) {
        boolean isDecade = this.colourMode.startsWith("occurrence_year_decade") || "decade".equals(this.colourMode);
        boolean isYear = this.colourMode.contains("occurrence_year") && !isDecade;
        int count = 0;
        int sum = 0;
        String colour = null;
        String line = null;
        StringBuilder sb = new StringBuilder();
        sb.append("name,red,green,blue,count");
        long start = System.currentTimeMillis();
        JSONParser jp = new JSONParser();
        JSONArray items = null;
        try {
            items = (JSONArray)jp.parse(legend);
        }
        catch (ParseException e) {
            LOGGER.error((Object)"failed to parse legend", (Throwable)e);
        }
        LOGGER.debug((Object)("*** time to parse legend to JSON was " + (System.currentTimeMillis() - start) + "ms"));
        this.categoryNameOrder = new String[items.size()];
        int i = 0;
        for (Object item : items) {
            String blue;
            JSONObject jo = (JSONObject)item;
            String name = jo.containsKey((Object)"name") ? jo.get((Object)"name").toString() : "";
            String ccount = jo.containsKey((Object)"count") ? jo.get((Object)"count").toString() : null;
            String red = jo.containsKey((Object)"red") ? jo.get((Object)"red").toString() : "";
            String green = jo.containsKey((Object)"green") ? jo.get((Object)"green").toString() : "";
            String string = blue = jo.containsKey((Object)"blue") ? jo.get((Object)"blue").toString() : "";
            if (isYear && name != null) {
                name = name.replace("-01-01T00:00:00Z", "");
                name = name.replace("-12-31T00:00:00Z", "");
            } else if (isDecade && name != null) {
                for (int j = 0; j <= 9; ++j) {
                    name = name.replace(j + "-01-01T00:00:00Z", "0");
                    name = name.replace(j + "-12-31T00:00:00Z", "0");
                }
            }
            if (ccount == null || Integer.parseInt(ccount) == 0) continue;
            int[] value = new int[]{new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue)).getRGB(), Integer.parseInt(ccount)};
            this.categories.put(name, value);
            this.categoryNameOrder[i] = name;
            double d = Double.NaN;
            try {
                d = Double.parseDouble(name);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.categoriesNumeric.put(Float.valueOf((float)d), value);
            sb.append("\n");
            colour = red + "," + green + "," + blue;
            line = "\"" + name.replace("\"", "\"\"").replace("\\", "\\\\") + "\"," + colour + "," + ccount;
            sb.append(line);
            ++i;
        }
        this.csvLegend = count > 0 ? sb.toString().replace(line, count + " more" + "," + colour + "," + sum) : sb.toString();
    }

    private void loadFromCsv(String legend) {
        List csv = null;
        try {
            CSVReader csvReader = new CSVReader((Reader)new StringReader(legend));
            csv = csvReader.readAll();
            csvReader.close();
        }
        catch (IOException ex) {
            LOGGER.error((Object)"error reading legend: ", (Throwable)ex);
        }
        boolean isDecade = this.colourMode.startsWith("occurrence_year_decade") || "decade".equals(this.colourMode);
        boolean isYear = this.colourMode.contains("occurrence_year") && !isDecade;
        int count = 0;
        int sum = 0;
        String colour = null;
        String line = null;
        StringBuilder sb = new StringBuilder();
        sb.append("name,red,green,blue,count");
        this.categoryNameOrder = new String[csv.size() - 1];
        for (int i = 1; i < csv.size(); ++i) {
            String[] p;
            String[] c = (String[])csv.get(i);
            String[] stringArray = p = i > 1 ? (String[])csv.get(i - 1) : null;
            if (isYear) {
                c[0] = c[0].replace("-01-01T00:00:00Z", "");
                c[0] = c[0].replace("-12-31T00:00:00Z", "");
            } else if (isDecade) {
                for (int j = 0; j <= 9; ++j) {
                    c[0] = c[0].replace(j + "-01-01T00:00:00Z", "0");
                    c[0] = c[0].replace(j + "-12-31T00:00:00Z", "0");
                }
            }
            int rc = Integer.parseInt(c[4]);
            if (rc == 0) continue;
            int[] value = new int[]{this.readColour(c[1], c[2], c[3]), rc};
            this.categories.put(c[0], value);
            this.categoryNameOrder[i - 1] = c[0];
            double d = Double.NaN;
            try {
                d = Double.parseDouble(c[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.categoriesNumeric.put(Float.valueOf((float)d), value);
            if (p != null && c.length > 4 && p.length > 4 && p[1].equals(c[1]) && p[2].equals(c[2]) && p[3].equals(c[3]) && !isDecade && !isYear) {
                if (count == 0) {
                    count = 1;
                    sum = Integer.parseInt(p[4]);
                }
                ++count;
                sum += Integer.parseInt(c[4]);
                continue;
            }
            sb.append("\n");
            colour = c[1] + "," + c[2] + "," + c[3];
            line = "\"" + c[0].replace("\"", "\"\"") + "\"," + colour + "," + c[4];
            sb.append(line);
        }
        this.csvLegend = count > 0 ? sb.toString().replace(line, count + " more" + "," + colour + "," + sum) : sb.toString();
    }

    public String getTable() {
        return this.csvLegend;
    }

    public int getColour(String value) {
        int[] data = (int[])this.categories.get(value);
        if (data != null) {
            return data[0];
        }
        return 0xFFFFFF;
    }

    public int getColour(float value) {
        int[] data = (int[])this.categoriesNumeric.get(Float.valueOf(value));
        if (data != null) {
            return data[0];
        }
        return 0xFFFFFF;
    }

    public float[] getMinMax() {
        if (this.getNumericLegend() != null) {
            return super.getMinMax();
        }
        float[] minmax = new float[2];
        boolean first = true;
        for (Float d : this.categoriesNumeric.keySet()) {
            if (Float.isNaN(d.floatValue())) continue;
            if (first || minmax[0] > d.floatValue()) {
                minmax[0] = d.floatValue();
            }
            if (first || minmax[1] < d.floatValue()) {
                minmax[1] = d.floatValue();
            }
            first = false;
        }
        if (!first) {
            return new float[0];
        }
        return minmax;
    }

    private int readColour(String red, String green, String blue) {
        return new Color(Integer.parseInt(red), Integer.parseInt(green), Integer.parseInt(blue)).getRGB();
    }

    public LegendObject getAsIntegerLegend() {
        if ("decade".equals(this.colourMode)) {
            double[] values = new double[this.categoriesNumeric.size()];
            int i = 0;
            Iterator i$ = this.categoriesNumeric.keySet().iterator();
            while (i$.hasNext()) {
                double d = ((Float)i$.next()).floatValue();
                values[i++] = d;
            }
            return LegendBuilder.legendForDecades((double[])values, (QueryField)new QueryField(this.colourMode, QueryField.FieldType.INT));
        }
        int size = 0;
        Iterator i$ = this.categoriesNumeric.keySet().iterator();
        while (i$.hasNext()) {
            float f = ((Float)i$.next()).floatValue();
            int[] v = (int[])this.categoriesNumeric.get(Float.valueOf(f));
            size += v[1];
        }
        double[] values = new double[size];
        int pos = 0;
        Iterator i$2 = this.categoriesNumeric.keySet().iterator();
        while (i$2.hasNext()) {
            float f = ((Float)i$2.next()).floatValue();
            int[] v = (int[])this.categoriesNumeric.get(Float.valueOf(f));
            for (int i = 0; i < v[1]; ++i) {
                values[pos] = f;
                ++pos;
            }
        }
        return LegendBuilder.legendFromDoubles((double[])values, (QueryField)new QueryField(this.colourMode, QueryField.FieldType.INT));
    }
}

