/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.sampling;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.spatial.util.CommonData;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipInputStream;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

/*
 * Exception performing whole class analysis ignored.
 */
public final class Sampling {
    private static final Logger LOGGER = Logger.getLogger(Sampling.class);

    private Sampling() {
    }

    public static List<String[]> sampling(List<String> facetIds, double[][] points) {
        try {
            String downloadUrl;
            int i;
            long start = System.currentTimeMillis();
            URL url = new URL(CommonData.getLayersServer() + "/intersect/batch");
            URLConnection c = url.openConnection();
            c.setDoOutput(true);
            OutputStreamWriter out = new OutputStreamWriter(c.getOutputStream());
            out.write("fids=");
            for (i = 0; i < facetIds.size(); ++i) {
                if (i > 0) {
                    out.write(",");
                }
                out.write(facetIds.get(i));
            }
            out.write("&points=");
            for (i = 0; i < points.length; ++i) {
                if (i > 0) {
                    out.write(",");
                }
                out.write(String.valueOf(points[i][1]));
                out.write(",");
                out.write(String.valueOf(points[i][0]));
            }
            out.write("&pw=");
            out.write(CommonData.getSettings().getProperty("batch.sampling.pw"));
            out.close();
            JSONParser jp = new JSONParser();
            JSONObject jo = (JSONObject)jp.parse(IOUtils.toString((InputStream)c.getInputStream()));
            String statusUrl = jo.get((Object)"statusUrl").toString();
            int count = 0;
            while ((downloadUrl = Sampling.getDownloadUrl((String)statusUrl)) != null && downloadUrl.isEmpty() && downloadUrl != null) {
                ++count;
            }
            if (downloadUrl != null) {
                return Sampling.getDownloadData((String)downloadUrl, (int)points.length);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error with sampling", (Throwable)e);
        }
        return new ArrayList<String[]>();
    }

    static String getDownloadUrl(String statusUrl) {
        Object downloadUrl = null;
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(statusUrl);
            get.addRequestHeader("Content-type", "application/json");
            client.executeMethod((HttpMethod)get);
            JSONParser jp = new JSONParser();
            JSONObject jo = (JSONObject)jp.parse(get.getResponseBodyAsString());
            downloadUrl = "finished".equals(jo.get((Object)"status")) ? jo.get((Object)"downloadUrl").toString() : ("cancelled".equals(jo.get((Object)"status")) || "error".equals(jo.get((Object)"status")) ? null : "");
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting response from : " + statusUrl), (Throwable)e);
        }
        return downloadUrl;
    }

    static List<String[]> getDownloadData(String downloadUrl, int numberOfPoints) {
        ArrayList<String[]> output = new ArrayList<String[]>();
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(downloadUrl);
            get.addRequestHeader("Content-type", "application/zip");
            client.executeMethod((HttpMethod)get);
            try {
                ZipInputStream zip = new ZipInputStream(get.getResponseBodyAsStream());
                zip.getNextEntry();
                CSVReader csv = new CSVReader((Reader)new InputStreamReader(zip));
                String[] line = csv.readNext();
                for (int i = 2; i < line.length; ++i) {
                    output.add(new String[numberOfPoints]);
                }
                for (int row = 0; (line = csv.readNext()) != null && row < numberOfPoints; ++row) {
                    for (int i = 2; i - 2 < output.size() && i < line.length; ++i) {
                        ((String[])output.get((int)(i - 2)))[row] = line[i];
                    }
                }
                zip.close();
            }
            catch (Exception e) {
                LOGGER.error((Object)("failed to read zipped stream from: " + downloadUrl), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error getting response from url: " + downloadUrl), (Throwable)e);
        }
        return output;
    }
}

