/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.logger;

import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.Util;
import java.net.URLEncoder;
import javax.servlet.http.HttpSession;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Sessions;

public class RemoteLogger {
    private static final Logger LOGGER = Logger.getLogger(RemoteLogger.class);
    private String loggerService = "";
    private String appid = "";

    private void init() {
        this.loggerService = CommonData.getSettings().getProperty("logging_url");
        this.appid = CommonData.getSettings().getProperty("app_id");
    }

    public void logMapSpecies(String name, String lsid, String area, String extra) {
        this.logMapSpecies(name, lsid, area, "Species", extra);
    }

    public void logMapSpecies(String name, String lsid, String area, String type, String extra) {
        this.sendToServer(type, name, lsid, area, "", extra, "mapped", "0", "");
    }

    public void logMapArea(String name, String type, String area) {
        this.logMapArea(name, type, area, "");
    }

    public void logMapArea(String name, String type, String area, String extra) {
        this.logMapArea(name, type, area, "", "");
    }

    public void logMapArea(String name, String type, String area, String layer, String extra) {
        this.sendToServer(type, name, "", area, layer, extra, "mapped", "0", "");
    }

    public void logMapAnalysis(String name, String type, String area, String species, String layers, String pid, String options, String status) {
        this.sendToServer(type, name, species, area, layers, options, status, "0", pid);
    }

    public void logMapAnalysisUpdateStatus(String pid, String status) {
        this.sendToServer(pid, status);
    }

    private int sendToServer(String type, String name, String lsid, String area, String layers, String extra, String status, String privacy, String pid) {
        try {
            String newArea;
            String newPid;
            String newLsid;
            if (StringUtils.isBlank((String)this.loggerService)) {
                this.init();
            }
            String sessionid = ((HttpSession)Sessions.getCurrent().getNativeSession()).getId();
            String userip = Executions.getCurrent().getHeader("x-forwarded-for");
            if (StringUtils.isBlank((String)userip) && StringUtils.isBlank((String)(userip = Executions.getCurrent().getRemoteAddr()))) {
                userip = "";
            }
            String useremail = Util.getUserEmail();
            LOGGER.debug((Object)("Sending log to: " + this.loggerService + "/log/action"));
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(this.loggerService + "/log/action");
            post.addRequestHeader("Accept", "application/json");
            String category2 = "";
            String[] types = type.split("-");
            String category1 = StringUtils.capitalize((String)types[0].trim());
            if (types.length > 1) {
                category2 = StringUtils.capitalize((String)types[1].trim());
            }
            if (StringUtils.isBlank((String)(newLsid = lsid))) {
                newLsid = "";
            }
            if (StringUtils.isBlank((String)(newPid = pid))) {
                newPid = "";
            }
            if (StringUtils.isBlank((String)(newArea = area))) {
                newArea = "";
            }
            post.addParameter("email", useremail);
            post.addParameter("appid", this.appid);
            post.addParameter("userip", userip);
            post.addParameter("sessionid", sessionid);
            post.addParameter("type", type);
            post.addParameter("category1", category1);
            post.addParameter("category2", category2);
            post.addParameter("name", name);
            post.addParameter("processid", newPid);
            post.addParameter("specieslsid", newLsid);
            post.addParameter("layers", layers);
            post.addParameter("status", status);
            post.addParameter("privacy", privacy);
            post.addParameter("area", newArea);
            post.addParameter("extra", extra);
            LOGGER.debug((Object)("logging " + type + " action for user session " + sessionid + " for user " + useremail + " from " + userip));
            return client.executeMethod((HttpMethod)post);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error sending logging information to server:", (Throwable)e);
            return -1;
        }
    }

    private int sendToServer(String pid, String status) {
        try {
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(this.loggerService + "/log/update/" + pid + "/" + status);
            get.addRequestHeader("Accept", "application/json");
            LOGGER.debug((Object)("logging status update on " + pid));
            return client.executeMethod((HttpMethod)get);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error sending logging information to server:", (Throwable)e);
            return -1;
        }
    }

    public JSONObject getLogCSV() {
        this.init();
        try {
            if (Util.isLoggedIn()) {
                String url = this.loggerService + "/app/types/tool.json?" + "email=" + URLEncoder.encode(Util.getUserEmail(), "UTF-8") + "&appid=" + URLEncoder.encode(this.appid, "UTF-8") + "&api_key=" + URLEncoder.encode(CommonData.getSettings().getProperty("api_key"), "UTF-8");
                HttpClient client = new HttpClient();
                GetMethod get = new GetMethod(url);
                get.addRequestHeader("Accept", "application/json");
                client.executeMethod((HttpMethod)get);
                LOGGER.debug((Object)("get: " + url + ", response: " + get.getResponseBodyAsString()));
                JSONParser jp = new JSONParser();
                return (JSONObject)jp.parse(get.getResponseBodyAsString());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error getting logging information from server:", (Throwable)e);
        }
        return null;
    }

    public JSONObject getLogItem(String logId) {
        this.init();
        try {
            if (Util.isLoggedIn()) {
                String url = this.loggerService + "/app/view/" + logId + ".json" + "?appid=" + URLEncoder.encode(this.appid, "UTF-8") + "&api_key=" + URLEncoder.encode(CommonData.getSettings().getProperty("api_key"), "UTF-8");
                HttpClient client = new HttpClient();
                GetMethod get = new GetMethod(url);
                get.addRequestHeader("Accept", "application/json");
                client.executeMethod((HttpMethod)get);
                LOGGER.debug((Object)("get: " + url + ", response: " + get.getResponseBodyAsString()));
                JSONParser jp = new JSONParser();
                return (JSONObject)jp.parse(get.getResponseBodyAsString());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error getting logging information from server:", (Throwable)e);
        }
        return null;
    }
}

