/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.spatial.composer.tool;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.legend.Facet;
import au.org.ala.spatial.StringConstants;
import au.org.ala.spatial.composer.input.PasteLayerListController;
import au.org.ala.spatial.composer.input.UploadLayerListController;
import au.org.ala.spatial.composer.input.UploadSpeciesController;
import au.org.ala.spatial.composer.input.UploadToSpeciesListController;
import au.org.ala.spatial.composer.layer.EnvLayersCombobox;
import au.org.ala.spatial.composer.layer.EnvironmentalList;
import au.org.ala.spatial.composer.layer.SelectedLayersCombobox;
import au.org.ala.spatial.composer.sandbox.SandboxPasteController;
import au.org.ala.spatial.composer.species.SpeciesAutoCompleteComponent;
import au.org.ala.spatial.composer.species.SpeciesListListbox;
import au.org.ala.spatial.dto.UserDataDTO;
import au.org.ala.spatial.logger.RemoteLogger;
import au.org.ala.spatial.util.BiocacheQuery;
import au.org.ala.spatial.util.CommonData;
import au.org.ala.spatial.util.LayerSelection;
import au.org.ala.spatial.util.Query;
import au.org.ala.spatial.util.UserDataQuery;
import au.org.ala.spatial.util.Util;
import au.org.emii.portal.composer.UtilityComposer;
import au.org.emii.portal.menu.MapLayer;
import au.org.emii.portal.menu.SelectedArea;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.ForwardEvent;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Div;
import org.zkoss.zul.Doublebox;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Fileupload;
import org.zkoss.zul.Html;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.Radio;
import org.zkoss.zul.Radiogroup;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Window;

public class ToolComposer
extends UtilityComposer {
    private static final Logger LOGGER = Logger.getLogger(ToolComposer.class);
    protected String selectedMethod = "";
    protected RemoteLogger remoteLogger;
    protected int currentStep = 1;
    protected int totalSteps = 5;
    protected String pid = "";
    protected Radiogroup rgArea;
    protected Radiogroup rgAreaHighlight;
    protected Radiogroup rgSpecies;
    protected Radiogroup rgSpeciesBk;
    protected Radio rSpeciesSearch;
    protected Radio rSpeciesSearchBk;
    protected Radio rAreaSelected;
    protected Button btnOk;
    protected Textbox tToolName;
    protected SpeciesAutoCompleteComponent searchSpeciesACComp;
    protected SpeciesAutoCompleteComponent bgSearchSpeciesACComp;
    protected EnvironmentalList lbListLayers;
    protected EnvLayersCombobox cbLayer1;
    protected EnvLayersCombobox cbLayer2;
    protected SelectedLayersCombobox selectedLayersCombobox;
    protected Doublebox dResolution;
    protected Checkbox chkEndemicSpecies;
    protected boolean isBackgroundProcess = true;
    protected boolean hasEstimated = false;
    private Map<String, Object> params;
    private Radio rMaxent;
    private Radio rAloc;
    private Radio rScatterplot;
    private Radio rGdm;
    private Radio rTabulation;
    private Radio rSpeciesAll;
    private Radio rSpeciesMapped;
    private Radio rSpeciesUploadLSID;
    private Radio rSpeciesUploadSpecies;
    private Radio rMultiple;
    private Radio rSpeciesNoneBk;
    private Radio rSpeciesAllBk;
    private Radio rSpeciesMappedBk;
    private Radio rSpeciesUploadLSIDBk;
    private Radio rSpeciesUploadSpeciesBk;
    private Radio rMultipleBk;
    private Radio rAreaWorld;
    private Radio rAreaCustom;
    private Radio rAreaWorldHighlight;
    private Radio rSpeciesLifeform;
    private Button btnCancel;
    private Button btnBack;
    private Button btnHelp;
    private Div divSpeciesSearch;
    private Div divSpeciesSearchBk;
    private String winTop = "300px";
    private String winLeft = "500px";
    private boolean hasCustomArea = false;
    private MapLayer prevTopArea = null;
    private Fileupload fileUpload;
    private Div tlinfo;
    private Textbox tLayerList;
    private Div dLayerSummary;
    private EnvLayersCombobox cbLayer;
    private EnvLayersCombobox cbLayerEnvironmentalOnly;
    private EnvLayersCombobox cbLayerMix;
    private Button bLayerListDownload1;
    private Button bLayerListDownload2;
    private Label lLayersSelected;
    private Label lendemicNote;
    private Button btnClearSelection;
    private Menupopup mpLayer2;
    private Menupopup mpLayer1;
    private Vbox vboxMultiple;
    private Vbox vboxMultipleBk;
    private SpeciesAutoCompleteComponent mSearchSpeciesACComp;
    private SpeciesAutoCompleteComponent mSearchSpeciesACCompBk;
    private Textbox tMultiple;
    private Textbox tMultipleBk;
    private Listbox lMultiple;
    private Listbox lMultipleBk;
    private boolean includeAnalysisLayers;
    private boolean includeContextualLayers = false;
    private boolean singleLayerDomain = true;
    private boolean fullList;
    private boolean includeAnalysisLayersForUploadQuery = false;
    private boolean includeAnalysisLayersForAnyQuery = false;
    private boolean mpLayersIncludeAnalysisLayers = false;
    private Checkbox chkGeoKosherTrue;
    private Checkbox chkGeoKosherFalse;
    private Checkbox chkGeoKosherTrueBk;
    private Checkbox chkGeoKosherFalseBk;
    private Radio rAreaCurrent;
    private Caption cTitle;
    private Div atsummary;
    private Vbox vboxArea;
    private Checkbox cAreaCurrent;
    private Radio rAreaCurrentHighlight;
    private Radio rAreaNoneHighlight;
    private Radio rAreaNone;
    private boolean[] defaultGeospatialKosher = new boolean[]{true, true, false};
    private Label lEstimateMessage;
    private Div notLoggedIn;
    private Div isLoggedIn;
    private Vbox vboxImportSL;
    private Vbox vboxImportSLBk;
    private SpeciesListListbox speciesListListbox;
    private SpeciesListListbox speciesListListboxBk;
    private Div divLifeform;
    private Combobox cbLifeform;

    public void afterCompose() {
        super.afterCompose();
        this.winTop = this.getTop();
        this.winLeft = this.getLeft();
        this.setupDefaultParams();
        HashMap tmp = new HashMap();
        Map m = Executions.getCurrent().getArg();
        if (m != null) {
            for (Map.Entry o : m.entrySet()) {
                if (!(o.getKey() instanceof String)) continue;
                tmp.put((String)o.getKey(), o.getValue());
            }
        }
        this.setParams(tmp);
        if (tmp.containsKey("geospatial_kosher")) {
            this.setGeospatialKosherCheckboxes((boolean[])tmp.get("geospatial_kosher"));
        }
        if (tmp.containsKey("chooseEndemic")) {
            this.setChooseEndemic(((Boolean)tmp.get("chooseEndemic")).booleanValue());
        } else if (this.chkEndemicSpecies != null) {
            this.updateEndemicCheckBox();
        }
        this.updateWindowTitle();
        this.fixFocus();
        if (this.lbListLayers != null) {
            this.lbListLayers.clearSelection();
            this.lbListLayers.updateDistances();
        }
        if (this.mpLayer1 != null && this.mpLayer2 != null) {
            for (MapLayer ml : this.getMapComposer().getGridLayers()) {
                this.addToMpLayers(ml, false);
            }
        }
        if (this.searchSpeciesACComp != null) {
            this.mSearchSpeciesACComp.addEventListener("onValueSelected", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.mSearchSpeciesACComp != null) {
            this.mSearchSpeciesACComp.getAutoComplete().setBiocacheOnly(true);
            this.mSearchSpeciesACComp.addEventListener("onValueSelected", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.mSearchSpeciesACCompBk != null) {
            this.mSearchSpeciesACCompBk.getAutoComplete().setBiocacheOnly(true);
            this.mSearchSpeciesACCompBk.addEventListener("onValueSelected", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.cbLayer != null) {
            this.cbLayer.setIncludeLayers("AllLayers");
            this.cbLayer.refresh("");
        }
        if (this.cbLayerEnvironmentalOnly != null) {
            this.cbLayerEnvironmentalOnly.setIncludeLayers("EnvironmentalLayers");
            this.cbLayerEnvironmentalOnly.refresh("");
        }
        if (this.cbLayer1 != null) {
            this.cbLayer1.setIncludeLayers("EnvironmentalLayers");
            this.cbLayer1.refresh("");
        }
        if (this.cbLayer2 != null) {
            this.cbLayer2.setIncludeLayers("EnvironmentalLayers");
            this.cbLayer2.refresh("");
        }
        if (this.cbLayerMix != null) {
            this.cbLayerMix.setIncludeLayers("MixLayers");
            this.cbLayerMix.refresh("");
        }
        this.updateDefaultGeospatialKosherValues();
        if (this.getFellowIfAny("splistbox") != null) {
            this.vboxImportSL = (Vbox)this.getFellow("splistbox").getFellow("vboxImportSL");
            this.speciesListListbox = (SpeciesListListbox)this.getFellow("splistbox").getFellow("speciesListListbox");
        }
        if (this.getFellowIfAny("splistboxbk") != null) {
            this.vboxImportSLBk = (Vbox)this.getFellow("splistboxbk").getFellow("vboxImportSL");
            this.speciesListListboxBk = (SpeciesListListbox)this.getFellow("splistboxbk").getFellow("speciesListListbox");
        }
        if (this.rSpeciesUploadLSID != null && this.speciesListListbox != null) {
            this.speciesListListbox.addEventListener("onSlCheckBoxChanged", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.rSpeciesUploadLSIDBk != null && this.speciesListListbox != null) {
            this.speciesListListbox.addEventListener("onSlCheckBoxChanged", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.vboxImportSL != null) {
            this.vboxImportSL.getFellow("btnSearchSpeciesListListbox").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
            this.vboxImportSL.getFellow("btnClearSearchSpeciesListListbox").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        if (this.vboxImportSLBk != null) {
            this.vboxImportSLBk.getFellow("btnSearchSpeciesListListbox").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
            this.vboxImportSL.getFellow("btnClearSearchSpeciesListListbox").addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.initLifeforms();
    }

    private void initLifeforms() {
        if (this.cbLifeform != null) {
            for (String lf : StringConstants.SPECIES_GROUPS) {
                Comboitem ci = new Comboitem(lf);
                ci.setParent((Component)this.cbLifeform);
            }
            this.cbLifeform.setSelectedIndex(0);
        }
    }

    public void onClick$btnSearchSpeciesListListbox(Event event) {
        try {
            ((SpeciesListListbox)event.getTarget().getParent().getParent().getFellowIfAny("speciesListListbox")).onClick$btnSearchSpeciesListListbox(event);
        }
        catch (Exception e) {
            LOGGER.error((Object)"toolcomposer is missing speciesListListbox for refreshing", (Throwable)e);
        }
    }

    public void onClick$btnClearSearchSpeciesListListbox(Event event) {
        try {
            ((SpeciesListListbox)event.getTarget().getParent().getParent().getFellowIfAny("speciesListListbox")).onClick$btnClearSearchSpeciesListListbox(event);
        }
        catch (Exception e) {
            LOGGER.error((Object)"toolcomposer is missing speciesListListbox for refreshing", (Throwable)e);
        }
    }

    void updateDefaultGeospatialKosherValues() {
        if (this.chkGeoKosherTrue != null) {
            this.defaultGeospatialKosher[0] = this.chkGeoKosherTrue.isChecked();
        }
        if (this.chkGeoKosherFalse != null) {
            this.defaultGeospatialKosher[1] = this.chkGeoKosherFalse.isChecked();
        }
    }

    void addToMpLayers(MapLayer ml, boolean analysis) {
        String name = null;
        String url = ml.getUri();
        if (analysis) {
            name = ml.getName();
        } else {
            int p1 = url.indexOf("ALA:") + 4;
            int p2 = url.indexOf(38, p1);
            if (p1 > 4) {
                if (p2 < 0) {
                    p2 = url.length();
                }
                name = url.substring(p1, p2);
            }
        }
        Menuitem mi = new Menuitem(ml.getDisplayName());
        mi.setValue(name);
        mi.addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        mi.setParent((Component)this.mpLayer1);
        mi = new Menuitem(ml.getDisplayName());
        mi.setValue(name);
        mi.addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        mi.setParent((Component)this.mpLayer2);
    }

    private void setupDefaultParams() {
        this.btnOk.setLabel("Next >");
    }

    public void updateWindowTitle() {
        if (this.cTitle != null) {
            this.cTitle.setLabel("Step " + this.currentStep + " of " + this.totalSteps + " - " + this.selectedMethod);
        }
    }

    public void updateName(String name) {
        if (this.tToolName != null) {
            this.tToolName.setValue(name);
        }
    }

    private void loadSummaryDetails() {
        if (this.atsummary != null) {
            String summary = "";
            summary = summary + "<strong>Analytical tool</strong>: " + this.selectedMethod;
            summary = summary + "<strong>Area</strong>: ";
            summary = summary + "<strong>Species</strong>: ";
            summary = summary + "<strong>Grids</strong>: ";
            summary = summary + "<strong>Additional options</strong>: ";
            this.atsummary.setContext(summary);
        }
    }

    public void setParams(Map<String, Object> params) {
        if (this.params == null) {
            this.params = new HashMap();
        }
        if (params != null) {
            this.params.putAll(params);
        }
    }

    public void loadSpeciesLayers() {
        this.loadSpeciesLayers(false);
    }

    public void loadSpeciesLayers(boolean biocacheOnly) {
        try {
            int i;
            List layers = this.getMapComposer().getSpeciesLayers();
            Radio selectedSpecies = null;
            String selectedSpeciesLayer = (String)this.params.get("speciesLayerName");
            int speciesLayersCount = 0;
            for (i = 0; i < layers.size(); ++i) {
                MapLayer lyr = (MapLayer)layers.get(i);
                if (biocacheOnly && lyr.getSpeciesQuery() != null && !(lyr.getSpeciesQuery() instanceof BiocacheQuery)) continue;
                if (lyr.getSubType() != 23) {
                    ++speciesLayersCount;
                }
                Radio rSp = new Radio(lyr.getDisplayName());
                rSp.setValue((Object)lyr.getName());
                rSp.setId(lyr.getName().replaceAll(" ", "") + "_" + i);
                this.rgSpecies.insertBefore((Component)rSp, (Component)this.rSpeciesMapped);
                if (!rSp.getValue().equals(selectedSpeciesLayer)) continue;
                selectedSpecies = rSp;
            }
            if (speciesLayersCount > 1) {
                this.rSpeciesMapped.setLabel("All " + speciesLayersCount + " species currently mapped (excludes coordinate uploads)");
            } else {
                this.rSpeciesMapped.setVisible(false);
            }
            if (selectedSpecies != null) {
                this.rgSpecies.setSelectedItem(selectedSpecies);
            } else if ("none".equals(selectedSpeciesLayer)) {
                this.rgSpecies.setSelectedItem(this.rSpeciesAll);
            } else if (!layers.isEmpty()) {
                this.rgSpecies.setSelectedItem(this.rgSpecies.getItemAtIndex(1));
            } else {
                for (i = 0; i < this.rgSpecies.getItemCount(); ++i) {
                    if (!this.rgSpecies.getItemAtIndex(i).isVisible() || this.rgSpecies.getItemAtIndex(i) == this.rSpeciesAll) continue;
                    this.rgSpecies.setSelectedItem(this.rgSpecies.getItemAtIndex(i));
                    break;
                }
            }
            this.updateGeospatialKosherCheckboxes();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load species layers", (Throwable)e);
        }
    }

    public void loadSpeciesLayersBk() {
        try {
            List layers = this.getMapComposer().getSpeciesLayers();
            int speciesLayersCount = 0;
            for (int i = 0; i < layers.size(); ++i) {
                MapLayer lyr = (MapLayer)layers.get(i);
                if (lyr.getSubType() != 23) {
                    ++speciesLayersCount;
                }
                Radio rSp = new Radio(lyr.getDisplayName());
                rSp.setValue((Object)lyr.getName());
                rSp.setId(lyr.getName().replaceAll(" ", "") + "__bk" + i);
                this.rgSpeciesBk.insertBefore((Component)rSp, (Component)this.rSpeciesMappedBk);
            }
            if (speciesLayersCount > 1) {
                this.rSpeciesMappedBk.setLabel("All " + speciesLayersCount + " species currently mapped (excludes coordinate uploads)");
            } else {
                this.rSpeciesMappedBk.setVisible(false);
            }
            this.updateGeospatialKosherCheckboxesBk();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load species layers", (Throwable)e);
        }
    }

    public void loadAreaLayers(boolean multiple) {
        if (!multiple) {
            this.loadAreaLayers(null);
        } else {
            this.loadAreaLayersCheckboxes(null);
        }
    }

    public void loadAreaLayers() {
        this.loadAreaLayers(null);
    }

    public void loadAreaLayers(String selectedAreaName) {
        try {
            int i;
            for (int i2 = this.rgArea.getItemCount() - 1; i2 >= 0; --i2) {
                String id = ((Radio)this.rgArea.getItems().get(i2)).getId();
                if (id == null || id.length() == 0) {
                    this.rgArea.removeItemAt(i2);
                    continue;
                }
                this.rgArea.getItemAtIndex(i2).setSelected(false);
            }
            String selectedLayerName = null;
            if (this.params != null && this.params.containsKey("polygonLayerName")) {
                selectedLayerName = (String)this.params.get("polygonLayerName");
            }
            Radio rSelectedLayer = null;
            List layers = this.getMapComposer().getPolygonLayers();
            for (i = 0; i < layers.size(); ++i) {
                MapLayer lyr = (MapLayer)layers.get(i);
                Radio rAr = new Radio(lyr.getDisplayName());
                rAr.setValue((Object)lyr.getName());
                rAr.setParent((Component)this.rgArea);
                if (this.rAreaCurrent != null) {
                    this.rgArea.insertBefore((Component)rAr, (Component)this.rAreaCurrent);
                } else {
                    this.rgArea.appendChild((Component)rAr);
                }
                if (!lyr.getName().equals(selectedLayerName)) continue;
                rSelectedLayer = rAr;
                this.rAreaSelected = rAr;
            }
            if (selectedAreaName != null && !selectedAreaName.isEmpty()) {
                for (i = 0; i < this.rgArea.getItemCount(); ++i) {
                    if (!this.rgArea.getItemAtIndex(i).isVisible() || !this.rgArea.getItemAtIndex(i).getLabel().equals(selectedAreaName)) continue;
                    this.rAreaSelected = this.rgArea.getItemAtIndex(i);
                    this.rgArea.setSelectedItem(this.rAreaSelected);
                    break;
                }
            } else if (rSelectedLayer != null) {
                this.rAreaSelected = rSelectedLayer;
                this.rgArea.setSelectedItem(this.rAreaSelected);
            } else if ("none".equals(selectedLayerName)) {
                this.rgArea.setSelectedItem(this.rAreaWorld);
                this.rAreaSelected = this.rAreaWorld;
                this.rgArea.setSelectedItem(this.rAreaSelected);
            } else {
                for (i = 0; i < this.rgArea.getItemCount(); ++i) {
                    if (!this.rgArea.getItemAtIndex(i).isVisible()) continue;
                    this.rAreaSelected = this.rgArea.getItemAtIndex(i);
                    this.rgArea.setSelectedItem(this.rAreaSelected);
                    break;
                }
            }
            Clients.evalJavaScript((String)("jq('#" + this.rAreaSelected.getUuid() + "-real').attr('checked', true);"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load active area layers", (Throwable)e);
        }
    }

    public void loadAreaLayersCheckboxes(String selectedAreaName) {
        try {
            List layers = this.getMapComposer().getPolygonLayers();
            for (int i = 0; i < layers.size(); ++i) {
                MapLayer lyr = (MapLayer)layers.get(i);
                boolean found = false;
                if (this.getFellow("vboxArea") != null) {
                    List checkboxes = this.getFellow("vboxArea").getChildren();
                    for (int j = 0; j < checkboxes.size(); ++j) {
                        if (!(checkboxes.get(j) instanceof Checkbox) || !((Checkbox)checkboxes.get(j)).getLabel().equals(lyr.getDisplayName())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                Checkbox rAr = new Checkbox(lyr.getDisplayName());
                rAr.setValue((Object)lyr.getName());
                if (lyr.getDisplayName().equals(selectedAreaName)) {
                    rAr.setChecked(true);
                }
                rAr.setParent((Component)this.vboxArea);
                this.vboxArea.insertBefore((Component)rAr, (Component)this.cAreaCurrent);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load active area layers", (Throwable)e);
        }
    }

    public void loadAreaHighlightLayers(String selectedAreaName) {
        try {
            int i;
            for (int i2 = this.rgAreaHighlight.getItemCount() - 1; i2 >= 0; --i2) {
                String id = ((Radio)this.rgAreaHighlight.getItems().get(i2)).getId();
                if (id == null || id.length() == 0) {
                    this.rgAreaHighlight.removeItemAt(i2);
                    continue;
                }
                this.rgAreaHighlight.getItemAtIndex(i2).setSelected(false);
            }
            String selectedLayerName = (String)this.params.get("polygonLayerName");
            Radio rSelectedLayer = null;
            List layers = this.getMapComposer().getPolygonLayers();
            for (i = 0; i < layers.size(); ++i) {
                MapLayer lyr = (MapLayer)layers.get(i);
                Radio rAr = new Radio(lyr.getDisplayName());
                rAr.setValue((Object)lyr.getName());
                rAr.setParent((Component)this.rgAreaHighlight);
                this.rgAreaHighlight.insertBefore((Component)rAr, (Component)this.rAreaCurrentHighlight);
                if (!lyr.getName().equals(selectedLayerName)) continue;
                rSelectedLayer = rAr;
            }
            if (selectedAreaName != null && !selectedAreaName.isEmpty()) {
                for (i = 0; i < this.rgAreaHighlight.getItemCount(); ++i) {
                    if (!this.rgAreaHighlight.getItemAtIndex(i).isVisible() || !this.rgAreaHighlight.getItemAtIndex(i).getLabel().equals(selectedAreaName)) continue;
                    this.rgAreaHighlight.setSelectedItem(this.rgAreaHighlight.getItemAtIndex(i));
                    break;
                }
            } else if (rSelectedLayer != null) {
                this.rgAreaHighlight.setSelectedItem(this.rAreaSelected);
            } else if ("none".equals(selectedLayerName)) {
                this.rgAreaHighlight.setSelectedItem(this.rAreaWorld);
            } else {
                for (i = 0; i < this.rgAreaHighlight.getItemCount(); ++i) {
                    if (!this.rgAreaHighlight.getItemAtIndex(i).isVisible()) continue;
                    this.rgAreaHighlight.setSelectedItem(this.rgAreaHighlight.getItemAtIndex(i));
                    break;
                }
            }
            Clients.evalJavaScript((String)("jq('#" + this.rgAreaHighlight.getSelectedItem().getUuid() + "-real').attr('checked', true);"));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load active area layers", (Throwable)e);
        }
    }

    public void loadAreaLayersHighlight() {
        try {
            List layers = this.getMapComposer().getPolygonLayers();
            for (int i = 0; i < layers.size(); ++i) {
                MapLayer lyr = (MapLayer)layers.get(i);
                Radio rAr = new Radio(lyr.getDisplayName());
                rAr.setId(lyr.getName().replaceAll(" ", "") + "_" + i);
                rAr.setValue((Object)lyr.getName());
                rAr.setParent((Component)this.rgAreaHighlight);
                this.rgAreaHighlight.insertBefore((Component)rAr, (Component)this.rAreaCurrentHighlight);
            }
            this.rAreaNoneHighlight.setSelected(true);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load active area layers", (Throwable)e);
        }
    }

    public void loadGridLayers(boolean includeAnalysisLayers, boolean includeContextualLayers, boolean singleLayerDomain) {
        this.includeAnalysisLayers = includeAnalysisLayers;
        this.includeContextualLayers = includeContextualLayers;
        this.singleLayerDomain = singleLayerDomain;
        this.fullList = true;
        if (this.selectedLayersCombobox != null) {
            this.selectedLayersCombobox.init(this.getMapComposer().getLayerSelections(), this.getMapComposer(), false);
        }
        try {
            String layers;
            if (this.fullList) {
                this.lbListLayers.init(this.getMapComposer(), includeAnalysisLayers, !includeContextualLayers, singleLayerDomain);
                this.lbListLayers.updateDistances();
            }
            if ((layers = (String)this.params.get("environmentalLayerName")) != null) {
                this.lbListLayers.selectLayers(layers.split(","));
            }
            this.lbListLayers.renderAll();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Unable to load species layers", (Throwable)e);
        }
    }

    public void onCheck$rgArea(Event event) {
        if (this.rgArea == null) {
            return;
        }
        this.hasCustomArea = false;
        this.rAreaSelected = this.rgArea.getSelectedItem();
        try {
            this.rAreaSelected = (Radio)((ForwardEvent)event).getOrigin().getTarget();
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to set selected Radio from event", (Throwable)e);
        }
        if (this.rAreaSelected == this.rAreaCustom) {
            this.hasCustomArea = false;
        }
        if (this.chkEndemicSpecies != null) {
            this.updateEndemicCheckBox();
        }
    }

    private void updateEndemicCheckBox() {
        if (this.rAreaSelected == null) {
            return;
        }
        boolean showEndemic = false;
        String value = (String)this.rAreaSelected.getValue();
        if (!("australia".equals(value) || "world".equals(value) || "custom".equals(value))) {
            String areaName = this.rAreaSelected.getLabel();
            MapLayer ml = this.getMapComposer().getMapLayer(areaName);
            String sarea = "";
            if ("current".equals(value)) {
                SelectedArea sa = this.getSelectedArea();
                sarea = sa.getKm2Area();
            } else if (ml != null && (sarea = ml.getAreaSqKm()) == null) {
                sarea = ml.calculateAndStoreArea();
            }
            try {
                Float area = Float.valueOf(Float.parseFloat(sarea.replaceAll(",", "")));
                showEndemic = area.floatValue() <= (float)CommonData.getMaxEndemicArea();
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("failed to parse endemic area from: " + sarea));
            }
        }
        this.chkEndemicSpecies.setDisabled(!showEndemic);
        this.chkEndemicSpecies.setChecked(false);
        if (this.lendemicNote != null) {
            if (showEndemic) {
                this.lendemicNote.setValue("Please note this may take several minutes depending on the area selected.");
            } else {
                this.lendemicNote.setValue("The selected area is too large to be considered for endemic species.");
            }
        }
    }

    public void onCheck$rgAreaHighlight(Event event) {
        if (this.rgAreaHighlight == null) {
            return;
        }
        this.hasCustomArea = false;
        if ("rAreaCustomHighlight".equals(this.rgAreaHighlight.getSelectedItem().getId())) {
            this.hasCustomArea = false;
        }
    }

    public void onCheck$rgSpecies(Event event) {
        if (this.rgSpecies == null) {
            return;
        }
        Radio selectedItem = this.rgSpecies.getSelectedItem();
        try {
            if (selectedItem == null && event != null) {
                selectedItem = (Radio)((ForwardEvent)event).getOrigin().getTarget();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to set selected Radio from event", (Throwable)e);
        }
        try {
            Query q;
            MapLayer ml;
            if (this.vboxImportSL != null && event != null && selectedItem != this.rSpeciesUploadLSID) {
                this.vboxImportSL.setVisible(false);
            }
            if (this.vboxImportSLBk != null && event != null && this.vboxImportSLBk != null && selectedItem != this.rSpeciesUploadLSIDBk) {
                this.vboxImportSLBk.setVisible(false);
            }
            if (selectedItem == this.rSpeciesSearch && this.divSpeciesSearch != null) {
                this.divSpeciesSearch.setVisible(true);
                this.vboxMultiple.setVisible(false);
                this.divLifeform.setVisible(false);
                if (event != null) {
                    this.toggles();
                }
                return;
            }
            if (this.divSpeciesSearch != null) {
                this.divSpeciesSearch.setVisible(false);
            }
            if (selectedItem == this.rSpeciesUploadSpecies) {
                this.btnOk.setVisible(true);
                if (this.vboxMultiple != null) {
                    this.vboxMultiple.setVisible(false);
                }
                if (this.divLifeform != null) {
                    this.divLifeform.setVisible(false);
                }
            } else if (selectedItem == this.rSpeciesUploadLSID) {
                this.btnOk.setDisabled(true);
                this.vboxImportSL.setVisible(true);
                if (this.vboxMultiple != null) {
                    this.vboxMultiple.setVisible(false);
                }
                if (this.divLifeform != null) {
                    this.divLifeform.setVisible(false);
                }
            } else if (this.rMultiple != null && this.rMultiple.isSelected()) {
                this.vboxMultiple.setVisible(true);
                if (this.divLifeform != null) {
                    this.divLifeform.setVisible(false);
                }
            } else if (this.rSpeciesLifeform != null && this.rSpeciesLifeform.isSelected()) {
                if (this.vboxMultiple != null) {
                    this.vboxMultiple.setVisible(false);
                }
                this.divLifeform.setVisible(true);
            } else {
                this.btnOk.setDisabled(false);
                if (this.vboxMultiple != null) {
                    this.vboxMultiple.setVisible(false);
                }
                if (this.divLifeform != null) {
                    this.divLifeform.setVisible(false);
                }
            }
            if (event != null) {
                this.toggles();
            }
            if (this.rgSpecies.getSelectedItem() != null && this.rgSpecies.getSelectedItem().getValue() != null && (ml = this.getMapComposer().getMapLayer(this.rgSpecies.getSelectedItem().getLabel())) != null && (q = ml.getSpeciesQuery()) != null && q instanceof BiocacheQuery) {
                this.setGeospatialKosherCheckboxes(((BiocacheQuery)q).getGeospatialKosher());
            } else {
                this.setGeospatialKosherCheckboxes(this.defaultGeospatialKosher);
            }
            this.updateGeospatialKosherCheckboxes();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error from selecting a species radio", (Throwable)e);
        }
    }

    public void onCheck$rgSpeciesBk(Event event) {
        if (this.rgSpeciesBk == null) {
            return;
        }
        Radio selectedItem = this.rgSpeciesBk.getSelectedItem();
        try {
            if (selectedItem == null && event != null) {
                selectedItem = (Radio)((ForwardEvent)event).getOrigin().getTarget();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"failed to set selected Radio from event", (Throwable)e);
        }
        try {
            Query q;
            MapLayer ml;
            if (this.vboxImportSL != null && event != null && selectedItem != this.rSpeciesUploadLSID) {
                this.vboxImportSL.setVisible(false);
            }
            if (event != null && this.vboxImportSLBk != null && selectedItem != this.rSpeciesUploadLSIDBk) {
                this.vboxImportSLBk.setVisible(false);
            }
            if (selectedItem == this.rSpeciesSearchBk && this.divSpeciesSearchBk != null) {
                this.divSpeciesSearchBk.setVisible(true);
                this.vboxMultipleBk.setVisible(false);
                if (event != null) {
                    this.toggles();
                }
                return;
            }
            if (this.divSpeciesSearchBk != null) {
                this.divSpeciesSearchBk.setVisible(false);
            }
            if (selectedItem == this.rSpeciesUploadLSIDBk) {
                this.btnOk.setDisabled(true);
                this.vboxImportSLBk.setVisible(true);
                this.vboxMultiple.setVisible(false);
            } else if (selectedItem == this.rSpeciesUploadSpeciesBk) {
                this.btnOk.setVisible(true);
            }
            if (this.rMultipleBk != null && this.rMultipleBk.isSelected()) {
                this.vboxMultipleBk.setVisible(true);
            } else {
                this.vboxMultipleBk.setVisible(false);
            }
            if (event != null) {
                this.toggles();
            }
            if (this.rgSpeciesBk.getSelectedItem() != null && this.rgSpeciesBk.getSelectedItem().getValue() != null && (ml = this.getMapComposer().getMapLayer(this.rgSpeciesBk.getSelectedItem().getLabel())) != null && (q = ml.getSpeciesQuery()) != null && q instanceof BiocacheQuery) {
                this.setGeospatialKosherCheckboxesBk(((BiocacheQuery)q).getGeospatialKosher());
            } else {
                this.setGeospatialKosherCheckboxesBk(this.defaultGeospatialKosher);
            }
            this.updateGeospatialKosherCheckboxesBk();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error selecting background species radio", (Throwable)e);
        }
    }

    public void onValueSelected$searchSpeciesACComp(Event event) {
        this.toggles();
    }

    public void onClick$btnHelp(Event event) {
        String helpurl = "";
        if ("Prediction".equals(this.selectedMethod)) {
            helpurl = "http://www.ala.org.au/spatial-portal-help/analysis-prediction-tab/";
        } else if ("Sampling".equals(this.selectedMethod)) {
            helpurl = "http://www.ala.org.au/spatial-portal-help/analysis-sampling-tab/";
        } else if ("Classification".equals(this.selectedMethod)) {
            helpurl = "http://www.ala.org.au/spatial-portal-help/analysis-classification-tab/";
        } else if ("Scatterplot".equals(this.selectedMethod)) {
            helpurl = "http://www.ala.org.au/spatial-portal-help/scatterplot-tab/";
        }
        if (StringUtils.isNotBlank((String)helpurl)) {
            this.getMapComposer().activateLink(helpurl, "Help", false, "");
        }
    }

    public void onClick$btnCancel(Event event) {
        this.currentStep = 1;
        if (this.lbListLayers != null) {
            this.lbListLayers.clearSelection();
            this.toggles();
        }
        this.detach();
    }

    public void onClick$btnBack(Event event) {
        Div previousDiv;
        Div currentDiv = (Div)this.getFellowIfAny("atstep" + this.currentStep);
        Div div = previousDiv = this.currentStep > 1 ? (Div)this.getFellowIfAny("atstep" + (this.currentStep - 1)) : null;
        if (currentDiv.getZclass().contains("first")) {
            if (this.btnBack != null) {
                this.btnBack.setDisabled(true);
            }
        } else {
            currentDiv.setVisible(false);
            previousDiv.setVisible(true);
            Html currentStepCompletedImg = (Html)this.getFellowIfAny("imgCompletedStep" + (this.currentStep - 1));
            currentStepCompletedImg.setVisible(false);
            Label nextStepLabel = (Label)this.getFellowIfAny("lblStep" + this.currentStep);
            nextStepLabel.setStyle("font-weight:normal");
            Label currentStepLabel = (Label)this.getFellowIfAny("lblStep" + (this.currentStep - 1));
            currentStepLabel.setStyle("font-weight:bold");
            --this.currentStep;
            if (previousDiv != null && this.btnBack != null) {
                this.btnBack.setDisabled(previousDiv.getZclass().contains("first"));
            }
        }
        this.btnOk.setLabel("Next >");
        this.toggles();
        this.updateWindowTitle();
        this.displayTrafficLightInfo();
    }

    private void displayTrafficLightInfo() {
        if (this.tlinfo != null) {
            if ("Prediction".equalsIgnoreCase(this.selectedMethod) && this.currentStep == 3) {
                this.tlinfo.setVisible(true);
            } else if ("Classification".equalsIgnoreCase(this.selectedMethod) && this.currentStep == 2) {
                this.tlinfo.setVisible(true);
            } else if ("GDM".equalsIgnoreCase(this.selectedMethod) && this.currentStep == 3) {
                this.tlinfo.setVisible(true);
            } else if ("Sampling".equalsIgnoreCase(this.selectedMethod) && this.currentStep == 3) {
                this.tlinfo.setVisible(true);
            } else {
                this.tlinfo.setVisible(false);
            }
        }
    }

    public void resetWindowFromSpeciesUpload(String lsid, String type) {
        try {
            if (type.compareTo("cancel") == 0) {
                this.fixFocus();
                return;
            }
            if (type.compareTo("normal") == 0) {
                this.setLsid(lsid);
            }
            if (type.compareTo("bk") == 0) {
                this.setLsidBk(lsid);
            }
            if (type.compareTo("assemblage") == 0) {
                this.setMultipleLsids(lsid);
            }
            if (type.compareTo("assemblagebk") == 0) {
                this.setMultipleLsidsBk(lsid);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception when resetting analysis window", (Throwable)e);
        }
    }

    public void resetWindow(String selectedArea) {
        try {
            List layers;
            MapLayer curTopArea;
            this.hasCustomArea = selectedArea != null && !selectedArea.trim().isEmpty();
            boolean ok = false;
            if (this.hasCustomArea && (curTopArea = (layers = this.getMapComposer().getPolygonLayers()) != null && !layers.isEmpty() ? (MapLayer)layers.get(0) : null) != this.prevTopArea) {
                if (this.isAreaHighlightTab()) {
                    this.loadAreaHighlightLayers(curTopArea.getDisplayName());
                } else if (this.isAreaTab()) {
                    if (this.getFellow("cAreaCurrent") != null) {
                        this.loadAreaLayersCheckboxes(curTopArea.getDisplayName());
                    } else {
                        this.loadAreaLayers(curTopArea.getDisplayName());
                    }
                }
                ok = true;
            }
            this.setTop(this.winTop);
            this.setLeft(this.winLeft);
            this.doModal();
            if (ok) {
                if (this.getFellow("cAreaCurrent") == null) {
                    this.onClick$btnOk(null);
                } else if (this.rAreaCustom != null) {
                    this.rAreaCustom.setSelected(false);
                }
                this.hasCustomArea = false;
            }
            this.fixFocus();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Exception when resetting analysis window", (Throwable)ex);
        }
    }

    public void onClick$btnOk(Event event) {
        if (this.btnOk.isDisabled()) {
            return;
        }
        boolean successful = false;
        try {
            if (!this.hasCustomArea && (this.isAreaCustom() || this.isAreaHighlightCustom())) {
                this.doOverlapped();
                this.setTop("-9999px");
                this.setLeft("-9999px");
                HashMap<String, Object> winProps = new HashMap<String, Object>();
                winProps.put("parent", this);
                winProps.put("parentname", "Tool");
                winProps.put("selectedMethod", this.selectedMethod);
                List layers = this.getMapComposer().getPolygonLayers();
                this.prevTopArea = layers != null && !layers.isEmpty() ? (MapLayer)layers.get(0) : null;
                Window window = (Window)Executions.createComponents((String)"WEB-INF/zul/add/AddArea.zul", (Component)this, winProps);
                window.setAttribute("winProps", winProps, true);
                window.setParent((Component)this);
                window.doModal();
                return;
            }
            Div currentDiv = (Div)this.getFellowIfAny("atstep" + this.currentStep);
            Div nextDiv = (Div)this.getFellowIfAny("atstep" + (this.currentStep + 1));
            if (Components.isAncestor((Component)currentDiv, (Component)this.lMultiple) && this.rMultiple.isChecked()) {
                if (Util.getUserEmail() != null && !"guest@ala.org.au".equals(Util.getUserEmail())) {
                    this.showExportSpeciesListDialog(this.lMultiple);
                    return;
                }
            } else if (Components.isAncestor((Component)currentDiv, (Component)this.lMultipleBk) && this.rMultipleBk.isChecked() && Util.getUserEmail() != null && !"guest@ala.org.au".equals(Util.getUserEmail())) {
                this.showExportSpeciesListDialog(this.lMultipleBk);
                return;
            }
            if (!currentDiv.getZclass().contains("last")) {
                if (currentDiv.getZclass().contains("species") && this.rSpeciesUploadSpecies != null && this.rSpeciesUploadSpecies.isSelected()) {
                    Boolean test = currentDiv.getZclass().contains("species") && this.rSpeciesUploadSpecies.isSelected();
                    LOGGER.debug((Object)("test=" + test));
                    this.onClick$btnUpload(event);
                } else {
                    currentDiv.setVisible(false);
                    nextDiv.setVisible(true);
                    Html previousStepCompletedImg = (Html)this.getFellowIfAny("imgCompletedStep" + this.currentStep);
                    previousStepCompletedImg.setVisible(true);
                    Label previousStepLabel = (Label)this.getFellowIfAny("lblStep" + this.currentStep);
                    previousStepLabel.setStyle("font-weight:normal");
                    Label currentStepLabel = (Label)this.getFellowIfAny("lblStep" + (this.currentStep + 1));
                    currentStepLabel.setStyle("font-weight:bold");
                    if (nextDiv != null) {
                        if (nextDiv.getZclass().contains("last")) {
                            this.loadSummaryDetails();
                            this.onLastPanel();
                        }
                        this.btnOk.setLabel("Next >");
                    }
                    ++this.currentStep;
                    successful = true;
                }
            } else {
                this.saveLayerSelection();
                successful = this.onFinish();
                if (successful) {
                    this.currentStep = 1;
                }
            }
            if (successful) {
                Query q;
                if (nextDiv != null && this.rgSpecies != null && (this.includeAnalysisLayersForUploadQuery || this.includeAnalysisLayersForAnyQuery) && (q = this.getSelectedSpecies()) != null) {
                    boolean test;
                    boolean bl = test = this.includeAnalysisLayersForAnyQuery || q instanceof UserDataQuery;
                    if (this.selectedLayersCombobox != null && this.selectedLayersCombobox.getIncludeAnalysisLayers() != test) {
                        this.selectedLayersCombobox.init(this.getMapComposer().getLayerSelections(), this.getMapComposer(), test);
                    }
                    if (this.lbListLayers != null && this.lbListLayers.getIncludeAnalysisLayers() != test) {
                        String[] selectedLayers = this.lbListLayers.getSelectedLayers();
                        this.lbListLayers.init(this.getMapComposer(), test, !this.includeContextualLayers, this.singleLayerDomain);
                        this.lbListLayers.updateDistances();
                        if (selectedLayers != null && selectedLayers.length > 0) {
                            this.lbListLayers.selectLayers(selectedLayers);
                        }
                        this.lbListLayers.renderAll();
                    }
                    if (this.cbLayer != null && this.cbLayer.getIncludeAnalysisLayers() != test) {
                        this.cbLayer.setIncludeAnalysisLayers(test);
                    }
                    if (this.cbLayerEnvironmentalOnly != null && this.cbLayerEnvironmentalOnly.getIncludeAnalysisLayers() != test) {
                        this.cbLayerEnvironmentalOnly.setIncludeAnalysisLayers(test);
                    }
                    if (this.cbLayer1 != null && this.cbLayer1.getIncludeAnalysisLayers() != test) {
                        this.cbLayer1.setIncludeAnalysisLayers(test);
                    }
                    if (this.cbLayer2 != null && this.cbLayer2.getIncludeAnalysisLayers() != test) {
                        this.cbLayer2.setIncludeAnalysisLayers(test);
                    }
                    if (this.cbLayerMix != null && this.cbLayerMix.getIncludeAnalysisLayers() != test) {
                        this.cbLayerMix.setIncludeAnalysisLayers(test);
                    }
                    if (this.mpLayer1 != null && this.mpLayer2 != null && this.mpLayersIncludeAnalysisLayers != test) {
                        while (!this.mpLayer1.getChildren().isEmpty()) {
                            this.mpLayer1.removeChild(this.mpLayer1.getFirstChild());
                        }
                        while (!this.mpLayer2.getChildren().isEmpty()) {
                            this.mpLayer2.removeChild(this.mpLayer2.getFirstChild());
                        }
                        for (MapLayer ml : this.getMapComposer().getGridLayers()) {
                            this.addToMpLayers(ml, false);
                        }
                        this.mpLayersIncludeAnalysisLayers = test;
                        if (this.mpLayersIncludeAnalysisLayers) {
                            for (MapLayer ml : this.getMapComposer().getAnalysisLayers()) {
                                if (ml.getSubType() == 14) continue;
                                this.addToMpLayers(ml, true);
                            }
                        }
                    }
                }
                if (nextDiv != null && nextDiv.getZclass().contains("last")) {
                    this.updateLayerListText();
                }
                if (this.btnBack != null) {
                    this.btnBack.setDisabled(false);
                }
                this.updateWindowTitle();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error progressing to next screen of tool", (Throwable)e);
        }
        this.toggles();
        this.displayTrafficLightInfo();
        this.fixFocus();
    }

    void fixFocus() {
    }

    public void onLastPanel() {
    }

    public boolean onFinish() {
        this.detach();
        Messagebox.show((String)("Running your analysis tool: " + this.selectedMethod));
        return true;
    }

    public long getEstimate() {
        return -1L;
    }

    public void onClick$bLogin(Event event) {
        this.getMapComposer().activateLink("https://auth.ala.org.au/cas/login", "Login", false);
    }

    public void checkEstimate() {
        try {
            long estimate = this.getEstimate();
            double minutes = (double)estimate / 60000.0;
            String estimateInMin = minutes < 0.5 ? "< 1 minute" : (int)Math.ceil(minutes) + " minutes";
            LOGGER.debug((Object)("Got estimate for process: " + estimate));
            LOGGER.debug((Object)("Estimate in minutes: " + estimateInMin));
            this.lEstimateMessage.setValue(estimateInMin);
            this.hasEstimated = true;
            this.isBackgroundProcess = true;
            if (estimate > 300000L && !this.isUserLoggedIn()) {
                this.notLoggedIn.setVisible(true);
                this.isLoggedIn.setVisible(false);
                this.hasEstimated = false;
                return;
            }
            this.notLoggedIn.setVisible(false);
            this.isLoggedIn.setVisible(true);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unable to get estimate for the process", (Throwable)e);
        }
    }

    public boolean isUserLoggedIn() {
        String authCookie = Util.getUserEmail();
        return !"guest@ala.org.au".equals(authCookie);
    }

    public SelectedArea getSelectedArea() {
        SelectedArea sa;
        block6: {
            String area = (String)this.rAreaSelected.getValue();
            sa = null;
            try {
                if ("current".equals(area)) {
                    sa = new SelectedArea(null, this.getMapComposer().getViewArea());
                    break block6;
                }
                if ("australia".equals(area)) {
                    sa = new SelectedArea(null, CommonData.getSettings().getProperty("default.wkt"));
                    break block6;
                }
                if ("world".equals(area)) {
                    sa = new SelectedArea(null, "POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))");
                    break block6;
                }
                List layers = this.getMapComposer().getPolygonLayers();
                for (MapLayer ml : layers) {
                    if (area != null && !area.equals(ml.getName())) continue;
                    sa = new SelectedArea(ml, null);
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Unable to retrieve selected area", (Throwable)e);
            }
        }
        return sa;
    }

    public SelectedArea getSelectedAreaHighlight() {
        SelectedArea sa;
        block6: {
            String area = (String)this.rgAreaHighlight.getSelectedItem().getValue();
            sa = null;
            try {
                if ("current".equals(area)) {
                    sa = new SelectedArea(null, this.getMapComposer().getViewArea());
                    break block6;
                }
                if ("australia".equals(area)) {
                    sa = new SelectedArea(null, CommonData.getSettings().getProperty("default.wkt"));
                    break block6;
                }
                if ("world".equals(area)) {
                    sa = new SelectedArea(null, "POLYGON((-179.999 -89.999,-179.999 89.999,179.999 84.999,179.999 -89.999,-179.999 -89.999))");
                    break block6;
                }
                List layers = this.getMapComposer().getPolygonLayers();
                for (MapLayer ml : layers) {
                    if (!area.equals(ml.getName())) continue;
                    sa = new SelectedArea(ml, null);
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Unable to retrieve selected area", (Throwable)e);
            }
        }
        return sa;
    }

    public Query getSelectedSpecies() {
        return this.getSelectedSpecies(false, true);
    }

    public Query getSelectedSpecies(boolean mapspecies, boolean applycheckboxes) {
        Query q = null;
        if (this.rgSpecies == null) {
            return q;
        }
        Radio r = this.rgSpecies.getSelectedItem();
        if (r == null) {
            if (this.rgSpecies.getItemCount() == 0) {
                return q;
            }
            LOGGER.error((Object)("rgSpecies item is not selected. step=" + this.currentStep + " method=" + this.getTitle() + " rgSpeces item at [0]=" + (this.rgSpecies != null && this.rgSpecies.getItemCount() > 0 ? this.rgSpecies.getItemAtIndex(0).getValue() : "null or no species items in list")));
            r = this.rgSpecies.getItemAtIndex(0);
        }
        String species = (String)r.getValue();
        String id = this.rgSpecies.getSelectedItem().getId();
        LOGGER.debug((Object)("getSelectedSpecies.species: " + species));
        MapLayer ml = this.getMapComposer().getMapLayer(species);
        if (ml != null) {
            q = ml.getSpeciesQuery();
            if (q instanceof BiocacheQuery) {
                BiocacheQuery bq = (BiocacheQuery)q;
                q = bq.newFacetGeospatialKosher(applycheckboxes ? this.getGeospatialKosher() : null, false);
            }
        } else {
            try {
                LOGGER.debug((Object)("getSelectedSpecies: " + species));
                LOGGER.debug((Object)("tool is: " + (this.tToolName == null ? "null" : this.tToolName.getValue())));
                if ("allspecies".equals(species)) {
                    q = new BiocacheQuery(null, null, null, null, false, applycheckboxes ? this.getGeospatialKosher() : null);
                } else {
                    if (ml == null && "allmapped".equals(species)) {
                        throw new UnsupportedOperationException("Not yet implemented");
                    }
                    if ("multiple".equals(species)) {
                        String lsids = this.getMultipleLsids();
                        LOGGER.debug((Object)("getSelectedSpecies.lsids: " + lsids));
                        if (lsids != null && lsids.length() > 0) {
                            q = new BiocacheQuery(lsids, null, null, null, false, applycheckboxes ? this.getGeospatialKosher() : null);
                            LOGGER.debug((Object)"getSelectedSpecies.query is now set");
                        }
                    } else if ("uploadLsid".equals(species)) {
                        SpeciesListListbox lb = id.endsWith("Bk") ? this.speciesListListboxBk : this.speciesListListbox;
                        q = lb.extractQueryFromSelectedLists(applycheckboxes ? this.getGeospatialKosher() : null);
                    } else if (("search".equals(species) || "uploadSpecies".equals(species)) && this.searchSpeciesACComp.hasValidItemSelected()) {
                        if (!this.searchSpeciesACComp.hasValidAnnotatedItemSelected()) {
                            LOGGER.debug((Object)("error in getSelectedSpecies value=" + this.searchSpeciesACComp.getAutoComplete().getSelectedItem().getValue() + " text=" + this.searchSpeciesACComp.getAutoComplete().getText()));
                        } else {
                            q = this.searchSpeciesACComp.getQuery((Map)this.getMapComposer().getSession().getAttribute("userpoints"), false, applycheckboxes ? this.getGeospatialKosher() : null);
                        }
                    } else if ("lifeform".equalsIgnoreCase(species)) {
                        q = new BiocacheQuery(null, null, null, Arrays.asList(new Facet("species_group", this.cbLifeform.getValue(), true)), mapspecies, applycheckboxes ? this.getGeospatialKosher() : null);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Unable to retrieve selected species", (Throwable)e);
            }
        }
        return q;
    }

    public Query getSelectedSpeciesBk() {
        return this.getSelectedSpeciesBk(false, true);
    }

    public Query getSelectedSpeciesBk(boolean mapspecies, boolean applycheckboxes) {
        Query q = null;
        if (this.rgSpeciesBk == null) {
            return q;
        }
        Radio r = this.rgSpeciesBk.getSelectedItem();
        if (r == null) {
            if (this.rgSpeciesBk.getItemCount() == 0) {
                return q;
            }
            LOGGER.error((Object)("rgSpeciesBk item is not selected. step=" + this.currentStep + " method=" + this.getTitle() + " rgSpeces item at [0]=" + (this.rgSpeciesBk != null && this.rgSpeciesBk.getItemCount() > 0 ? this.rgSpeciesBk.getItemAtIndex(0).getValue() : "null or no species items in list")));
            r = this.rgSpeciesBk.getItemAtIndex(0);
        }
        String species = (String)r.getValue();
        String id = this.rgSpeciesBk.getSelectedItem().getId();
        MapLayer ml = this.getMapComposer().getMapLayer(species);
        if (ml != null) {
            q = ml.getSpeciesQuery();
            if (q instanceof BiocacheQuery) {
                BiocacheQuery bq = (BiocacheQuery)q;
                q = bq.newFacetGeospatialKosher(applycheckboxes ? this.getGeospatialKosherBk() : null, false);
            }
        } else {
            try {
                if ("allspecies".equals(species)) {
                    q = new BiocacheQuery(null, null, null, null, false, applycheckboxes ? this.getGeospatialKosherBk() : null);
                } else {
                    if ("allmapped".equals(species)) {
                        throw new UnsupportedOperationException("Not yet implemented");
                    }
                    if ("multiple".equals(species)) {
                        String lsids = this.getMultipleLsidsBk();
                        if (lsids != null && lsids.length() > 0) {
                            q = new BiocacheQuery(lsids, null, null, null, false, applycheckboxes ? this.getGeospatialKosherBk() : null);
                        }
                    } else if ("uploadLsid".equals(species)) {
                        SpeciesListListbox lb = id.endsWith("Bk") ? this.speciesListListboxBk : this.speciesListListbox;
                        q = lb.extractQueryFromSelectedLists(applycheckboxes ? this.getGeospatialKosher() : null);
                    } else if (("search".equals(species) || "uploadSpecies".equals(species)) && this.bgSearchSpeciesACComp.hasValidItemSelected()) {
                        q = this.bgSearchSpeciesACComp.getQuery((Map)this.getMapComposer().getSession().getAttribute("userpoints"), false, applycheckboxes ? this.getGeospatialKosherBk() : null);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn((Object)"Unable to retrieve selected species", (Throwable)e);
            }
        }
        return q;
    }

    public String getSelectedSpeciesName() {
        String species = (String)this.rgSpecies.getSelectedItem().getValue();
        try {
            if ("allmapped".equals(species)) {
                species = "All mapped species";
            } else if ("search".equals(species)) {
                if (this.searchSpeciesACComp.hasValidItemSelected()) {
                    species = this.searchSpeciesACComp.getAutoComplete().getText();
                }
            } else if ("uploadLsid".equals(species)) {
                String id = this.rgSpecies.getSelectedItem().getId();
                SpeciesListListbox lb = id.endsWith("Bk") ? this.speciesListListboxBk : this.speciesListListbox;
                species = lb.getSelectedNames();
            } else {
                species = "lifeform".equalsIgnoreCase(species) ? this.cbLifeform.getText() : this.rgSpecies.getSelectedItem().getLabel();
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unable to retrieve selected species", (Throwable)e);
        }
        return species;
    }

    public String getSelectedLayers() {
        String layers = "";
        try {
            if (this.lbListLayers.getSelectedLayers().length > 0) {
                String[] sellayers;
                for (String l : sellayers = this.lbListLayers.getSelectedLayers()) {
                    layers = layers + l + ":";
                }
                layers = layers.substring(0, layers.length() - 1);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Unable to retrieve selected layers", (Throwable)e);
        }
        return layers;
    }

    void setLsid(String lsidName) {
        try {
            LOGGER.debug((Object)("lsidName: " + lsidName));
            String[] s = lsidName.split("\t");
            String species = s[1];
            String lsid = s[0];
            if (species != null) {
                String tmpSpecies = species;
                this.searchSpeciesACComp.getAutoComplete().setValue(tmpSpecies);
                this.searchSpeciesACComp.getAutoComplete().refresh(tmpSpecies);
                if (!this.searchSpeciesACComp.hasValidItemSelected()) {
                    List list = this.searchSpeciesACComp.getAutoComplete().getItems();
                    for (int i = 0; i < list.size(); ++i) {
                        Comboitem ci = (Comboitem)list.get(i);
                        if (!ci.getLabel().equalsIgnoreCase(this.searchSpeciesACComp.getAutoComplete().getValue()) || ci.getAnnotatedProperties() == null || !((String)ci.getAnnotatedProperties().get(0)).equals(lsid)) continue;
                        this.searchSpeciesACComp.getAutoComplete().setSelectedItem(ci);
                        break;
                    }
                }
                this.btnOk.setDisabled(!this.searchSpeciesACComp.hasValidItemSelected());
                this.rgSpecies.setSelectedItem(this.rSpeciesSearch);
                Clients.evalJavaScript((String)("jq('#" + this.rSpeciesSearch.getUuid() + "-real').attr('checked', true);"));
                this.toggles();
                this.onClick$btnOk(null);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Error setting lsid:", (Throwable)e);
        }
    }

    void setLsidBk(String lsidName) {
        if (lsidName == null) {
            return;
        }
        String[] s = lsidName.split("\t");
        String species = s[1];
        String lsid = s[0];
        if (species != null) {
            String tmpSpecies = species;
            this.bgSearchSpeciesACComp.getAutoComplete().setValue(tmpSpecies);
            this.bgSearchSpeciesACComp.getAutoComplete().refresh(tmpSpecies);
            if (!this.bgSearchSpeciesACComp.hasValidItemSelected()) {
                List list = this.bgSearchSpeciesACComp.getAutoComplete().getItems();
                for (int i = 0; i < list.size(); ++i) {
                    Comboitem ci = (Comboitem)list.get(i);
                    if (!ci.getLabel().equalsIgnoreCase(this.bgSearchSpeciesACComp.getAutoComplete().getValue()) || ci.getAnnotatedProperties() == null || !((String)ci.getAnnotatedProperties().get(0)).equals(lsid)) continue;
                    this.bgSearchSpeciesACComp.getAutoComplete().setSelectedItem(ci);
                    break;
                }
            }
            this.btnOk.setDisabled(!this.bgSearchSpeciesACComp.hasValidItemSelected());
            this.rgSpeciesBk.setSelectedItem(this.rSpeciesSearchBk);
            Clients.evalJavaScript((String)("jq('#" + this.rSpeciesSearchBk.getUuid() + "-real').attr('checked', true);"));
            this.onClick$btnOk(null);
        }
    }

    public void onSelect$lbListLayers(Event event) {
        this.toggles();
    }

    void toggles() {
        this.btnOk.setDisabled(false);
        this.btnOk.setVisible(true);
        if (this.fileUpload != null) {
            this.fileUpload.setVisible(false);
        }
        Div currentDiv = (Div)this.getFellowIfAny("atstep" + this.currentStep);
        if (this.lbListLayers != null) {
            if (currentDiv.getZclass().contains("minlayers1")) {
                this.btnOk.setDisabled(this.lbListLayers.getSelectedCount() < 1);
            } else if (currentDiv.getZclass().contains("minlayers2")) {
                this.btnOk.setDisabled(this.lbListLayers.getSelectedCount() < 2);
            } else if (currentDiv.getZclass().contains("optional")) {
                this.btnOk.setDisabled(false);
            }
            if (currentDiv.getZclass().contains("maxlayers")) {
                int start = currentDiv.getZclass().indexOf("maxlayers") + "maxlayers".length();
                int end = Math.max(currentDiv.getZclass().indexOf(" ", start), currentDiv.getZclass().length());
                int max = Integer.parseInt(currentDiv.getZclass().substring(start, end));
                if (!this.btnOk.isDisabled()) {
                    this.btnOk.setDisabled(this.lbListLayers.getSelectedCount() > max);
                }
            }
            this.updateLayerSelectionCount();
        }
        if (this.rgSpecies != null && Components.isAncestor((Component)currentDiv, (Component)this.rgSpecies)) {
            this.onCheck$rgSpecies(null);
        }
        if (this.rgSpeciesBk != null && Components.isAncestor((Component)currentDiv, (Component)this.rgSpeciesBk)) {
            this.onCheck$rgSpeciesBk(null);
        }
        if (currentDiv != null) {
            if (currentDiv.getZclass().contains("layers2auto")) {
                this.btnOk.setDisabled(this.cbLayer2.getSelectedItem() == null || this.cbLayer1.getSelectedItem() == null);
            }
            if (currentDiv.getZclass().contains("optional")) {
                this.btnOk.setDisabled(false);
            }
            if (currentDiv.getZclass().contains("species")) {
                if (this.divSpeciesSearch.isVisible()) {
                    this.btnOk.setDisabled(!this.searchSpeciesACComp.hasValidAnnotatedItemSelected());
                } else if (this.vboxMultiple.isVisible()) {
                    this.btnOk.setDisabled(this.getMultipleLsids().length() == 0);
                }
                if (this.chkGeoKosherTrue != null) {
                    this.updateGeospatialKosherCheckboxes();
                }
                if (this.chkGeoKosherTrueBk != null) {
                    this.updateGeospatialKosherCheckboxesBk();
                }
            }
        }
        if (this.lbListLayers != null && this.bLayerListDownload1 != null && this.bLayerListDownload2 != null) {
            this.bLayerListDownload1.setDisabled(this.lbListLayers.getSelectedCount() == 0);
            this.bLayerListDownload2.setDisabled(this.lbListLayers.getSelectedCount() == 0);
        }
    }

    public void onChange$cbLayer2(Event event) {
        this.toggles();
    }

    public void onChange$cbLayer1(Event event) {
        this.toggles();
    }

    public String getSelectedAreaName() {
        String area = this.rAreaSelected.getLabel();
        List layers = this.getMapComposer().getPolygonLayers();
        for (MapLayer ml : layers) {
            if (!area.equals(ml.getDisplayName())) continue;
            area = ml.getName();
            break;
        }
        return area;
    }

    public String getSelectedAreaDisplayName() {
        return this.rAreaSelected.getLabel();
    }

    public void onClick$btnClearSelection(Event event) {
        this.lbListLayers.clearSelection();
        this.lbListLayers.updateDistances();
        this.toggles();
        this.btnOk.setDisabled(true);
    }

    private boolean isAreaHighlightTab() {
        return this.rgAreaHighlight != null && this.rgAreaHighlight.getParent().isVisible();
    }

    boolean isAreaTab() {
        return this.rgArea != null && this.rgArea.getParent().isVisible();
    }

    boolean isAreaCustom() {
        return this.isAreaTab() && this.rAreaCustom != null && this.rAreaCustom.isSelected();
    }

    boolean isAreaHighlightCustom() {
        return this.isAreaHighlightTab() && this.rgAreaHighlight != null && "rAreaCustomHighlight".equals(this.rgAreaHighlight.getSelectedItem().getId());
    }

    public void onSelect$selectedLayersCombobox(Event event) {
        Comboitem ci = this.selectedLayersCombobox.getSelectedItem();
        if (ci != null && this.lbListLayers != null) {
            String layersList = null;
            if (ci.getValue() != null && ci.getValue() instanceof LayerSelection) {
                layersList = ((LayerSelection)ci.getValue()).getLayers();
            } else if (ci.getValue() == null) {
                if (ci.getLabel().toLowerCase().contains("paste")) {
                    PasteLayerListController window = (PasteLayerListController)Executions.createComponents((String)"WEB-INF/zul/input/PasteLayerList.zul", (Component)this, null);
                    window.setCallback((EventListener)new /* Unavailable Anonymous Inner Class!! */);
                    try {
                        window.setParent((Component)this);
                        window.doModal();
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"error opening PasteLayerList.zul", (Throwable)e);
                    }
                } else if (ci.getLabel().toLowerCase().contains("import")) {
                    UploadLayerListController window = (UploadLayerListController)Executions.createComponents((String)"WEB-INF/zul/input/UploadLayerList.zul", (Component)this, null);
                    window.setCallback((EventListener)new /* Unavailable Anonymous Inner Class!! */);
                    try {
                        window.setParent((Component)this);
                        window.doModal();
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"error opening UploadLayerList.zul", (Throwable)e);
                    }
                }
                this.selectedLayersCombobox.setSelectedIndex(-1);
            }
            this.selectLayerFromList(layersList);
        }
    }

    public void selectLayerFromList(String layersList) {
        String newLayersList = layersList;
        if (newLayersList == null) {
            return;
        }
        newLayersList = newLayersList.replace("\n", ",");
        String[] layers = newLayersList.split(",");
        String[] list = new String[layers.length * 2];
        for (int i = 0; i < layers.length; ++i) {
            int p1 = layers[i].lastIndexOf(40);
            int p2 = layers[i].lastIndexOf(41);
            if (p1 >= 0 && p2 >= 0 && p1 < p2) {
                list[i * 2] = layers[i].substring(p1 + 1, p2).trim();
            }
            list[i * 2 + 1] = layers[i];
        }
        this.lbListLayers.selectLayers(list);
        this.toggles();
    }

    public void saveLayerSelection() {
        if (this.lbListLayers != null && this.lbListLayers.getSelectedCount() > 0) {
            String list = this.getLayerListShortText();
            LayerSelection ls = new LayerSelection(this.selectedMethod, this.tToolName.getText(), System.currentTimeMillis(), list);
            this.getMapComposer().addLayerSelection(ls);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.getMapComposer().getLayerSelections().size(); ++i) {
                if (i > 0) {
                    sb.append("\n");
                }
                sb.append(((LayerSelection)this.getMapComposer().getLayerSelections().get(i)).toString());
                sb.append(" // ");
                sb.append(((LayerSelection)this.getMapComposer().getLayerSelections().get(i)).getLayers());
            }
            try {
                Cookie c = new Cookie("analysis_layer_selections", URLEncoder.encode(sb.toString(), "UTF-8"));
                c.setMaxAge(Integer.MAX_VALUE);
                ((HttpServletResponse)Executions.getCurrent().getNativeResponse()).addCookie(c);
            }
            catch (Exception e) {
                LOGGER.error((Object)("error encoding cookies from UTF-8: " + sb.toString()));
            }
        }
    }

    void updateLayerListText() {
        try {
            if (this.lbListLayers != null && this.lbListLayers.getSelectedCount() > 0 && this.tLayerList != null) {
                String lyrtext = this.getLayerListText();
                LOGGER.debug((Object)("Setting Layer text: \n" + lyrtext));
                this.tLayerList.setText(lyrtext);
                if (this.dLayerSummary != null) {
                    this.dLayerSummary.setVisible(this.tLayerList.getText().length() > 0);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error selecting layers", (Throwable)e);
        }
    }

    String getLayerListText() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.lbListLayers.getSelectedLayers()) {
            try {
                String displayname;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if ((displayname = CommonData.getLayerDisplayName((String)s)) != null && displayname.length() > 0) {
                    sb.append(displayname).append(" (").append(s).append(")");
                    continue;
                }
                sb.append(s);
            }
            catch (Exception e) {
                LOGGER.error((Object)"error geting layer list as text", (Throwable)e);
            }
        }
        return sb.toString();
    }

    String getLayerListShortText() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.lbListLayers.getSelectedLayers()) {
            try {
                String displayname = CommonData.getFacetLayerDisplayNameDefault((String)CommonData.getLayerFacetName((String)s));
                if (displayname == null || displayname.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(s);
            }
            catch (Exception e) {
                LOGGER.error((Object)"error getting list of layer short names", (Throwable)e);
            }
        }
        return sb.toString();
    }

    public void onChange$cbLayer(Event event) {
        if (this.lbListLayers != null && this.cbLayer.getSelectedItem() != null) {
            JSONObject jo = (JSONObject)this.cbLayer.getSelectedItem().getValue();
            String[] layer = jo.get((Object)"name").toString().split("/");
            this.lbListLayers.selectLayers(layer);
            this.cbLayer.setSelectedIndex(-1);
        }
        this.toggles();
    }

    public void onChange$cbLayerEnvironmentalOnly(Event event) {
        if (this.lbListLayers != null && this.cbLayerEnvironmentalOnly.getSelectedItem() != null) {
            JSONObject jo = (JSONObject)this.cbLayerEnvironmentalOnly.getSelectedItem().getValue();
            String[] layer = jo.get((Object)"name").toString().split("/");
            this.lbListLayers.selectLayers(layer);
            this.cbLayerEnvironmentalOnly.setSelectedIndex(-1);
        }
        this.toggles();
    }

    public void onChange$cbLayerMix(Event event) {
        if (this.lbListLayers != null && this.cbLayerMix.getSelectedItem() != null) {
            JSONObject jo = (JSONObject)this.cbLayerMix.getSelectedItem().getValue();
            String[] layer = jo.get((Object)"name").toString().split("/");
            this.lbListLayers.selectLayers(layer);
            this.cbLayerMix.setSelectedIndex(-1);
        }
        this.toggles();
    }

    public void onClick$bLayerListDownload1(Event event) {
        this.downloadLayerList();
    }

    public void onClick$bLayerListDownload2(Event event) {
        this.downloadLayerList();
    }

    void downloadLayerList() {
        SimpleDateFormat sdf = new SimpleDateFormat("ddmmyyyy_hhmm");
        Filedownload.save((String)this.getLayerListShortText(), (String)"text/plain", (String)("layer_selection_" + sdf.format(new Date()) + ".txt"));
    }

    public void updateLayerSelectionCount() {
        if (this.lLayersSelected != null && this.lbListLayers != null) {
            if (this.lbListLayers.getSelectedCount() == 1) {
                this.lLayersSelected.setValue("1 layer selected");
            } else {
                int end;
                int start;
                String error = "";
                Div currentDiv = (Div)this.getFellowIfAny("atstep" + this.currentStep);
                if (currentDiv.getZclass().contains("maxlayers")) {
                    start = currentDiv.getZclass().indexOf("maxlayers") + "maxlayers".length();
                    end = currentDiv.getZclass().indexOf(" ", start);
                    if (end < 0) {
                        end = currentDiv.getZclass().length();
                    }
                    int max = Integer.parseInt(currentDiv.getZclass().substring(start, end));
                    if (this.lbListLayers.getSelectedCount() > max) {
                        this.lLayersSelected.setSclass("lblRed");
                        error = ", INVALID: select no more than " + max + " layers.";
                    } else {
                        this.lLayersSelected.setSclass("");
                    }
                }
                if (currentDiv.getZclass().contains("minlayers")) {
                    start = currentDiv.getZclass().indexOf("minlayers") + "minlayers".length();
                    end = currentDiv.getZclass().indexOf(" ", start);
                    if (end < 0) {
                        end = currentDiv.getZclass().length();
                    }
                    int min = Integer.parseInt(currentDiv.getZclass().substring(start, end));
                    if (this.lbListLayers.getSelectedCount() < min) {
                        this.lLayersSelected.setSclass("lblRed");
                        error = ", INVALID: select at least " + min + " layers.";
                    }
                }
                if (error.length() == 0) {
                    this.lLayersSelected.setSclass("");
                }
                this.lLayersSelected.setValue(this.lbListLayers.getSelectedCount() + " layers selected" + error);
            }
        }
    }

    public void onUpload$uploadLayerList(Event event) {
        this.doFileUpload(event);
    }

    public void onUpload$fileUpload(Event event) {
        UploadEvent ue = null;
        UserDataDTO ud = null;
        if (event instanceof UploadEvent) {
            ue = (UploadEvent)event;
        } else if (event instanceof ForwardEvent) {
            ue = (UploadEvent)((ForwardEvent)event).getOrigin();
        }
        Media m = ue.getMedia();
        if (ud == null) {
            ud = new UserDataDTO(m.getName());
        }
        if (ud.getName().trim().isEmpty()) {
            ud.setName(m.getName());
        }
        ud.setFilename(m.getName());
        if (ud.getName() == null || ud.getName().length() == 0) {
            ud.setName(m.getName());
        }
        if (ud.getDescription() == null || ud.getDescription().length() == 0) {
            ud.setDescription(m.getName());
        }
        ud.setUploadedTimeInMs(System.currentTimeMillis());
        UploadSpeciesController usc = (UploadSpeciesController)Executions.createComponents((String)"WEB-INF/zul/input/UploadSpecies.zul", (Component)this, null);
        usc.setAddToMap(false);
        if (this.rgSpeciesBk != null) {
            if (this.rgSpeciesBk.getSelectedItem() == this.rSpeciesUploadLSIDBk) {
                usc.setUploadType("assemblagebk");
            } else if (this.rgSpeciesBk.getSelectedItem() == this.rSpeciesUploadSpeciesBk) {
                usc.setUploadType("bk");
            }
        }
        usc.setVisible(false);
        usc.doOverlapped();
        usc.doFileUpload(ud, event);
        usc.detach();
    }

    public void doFileUpload(Event event) {
        UploadEvent ue = null;
        if (event instanceof UploadEvent) {
            ue = (UploadEvent)event;
        } else if (event instanceof ForwardEvent) {
            ue = (UploadEvent)((ForwardEvent)event).getOrigin();
        }
        if (ue == null) {
            LOGGER.error((Object)"unable to upload file");
            return;
        }
        LOGGER.debug((Object)"fileUploaded()");
        try {
            Media m = ue.getMedia();
            boolean loaded = false;
            try {
                this.loadLayerList(m.getReaderData());
                loaded = true;
                LOGGER.debug((Object)("read type " + m.getContentType() + " with getReaderData"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!loaded) {
                try {
                    this.loadLayerList((Reader)new StringReader(new String(m.getByteData())));
                    loaded = true;
                    LOGGER.debug((Object)("read type " + m.getContentType() + " with getByteData"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!loaded) {
                try {
                    this.loadLayerList((Reader)new InputStreamReader(m.getStreamData()));
                    loaded = true;
                    LOGGER.debug((Object)("read type " + m.getContentType() + " with getStreamData"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!loaded) {
                try {
                    this.loadLayerList((Reader)new StringReader(m.getStringData()));
                    LOGGER.debug((Object)("read type " + m.getContentType() + " with getStringData"));
                }
                catch (Exception e) {
                    this.getMapComposer().showMessage("Unable to load your file.");
                    LOGGER.error((Object)"unable to load user layer list: ", (Throwable)e);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex);
        }
    }

    private void loadLayerList(Reader r) throws Exception {
        CSVReader reader = new CSVReader(r);
        StringBuilder sb = new StringBuilder();
        for (String s : reader.readNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(s);
        }
        reader.close();
        this.selectLayerFromList(sb.toString());
        this.updateLayerSelectionCount();
    }

    public void mChooseSelected(Event event) {
        Comboitem ci = this.mSearchSpeciesACComp.getAutoComplete().getSelectedItem();
        if (ci != null && ci.getAnnotatedProperties() != null && ci.getAnnotatedProperties().get(0) != null) {
            String annotatedValue = (String)ci.getAnnotatedProperties().get(0);
            if (this.mSearchSpeciesACComp.shouldUseRawName()) {
                this.addTolMultiple(null, annotatedValue, null, null, true);
            } else {
                String lsid = annotatedValue;
                try {
                    Map searchResult = BiocacheQuery.getClassification((String)lsid);
                    String sciname = (String)searchResult.get("scientificName");
                    String family = (String)searchResult.get("family");
                    String kingdom = (String)searchResult.get("kingdom");
                    if (sciname == null) {
                        sciname = "";
                    }
                    if (family == null) {
                        family = "";
                    }
                    if (kingdom == null) {
                        kingdom = "";
                    }
                    if (sciname != null && sciname.length() > 0) {
                        this.addTolMultiple(lsid, sciname, family, kingdom, true);
                        this.mSearchSpeciesACComp.getAutoComplete().setText("");
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error with species autocomplete", (Throwable)e);
                }
            }
        }
        this.toggles();
    }

    public void mChooseSelectedBk(Event event) {
        Comboitem ci = this.mSearchSpeciesACCompBk.getAutoComplete().getSelectedItem();
        if (ci != null && ci.getAnnotatedProperties() != null && ci.getAnnotatedProperties().get(0) != null) {
            String annotatedValue = (String)ci.getAnnotatedProperties().get(0);
            if (this.mSearchSpeciesACCompBk.shouldUseRawName()) {
                this.addTolMultipleBk(null, annotatedValue, null, null, true);
            } else {
                String lsid = annotatedValue;
                try {
                    Map searchResult = BiocacheQuery.getClassification((String)lsid);
                    String sciname = (String)searchResult.get("scientificName");
                    String family = (String)searchResult.get("family");
                    String kingdom = (String)searchResult.get("kingdom");
                    if (sciname == null) {
                        sciname = "";
                    }
                    if (family == null) {
                        family = "";
                    }
                    if (kingdom == null) {
                        kingdom = "";
                    }
                    if (sciname != null && sciname.length() > 0) {
                        this.addTolMultipleBk(lsid, sciname, family, kingdom, true);
                        this.mSearchSpeciesACCompBk.getAutoComplete().setText("");
                    }
                }
                catch (Exception e) {
                    LOGGER.error((Object)"error with species autocomplete for background species (scatterplot)", (Throwable)e);
                }
            }
        }
        this.toggles();
    }

    public void onClick$bMultiple(Event event) {
        this.importList(this.tMultiple.getText());
    }

    void importList(String list) {
        String[] speciesNames = list.replace("\n", ",").replace("\t", ",").split(",");
        ArrayList<String> notFound = new ArrayList<String>();
        StringBuilder notFoundSb = new StringBuilder();
        for (int i = 0; i < speciesNames.length; ++i) {
            String s = speciesNames[i].trim();
            if (s.length() <= 0) continue;
            JSONObject searchResult = this.processAdhoc(s);
            try {
                Map sr;
                JSONArray ja = (JSONArray)searchResult.get((Object)"values");
                String sciname = "";
                String family = "";
                String kingdom = "";
                String lsid = null;
                for (int j = 0; j < ja.size(); ++j) {
                    if ("scientificName".equals(((JSONObject)ja.get(j)).get((Object)"name"))) {
                        sciname = ((JSONObject)ja.get(j)).get((Object)"processed").toString();
                    }
                    if ("family".equals(((JSONObject)ja.get(j)).get((Object)"name"))) {
                        family = ((JSONObject)ja.get(j)).get((Object)"processed").toString();
                    }
                    if ("kingdom".equals(((JSONObject)ja.get(j)).get((Object)"name"))) {
                        kingdom = ((JSONObject)ja.get(j)).get((Object)"processed").toString();
                    }
                    if (!"taxonConceptID".equals(((JSONObject)ja.get(j)).get((Object)"name"))) continue;
                    lsid = ((JSONObject)ja.get(j)).get((Object)"processed").toString();
                }
                if ((lsid == null || lsid.length() == 0) && s.matches(".*[0-9].*") && !(sr = BiocacheQuery.getClassification((String)s)).isEmpty() && sr.get("scientificName") != null && ((String)sr.get("scientificName")).length() > 0) {
                    lsid = s;
                    sciname = (String)sr.get("scientificName");
                    family = (String)sr.get("family");
                    kingdom = (String)sr.get("kingdom");
                    if (sciname == null) {
                        sciname = "";
                    }
                    if (family == null) {
                        family = "";
                    }
                    if (kingdom == null) {
                        kingdom = "";
                    }
                }
                if (lsid != null && lsid.length() > 0) {
                    this.addTolMultiple(lsid, sciname, family, kingdom, false);
                } else {
                    this.addTolMultiple(null, s, "", "", false);
                }
                if (lsid != null && lsid.length() != 0) continue;
                notFound.add(s);
                notFoundSb.append(s).append("\n");
                continue;
            }
            catch (Exception e) {
                notFound.add(s);
                notFoundSb.append(s).append("\n");
            }
        }
        if (!notFound.isEmpty()) {
            this.getMapComposer().showMessage("Cannot identify these scientific names:\n" + notFoundSb.toString(), (Component)this);
        }
        this.toggles();
    }

    public void onClick$bMultipleBk(Event event) {
        String[] speciesNames = this.tMultipleBk.getText().replace("\n", ",").split(",");
        ArrayList<String> notFound = new ArrayList<String>();
        StringBuilder notFoundSb = new StringBuilder();
        for (int i = 0; i < speciesNames.length; ++i) {
            String s = speciesNames[i].trim();
            if (s.length() <= 0) continue;
            JSONObject searchResult = this.processAdhoc(s);
            try {
                Map sr;
                JSONArray ja = (JSONArray)searchResult.get((Object)"values");
                String sciname = "";
                String family = "";
                String kingdom = "";
                String lsid = null;
                for (int j = 0; j < ja.size(); ++j) {
                    if ("scientificName".equals(((JSONObject)ja.get(j)).get((Object)"name"))) {
                        sciname = ((JSONObject)ja.get(j)).get((Object)"processed").toString();
                    }
                    if ("family".equals(((JSONObject)ja.get(j)).get((Object)"name"))) {
                        family = ((JSONObject)ja.get(j)).get((Object)"processed").toString();
                    }
                    if ("kingdom".equals(((JSONObject)ja.get(j)).get((Object)"name"))) {
                        kingdom = ((JSONObject)ja.get(j)).get((Object)"processed").toString();
                    }
                    if (!"taxonConceptID".equals(((JSONObject)ja.get(j)).get((Object)"name"))) continue;
                    lsid = ((JSONObject)ja.get(j)).get((Object)"processed").toString();
                }
                if (!(lsid != null && lsid.length() != 0 || (sr = BiocacheQuery.getClassification((String)s)).isEmpty() || sr.get("scientificName") == null || ((String)sr.get("scientificName")).length() <= 0)) {
                    lsid = s;
                    sciname = (String)sr.get("scientificName");
                    family = (String)sr.get("family");
                    kingdom = (String)sr.get("kingdom");
                    if (sciname == null) {
                        sciname = "";
                    }
                    if (family == null) {
                        family = "";
                    }
                    if (kingdom == null) {
                        kingdom = "";
                    }
                }
                if (lsid != null && lsid.length() > 0) {
                    this.addTolMultipleBk(lsid, sciname, family, kingdom, false);
                } else {
                    this.addTolMultipleBk(null, s, "", "", false);
                }
                if (lsid != null && lsid.length() != 0) continue;
                notFound.add(s);
                notFoundSb.append(s).append("\n");
                continue;
            }
            catch (Exception e) {
                notFound.add(s);
                notFoundSb.append(s).append("\n");
            }
        }
        if (!notFound.isEmpty()) {
            this.getMapComposer().showMessage("Cannot identify these scientific names:\n" + notFoundSb.toString(), (Component)this);
        }
        this.toggles();
    }

    JSONObject processAdhoc(String scientificName) {
        String url = CommonData.getBiocacheServer() + "/process/adhoc";
        try {
            HttpClient client = new HttpClient();
            PostMethod post = new PostMethod(url);
            StringRequestEntity sre = new StringRequestEntity("{ \"scientificName\": \"" + scientificName.replace("\"", "'") + "\" } ", "application/json", "UTF-8");
            post.setRequestEntity((RequestEntity)sre);
            int result = client.executeMethod((HttpMethod)post);
            if (result == 200) {
                JSONParser jp = new JSONParser();
                return (JSONObject)jp.parse(post.getResponseBodyAsString());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("error processing species request: " + url + ", scientificName=" + scientificName), (Throwable)e);
        }
        return null;
    }

    private void addTolMultiple(String lsid, String sciname, String family, String kingdom, boolean insertAtBeginning) {
        int count;
        for (Listitem li : this.lMultiple.getItems()) {
            Listcell lsidCell = (Listcell)li.getLastChild();
            Listcell scinameCell = (Listcell)li.getFirstChild().getNextSibling();
            if (!lsidCell.getLabel().equals(lsid) && !scinameCell.getLabel().replace("(not found)", "").trim().equals(sciname)) continue;
            return;
        }
        Listitem li = new Listitem();
        Listcell lc = new Listcell("x");
        lc.setSclass("xRemove");
        lc.addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        lc.setParent((Component)li);
        if (lsid == null) {
            lc = new Listcell(sciname + " (not found)");
            lc.setSclass("notFoundSciname");
        } else {
            lc = new Listcell(sciname);
        }
        lc.setParent((Component)li);
        if (lsid == null) {
            lc = new Listcell("click to search");
            lc.setSclass("notFoundFamily");
            lc.addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            lc = new Listcell(family);
        }
        lc.setParent((Component)li);
        lc = new Listcell(kingdom);
        lc.setParent((Component)li);
        lc = lsid != null ? ((count = new BiocacheQuery(lsid, null, null, null, false, this.getGeospatialKosher()).getOccurrenceCount()) > 0 ? new Listcell(String.valueOf(count)) : new Listcell(kingdom)) : new Listcell(kingdom);
        lc.setParent((Component)li);
        lc = new Listcell(lsid);
        lc.setParent((Component)li);
        if (insertAtBeginning && !this.lMultiple.getChildren().isEmpty()) {
            this.lMultiple.insertBefore((Component)li, this.lMultiple.getFirstChild());
        } else {
            li.setParent((Component)this.lMultiple);
        }
    }

    private void addTolMultipleBk(String lsid, String sciname, String family, String kingdom, boolean insertAtBeginning) {
        int count;
        for (Listitem li : this.lMultipleBk.getItems()) {
            Listcell lsidCell = (Listcell)li.getLastChild();
            Listcell scinameCell = (Listcell)li.getFirstChild().getNextSibling();
            if (!lsidCell.getLabel().equals(lsid) && !scinameCell.getLabel().replace("(not found)", "").trim().equals(sciname)) continue;
            return;
        }
        Listitem li = new Listitem();
        Listcell lc = new Listcell("x");
        lc.setSclass("xRemove");
        lc.addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        lc.setParent((Component)li);
        if (lsid == null) {
            lc = new Listcell(sciname + " (not found)");
            lc.setSclass("notFoundSciname");
        } else {
            lc = new Listcell(sciname);
        }
        lc.setParent((Component)li);
        if (lsid == null) {
            lc = new Listcell("click to search");
            lc.setSclass("notFoundFamily");
            lc.addEventListener("onClick", (EventListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            lc = new Listcell(family);
        }
        lc.setParent((Component)li);
        lc = new Listcell(kingdom);
        lc.setParent((Component)li);
        lc = lsid != null ? ((count = new BiocacheQuery(lsid, null, null, null, false, this.getGeospatialKosherBk()).getOccurrenceCount()) > 0 ? new Listcell(String.valueOf(count)) : new Listcell(kingdom)) : new Listcell(kingdom);
        lc.setParent((Component)li);
        lc = new Listcell(lsid);
        lc.setParent((Component)li);
        if (insertAtBeginning && !this.lMultipleBk.getChildren().isEmpty()) {
            this.lMultipleBk.insertBefore((Component)li, this.lMultipleBk.getFirstChild());
        } else {
            li.setParent((Component)this.lMultipleBk);
        }
    }

    private String getMultipleLsids() {
        StringBuilder sb = new StringBuilder();
        for (Listitem li : this.lMultiple.getItems()) {
            Listcell lc = (Listcell)li.getLastChild();
            if (lc.getLabel() == null || lc.getLabel().length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(lc.getLabel());
        }
        return sb.toString();
    }

    void setMultipleLsids(String lsids) {
        try {
            if (lsids != null) {
                this.tMultiple.setText(lsids);
                this.rgSpecies.setSelectedItem(this.rMultiple);
                Clients.evalJavaScript((String)("jq('#" + this.rMultiple.getUuid() + "-real').attr('checked', true);"));
                this.onClick$bMultiple(null);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Error setting lsid:", (Throwable)e);
        }
    }

    private String getMultipleLsidsBk() {
        StringBuilder sb = new StringBuilder();
        for (Listitem li : this.lMultipleBk.getItems()) {
            Listcell lc = (Listcell)li.getLastChild();
            if (lc.getLabel() == null || lc.getLabel().length() <= 0) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(lc.getLabel());
        }
        return sb.toString();
    }

    void setMultipleLsidsBk(String lsids) {
        try {
            if (lsids != null) {
                this.tMultipleBk.setText(lsids);
                this.rgSpeciesBk.setSelectedItem(this.rMultipleBk);
                Clients.evalJavaScript((String)("jq('#" + this.rMultipleBk.getUuid() + "-real').attr('checked', true);"));
                this.onClick$bMultipleBk(null);
            }
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Error setting lsid:", (Throwable)e);
        }
    }

    public void setIncludeAnalysisLayersForUploadQuery(boolean includeAnalysisLayersForUploadQuery) {
        this.includeAnalysisLayersForUploadQuery = includeAnalysisLayersForUploadQuery;
    }

    public void setIncludeAnalysisLayersForAnyQuery(boolean includeAnalysisLayersForAnyQuery) {
        this.includeAnalysisLayersForAnyQuery = includeAnalysisLayersForAnyQuery;
    }

    public void onClick$btnUpload(Event event) {
        try {
            LOGGER.debug((Object)"onClick$btnUpload(Event event)");
            if (StringUtils.isNotEmpty((String)CommonData.getSettings().getProperty("sandbox.url", null)) && CommonData.getSettings().getProperty("import.points.layers-service", "false").equals("false")) {
                SandboxPasteController spc = (SandboxPasteController)Executions.createComponents((String)"WEB-INF/zul/sandbox/SandboxPaste.zul", (Component)this.getMapComposer(), null);
                spc.setAddToMap(true);
                spc.setParent((Component)this.getMapComposer());
                spc.doModal();
            } else {
                UploadSpeciesController usc = (UploadSpeciesController)Executions.createComponents((String)"WEB-INF/zul/input/UploadSpecies.zul", (Component)this, null);
                if (this.rSpeciesUploadSpecies.isSelected()) {
                    usc.setTbInstructions("3. Select file (comma separated ID (text), longitude (decimal degrees), latitude(decimal degrees))");
                } else if (this.rSpeciesUploadLSID.isSelected()) {
                    usc.setTbInstructions("3. Select file (text file, one LSID or name per line)");
                } else {
                    usc.setTbInstructions("3. Select file");
                }
                usc.setAddToMap(true);
                usc.setParent((Component)this);
                usc.doModal();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"file upload error", (Throwable)e);
        }
    }

    public void setChooseEndemic(boolean choose) {
        this.chkEndemicSpecies.setChecked(choose);
    }

    public boolean getIsEndemic() {
        return this.chkEndemicSpecies != null && this.chkEndemicSpecies.isChecked();
    }

    public boolean[] getGeospatialKosher() {
        if (this.chkGeoKosherTrue == null || this.chkGeoKosherFalse == null) {
            LOGGER.warn((Object)("Error in ToolComposer.  Expect checkboxes for geospatial kosher species.  Tool: " + (this.tToolName == null ? "'also missing tToolName textbox'" : this.tToolName.getValue())));
            return new boolean[]{true, true, false};
        }
        return new boolean[]{this.chkGeoKosherTrue.isChecked(), this.chkGeoKosherFalse.isChecked(), false};
    }

    public boolean[] getGeospatialKosherBk() {
        if (this.chkGeoKosherTrueBk == null || this.chkGeoKosherFalseBk == null) {
            LOGGER.warn((Object)("Error in ToolComposer.  Expect checkboxes for geospatial kosher background species.  Tool: " + (this.tToolName == null ? "'also missing tToolName textbox'" : this.tToolName.getValue())));
            return new boolean[]{true, true, false};
        }
        return new boolean[]{this.chkGeoKosherTrueBk.isChecked(), this.chkGeoKosherFalseBk.isChecked(), false};
    }

    void updateGeospatialKosherCheckboxes() {
        if (this.chkGeoKosherTrue == null || this.chkGeoKosherFalse == null) {
            LOGGER.warn((Object)("Error in ToolComposer.  Expect checkboxes for geospatial kosher species.  Tool: " + (this.tToolName == null ? "'also missing tToolName textbox'" : this.tToolName.getValue())));
            return;
        }
        Query q = this.getSelectedSpecies(false, true);
        if (q != null) {
            boolean[] gk;
            if (q instanceof BiocacheQuery && (gk = ((BiocacheQuery)q).getGeospatialKosher()) != null) {
                this.chkGeoKosherTrue.setDisabled(false);
                this.chkGeoKosherFalse.setDisabled(false);
                if (this.chkGeoKosherTrue.isVisible()) {
                    this.chkGeoKosherTrue.setChecked(gk[0]);
                }
                if (this.chkGeoKosherFalse.isVisible()) {
                    this.chkGeoKosherFalse.setChecked(gk[1]);
                }
            } else {
                this.chkGeoKosherTrue.setDisabled(true);
                this.chkGeoKosherFalse.setDisabled(true);
            }
        }
    }

    public void setGeospatialKosherCheckboxes(boolean[] geospatialKosher) {
        if (this.chkGeoKosherTrue == null || this.chkGeoKosherFalse == null) {
            LOGGER.warn((Object)("Error in ToolComposer.  Expect checkboxes for geospatial kosher species.  Tool: " + (this.tToolName == null ? "'also missing tToolName textbox'" : this.tToolName.getValue())));
            return;
        }
        if (geospatialKosher != null) {
            this.chkGeoKosherTrue.setChecked(geospatialKosher[0]);
            this.chkGeoKosherFalse.setChecked(geospatialKosher[1]);
        } else {
            this.chkGeoKosherTrue.setChecked(true);
            this.chkGeoKosherFalse.setChecked(true);
        }
    }

    void updateGeospatialKosherCheckboxesBk() {
        if (this.chkGeoKosherTrueBk == null || this.chkGeoKosherFalseBk == null) {
            LOGGER.warn((Object)("Error in ToolComposer.  Expect checkboxes for geospatial kosher background species.  Tool: " + (this.tToolName == null ? "'also missing tToolName textbox'" : this.tToolName.getValue())));
            return;
        }
        Query q = this.getSelectedSpeciesBk(false, true);
        if (q != null) {
            boolean[] gk;
            if (q instanceof BiocacheQuery && (gk = ((BiocacheQuery)q).getGeospatialKosher()) != null) {
                this.chkGeoKosherTrueBk.setDisabled(false);
                this.chkGeoKosherFalseBk.setDisabled(false);
                if (this.chkGeoKosherTrueBk.isVisible()) {
                    this.chkGeoKosherTrueBk.setChecked(gk[0]);
                }
                if (this.chkGeoKosherFalseBk.isVisible()) {
                    this.chkGeoKosherFalseBk.setChecked(gk[1]);
                }
            } else {
                this.chkGeoKosherTrueBk.setDisabled(true);
                this.chkGeoKosherFalseBk.setDisabled(true);
            }
        }
    }

    public void setGeospatialKosherCheckboxesBk(boolean[] geospatialKosher) {
        if (this.chkGeoKosherTrueBk == null || this.chkGeoKosherFalseBk == null) {
            LOGGER.warn((Object)("Error in ToolComposer.  Expect checkboxes for geospatial kosher species.  Tool: " + (this.tToolName == null ? "'also missing tToolName textbox'" : this.tToolName.getValue())));
            return;
        }
        if (geospatialKosher != null) {
            this.chkGeoKosherTrueBk.setChecked(geospatialKosher[0]);
            this.chkGeoKosherFalseBk.setChecked(geospatialKosher[1]);
        } else {
            this.chkGeoKosherTrueBk.setChecked(true);
            this.chkGeoKosherFalseBk.setChecked(true);
        }
    }

    public void onCheck$chkGeoKosherTrue(Event event) {
        Event evt = ((ForwardEvent)event).getOrigin();
        if (!((CheckEvent)evt).isChecked() && !this.chkGeoKosherFalse.isChecked()) {
            this.chkGeoKosherFalse.setChecked(true);
        }
    }

    public void onCheck$chkGeoKosherFalse(Event event) {
        Event evt = ((ForwardEvent)event).getOrigin();
        if (!((CheckEvent)evt).isChecked() && !this.chkGeoKosherTrue.isChecked()) {
            this.chkGeoKosherTrue.setChecked(true);
        }
    }

    public void onCheck$chkGeoKosherTrueBk(Event event) {
        Event evt = ((ForwardEvent)event).getOrigin();
        if (!((CheckEvent)evt).isChecked() && !this.chkGeoKosherFalseBk.isChecked()) {
            this.chkGeoKosherFalseBk.setChecked(true);
        }
    }

    public void onCheck$chkGeoKosherFalseBk(Event event) {
        Event evt = ((ForwardEvent)event).getOrigin();
        if (!((CheckEvent)evt).isChecked() && !this.chkGeoKosherTrueBk.isChecked()) {
            this.chkGeoKosherTrueBk.setChecked(true);
        }
    }

    public void onCheck$chkGeoKosherNullBk(Event event) {
        Event evt = ((ForwardEvent)event).getOrigin();
        if (!((CheckEvent)evt).isChecked() && !this.chkGeoKosherTrueBk.isChecked()) {
            this.chkGeoKosherTrueBk.setChecked(true);
        }
    }

    public void onClick$bAssemblageExport(Event event) {
        SimpleDateFormat sdf = new SimpleDateFormat("ddmmyyyy_hhmm");
        Filedownload.save((String)this.getLsids(), (String)"text/plain", (String)("species_assemblage_" + sdf.format(new Date()) + ".txt"));
    }

    private void showExportSpeciesListDialog(Listbox lb) {
        String values = this.getScientificName(lb);
        LOGGER.debug((Object)("Creating species list with " + values));
        if (values.length() > 0) {
            UploadToSpeciesListController dialog = (UploadToSpeciesListController)Executions.createComponents((String)"WEB-INF/zul/input/UploadToSpeciesList.zul", (Component)this, null);
            dialog.setSpecies(values);
            dialog.setCallback((EventListener)new /* Unavailable Anonymous Inner Class!! */);
            try {
                dialog.setParent((Component)this);
                dialog.doModal();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unable to export assemblage", (Throwable)e);
            }
        }
    }

    private String getScientificName(Listbox lb) {
        StringBuilder sb = new StringBuilder();
        for (Listitem li : lb.getItems()) {
            Listcell sciNameCell = (Listcell)li.getChildren().get(1);
            String name = sciNameCell.getLabel();
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(name.replaceAll("\\(not found\\)", "").trim());
        }
        return sb.toString();
    }

    public void updateSpeciesListMessage(String drUid) {
        LOGGER.debug((Object)("Species list that was created : " + drUid));
        if (drUid != null) {
            boolean isBk = this.rMultipleBk != null && this.rMultipleBk.isChecked();
            SpeciesListListbox lb = isBk ? this.speciesListListboxBk : this.speciesListListbox;
            Radio r = isBk ? this.rSpeciesUploadLSIDBk : this.rSpeciesUploadLSID;
            ((SpeciesListListbox.SpeciesListListModel)lb.getModel()).refreshModel();
            r.setSelected(true);
            if (isBk) {
                this.onCheck$rgSpeciesBk(null);
            } else {
                this.onCheck$rgSpecies(null);
            }
        }
    }

    String getLsids() {
        StringBuilder sb = new StringBuilder();
        for (Listitem li : this.lMultiple.getItems()) {
            Listcell lsidCell = (Listcell)li.getLastChild();
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(lsidCell.getLabel());
        }
        return sb.toString();
    }

    public void onClick$bSpeciesListUpload(Event event) {
        UploadLayerListController window = (UploadLayerListController)Executions.createComponents((String)"WEB-INF/zul/input/UploadSpeciesList.zul", (Component)this, null);
        window.setCallback((EventListener)new /* Unavailable Anonymous Inner Class!! */);
        try {
            window.setParent((Component)this);
            window.doModal();
        }
        catch (Exception e) {
            LOGGER.error((Object)"error opening UploadSpeciesList.zul", (Throwable)e);
        }
    }

    String readerToString(Reader reader) throws IOException {
        int size;
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1000];
        while ((size = reader.read(buffer)) > 0) {
            sb.append(buffer, 0, size);
        }
        return sb.toString();
    }

    static /* synthetic */ SpeciesAutoCompleteComponent access$000(ToolComposer x0) {
        return x0.mSearchSpeciesACComp;
    }

    static /* synthetic */ SpeciesAutoCompleteComponent access$100(ToolComposer x0) {
        return x0.mSearchSpeciesACCompBk;
    }
}

